/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import javax.microedition.lcdui.Image;

public class ImageScaler {
    private static final int FP_SHIFT = 13;
    public static final int MODE_POINT_SAMPLE = 0;
    public static final int MODE_BOX_FILTER = 1;

    static int[] getPixels(Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    static Image drawPixels(int[] pixels, int w, int h) {
        return Image.createRGBImage((int[])pixels, (int)w, (int)h, (boolean)true);
    }

    static Image resizeImage(Image src, int scale) {
        return ImageScaler.resizeImage(src, scale, scale, 1);
    }

    static Image resizeImage(Image src, int scaleX, int scaleY, int mode) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int destW = srcW * scaleX / 1000;
        int destH = srcH * scaleY / 1000;
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = ImageScaler.getPixels(src);
        if (mode == 0) {
            for (int destY = 0; destY < destH; ++destY) {
                for (int destX = 0; destX < destW; ++destX) {
                    int srcX = destX * srcW / destW;
                    int srcY = destY * srcH / destH;
                    destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
                }
            }
        } else {
            int argb;
            int g;
            int b;
            int r;
            int a;
            int count;
            int ratioW = (srcW << 13) / destW;
            int ratioH = (srcH << 13) / destH;
            int[] tmpPixels = new int[destW * srcH];
            for (int y = 0; y < srcH; ++y) {
                for (int destX = 0; destX < destW; ++destX) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcX = destX * ratioW >> 13;
                    int srcX2 = (destX + 1) * ratioW >> 13;
                    do {
                        argb = srcPixels[srcX + y * srcW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcX <= srcX2 && srcX + y * srcW < srcPixels.length);
                    tmpPixels[destX + y * destW] = (a /= count) << 24 | (r /= count) << 16 | (g /= count) << 8 | (b /= count);
                }
            }
            for (int x = 0; x < destW; ++x) {
                for (int destY = 0; destY < destH; ++destY) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcY = destY * ratioH >> 13;
                    int srcY2 = (destY + 1) * ratioH >> 13;
                    do {
                        argb = tmpPixels[x + srcY * destW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcY <= srcY2 && x + srcY * destW < tmpPixels.length);
                    a = (a /= count) > 255 ? 255 : a;
                    r = (r /= count) > 255 ? 255 : r;
                    g = (g /= count) > 255 ? 255 : g;
                    b = (b /= count) > 255 ? 255 : b;
                    destPixels[x + destY * destW] = a << 24 | r << 16 | g << 8 | b;
                }
            }
        }
        return ImageScaler.drawPixels(destPixels, destW, destH);
    }
}

