/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import java.util.Vector;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.oldschoolracing.CMenuItem;
import sk.inlogic.oldschoolracing.IMenuItemActivator;
import sk.inlogic.oldschoolracing.IMenuItemRenderer;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;

public class MenuSystem {
    Vector vecMenuItems;
    int iSelectedMenuItem;
    final int MAX_MENU_ITEMS;
    int iMenuItemsCount;
    public int iMenuType = 0;
    public final int TYPE_LANG;
    public final int TYPE_MAIN;
    public final int TYPE_GAME;
    public final int TYPE_CHOOSE_CAR;
    public final int TYPE_CHOOSE_TRACK;
    public final int TYPE_SCORES;
    public final int TYPE_OPTIONS;
    private IMenuItemActivator pMenuItemActivator = null;
    private IMenuItemRenderer pMenuItemRenderer = null;
    private static MenuSystem pInstance = null;

    public static MenuSystem getInstance() {
        if (pInstance == null) {
            pInstance = new MenuSystem();
        }
        return pInstance;
    }

    public void releaseInstance() {
        if (pInstance != null) {
            pInstance = null;
            System.gc();
        }
    }

    public MenuSystem() {
        this.MAX_MENU_ITEMS = 10;
        this.TYPE_LANG = 1;
        this.TYPE_MAIN = 2;
        this.TYPE_GAME = 3;
        this.TYPE_CHOOSE_CAR = 4;
        this.TYPE_CHOOSE_TRACK = 5;
        this.TYPE_SCORES = 6;
        this.TYPE_OPTIONS = 7;
        this.reset();
    }

    public void setMenuItemActivator(IMenuItemActivator pMenuItemActivator) {
        this.pMenuItemActivator = pMenuItemActivator;
    }

    public void setMenuItemRenderer(IMenuItemRenderer pMenuItemRenderer) {
        this.pMenuItemRenderer = pMenuItemRenderer;
    }

    public void setSelectedItem(int iSelectedItem) {
        this.iSelectedMenuItem = iSelectedItem;
    }

    public void reset() {
        this.vecMenuItems = new Vector();
        this.iMenuItemsCount = 0;
        this.iSelectedMenuItem = 0;
    }

    public void addMenuItem(CMenuItem pMenuItem) {
        this.vecMenuItems.addElement(pMenuItem);
        ++this.iMenuItemsCount;
    }

    public void paintMenu(Graphics g) {
        if (this.iMenuType == 1) {
            this.paintLangMenu(g);
        }
        if (this.iMenuType == 2) {
            this.paintMainMenu(g);
        }
        if (this.iMenuType == 4) {
            this.paintChooseMenuWide(g);
        }
        if (this.iMenuType == 5 || this.iMenuType == 6) {
            this.paintChooseTrackMenuWide(g);
        }
        if (this.iMenuType == 7) {
            this.paintOptions(g);
        }
    }

    public void paintOptions(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - 6;
        if (Profile.canLoad()) {
            partsY = Resources.iScreenH / Resources.iBorderH - 4;
        }
        Resources.paintMenuBG(partsX, partsY, g);
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
        Resources.paintLeftButton(g, partsY);
    }

    public void paintChooseTrackMenu(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcOutH) / 2;
        int iPosX = (Resources.iScreenW - Resources.iCarNamesW) / 2;
        if (Resources.iScreenW == 128) {
            y -= 20;
        }
        Resources.imgChooseSide.drawAtPoint(g, iPosX - Resources.iChooseSideW, y);
        Resources.imgChooseSide.drawRotatedAtPoint(g, iPosX + Resources.iCarNamesW, y, true, false, 1);
        int arrOfsetY = (Resources.iChooseSideH - Resources.iIconsH) / 2;
        int arrOfsetX = (Resources.iChooseSideW - Resources.iIconsW) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX - Resources.iChooseSideW + arrOfsetX + Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.setRotation(0);
        Resources.sprIcons.paintRotated(g);
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iCarNamesW + arrOfsetX - Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.paintRotated(g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        y = (partsY * Resources.iBorderH - Resources.iCarNamesH - Resources.iCarImgsH) / 2 + iPosY / 2 + Resources.iCarNamesH;
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
        if (this.iMenuType != 6) {
            Resources.paintLeftButton(g, partsY);
        } else {
            Resources.paintRightButton(g, partsY);
        }
        if (this.iMenuType != 6) {
            Resources.paintRightButton(g, partsY);
        }
    }

    public void paintChooseTrackMenuWide(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 - Resources.CHOOSE_MENU_OFFSET;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        Resources.imgChooseSide2.drawAtPoint(g, iPosX + Resources.iBorderW + Resources.iBorderW / 2, iPosY + Resources.iBorderH + Resources.iBorderH / 2);
        Resources.imgChooseSide2.drawRotatedAtPoint(g, iPosX + Resources.iBorderW + Resources.iBorderW / 2 + Resources.iChooseSide2W + Resources.iEnvsW, iPosY + Resources.iBorderH + Resources.iBorderH / 2, false, false, 3);
        int arrOfsetY = (Resources.iChooseSide2H - Resources.iIconsH) / 2;
        int arrOfsetX = (Resources.iChooseSide2W - Resources.iIconsW) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iBorderW + Resources.iBorderW / 2 + arrOfsetX, iPosY + Resources.iBorderH + Resources.iBorderH / 2 + arrOfsetY + Resources.CHOOSE_ARR_OFF);
        Resources.sprIcons.setRotation(1);
        Resources.sprIcons.paintRotated(g);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.setPosition(iPosX + Resources.iBorderW + Resources.iBorderW / 2 + arrOfsetX + Resources.iChooseSide2W + Resources.iEnvsW, iPosY + Resources.iBorderH + Resources.iBorderH / 2 + arrOfsetY - Resources.CHOOSE_ARR_OFF);
        Resources.sprIcons.paintRotated(g);
        Resources.sprIcons.setRotation(1);
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
        Resources.paintRightButton(g, partsY);
        Resources.paintLeftButton(g, partsY);
    }

    public void paintChooseMenuWide(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        int y = iPosY + Resources.iBorderH + Resources.iBorderH / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW - Resources.CHOOSE_MENU_OFFSET * 2;
        Resources.imgChooseSide.drawAtPoint(g, iPosX + Resources.iChooseSideW, y);
        Resources.imgChooseSide.drawRotatedAtPoint(g, iPosX + Resources.iCarNamesW + Resources.iChooseSideW * 2, y, true, false, 1);
        int arrOfsetY = (Resources.iChooseSideH - Resources.iIconsH) / 2;
        int arrOfsetX = (Resources.iChooseSideW - Resources.iIconsW) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iChooseSideW + arrOfsetX + Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.paint(g);
        Resources.sprIcons.setPosition(iPosX + Resources.iCarNamesW + Resources.iChooseSideW * 2 + arrOfsetX - Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.paintRotated(g);
        Resources.sprIcons.setRotation(0);
        y += Resources.iCarNamesH + Resources.iIconsH / 2;
        int offset = Resources.iBonsH + Resources.iBonsH / 2;
        int iconOffset = (offset - Resources.iIconsH) / 2;
        int xDots = iPosX + Resources.iCarNamesW + Resources.iChooseSideW * 2;
        for (int i = 0; i < 3; ++i) {
            if (i != 0) {
                Resources.imgLineM.drawAtPoint(g, iPosX + Resources.iChooseSideW, y + i * offset);
            }
            if (i == 3) continue;
            Resources.sprIcons.setFrame(9 + i);
            Resources.sprIcons.setPosition(iPosX + Resources.iChooseSideW + Resources.iIconsW / 4, y + i * offset + iconOffset);
            Resources.sprIcons.paint(g);
            for (int j = 0; j < 4; ++j) {
                Resources.sprIcons.setFrame(13);
                Resources.sprIcons.setPosition(xDots - j * (Resources.iIconsW + Resources.DOTS_OFFSET), y + i * offset + iconOffset + 1);
                Resources.sprIcons.paint(g);
            }
        }
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    public void paintChooseMenu(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcOutH) / 2;
        int iPosX = (Resources.iScreenW - Resources.iCarNamesW) / 2;
        if (Resources.iScreenW == 128) {
            y -= 10;
        }
        Resources.imgChooseSide.drawAtPoint(g, iPosX - Resources.iChooseSideW, y);
        Resources.imgChooseSide.drawRotatedAtPoint(g, iPosX + Resources.iCarNamesW, y, true, false, 1);
        int arrOfsetY = (Resources.iChooseSideH - Resources.iIconsH) / 2;
        int arrOfsetX = (Resources.iChooseSideW - Resources.iIconsW) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX - Resources.iChooseSideW + arrOfsetX + Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.setRotation(0);
        Resources.sprIcons.paintRotated(g);
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iCarNamesW + arrOfsetX - Resources.CHOOSE_ARR_OFF, y + arrOfsetY);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.paintRotated(g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        y = (partsY * Resources.iBorderH - Resources.iCarNamesH - Resources.iCarImgsH) / 2 + iPosY / 2 + Resources.iCarNamesH;
        int offset = Resources.iCarImgsH / 3;
        int iconOffset = (offset - Resources.iIconsH) / 2;
        for (int i = 0; i < 4; ++i) {
            if (Resources.iScreenW != 208 || Resources.iScreenH != 208) {
                Resources.imgLineS.drawAtPoint(g, Resources.iScreenW / 2 + Resources.iChooseSideW / 4, y + i * offset);
            }
            if (i == 3) continue;
            Resources.sprIcons.setFrame(9 + i);
            Resources.sprIcons.setPosition(Resources.iScreenW / 2 + Resources.iChooseSideW / 2, y + i * offset + iconOffset + 1);
            Resources.sprIcons.paint(g);
            for (int j = 0; j < 4; ++j) {
                Resources.sprIcons.setFrame(13);
                Resources.sprIcons.setPosition(Resources.iScreenW / 2 + Resources.iChooseSideW + Resources.iIconsW + j * (Resources.iIconsW + Resources.DOTS_OFFSET), y + i * offset + iconOffset + 1);
                Resources.sprIcons.paint(g);
            }
        }
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    public void paintMainMenu(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        Resources.imgLogo.drawAtPoint(g, (Resources.iScreenW - Resources.iLogoW) / 2, iPosY);
        int iSize = this.vecMenuItems.size();
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
    }

    public void paintLangMenu(Graphics g) {
        int iSize = this.vecMenuItems.size();
        int partsX = Resources.iScreenW / Resources.iBorderW - 2;
        int partsY = Resources.iScreenH / Resources.iBorderH - 2;
        Resources.paintMenuBG(partsX, partsY, g, false);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW;
        Resources.imgLogo.drawAtPoint(g, iPosX, iPosY);
        iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Resources.BORDER_WIDTH;
        Resources.imgIlust.drawAtPoint(g, iPosX, iPosY - Resources.iIlustH);
        for (int i = 0; i < iSize; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, i == this.iSelectedMenuItem);
        }
    }

    public void langKeyPr(Key pKey) {
        if (pKey.iGameAction == 2 || pKey.iValue == 102 || pKey.iValue == 101) {
            --this.iSelectedMenuItem;
            if (this.iSelectedMenuItem < 0) {
                this.iSelectedMenuItem += this.iMenuItemsCount;
            }
        }
        if (pKey.iGameAction == 5 || pKey.iValue == 104 || pKey.iValue == 120) {
            ++this.iSelectedMenuItem;
            if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                this.iSelectedMenuItem -= this.iMenuItemsCount;
            }
        }
        if (pKey.iGameAction == 1 || pKey.iValue == 116 || pKey.iValue == 101) {
            this.iSelectedMenuItem = this.iSelectedMenuItem < 3 ? (this.iSelectedMenuItem += 3) : (this.iSelectedMenuItem -= 3);
        }
        if (pKey.iGameAction == 6 || pKey.iValue == 98 || pKey.iValue == 120) {
            this.iSelectedMenuItem = this.iSelectedMenuItem < 3 ? (this.iSelectedMenuItem += 3) : (this.iSelectedMenuItem -= 3);
        }
    }

    public void langKeyPrWide(Key pKey) {
        if (pKey.iGameAction == 2 || pKey.iValue == 102) {
            --this.iSelectedMenuItem;
            if (this.iSelectedMenuItem < 0) {
                this.iSelectedMenuItem += this.iMenuItemsCount;
            }
        }
        if (pKey.iGameAction == 5 || pKey.iValue == 104) {
            ++this.iSelectedMenuItem;
            if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                this.iSelectedMenuItem -= this.iMenuItemsCount;
            }
        }
        if (pKey.iGameAction == 1 || pKey.iValue == 116) {
            this.iSelectedMenuItem -= 2;
            if (this.iSelectedMenuItem == -1) {
                this.iSelectedMenuItem = this.iMenuItemsCount - 1;
            }
            if (this.iSelectedMenuItem == -2) {
                this.iSelectedMenuItem = this.iMenuItemsCount - 2;
            }
        }
        if (pKey.iGameAction == 6 || pKey.iValue == 98) {
            this.iSelectedMenuItem += 2;
            if (this.iSelectedMenuItem == this.iMenuItemsCount) {
                this.iSelectedMenuItem = 0;
            }
            if (this.iSelectedMenuItem > this.iMenuItemsCount) {
                this.iSelectedMenuItem = 1;
            }
        }
    }

    public void keyPressed(Key pKey) {
        if (this.iMenuType == 1) {
            this.langKeyPrWide(pKey);
            if (pKey.iGameAction == 8 || pKey.iValue == 103) {
                if (this.pMenuItemActivator == null) {
                    return;
                }
                this.activateSelectedMenuItem();
            }
            System.out.println("MenuSystem.keyPressed: " + this.iSelectedMenuItem);
            return;
        }
        if (this.iMenuType == 4 || this.iMenuType == 5) {
            if (pKey.iValue == Keys.KEY_FNLEFT) {
                if (this.pMenuItemActivator == null) {
                    return;
                }
                this.activateSelectedMenuItem();
                return;
            }
            if (pKey.iGameAction == 8) {
                return;
            }
        }
        if (this.iMenuType != 5 && this.iMenuType != 7) {
            if (pKey.iGameAction == 2 || pKey.iValue == 102 || pKey.iValue == 101) {
                --this.iSelectedMenuItem;
                if (this.iSelectedMenuItem < 0) {
                    this.iSelectedMenuItem += this.iMenuItemsCount;
                }
            }
            if (pKey.iGameAction == 5 || pKey.iValue == 104 || pKey.iValue == 120) {
                ++this.iSelectedMenuItem;
                if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                    this.iSelectedMenuItem -= this.iMenuItemsCount;
                }
            }
        } else {
            if (pKey.iGameAction == 1 || pKey.iValue == 116 || pKey.iValue == 101) {
                --this.iSelectedMenuItem;
                if (this.iSelectedMenuItem < 0) {
                    this.iSelectedMenuItem += this.iMenuItemsCount;
                }
            }
            if (pKey.iGameAction == 6 || pKey.iValue == 98 || pKey.iValue == 120) {
                ++this.iSelectedMenuItem;
                if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                    this.iSelectedMenuItem -= this.iMenuItemsCount;
                }
            }
        }
        if (this.iMenuType == 7 || this.iMenuType == 2) {
            if (pKey.iGameAction == 8 || pKey.iValue == 103 || pKey.iValue == 100) {
                if (this.pMenuItemActivator == null) {
                    return;
                }
                this.activateSelectedMenuItem();
            }
        } else if (pKey.iGameAction == Keys.KEY_FNLEFT || pKey.iGameAction == 8 || pKey.iValue == 103) {
            if (this.pMenuItemActivator == null) {
                return;
            }
            this.activateSelectedMenuItem();
        }
        System.out.println("MenuSystem.keyPressed: " + this.iSelectedMenuItem);
    }

    public void pointerPressed(int iX, int iY) {
        for (int i = 0; i < this.iMenuItemsCount; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            if (!pMenuItem.containsPoint(iX, iY)) continue;
            this.iSelectedMenuItem = i;
            return;
        }
    }

    public void activateSelectedMenuItem() {
        this.pMenuItemActivator.onMenuItemActivated(this.iSelectedMenuItem);
    }
}

