/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.Game;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.UICaptionThick;
import Kartmania.UIList;
import Kartmania.UIListColumn;
import Kartmania.UIListTextItem;
import java.util.Vector;

public class CompetitionResultsScreen
extends UIList {
    int continueColor;
    private boolean showRaceCredits = false;

    public CompetitionResultsScreen(String strResultColumnName) {
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(614L, 4));
        this.columns.addElement(new UIListColumn(1638L, 4));
        this.columns.addElement(new UIListColumn(1843L, 1));
        this.headers.addElement(Application.defaultFont.encodeDynamicString(""));
        this.headers.addElement(Application.lp.getTranslatedString(Options.languageID, "ID_RESULTS_NICK"));
        this.headers.addElement(Application.lp.getTranslatedString(Options.languageID, strResultColumnName));
        this.showHeaders = true;
        this.enableSelection = false;
        this.showScrollbars = false;
        String captionText = Application.lp.getTranslatedString(Options.languageID, "ID_ROUND_OF_COMPETITION") + Application.defaultFont.encodeDynamicString(" ") + Application.lp.getTranslatedString(Options.languageID, "ID_ROUND_RESULTS");
        this.setCaption(new UICaptionThick(captionText));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK);
        this.setSoftButtonText(Application.lp.getTranslatedString(Options.languageID, "SOFT_BUTTON_EXIT"), Application.lp.getTranslatedString(Options.languageID, "SOFT_BUTTON_NEXT"));
    }

    public void updateList(Vector nicks, Vector results) {
        this.clearList();
        for (int i = 0; i < nicks.size(); ++i) {
            this.append(new UIListTextItem(Application.defaultFont.encodeDynamicString(" " + (i + 1) + ". ")), 0);
            this.append(new UIListTextItem((String)nicks.elementAt(i)), 1);
            if (!this.showRaceCredits) {
                this.append(new UIListTextItem((String)results.elementAt(i)), 2);
                continue;
            }
            this.append(new UIListTextItem(Application.defaultFont.encodeDynamicString("" + Game.positionToPoints[i])), 2);
        }
    }

    public void showRaceCredits() {
        this.showRaceCredits = true;
        this.headers.removeElementAt(2);
        this.headers.addElement(Application.lp.getTranslatedString(Options.languageID, "ID_RESULTS_CREDITS"));
    }

    public boolean isShowRaceCredits() {
        return this.showRaceCredits;
    }

    public void currentItemChanged(int oldId, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
    }

    protected void leftSoftButton() {
    }

    protected void rightSoftButton() {
    }
}

