/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAnimation;
import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.Vector2FX;
import baltorogames.project_gameplay.Vector3FX;

public class CGBolid {
    public static long __MAX_STRAIGHT__ = 3482L;
    public static long __AVAILABLE_MAX_STRAIGHT__ = 3482L;
    public static final int eStateCountDown = 0;
    public static final int eStateRiding = 1;
    public static final int eStateFinish = 2;
    Vector2FX Dir = new Vector2FX();
    Vector2FX prevPos = new Vector2FX();
    Vector2FX curPos = new Vector2FX();
    Vector2FX DirPrev = new Vector2FX();
    protected CGBolid[] m_Opponents;
    protected int m_nOpponentsCount;
    protected CGTrackNode m_pCurTrackNode;
    protected int m_nSoonLapComplete = 0;
    public Vector3FX m_PosVector3D;
    public Vector2FX m_PosVector;
    public Vector2FX m_DirVector;
    protected long m_fxAppendVelocityPerSec = 409600L;
    protected long m_fxDepriveVelocityPerSec = 614400L;
    protected long m_fxMaxVelocityPerSec = 2048000L;
    protected long m_fxDefaultStraight;
    protected long m_fxTargetVelocity;
    protected long m_fxCurrentVelocity;
    protected long[] m_fxMaxVelManual = new long[4];
    protected boolean m_bManualGear = false;
    protected long m_fxTargetStraight;
    protected long m_fxCurrentStraight;
    protected long m_fxLastStraight;
    protected long m_fxDriftAccumulatorTime = 0L;
    protected long m_fxStartDriftTime = 0L;
    protected long m_fxStopDriftTime = 0L;
    protected int m_nDriftDir = 0;
    protected long m_fxCurrentSterringStraight;
    protected long m_fxCurrentDistanceFromStart;
    protected long m_fxRealCurrentDistanceFromStart;
    protected int m_nBreak;
    protected int m_nStraight;
    public long m_fxSterringLeftTime;
    public long m_fxSterringRightTime;
    public int m_nViewAngleVariant;
    public long m_fxReleaseLeftTime;
    public long m_fxReleaseRightTime;
    protected int m_nIsHuman;
    protected int m_nEngine2DBolidIndex;
    protected CGTexture[] m_Textures;
    protected CGTexture[] m_TexturesShadow;
    protected int[] m_nSmokeOffsetX_R;
    protected int[] m_nSmokeOffsetX_L;
    protected long m_fxPrevDistance;
    protected long m_fxPrevAngle;
    protected int m_nState;
    protected int m_nNrOfLaps;
    protected long[] m_arrLapTimes;
    protected String m_szNick;
    protected long m_fxPowerFactorHuman;
    protected long m_fxNitroFactorHuman;
    protected long m_fxHandlingFactorHuman;
    protected int m_nEndRacePosition;
    protected long m_fxEnableNitroTimer;
    protected int m_nBadSticks = 0;
    protected CGAnimation m_NitroAnimation;
    protected CGBillboardObject m_BillboardObject;
    public int m_nTrainerSide = 0;
    public long m_fxCheckPointTime = 0L;
    public boolean m_bCheckPointFailed = false;
    public int m_nJumpHeight = 0;
    public long m_fxStartDisplayCheckPointDeltaTime = 0L;
    public long m_fxCheckPointDeltaTime = 0L;
    public int m_nCheckPointNumber = 0;

    public CGBolid(int n) {
        this.m_PosVector = new Vector2FX();
        this.m_PosVector3D = new Vector3FX();
        this.m_DirVector = new Vector2FX();
        this.m_BillboardObject = new CGBillboardObject();
        this.m_BillboardObject.m_fxW = 262144L;
        this.m_BillboardObject.m_fxH = 245760L;
        this.m_BillboardObject.m_nCarIndex = n + 1;
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        this.m_BillboardObject.m_nLinearScale = 0;
        long l = 8L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
        long l2 = (4096L - l) / (long)CGTexture.m_nNrOfMipMaps;
        int[] nArray = new int[CGTexture.m_nNrOfMipMaps];
        int[] nArray2 = new int[CGTexture.m_nNrOfMipMaps];
        for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            nArray[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * this.m_BillboardObject.m_fxW / 4096L * (l + (long)i * l2) / 4096L / 4096L);
            nArray2[i] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * this.m_BillboardObject.m_fxH / 4096L * (l + (long)i * l2) / 4096L / 4096L);
        }
        this.m_bManualGear = false;
        this.m_Textures = new CGTexture[4];
        if (n == 0) {
            if (CGUserCareer.currentKart == 0) {
                this.m_Textures[0] = TextureManager.AddTexture("/gameplay/car1_4.png", 0, 1, nArray, nArray2);
                this.m_Textures[1] = TextureManager.AddTexture("/gameplay/car1_3.png", 0, 1, nArray, nArray2);
                this.m_Textures[2] = TextureManager.AddTexture("/gameplay/car1_2.png", 0, 1, nArray, nArray2);
                this.m_Textures[3] = TextureManager.AddTexture("/gameplay/car1_1.png", 0, 1, nArray, nArray2);
            } else if (CGUserCareer.currentKart == 1) {
                this.m_Textures[0] = TextureManager.AddTexture("/gameplay/car2_4.png", 0, 1, nArray, nArray2);
                this.m_Textures[1] = TextureManager.AddTexture("/gameplay/car2_3.png", 0, 1, nArray, nArray2);
                this.m_Textures[2] = TextureManager.AddTexture("/gameplay/car2_2.png", 0, 1, nArray, nArray2);
                this.m_Textures[3] = TextureManager.AddTexture("/gameplay/car2_1.png", 0, 1, nArray, nArray2);
            } else {
                this.m_Textures[0] = TextureManager.AddTexture("/gameplay/car3_4.png", 0, 1, nArray, nArray2);
                this.m_Textures[1] = TextureManager.AddTexture("/gameplay/car3_3.png", 0, 1, nArray, nArray2);
                this.m_Textures[2] = TextureManager.AddTexture("/gameplay/car3_2.png", 0, 1, nArray, nArray2);
                this.m_Textures[3] = TextureManager.AddTexture("/gameplay/car3_1.png", 0, 1, nArray, nArray2);
            }
            this.m_nSmokeOffsetX_R = new int[4];
            this.m_nSmokeOffsetX_R[0] = 77 * this.m_Textures[0].m_MipMaps[1].getWidth() / 90 - this.m_Textures[0].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_R[1] = 73 * this.m_Textures[1].m_MipMaps[1].getWidth() / 90 - this.m_Textures[1].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_R[2] = 67 * this.m_Textures[2].m_MipMaps[1].getWidth() / 90 - this.m_Textures[2].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_R[3] = 62 * this.m_Textures[3].m_MipMaps[1].getWidth() / 90 - this.m_Textures[3].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_L = new int[4];
            this.m_nSmokeOffsetX_L[0] = 45 * this.m_Textures[0].m_MipMaps[1].getWidth() / 90 - this.m_Textures[0].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_L[1] = 34 * this.m_Textures[1].m_MipMaps[1].getWidth() / 90 - this.m_Textures[1].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_L[2] = 29 * this.m_Textures[2].m_MipMaps[1].getWidth() / 90 - this.m_Textures[2].m_MipMaps[1].getWidth() / 2;
            this.m_nSmokeOffsetX_L[3] = 25 * this.m_Textures[3].m_MipMaps[1].getWidth() / 90 - this.m_Textures[3].m_MipMaps[1].getWidth() / 2;
        } else {
            this.m_Textures[0] = TextureManager.AddTexture("/gameplay/car4_4.png", 0, 1, nArray, nArray2);
            this.m_Textures[1] = TextureManager.AddTexture("/gameplay/car4_3.png", 0, 1, nArray, nArray2);
            this.m_Textures[2] = TextureManager.AddTexture("/gameplay/car4_2.png", 0, 1, nArray, nArray2);
            this.m_Textures[3] = TextureManager.AddTexture("/gameplay/car4_1.png", 0, 1, nArray, nArray2);
        }
        this.m_nState = 0;
        this.m_nBadSticks = 0;
        this.m_nIsHuman = 0;
        this.m_nBreak = 0;
        this.m_fxStartDisplayCheckPointDeltaTime = 0L;
        this.m_fxCheckPointDeltaTime = 0L;
        this.m_fxPowerFactorHuman = 4096L;
        this.m_fxHandlingFactorHuman = 4096L;
        this.m_fxNitroFactorHuman = 5325L;
        this.m_nEndRacePosition = 100;
        this.m_nEngine2DBolidIndex = -1;
        this.m_NitroAnimation = null;
        this.m_bCheckPointFailed = false;
    }

    public void SetManualGear(boolean bl) {
        this.m_bManualGear = bl;
    }

    public boolean GetManualGear() {
        return this.m_bManualGear;
    }

    public void DrawSmoke(int n, int n2) {
        if (CGEngine.testApp.m_TexturesSmoke[0] == null) {
            return;
        }
        if (this.m_fxCurrentVelocity < 409600L) {
            return;
        }
        int n3 = RandSync.nextInt(4);
        if (this.m_fxStartDriftTime == 0L) {
            if (n3 != 3) {
                if (this.m_nViewAngleVariant == 3) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_R[3], n2);
                } else if (this.m_nViewAngleVariant == 2) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_R[2], n2);
                } else if (this.m_nViewAngleVariant == 1) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_R[1], n2);
                } else if (this.m_nViewAngleVariant == -2) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - this.m_nSmokeOffsetX_R[2], n2);
                } else if (this.m_nViewAngleVariant == -1) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - this.m_nSmokeOffsetX_R[1], n2);
                }
            }
            if ((n3 = RandSync.nextInt(4)) != 3) {
                if (this.m_nViewAngleVariant == 3) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_L[3], n2);
                } else if (this.m_nViewAngleVariant == 2) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_L[2], n2);
                } else if (this.m_nViewAngleVariant == 1) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + this.m_nSmokeOffsetX_L[1], n2);
                } else if (this.m_nViewAngleVariant == -2) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - this.m_nSmokeOffsetX_L[2], n2);
                } else if (this.m_nViewAngleVariant == -1) {
                    Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - this.m_nSmokeOffsetX_L[1], n2);
                }
            }
        } else {
            int n4 = 1;
            if (ApplicationData.screenWidth == 128) {
                n4 = 2;
            }
            if (this.m_nDriftDir < 0) {
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - 9 / n4, n2);
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + 30 / n4, n2);
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - 27 / n4, n2 - 17 / n4);
            } else {
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + 9 / n4, n2);
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n - 30 / n4, n2);
                n3 = RandSync.nextInt(3);
                Graphic2D.DrawCenter(CGEngine.testApp.m_TexturesSmoke[n3], n + 27 / n4, n2 - 17 / n4);
            }
        }
    }

    public long GetDistanceFromStart() {
        return this.m_fxCurrentDistanceFromStart;
    }

    public void SetDistanceFromStart(long l) {
        this.m_fxCurrentDistanceFromStart = l;
    }

    public long GetRealDistanceFromStart() {
        return this.m_fxRealCurrentDistanceFromStart;
    }

    public long GetCurrentStraight() {
        return this.m_fxCurrentStraight;
    }

    public long GetTargetStraight() {
        return this.m_fxTargetStraight;
    }

    public long GetMaxVelocity() {
        return this.m_fxMaxVelocityPerSec * this.m_fxPowerFactorHuman / 4096L + 36864L;
    }

    public long GetCurrentVelocity() {
        return this.m_fxCurrentVelocity;
    }

    public long GetRealVelocity() {
        return this.m_fxCurrentVelocity * this.m_fxPowerFactorHuman / this.m_fxMaxVelocityPerSec;
    }

    public void SetBreak(int n) {
        this.m_nBreak = n;
    }

    public void SetStraight(int n) {
        this.m_nStraight = n;
    }

    public int IsStraightLeft() {
        if (this.m_nStraight < 0) {
            return 1;
        }
        return 0;
    }

    public int IsStraightRight() {
        if (this.m_nStraight > 0) {
            return 1;
        }
        return 0;
    }

    public void Setup(long l, long l2, long l3, long l4) {
        this.m_fxCurrentStraight = this.m_fxDefaultStraight = l2;
        this.m_fxAppendVelocityPerSec = l4;
        this.m_fxMaxVelocityPerSec = l3;
        this.m_fxCurrentDistanceFromStart = l;
        this.m_fxRealCurrentDistanceFromStart = l;
        this.m_nState = 0;
        this.m_nBadSticks = 0;
        this.m_bCheckPointFailed = false;
        this.m_fxStartDisplayCheckPointDeltaTime = 0L;
        this.m_fxCheckPointDeltaTime = 0L;
        this.m_fxMaxVelManual[0] = this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[1] = 2L * this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[2] = 3L * this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[3] = 4L * this.m_fxMaxVelocityPerSec / 5L;
    }

    public void SetupLaps(int n) {
        this.m_nNrOfLaps = n;
        this.m_arrLapTimes = new long[this.m_nNrOfLaps];
        for (int i = 0; i < this.m_nNrOfLaps; ++i) {
            this.m_arrLapTimes[i] = 0L;
        }
    }

    protected int CanIChangeStraight(long l) {
        for (int i = 0; i < this.m_nOpponentsCount; ++i) {
            long l2 = this.m_fxRealCurrentDistanceFromStart - this.m_Opponents[i].GetRealDistanceFromStart();
            if (l2 >= l || l2 <= 0L) continue;
            return 0;
        }
        return 1;
    }

    protected long IsOpponentOnOurTrack(long l) {
        for (int i = 0; i < this.m_nOpponentsCount; ++i) {
            long l2 = this.m_Opponents[i].GetRealDistanceFromStart() - this.m_fxRealCurrentDistanceFromStart;
            if (l2 >= l || l2 <= 0L || this.m_Opponents[i].GetTargetStraight() != this.m_fxTargetStraight || this.m_Opponents[i].GetCurrentVelocity() >= this.m_fxCurrentVelocity) continue;
            return this.m_Opponents[i].GetCurrentVelocity();
        }
        return 0L;
    }

    protected int IsOpponentOnNeighbourTrack(long l, long l2) {
        for (int i = 0; i < this.m_nOpponentsCount; ++i) {
            long l3 = this.m_Opponents[i].GetRealDistanceFromStart() - this.m_fxRealCurrentDistanceFromStart;
            if (l3 >= l2 || l3 <= 0L || this.m_Opponents[i].GetTargetStraight() != l) continue;
            return 1;
        }
        return 0;
    }

    public void SetOpponents(int n, CGBolid[] cGBolidArray) {
        this.m_Opponents = new CGBolid[n - 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cGBolidArray[i] == this) continue;
            this.m_Opponents[n2] = cGBolidArray[i];
            ++n2;
        }
        this.m_nOpponentsCount = n2;
    }

    public void Go() {
        this.m_nEndRacePosition = 100;
        this.m_pCurTrackNode = CGEngine.testApp.GetTrack().m_pFirstTrackNode;
        this.m_nSoonLapComplete = 0;
        if (this.m_nIsHuman == 1) {
            this.GoHuman();
        } else if (this.m_nIsHuman == 0) {
            this.GoAI();
        }
        this.m_nState = 1;
        this.m_nBadSticks = 0;
        this.m_fxEnableNitroTimer = -40960L;
        CGEngine.testApp.GetTrack().m_nCurrentCheckPointIndex = 0;
        CGEngine.testApp.GetTrack().m_nCurrentStoneIndex = 0;
        this.m_nTrainerSide = 0;
        this.m_bCheckPointFailed = false;
        this.m_fxStartDisplayCheckPointDeltaTime = 0L;
        this.m_fxCheckPointDeltaTime = 0L;
    }

    void GoHuman() {
        this.m_NitroAnimation = new CGAnimation();
        this.m_fxTargetStraight = this.m_fxDefaultStraight;
        this.m_fxCurrentStraight = this.m_fxDefaultStraight;
        this.m_fxCurrentSterringStraight = 0L;
        this.m_pCurTrackNode = CGEngine.testApp.GetTrack().m_pFirstTrackNode;
        this.m_fxCurrentVelocity = 0L;
        this.m_fxCheckPointTime = 0L;
        this.m_fxStartDriftTime = 0L;
        this.m_fxStopDriftTime = 0L;
        this.m_nDriftDir = 0;
        this.m_fxSterringLeftTime = 0L;
        this.m_fxSterringRightTime = 0L;
        this.m_fxReleaseLeftTime = 0L;
        this.m_fxReleaseRightTime = 0L;
        this.m_fxPrevDistance = this.m_fxCurrentDistanceFromStart;
        this.m_fxPrevAngle = -40960000L;
        this.m_nViewAngleVariant = 3;
        this.m_nJumpHeight = 0;
        this.m_fxStartDisplayCheckPointDeltaTime = 0L;
        this.m_fxCheckPointDeltaTime = 0L;
    }

    void GoAI() {
        this.m_fxTargetStraight = this.m_fxDefaultStraight;
        this.m_fxCurrentStraight = this.m_fxDefaultStraight;
        this.m_pCurTrackNode = CGEngine.testApp.GetTrack().m_pFirstTrackNode;
        this.m_fxCurrentVelocity = 0L;
        long l = CGEngine.testApp.GetTrack().GetVelocityFactorForDistance(this.m_fxCurrentDistanceFromStart, this.m_fxCurrentStraight, this.m_pCurTrackNode, this.m_PosVector, this.m_DirVector);
        long l2 = l;
        if (l2 < 0L) {
            l2 = -l2;
        }
        l2 = 4096L - l2;
        this.m_fxTargetVelocity = l2 * this.m_fxMaxVelocityPerSec / 4096L;
    }

    public void Step() {
        if (this.m_nIsHuman == 1) {
            this.StepHuman();
        } else if (this.m_nIsHuman == 0) {
            this.StepAI();
        }
    }

    public void Sterring_Nitro() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1 && this.m_fxEnableNitroTimer == 0L) {
            this.m_fxEnableNitroTimer = 8192L + this.m_fxNitroFactorHuman * 2L;
            this.m_nBreak = 0;
            this.m_fxTargetVelocity = this.m_fxMaxVelocityPerSec * this.m_fxPowerFactorHuman / 4096L * this.m_fxNitroFactorHuman / 4096L;
            if (this.m_NitroAnimation != null) {
                this.m_NitroAnimation.Start();
            }
        }
    }

    public void Sterring_Up() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1 && !this.m_bCheckPointFailed) {
            this.m_nBreak = 0;
            this.m_fxTargetVelocity = this.m_fxMaxVelocityPerSec * this.m_fxPowerFactorHuman / 4096L;
        }
    }

    public void Sterring_Down() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1) {
            this.m_nBreak = 1;
            this.m_fxTargetVelocity = 0L;
        }
    }

    public void Sterring_Right() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1) {
            if (CGEngine.testApp.m_fxCurrentTime - this.m_fxStopDriftTime > 12288L && CGEngine.testApp.m_fxCurrentTime - this.m_fxReleaseRightTime < 800L) {
                this.m_fxStartDriftTime = CGEngine.testApp.m_fxCurrentTime;
                this.m_nDriftDir = 1;
            }
            this.m_fxReleaseRightTime = 0L;
            this.m_fxSterringLeftTime = 0L;
            this.m_nStraight = 1;
        }
    }

    public void Sterring_Left() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1) {
            if (CGEngine.testApp.m_fxCurrentTime - this.m_fxStopDriftTime > 12288L && CGEngine.testApp.m_fxCurrentTime - this.m_fxReleaseLeftTime < 800L) {
                this.m_fxStartDriftTime = CGEngine.testApp.m_fxCurrentTime;
                this.m_nDriftDir = -1;
            }
            this.m_fxReleaseLeftTime = 0L;
            this.m_fxSterringRightTime = 0L;
            this.m_nStraight = -1;
        }
    }

    public void Sterring_LeftRight() {
        if (this.m_nIsHuman == 1 && this.m_nState == 1) {
            if (this.m_fxCurrentVelocity < 40960L) {
                return;
            }
            long l = CGEngine.testApp.m_fxDeltaTime;
            if (this.m_fxStartDriftTime > 0L) {
                // empty if block
            }
            if (this.m_nStraight >= 0 && this.m_fxReleaseLeftTime == 0L) {
                this.m_fxReleaseLeftTime = CGEngine.testApp.m_fxCurrentTime;
            }
            if (this.m_nStraight <= 0 && this.m_fxReleaseRightTime == 0L) {
                this.m_fxReleaseRightTime = CGEngine.testApp.m_fxCurrentTime;
            }
            if (this.m_nStraight == 0) {
                this.m_fxSterringRightTime = 0L;
                this.m_fxSterringLeftTime = 0L;
                if (this.m_fxCurrentSterringStraight > 0L) {
                    this.m_fxCurrentSterringStraight -= l * 3L * this.m_fxHandlingFactorHuman / 4096L;
                    if (this.m_fxCurrentSterringStraight < 0L) {
                        this.m_fxCurrentSterringStraight = 0L;
                    }
                } else if (this.m_fxCurrentSterringStraight < 0L) {
                    this.m_fxCurrentSterringStraight += l * 3L * this.m_fxHandlingFactorHuman / 4096L;
                    if (this.m_fxCurrentSterringStraight > 0L) {
                        this.m_fxCurrentSterringStraight = 0L;
                    }
                }
            } else if (this.m_nStraight == 1) {
                this.m_fxSterringRightTime += CGEngine.testApp.m_fxDeltaTime;
                this.m_fxCurrentSterringStraight += l * 3L * this.m_fxHandlingFactorHuman / 4096L;
                if (this.m_fxCurrentSterringStraight > 4096L) {
                    this.m_fxCurrentSterringStraight = 4096L;
                }
            } else if (this.m_nStraight == -1) {
                this.m_fxSterringLeftTime += CGEngine.testApp.m_fxDeltaTime;
                this.m_fxCurrentSterringStraight -= l * 3L * this.m_fxHandlingFactorHuman / 4096L;
                if (this.m_fxCurrentSterringStraight < -4096L) {
                    this.m_fxCurrentSterringStraight = -4096L;
                }
            }
            int n = 1;
            n = 1;
            n = 1;
            this.m_fxCurrentStraight += l * (long)n * this.m_fxCurrentSterringStraight / 4096L;
            if (this.m_fxCurrentStraight < -__MAX_STRAIGHT__) {
                CGSoundSystem.Vibrate(300);
                this.m_fxCurrentStraight = -__AVAILABLE_MAX_STRAIGHT__;
                if (this.m_fxCurrentVelocity > 122880L) {
                    this.m_fxCurrentVelocity = 9000L * this.m_fxCurrentVelocity / 10000L;
                    this.m_fxStartDriftTime = 0L;
                    this.m_fxDriftAccumulatorTime = 0L;
                }
            } else if (this.m_fxCurrentStraight > __MAX_STRAIGHT__) {
                CGSoundSystem.Vibrate(300);
                this.m_fxCurrentStraight = __AVAILABLE_MAX_STRAIGHT__;
                if (this.m_fxCurrentVelocity > 122880L) {
                    this.m_fxCurrentVelocity = 9000L * this.m_fxCurrentVelocity / 10000L;
                    this.m_fxStartDriftTime = 0L;
                    this.m_fxDriftAccumulatorTime = 0L;
                }
            }
            if (this.m_fxCurrentStraight < -1638L) {
                this.m_fxTargetStraight = -2458L;
            }
            this.m_fxTargetStraight = this.m_fxCurrentStraight > 1638L ? 2458L : 0L;
        } else {
            this.m_nStraight = 0;
        }
    }

    public boolean IsMaxManualVelocity() {
        return this.m_fxCurrentVelocity == this.m_fxMaxVelManual[0] - 1L || this.m_fxCurrentVelocity == this.m_fxMaxVelManual[1] - 1L || this.m_fxCurrentVelocity == this.m_fxMaxVelManual[2] - 1L || this.m_fxCurrentVelocity == this.m_fxMaxVelManual[3] - 1L;
    }

    public void ChangeGear() {
        if (this.m_fxCurrentVelocity == this.m_fxMaxVelManual[0] - 1L) {
            this.m_fxCurrentVelocity = this.m_fxMaxVelManual[0] + 1L;
        } else if (this.m_fxCurrentVelocity == this.m_fxMaxVelManual[1] - 1L) {
            this.m_fxCurrentVelocity = this.m_fxMaxVelManual[1] + 1L;
        } else if (this.m_fxCurrentVelocity == this.m_fxMaxVelManual[2] - 1L) {
            this.m_fxCurrentVelocity = this.m_fxMaxVelManual[2] + 1L;
        } else if (this.m_fxCurrentVelocity == this.m_fxMaxVelManual[3] - 1L) {
            this.m_fxCurrentVelocity = this.m_fxMaxVelManual[3] + 1L;
        }
    }

    long GetRaceProgress() {
        long l = CGEngine.testApp.GetTrack().m_arrCheckPointsDistance[CGEngine.testApp.GetTrack().m_arrCheckPointsDistance.length - 1];
        long l2 = this.m_fxRealCurrentDistanceFromStart / l;
        if (l2 > 4096L) {
            return 4096L;
        }
        return l2;
    }

    void StepHuman() {
        int n;
        long l;
        long l2;
        if (this.m_nState >= 10) {
            this.m_nViewAngleVariant = 3;
            return;
        }
        if (this.m_nState == 1 && CGEngine.selectedGameMode == 3 && CGEngine.testApp.GetTrack().m_arrCheckPointsTime != null) {
            this.m_fxCheckPointTime += CGEngine.testApp.m_fxDeltaTime;
            if (this.m_fxCheckPointTime >= (long)CGEngine.testApp.GetTrack().m_arrCheckPointsTime[CGEngine.testApp.GetTrack().m_nCurrentCheckPointIndex] * 4096L) {
                // empty if block
            }
        }
        if (this.m_fxEnableNitroTimer > 0L) {
            if (this.m_NitroAnimation != null) {
                this.m_NitroAnimation.Step();
            }
            this.m_fxEnableNitroTimer -= CGEngine.testApp.m_fxDeltaTime;
            if (this.m_fxEnableNitroTimer < 0L) {
                this.m_fxEnableNitroTimer = -40960L;
                if (this.m_NitroAnimation != null) {
                    this.m_NitroAnimation.Stop();
                }
            }
        } else if (this.m_fxEnableNitroTimer < 0L) {
            this.m_fxEnableNitroTimer += CGEngine.testApp.m_fxDeltaTime;
            if (this.m_fxEnableNitroTimer > 0L) {
                this.m_fxEnableNitroTimer = 0L;
            }
        }
        this.Sterring_LeftRight();
        long l3 = 0L;
        if (this.m_fxCurrentVelocity > 0L && this.m_fxPrevDistance != this.m_fxCurrentDistanceFromStart) {
            CGEngine.testApp.GetTrack().GetVelocityFactorForDistance(this.m_fxPrevDistance, 0L, null, this.prevPos, this.DirPrev);
            l3 = CGEngine.testApp.GetTrack().GetVelocityFactorForDistance(this.m_fxCurrentDistanceFromStart, 0L, this.m_pCurTrackNode, this.curPos, this.Dir);
            this.curPos.x -= this.prevPos.x;
            this.curPos.y -= this.prevPos.y;
            this.curPos.Normalize();
            l2 = Vector2FX.AngleFromVector(this.curPos);
            if (this.m_fxPrevAngle > -40960000L) {
                l = this.m_fxPrevAngle - l2;
                if (l >= 1228800L) {
                    l -= 1474560L;
                } else if (l <= -1228800L) {
                    l += 1474560L;
                }
                long l4 = l / 40L;
                this.m_fxCurrentStraight += l4;
                if (this.m_fxCurrentStraight < -__MAX_STRAIGHT__) {
                    this.m_fxCurrentStraight = -__AVAILABLE_MAX_STRAIGHT__;
                    if (this.m_fxCurrentVelocity > 122880L) {
                        this.m_fxCurrentVelocity = 9000L * this.m_fxCurrentVelocity / 10000L;
                        this.m_fxStartDriftTime = 0L;
                        this.m_fxDriftAccumulatorTime = 0L;
                    }
                } else if (this.m_fxCurrentStraight > __MAX_STRAIGHT__) {
                    this.m_fxCurrentStraight = __AVAILABLE_MAX_STRAIGHT__;
                    if (this.m_fxCurrentVelocity > 122880L) {
                        this.m_fxCurrentVelocity = 9000L * this.m_fxCurrentVelocity / 10000L;
                        this.m_fxStartDriftTime = 0L;
                        this.m_fxDriftAccumulatorTime = 0L;
                    }
                }
                if (this.m_fxCurrentStraight < -1638L) {
                    this.m_fxTargetStraight = -2457L;
                }
                this.m_fxTargetStraight = this.m_fxCurrentStraight > 1638L ? 2457L : 0L;
                if (this.m_fxStartDriftTime == 0L && FXUtility.abs(l) > 409L) {
                    this.m_fxCurrentVelocity = l > 0L ? (this.m_fxCurrentVelocity -= this.m_fxCurrentStraight * 15L) : (this.m_fxCurrentVelocity += this.m_fxCurrentStraight * 15L);
                }
            }
            this.m_fxPrevDistance = this.m_fxCurrentDistanceFromStart;
            this.m_fxPrevAngle = l2;
        }
        if (this.m_nState == 2) {
            this.m_fxTargetVelocity = 0L;
            this.m_nBreak = 1;
        } else if (this.m_nState == 1 && this.m_nBreak == 0) {
            this.m_fxTargetVelocity = this.m_fxEnableNitroTimer > 0L ? this.m_fxMaxVelocityPerSec * this.m_fxPowerFactorHuman / 4096L * this.m_fxNitroFactorHuman / 4096L : (4096L - l3) * this.m_fxMaxVelocityPerSec * this.m_fxPowerFactorHuman / 0x1000000L;
            this.m_fxTargetVelocity *= 800L;
            this.m_fxTargetVelocity /= 1000L;
        }
        if (this.m_fxStartDriftTime > 0L) {
            this.m_fxTargetVelocity *= 50L;
            this.m_fxTargetVelocity /= 100L;
        }
        if (this.m_fxCurrentVelocity < this.m_fxTargetVelocity) {
            l2 = CGEngine.testApp.m_fxDeltaTime * this.m_fxAppendVelocityPerSec / 4096L * this.m_fxPowerFactorHuman / 4096L;
            if (this.m_bManualGear) {
                if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[0]) {
                    this.m_fxCurrentVelocity = this.m_fxCurrentVelocity + l2 >= this.m_fxMaxVelManual[0] ? this.m_fxMaxVelManual[0] - 1L : (this.m_fxCurrentVelocity += l2);
                } else if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[1]) {
                    this.m_fxCurrentVelocity = this.m_fxCurrentVelocity + l2 >= this.m_fxMaxVelManual[1] ? this.m_fxMaxVelManual[1] - 1L : (this.m_fxCurrentVelocity += l2);
                } else if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[2]) {
                    this.m_fxCurrentVelocity = this.m_fxCurrentVelocity + l2 >= this.m_fxMaxVelManual[2] ? this.m_fxMaxVelManual[2] - 1L : (this.m_fxCurrentVelocity += l2);
                } else if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[3]) {
                    this.m_fxCurrentVelocity = this.m_fxCurrentVelocity + l2 >= this.m_fxMaxVelManual[3] ? this.m_fxMaxVelManual[3] - 1L : (this.m_fxCurrentVelocity += l2);
                } else {
                    this.m_fxCurrentVelocity += l2;
                    if (this.m_fxCurrentVelocity > this.m_fxTargetVelocity) {
                        this.m_fxCurrentVelocity = this.m_fxTargetVelocity;
                    }
                }
            } else {
                this.m_fxCurrentVelocity += l2;
                if (this.m_fxCurrentVelocity > this.m_fxTargetVelocity) {
                    this.m_fxCurrentVelocity = this.m_fxTargetVelocity;
                }
            }
        } else if (this.m_fxCurrentVelocity > this.m_fxTargetVelocity) {
            l2 = CGEngine.testApp.m_fxDeltaTime;
            l2 = this.m_nBreak > 0 ? (l2 *= this.m_fxDepriveVelocityPerSec) : (l2 *= 25L * this.m_fxDepriveVelocityPerSec / 100L);
            this.m_fxCurrentVelocity -= 2L * (l2 /= 4096L);
            if (this.m_fxCurrentVelocity < this.m_fxTargetVelocity) {
                this.m_fxCurrentVelocity = this.m_fxTargetVelocity;
            }
        }
        l2 = this.m_fxCurrentVelocity - FXUtility.abs(this.m_fxCurrentSterringStraight) * 20L;
        if (l2 < 0L) {
            l2 = 0L;
        }
        l = l2 * CGEngine.testApp.m_fxDeltaTime / 4096L;
        int n2 = 0;
        for (n = 0; n < this.m_nOpponentsCount; ++n) {
            long l5 = this.m_Opponents[n].GetRealDistanceFromStart() - (this.m_fxRealCurrentDistanceFromStart + l);
            if (l5 <= 0L || l5 >= 143360L || FXUtility.abs(this.m_fxCurrentStraight - this.m_Opponents[n].GetCurrentStraight()) >= 1638L) continue;
            n2 = n + 1;
        }
        if (n2 == 0) {
            if (l > 0L) {
                n = 0;
                ++n;
            }
            if (CGEngine.selectedRaceType == 0) {
                if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[0] && this.m_fxCurrentDistanceFromStart + l >= CGEngine.testApp.GetTrack().arrRadarDistance[0] && this.m_fxCurrentVelocity > this.GetMaxHumanRadarVelocity()) {
                    if ((CGEngine.m_nCurrrentFamePoints += -15) < 0) {
                        CGEngine.m_nCurrrentFamePoints = 0;
                    }
                    CGEngine.RadarEvent();
                }
                if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[1] && this.m_fxCurrentDistanceFromStart + l >= CGEngine.testApp.GetTrack().arrRadarDistance[1] && this.m_fxCurrentVelocity > this.GetMaxHumanRadarVelocity()) {
                    if ((CGEngine.m_nCurrrentFamePoints += -15) < 0) {
                        CGEngine.m_nCurrrentFamePoints = 0;
                    }
                    CGEngine.RadarEvent();
                }
            }
            this.m_fxCurrentDistanceFromStart += l;
            this.m_fxRealCurrentDistanceFromStart += l;
            long l6 = CGEngine.testApp.GetTrack().m_fxTrackFinishDist;
            if (this.m_fxCurrentDistanceFromStart - l < l6 && this.m_fxCurrentDistanceFromStart >= l6) {
                this.m_arrLapTimes[this.m_nNrOfLaps - 1] = CGEngine.testApp.m_fxCurrentTime;
                this.m_nState = 2;
                for (int i = 1; i < CGEngine.testApp.m_nNrOfBolids; ++i) {
                    if (CGEngine.testApp.GetBolid((int)i).m_nState != 1) continue;
                    long l7 = CGEngine.testApp.GetBolid((int)i).m_fxCurrentDistanceFromStart / 4096L;
                    long l8 = CGEngine.testApp.GetTrack().m_fxTrackFinishDist;
                    long l9 = l8 / l7;
                    CGEngine.testApp.GetBolid((int)i).m_arrLapTimes[this.m_nNrOfLaps - 1] = CGEngine.testApp.m_fxCurrentTime * l9 / 4096L;
                    CGEngine.testApp.GetBolid((int)i).m_nState = 2;
                }
                System.out.println("Player complete");
            }
            if (this.m_nJumpHeight > 0) {
                this.m_nJumpHeight -= 2;
                if (this.m_nJumpHeight < 0) {
                    this.m_nJumpHeight = 0;
                }
            }
        } else {
            this.m_fxTargetVelocity *= 7L;
            this.m_fxTargetVelocity /= 10L;
            this.m_fxCurrentVelocity *= 7L;
            this.m_fxCurrentVelocity /= 10L;
            this.m_Opponents[n2 - 1].m_fxCurrentVelocity *= 12L;
            this.m_Opponents[n2 - 1].m_fxCurrentVelocity /= 10L;
        }
        CGEngine.testApp.GetTrack().GetVelocityFactorForDistance(this.m_fxCurrentDistanceFromStart, this.m_fxCurrentStraight, this.m_pCurTrackNode, this.m_PosVector, this.m_DirVector);
        this.m_BillboardObject.m_fxX = this.m_PosVector.x;
        this.m_BillboardObject.m_fxZ = this.m_PosVector.y;
        CGTrackNode cGTrackNode = CGEngine.testApp.GetTrack().FindPlaceOnTrack3D(this.m_fxCurrentDistanceFromStart, this.m_fxCurrentStraight, this.m_pCurTrackNode, this.m_PosVector3D, this.m_DirVector);
        if (cGTrackNode != null) {
            this.m_BillboardObject.m_fxX = this.m_PosVector3D.x;
            this.m_BillboardObject.m_fxY = this.m_PosVector3D.y;
            this.m_BillboardObject.m_fxZ = this.m_PosVector3D.z;
        }
        if (this.m_fxStartDriftTime > 0L && this.IsStraightLeft() == 0 && this.IsStraightRight() == 0) {
            this.m_fxStartDriftTime = 0L;
            this.m_fxStopDriftTime = CGEngine.testApp.m_fxCurrentTime;
            this.m_fxDriftAccumulatorTime = 0L;
        }
        this.m_fxLastStraight = this.m_fxCurrentStraight;
        if (this.m_fxStartDisplayCheckPointDeltaTime > 0L && CGEngine.testApp.m_fxCurrentTime - this.m_fxStartDisplayCheckPointDeltaTime > 16384L) {
            this.m_fxStartDisplayCheckPointDeltaTime = 0L;
            this.m_fxCheckPointDeltaTime = 0L;
        }
    }

    public long GetMaxHumanRadarVelocity() {
        return 1433600L;
    }

    public long GetTachoVelocity() {
        if (this.m_fxCurrentVelocity >= 2867200L) {
            return 4096L;
        }
        return this.m_fxCurrentVelocity / 700L;
    }

    public long GetTachoRPM() {
        this.m_fxMaxVelManual[0] = this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[1] = 2L * this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[2] = 3L * this.m_fxMaxVelocityPerSec / 5L;
        this.m_fxMaxVelManual[3] = 4L * this.m_fxMaxVelocityPerSec / 5L;
        if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[0]) {
            return 4096L * this.m_fxCurrentVelocity / this.m_fxMaxVelManual[0];
        }
        if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[1]) {
            return 4096L * (this.m_fxCurrentVelocity - this.m_fxMaxVelManual[0]) / (this.m_fxMaxVelManual[1] - this.m_fxMaxVelManual[0]);
        }
        if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[2]) {
            return 4096L * (this.m_fxCurrentVelocity - this.m_fxMaxVelManual[1]) / (this.m_fxMaxVelManual[2] - this.m_fxMaxVelManual[1]);
        }
        if (this.m_fxCurrentVelocity < this.m_fxMaxVelManual[3]) {
            return 4096L * (this.m_fxCurrentVelocity - this.m_fxMaxVelManual[2]) / (this.m_fxMaxVelManual[3] - this.m_fxMaxVelManual[2]);
        }
        if (this.m_fxCurrentVelocity >= 2867200L) {
            return 4096L;
        }
        return this.m_fxCurrentVelocity / 700L;
    }

    public int CheckHumanRadar() {
        if (CGEngine.selectedRaceType == 0) {
            if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[0] && this.m_fxCurrentDistanceFromStart > CGEngine.testApp.GetTrack().arrRadarDistance[0] - 0x7D0000L) {
                if (this.m_fxCurrentVelocity < this.GetMaxHumanRadarVelocity()) {
                    return 1;
                }
                return 2;
            }
            if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[1] && this.m_fxCurrentDistanceFromStart > CGEngine.testApp.GetTrack().arrRadarDistance[1] - 0x7D0000L) {
                if (this.m_fxCurrentVelocity < this.GetMaxHumanRadarVelocity()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    void StepAI() {
        long l = CGEngine.testApp.GetTrack().GetVelocityFactorForDistance(this.m_fxCurrentDistanceFromStart, this.m_fxCurrentStraight, this.m_pCurTrackNode, this.m_PosVector, this.m_DirVector);
        this.m_BillboardObject.m_fxX = this.m_PosVector.x;
        this.m_BillboardObject.m_fxZ = this.m_PosVector.y;
        CGTrackNode cGTrackNode = CGEngine.testApp.GetTrack().FindPlaceOnTrack3D(this.m_fxCurrentDistanceFromStart, this.m_fxCurrentStraight, this.m_pCurTrackNode, this.m_PosVector3D, this.m_DirVector);
        if (cGTrackNode != null) {
            this.m_BillboardObject.m_fxX = this.m_PosVector3D.x;
            this.m_BillboardObject.m_fxY = this.m_PosVector3D.y;
            this.m_BillboardObject.m_fxZ = this.m_PosVector3D.z;
        }
        if (this.m_nState == 0) {
            return;
        }
        long l2 = l;
        if (l2 < 0L) {
            l2 = -l2;
        }
        l2 = 4096L - l2;
        this.m_fxTargetVelocity = 5325L * l2 / 4096L * this.m_fxMaxVelocityPerSec / 4096L;
        if (this.m_nState == 2) {
            this.m_fxTargetVelocity = 0L;
            this.m_nStraight = 0;
        }
        int n = this.CanIChangeStraight(0x190000L);
        long l3 = this.IsOpponentOnOurTrack(0x190000L);
        if (l3 > 0L) {
            if (n > 0) {
                if (this.m_fxTargetStraight != 0L) {
                    if (this.IsOpponentOnNeighbourTrack(0L, 245760L) == 0) {
                        this.m_fxTargetStraight = 0L;
                    } else {
                        this.m_fxTargetVelocity = l3 * 3686L / 4096L;
                    }
                } else if (this.IsOpponentOnNeighbourTrack(2457L, 245760L) == 0) {
                    this.m_fxTargetStraight = 2457L;
                } else {
                    this.m_fxCurrentVelocity = this.m_fxTargetVelocity = 8L * l3 / 10L;
                }
            } else {
                this.m_fxCurrentVelocity = this.m_fxTargetVelocity = 8L * l3 / 10L;
            }
        }
        if (l3 == 0L && n > 0) {
            int n2;
            if (l > 1228L) {
                if (this.m_fxDefaultStraight == -2457L) {
                    this.m_fxTargetStraight = 0L;
                } else if (this.m_fxDefaultStraight == 0L) {
                    this.m_fxTargetStraight = 2457L;
                }
            } else if (l < -1228L) {
                if (this.m_fxDefaultStraight == 2457L) {
                    this.m_fxTargetStraight = 0L;
                } else if (this.m_fxDefaultStraight == 0L) {
                    this.m_fxTargetStraight = -2457L;
                }
            } else if (this.m_fxTargetStraight != this.m_fxDefaultStraight && (n2 = this.IsOpponentOnNeighbourTrack(this.m_fxDefaultStraight, 4096000L)) == 0) {
                this.m_fxTargetStraight = this.m_fxDefaultStraight;
            }
        }
        if (this.m_fxCurrentStraight < this.m_fxTargetStraight) {
            long l4 = 8L * CGEngine.testApp.m_fxDeltaTime / 10L;
            this.m_fxCurrentStraight += l4;
            if (this.m_fxCurrentStraight > this.m_fxTargetStraight) {
                this.m_fxCurrentStraight = this.m_fxTargetStraight;
            }
        } else if (this.m_fxCurrentStraight > this.m_fxTargetStraight) {
            long l5 = 8L * CGEngine.testApp.m_fxDeltaTime / 10L;
            this.m_fxCurrentStraight -= l5;
            if (this.m_fxCurrentStraight < this.m_fxTargetStraight) {
                this.m_fxCurrentStraight = this.m_fxTargetStraight;
            }
        }
        if (CGEngine.selectedRaceType == 0) {
            if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[0] && this.m_fxCurrentDistanceFromStart > CGEngine.testApp.GetTrack().arrRadarDistance[0] - 0x7D0000L) {
                this.m_fxTargetVelocity /= 2L;
            }
            if (this.m_fxCurrentDistanceFromStart < CGEngine.testApp.GetTrack().arrRadarDistance[1] && this.m_fxCurrentDistanceFromStart > CGEngine.testApp.GetTrack().arrRadarDistance[1] - 0x7D0000L) {
                this.m_fxTargetVelocity /= 2L;
            }
        }
        if (this.m_fxCurrentVelocity < this.m_fxTargetVelocity) {
            long l6 = CGEngine.testApp.m_fxDeltaTime * this.m_fxAppendVelocityPerSec / 4096L;
            this.m_fxCurrentVelocity += l6;
            if (this.m_fxCurrentVelocity > this.m_fxTargetVelocity) {
                this.m_fxCurrentVelocity = this.m_fxTargetVelocity;
            }
        } else if (this.m_fxCurrentVelocity > this.m_fxTargetVelocity) {
            long l7 = CGEngine.testApp.m_fxDeltaTime * this.m_fxDepriveVelocityPerSec / 4096L;
            this.m_fxCurrentVelocity -= l7;
            if (this.m_fxCurrentVelocity < this.m_fxTargetVelocity) {
                this.m_fxCurrentVelocity = this.m_fxTargetVelocity;
            }
        }
        long l8 = this.m_fxCurrentVelocity * CGEngine.testApp.m_fxDeltaTime / 4096L;
        int n3 = 0;
        for (int i = 0; i < this.m_nOpponentsCount; ++i) {
            long l9 = this.m_Opponents[i].GetRealDistanceFromStart() - (this.m_fxRealCurrentDistanceFromStart + l8);
            if (l9 <= 0L || l9 >= 143360L || FXUtility.abs(this.m_fxCurrentStraight - this.m_Opponents[i].GetCurrentStraight()) >= 1638L) continue;
            n3 = i + 1;
        }
        if (n3 == 0) {
            this.m_fxCurrentDistanceFromStart += l8;
            this.m_fxRealCurrentDistanceFromStart += l8;
            if (this.m_fxCurrentDistanceFromStart > CGEngine.testApp.GetTrack().m_fxTrackFinishDist && this.m_nState == 1) {
                this.m_arrLapTimes[this.m_nNrOfLaps - 1] = CGEngine.testApp.m_fxCurrentTime;
                this.m_nState = 2;
                this.m_nStraight = 0;
                System.out.println("AI complete");
            }
        } else {
            this.m_fxTargetVelocity *= 7L;
            this.m_fxTargetVelocity /= 10L;
            this.m_fxCurrentVelocity *= 7L;
            this.m_fxCurrentVelocity /= 10L;
            this.m_Opponents[n3 - 1].m_fxCurrentVelocity *= 12L;
            this.m_Opponents[n3 - 1].m_fxCurrentVelocity /= 10L;
        }
    }

    public int GetState() {
        return this.m_nState;
    }

    public void EndBraking() {
        this.m_fxTargetVelocity = 0L;
    }

    public CGBillboardObject GetBillboardObject() {
        return this.m_BillboardObject;
    }

    public void SetHuman(int n) {
        this.m_nIsHuman = n;
    }

    public int IsHuman() {
        return this.m_nIsHuman;
    }

    public long GetCurrentSterringStraight() {
        return this.m_fxCurrentSterringStraight;
    }

    public int GetFinishedLaps() {
        for (int i = 0; i < this.m_nNrOfLaps; ++i) {
            if (this.m_arrLapTimes[i] != 0L) continue;
            return i;
        }
        return this.m_nNrOfLaps;
    }

    public boolean IsShowFinishFlag() {
        return false;
    }

    public int GetCurrentLapTime() {
        int n = this.GetFinishedLaps();
        long l = 0L;
        if (n > 0) {
            l = this.m_arrLapTimes[n - 1];
        }
        return this.m_nBadSticks * 1000 + (int)(1000L * (CGEngine.testApp.m_fxCurrentTime - l) / 4096L);
    }

    public int GetTotalTime() {
        return (int)(1000L * this.m_arrLapTimes[this.m_nNrOfLaps - 1] / 4096L);
    }

    public int GetLapTime(int n) {
        int n2 = this.GetFinishedLaps();
        if (n < n2) {
            if (n == 0) {
                return this.m_nBadSticks * 1000 + (int)(1000L * this.m_arrLapTimes[n] / 4096L);
            }
            return this.m_nBadSticks * 1000 + (int)((1000L * this.m_arrLapTimes[n] - 1000L * this.m_arrLapTimes[n - 1]) / 4096L);
        }
        return 0;
    }

    public long GetLastLapTime() {
        return this.GetLapTime(this.m_nNrOfLaps - 1);
    }

    int GetBestLapTime() {
        int n = this.GetFinishedLaps();
        int n2 = 1000000;
        for (int i = 0; i < n; ++i) {
            int n3 = this.GetLapTime(i) / 4096;
            if (n3 >= n2) continue;
            n2 = n3;
        }
        if (n2 < 1000000) {
            return n2;
        }
        return 0;
    }

    public void SetNick(String string) {
        this.m_szNick = new String(string);
    }

    public String GetNick() {
        return this.m_szNick;
    }

    public void SetPowerFactorHuman(long l) {
        this.m_fxPowerFactorHuman = l;
    }

    public long GetPowerFactorHuman() {
        return this.m_fxPowerFactorHuman;
    }

    public void SetNitroFactorHuman(long l) {
        this.m_fxNitroFactorHuman = l;
    }

    public long GetNitroFactorHuman() {
        return this.m_fxNitroFactorHuman;
    }

    public void SetHandlingFactorHuman(long l) {
        this.m_fxHandlingFactorHuman = l;
    }

    public long GetHandlingFactorHuman() {
        return this.m_fxHandlingFactorHuman;
    }

    public int GetEndRacePosition() {
        return this.m_nEndRacePosition;
    }

    public void SetBolidIndex(int n) {
        this.m_nEngine2DBolidIndex = n;
    }

    public CGTrackNode GetCurrentTrackNode() {
        return this.m_pCurTrackNode;
    }

    public long GetCurrentNitroLevel() {
        if (this.m_fxEnableNitroTimer == 0L) {
            return 4096L;
        }
        if (this.m_fxEnableNitroTimer < 0L) {
            return (this.m_fxEnableNitroTimer + 40960L) / 10L;
        }
        return this.m_fxEnableNitroTimer / ((8192L + this.m_fxNitroFactorHuman * 2L) / 4096L);
    }

    public CGAnimation GetNitroAnimation() {
        if (this.m_fxEnableNitroTimer > 0L) {
            return this.m_NitroAnimation;
        }
        return null;
    }

    public void ResetObj() {
        this.m_pCurTrackNode = null;
    }

    int IsDrift() {
        if (this.m_fxStartDriftTime > 0L) {
            return this.m_nDriftDir;
        }
        return 0;
    }
}

