/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.FXUtility;

class CGCamera {
    public int m_nScreenXSize = 240;
    public int m_nScreenYSize = 320;
    public int m_nScreenHeight = 0;
    public int m_nCameraHeight = 105;
    public int m_nCameraDistance = 150;
    public int m_nRayCastingCount = 100;
    public long m_fxCameraScale = 4096L;
    protected long[] m_arrPlaneDistanceForRay = null;
    public long[] m_arrScaleForRay;
    public int[] m_arrMipMapForRay;
    protected long m_fxFirstPlaneScale = 4096L;
    protected long m_fxLastPlaneScale = 4096L;
    protected long m_fxDeltaScale = (this.m_fxFirstPlaneScale - this.m_fxLastPlaneScale) / (long)this.m_nRayCastingCount;
    protected long m_fxLastDistance;
    protected CGTrackNode m_pCurrentTrackNode = null;

    CGCamera() {
    }

    int FindRayIndexForDistance(long l) {
        for (int i = 0; i < this.m_nRayCastingCount; ++i) {
            if (this.m_arrPlaneDistanceForRay[i] <= l) continue;
            return i;
        }
        return this.m_nRayCastingCount - 1;
    }

    public void ResetObj() {
        this.m_pCurrentTrackNode = null;
    }

    public void SetCurrentTrackNode(CGTrackNode cGTrackNode) {
        this.m_pCurrentTrackNode = cGTrackNode;
    }

    public CGTrackNode GetCurrentTrackNode() {
        return this.m_pCurrentTrackNode;
    }

    public void PreparePlaneDistanceForRay() {
        int n = this.m_nScreenHeight + this.m_nCameraHeight;
        int n2 = this.m_nRayCastingCount;
        this.m_arrPlaneDistanceForRay = new long[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_nScreenHeight + i;
            int n4 = n3 * this.m_nCameraDistance * 4096 / (n - n3);
            this.m_arrPlaneDistanceForRay[i] = n4;
        }
        this.m_fxLastDistance = this.m_arrPlaneDistanceForRay[this.m_nRayCastingCount - 1];
    }

    public void PrepareScaleForRay() {
        int n = this.m_nRayCastingCount;
        this.m_arrScaleForRay = new long[n];
        long l = this.CalculateFloatScreenX(409600L, this.m_arrPlaneDistanceForRay[0]);
        l /= 4096L;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3 = this.CalculateFloatScreenX(409600L, this.m_arrPlaneDistanceForRay[i]);
            this.m_arrScaleForRay[i] = l2 = l3 / l;
        }
    }

    public long GetScaleForDistance(long l) {
        return this.CalculateFloatScreenX(409600L, l) / 100L;
    }

    public void PrepareMipMapForRay() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.m_nRayCastingCount;
        this.m_arrMipMapForRay = new int[n8];
        int n9 = n8 - (int)((long)n8 * 409L / 4096L);
        for (n7 = n8 - 1; n7 >= n9; --n7) {
            this.m_arrMipMapForRay[n7] = 0;
        }
        n7 = n8 - (int)((long)n8 * 655L / 4096L);
        for (n6 = n9 - 1; n6 >= n7; --n6) {
            this.m_arrMipMapForRay[n6] = 1;
        }
        n6 = n8 - (int)((long)n8 * 1024L / 4096L);
        for (n5 = n7 - 1; n5 >= n6; --n5) {
            this.m_arrMipMapForRay[n5] = 2;
        }
        n5 = n8 - (int)((long)n8 * 1638L / 4096L);
        for (n4 = n6 - 1; n4 >= n5; --n4) {
            this.m_arrMipMapForRay[n4] = 3;
        }
        n4 = n8 - (int)((long)n8 * 2253L / 4096L);
        for (n3 = n5 - 1; n3 >= n4; --n3) {
            this.m_arrMipMapForRay[n3] = 4;
        }
        n3 = n8 - (int)((long)n8 * 2867L / 4096L);
        for (n2 = n4 - 1; n2 >= n3; --n2) {
            this.m_arrMipMapForRay[n2] = 5;
        }
        n2 = n8 - (int)((long)n8 * 3482L / 4096L);
        for (n = n3 - 1; n >= n2; --n) {
            this.m_arrMipMapForRay[n] = 6;
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.m_arrMipMapForRay[n] = 7;
        }
    }

    public long CalculateScreenX(long l, long l2) {
        long l3 = (long)this.m_nCameraDistance * l;
        long l4 = ((long)this.m_nCameraDistance * 4096L + l2) / 4096L;
        return l3 / l4;
    }

    public long CalculateFloatScreenX(long l, long l2) {
        long l3 = (long)this.m_nCameraDistance * l;
        long l4 = ((long)this.m_nCameraDistance * 4096L + l2) / 4096L;
        return l3 / l4;
    }

    public int CalculateObjectScreenPosition(CGBillboardObject cGBillboardObject, int[] nArray) {
        int n = this.m_nScreenHeight + this.m_nCameraHeight;
        long l = (long)(4096 * n) * cGBillboardObject.m_fxTrZ / ((long)(4096 * this.m_nCameraDistance) + cGBillboardObject.m_fxTrZ);
        nArray[3] = (int)(l / 4096L - (long)this.m_nScreenHeight);
        long l2 = FXUtility.Sqrt(cGBillboardObject.m_fxTrY * cGBillboardObject.m_fxTrY / 4096L + cGBillboardObject.m_fxTrZ * cGBillboardObject.m_fxTrZ / 4096L);
        long l3 = this.GetScaleForDistance(l2);
        long l4 = cGBillboardObject.m_fxW * (l3 / 2L) / 4096L;
        long l5 = cGBillboardObject.m_fxH * l3 / 4096L;
        long l6 = cGBillboardObject.m_fxTrY * l3 / 4096L;
        l4 *= this.m_fxCameraScale;
        l4 /= 4096L;
        l5 *= this.m_fxCameraScale;
        nArray[1] = nArray[3] + (int)((l5 /= 4096L) / 4096L);
        nArray[1] = (int)((long)nArray[1] + l6 / 4096L);
        nArray[3] = (int)((long)nArray[3] + l6 / 4096L);
        long l7 = this.CalculateFloatScreenX(cGBillboardObject.m_fxTrX, cGBillboardObject.m_fxTrZ);
        l7 *= this.m_fxCameraScale;
        l7 /= 4096L;
        int n2 = (int)(l7 /= 4096L);
        nArray[0] = n2 - (int)l4 / 4096;
        nArray[2] = n2 + (int)l4 / 4096;
        return 1;
    }

    public int CalculateObjectScreenCenterBottomPosition(CGBillboardObject cGBillboardObject, int[] nArray) {
        int n = this.m_nScreenHeight + this.m_nCameraHeight;
        long l = (long)(4096 * n) * cGBillboardObject.m_fxTrZ / ((long)(4096 * this.m_nCameraDistance) + cGBillboardObject.m_fxTrZ);
        nArray[1] = (int)(l / 4096L - (long)this.m_nScreenHeight);
        if (nArray[1] >= this.m_nRayCastingCount) {
            return 0;
        }
        long l2 = this.CalculateFloatScreenX(cGBillboardObject.m_fxTrX, cGBillboardObject.m_fxTrZ);
        l2 *= this.m_fxCameraScale;
        l2 /= 4096L;
        nArray[0] = (int)(l2 /= 4096L);
        return 1;
    }

    public long CalculateObjectScaleForDistance(long l) {
        int n = this.m_nScreenHeight + this.m_nCameraHeight;
        long l2 = (long)(4096 * n) * l / ((long)(4096 * this.m_nCameraDistance) + l);
        int n2 = (int)(l2 / 4096L - (long)this.m_nScreenHeight);
        if (n2 >= this.m_nRayCastingCount) {
            return -4096L;
        }
        return this.m_fxCameraScale * this.m_arrScaleForRay[n2] / 4096L;
    }
}

