/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BestScores {
    public int currentTrackToShowBS = 0;
    public static boolean[] tracksUnlocked = new boolean[9];

    public static void unlockNextLevel(int n) {
        if (n + 1 < tracksUnlocked.length) {
            BestScores.tracksUnlocked[n + 1] = true;
        }
    }

    public static void unlockAllLevelsAndKarts() {
        for (int i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = true;
        }
    }

    public void initDefaultBestScores() {
        for (int i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = i < 1;
        }
    }

    public void readBestResultsFromStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"BestResults", (boolean)true);
            if (recordStore != null && recordStore.getNumRecords() != 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.readLockUnlockState(dataInputStream);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resetBestScores() {
        this.initDefaultBestScores();
        this.writeBestResultsToStore();
    }

    public void writeBestResultsToStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"BestResults", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (recordStore != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                this.writeLockUnlockState(dataOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                if (recordStore.getNumRecords() != 0) {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                } else {
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    private void readLockUnlockState(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < 9; ++i) {
            BestScores.tracksUnlocked[i] = dataInputStream.readBoolean();
        }
    }

    private void writeLockUnlockState(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < 9; ++i) {
            dataOutputStream.writeBoolean(tracksUnlocked[i]);
        }
    }
}

