/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGRainDrop;
import java.util.Vector;

public class CGRainSystem {
    public static final int modeNone = 0;
    public static final int modeRain = 1;
    public static final int modeSnow = 2;
    private int[] tabColor = new int[]{0x555566, 0x444455, 0x666677, 0x333344};
    int m_nMaxDropsRain;
    int m_nMaxDropsSnow;
    int[] m_arrDropX = null;
    int[] m_arrDropY = null;
    int[] m_arrDropZ = null;
    int m_nDropIndex;
    int m_nDropX;
    int m_nDropY;
    int m_nTime;
    int m_nMode = 1;
    CGTexture[] rainTextures = null;
    CGTexture[] dropTextures = null;
    private Vector dropsVector = new Vector();
    private long lastDropTime = 0L;
    private long newDropTime = 0L;

    public void Init(int n, int n2) {
        if (this.rainTextures == null) {
            this.rainTextures = new CGTexture[3];
        }
        this.rainTextures[0] = TextureManager.AddTexture("/gameplay/rain_drop_1.png");
        this.rainTextures[1] = TextureManager.AddTexture("/gameplay/rain_drop_2.png");
        this.rainTextures[2] = TextureManager.AddTexture("/gameplay/rain_drop_3.png");
        if (this.dropTextures == null) {
            this.dropTextures = new CGTexture[3];
        }
        this.dropTextures[0] = TextureManager.AddTexture("/gameplay/scr_rain_1.png");
        this.dropTextures[1] = TextureManager.AddTexture("/gameplay/scr_rain_2.png");
        this.dropTextures[2] = TextureManager.AddTexture("/gameplay/scr_rain_3.png");
        this.m_nMaxDropsRain = n;
        this.m_nMaxDropsSnow = n2;
        int n3 = this.m_nMaxDropsRain;
        if (this.m_nMaxDropsSnow > this.m_nMaxDropsRain) {
            n3 = this.m_nMaxDropsSnow;
        }
        this.m_arrDropX = new int[n3];
        this.m_arrDropY = new int[n3];
        this.m_arrDropZ = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.m_arrDropX[i] = Math.abs(RandSync.nextInt()) % ApplicationData.screenWidth;
            this.m_arrDropY[i] = Math.abs(RandSync.nextInt()) % ApplicationData.screenHeight;
            this.m_arrDropZ[i] = Math.abs(RandSync.nextInt(5)) + 1;
        }
        this.m_nTime = 0;
    }

    public void Step(long l) {
        int n;
        if (this.m_nMode == 0) {
            return;
        }
        int n2 = -5;
        int n3 = 8;
        long l2 = 3L;
        if (l2 >= 4L) {
            n2 = -1;
            n3 = 8;
        } else if (l2 >= 3L) {
            n2 = -1;
            n3 = 8;
        } else if (l2 >= 2L) {
            n2 = -2;
            n3 = 8;
        } else if (l2 >= 1L) {
            n2 = -3;
            n3 = 8;
        }
        if (this.m_nMode == 2) {
            n2 /= 2;
            n3 /= 2;
            for (n = 0; n < this.m_nMaxDropsSnow; ++n) {
                int n4 = n;
                this.m_arrDropX[n4] = this.m_arrDropX[n4] + n2 * this.m_arrDropZ[n];
                if (this.m_arrDropX[n] < 0) {
                    int n5 = n;
                    this.m_arrDropX[n5] = this.m_arrDropX[n5] + ApplicationData.screenWidth;
                }
                int n6 = n;
                this.m_arrDropY[n6] = this.m_arrDropY[n6] + n3 * this.m_arrDropZ[n];
                if (this.m_arrDropY[n] <= ApplicationData.screenHeight) continue;
                int n7 = n;
                this.m_arrDropY[n7] = this.m_arrDropY[n7] - ApplicationData.screenHeight;
            }
        } else {
            n2 *= 2;
            n3 *= 3;
            for (n = 0; n < this.m_nMaxDropsRain; ++n) {
                int n8 = n;
                this.m_arrDropX[n8] = this.m_arrDropX[n8] + n2 * this.m_arrDropZ[n];
                if (this.m_arrDropX[n] < 0) {
                    int n9 = n;
                    this.m_arrDropX[n9] = this.m_arrDropX[n9] + ApplicationData.screenWidth;
                }
                int n10 = n;
                this.m_arrDropY[n10] = this.m_arrDropY[n10] + n3 * this.m_arrDropZ[n];
                if (this.m_arrDropY[n] <= ApplicationData.screenHeight) continue;
                int n11 = n;
                this.m_arrDropY[n11] = this.m_arrDropY[n11] - ApplicationData.screenHeight;
            }
        }
        this.m_nTime = (int)((long)this.m_nTime - l / 4096L);
        if (this.m_nTime <= 0) {
            this.m_nDropX = Math.abs(RandSync.nextInt()) % ApplicationData.screenWidth;
            this.m_nDropY = Math.abs(RandSync.nextInt()) % ApplicationData.screenHeight;
            this.m_nTime = 3000 + Math.abs(RandSync.nextInt()) % 1000;
            this.m_nDropIndex = Math.abs(RandSync.nextInt()) % 2;
        }
        if (ApplicationData.getAppTime() > this.newDropTime) {
            CGRainDrop cGRainDrop = new CGRainDrop();
            cGRainDrop.x = Math.abs(RandSync.nextInt() % ApplicationData.screenWidth);
            cGRainDrop.y = Math.abs(RandSync.nextInt() % ApplicationData.screenHeight) * 4096;
            cGRainDrop.startSize = Math.abs(RandSync.nextInt() % 2);
            cGRainDrop.startTime = 0L;
            this.dropsVector.addElement(cGRainDrop);
            this.lastDropTime = ApplicationData.getAppTime();
            this.newDropTime = this.lastDropTime + (long)(400 + Math.abs(RandSync.nextInt() % 400));
        }
        int n12 = this.dropsVector.size();
        for (int i = n12 - 1; i >= 0; --i) {
            CGRainDrop cGRainDrop = (CGRainDrop)this.dropsVector.elementAt(i);
            cGRainDrop.Step(1000L * CGEngine.testApp.m_fxDeltaTime / 4096L);
            if (cGRainDrop.startSize <= 2) continue;
            this.dropsVector.removeElementAt(i);
        }
    }

    public void Reset() {
        this.dropsVector.removeAllElements();
        this.lastDropTime = ApplicationData.getAppTime();
        this.newDropTime = this.lastDropTime + (long)(300 + RandSync.nextInt() % 2000);
    }

    public void Render() {
        block14: {
            int n;
            int n2;
            int n3;
            block13: {
                if (this.m_nMode == 0) {
                    return;
                }
                int n4 = 1;
                int n5 = 4;
                int n6 = 12;
                n3 = 2;
                long l = 3L;
                if (l >= 4L) {
                    n3 = 1;
                    n5 = 1;
                    n6 = 7;
                } else if (l >= 3L) {
                    n3 = 2;
                    n5 = 1;
                    n6 = 9;
                } else if (l >= 2L) {
                    n3 = 2;
                    n5 = 2;
                    n6 = 10;
                } else if (l >= 1L) {
                    n3 = 2;
                    n5 = 3;
                    n6 = 11;
                }
                if (this.m_nMode != 2) break block13;
                Graphic2D.SetColor(0xFFFFFF);
                n4 = 2;
                for (int i = 0; i < this.m_nMaxDropsSnow; i += n3) {
                    Graphic2D.FillRect(this.m_arrDropX[i], this.m_arrDropY[i], n4, n4);
                }
                break block14;
            }
            if (this.rainTextures[0] != null) {
                for (n2 = 0; n2 < this.m_nMaxDropsRain; n2 += n3) {
                    n = 1;
                    if (this.m_arrDropZ[n2] < 2) {
                        n = 2;
                    }
                    int n7 = RandSync.nextInt(3);
                    Graphic2D.DrawImage(this.rainTextures[n7], this.m_arrDropX[n2], this.m_arrDropY[n2], 20);
                }
            }
            if (this.dropTextures[0] == null) break block14;
            n2 = this.dropsVector.size();
            for (n = n2 - 1; n >= 0; --n) {
                CGRainDrop cGRainDrop = (CGRainDrop)this.dropsVector.elementAt(n);
                if (cGRainDrop.startSize > 2) continue;
                Graphic2D.DrawImage(this.dropTextures[cGRainDrop.startSize], cGRainDrop.x, (int)cGRainDrop.y / 4096, 36);
            }
        }
    }

    public void SetMode(int n) {
        this.m_nMode = n;
    }
}

