/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectGameMode;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class CarSelectionScreen
extends MainUSRScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    public static int selectedCar = -1;
    private CGTexture carTexture;
    private CGTexture carName;
    private String carDescriptionLine1;
    private String carDescriptionLine2;
    private String carDescriptionLine3;
    int carPositioning;
    private CGTexture locked;
    private String carID;
    private String carPrice;
    private static int SCROLL_SPEED = 40;
    int scrollX = 0;
    int scrollXMax = 0;
    private String[] menuElements = new String[]{"ID_KART1_NAME", "ID_KART2_NAME", "ID_KART3_NAME"};

    public void autoSize() {
    }

    public CarSelectionScreen() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawFP = false;
        this.drawCash = false;
        this.drawStrip1 = true;
        this.drawStrip3 = true;
        this.drawLogo = false;
        CGUserCareer.currentKart = this.currentMenuElement;
        this.scrollX = ApplicationData.screenWidth;
        this.updateScreenInfo();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.locked = TextureManager.AddTexture("/car_locked.png");
        this.strip1Y = MainUSRScreen.getStrip1Height();
        this.strip3Y = ApplicationData.screenHeight - 2 * ObjectsCache.menuFooterImage.GetHeight() - MainUSRScreen.getStrip3Height() / 2;
        this.carPositioning = (this.strip1Y + MainUSRScreen.getStrip1Height() / 2 + this.strip3Y - MainUSRScreen.getStrip3Height() / 2) / 2;
        int n = this.carPositioning - ObjectsCache.scrollRightImg.GetHeight() / 2;
        int n2 = 0;
        int n3 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n3, n, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n2, n, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
        this.scrollX -= SCROLL_SPEED * n;
        if (this.scrollX < this.scrollXMax) {
            this.scrollX = ApplicationData.screenWidth;
        }
    }

    public void draw() {
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            Graphic2D.DrawImage(this.carTexture, ApplicationData.screenWidth / 2, this.carPositioning, 3);
        } else {
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, this.carPositioning, 3);
        }
        Graphic2D.DrawImage(this.carName, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 24);
        Utils.drawString(this.carID, ApplicationData.screenWidth, this.strip1Y + MainUSRScreen.getStrip1Height() / 2, 40, 0);
        Utils.drawString(this.carDescriptionLine2, 0, this.strip3Y, 6, 0);
        Utils.drawString(this.carDescriptionLine1, 0, this.strip3Y - ApplicationData.defaultFont.getFontHeight(), 6, 0);
        Utils.drawString(this.carDescriptionLine3, 0, this.strip3Y + ApplicationData.defaultFont.getFontHeight(), 6, 0);
    }

    public boolean rightSoftButton() {
        if (CGEngine.selectedGameMode == 1) {
            UIScreen.SetCurrentScreen(new MainMenu());
        } else if (CGEngine.selectedGameMode == 2) {
            UIScreen.SetCurrentScreen(new SelectGameMode());
        }
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
                CGUserCareer.currentKart = this.currentMenuElement;
            }
            if (CGEngine.selectedGameMode == 2) {
                UIScreen.SetCurrentScreen(new CareerScreen());
            } else {
                UIScreen.SetCurrentScreen(new LoadingLevelScreen());
            }
            return true;
        }
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= this.menuElements.length) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = this.menuElements.length - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    public void updateScreenInfo() {
        CGUserCareer.currentKart = this.currentMenuElement;
        this.carTexture = TextureManager.AddTexture("/car_" + (this.currentMenuElement + 1) + ".png");
        if (this.carTexture == null) {
            this.carTexture = TextureManager.AddTexture("/car_1.png");
        }
        this.carName = TextureManager.AddTexture("/car_" + (this.currentMenuElement + 1) + "_name.png");
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        this.carID = ApplicationData.defaultFont.encodeDynamicString(this.currentMenuElement + 1 + "/" + this.menuElements.length);
        this.carPrice = ApplicationData.defaultFont.encodeDynamicString("$50" + this.currentMenuElement);
        this.carDescriptionLine1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CAR" + (this.currentMenuElement + 1) + "_STAT_1");
        this.carDescriptionLine2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CAR" + (this.currentMenuElement + 1) + "_STAT_2");
        this.carDescriptionLine3 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_CAR" + (this.currentMenuElement + 1) + "_STAT_3");
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

