/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class EndTimeAttackScreen
extends MainScreen {
    Vector infoTextLines;
    String currentTimeString;
    String bestTimeString;
    float time;
    String congratulationString;
    private Vector mainText;
    private static long currentTotalTime = 0L;
    private static long bestTotalTime = 0L;
    public static final int MEDAL_AWARDED_NONE = -1;
    public static final int MEDAL_AWARDED_GOLD = 0;
    public static final int MEDAL_AWARDED_SILVER = 1;
    public static final int MEDAL_AWARDED_BRONZE = 2;
    private int medalAwarded = -1;
    private CGTexture medalIcon = null;

    public void Init() {
        int n = CGEngine.testApp.GetBolid(0).GetTotalTime();
        int n2 = CGEngine.selectedTrack * 3 + CGEngine.selectedRaceType;
        int n3 = CGEngine.timeAttack_GoldTime[n2];
        int n4 = CGEngine.timeAttack_SilverTime[n2];
        int n5 = CGEngine.timeAttack_BronzeTime[n2];
        if (n3 - n > 0) {
            this.medalAwarded = 0;
            this.medalIcon = TextureManager.AddTexture("/gold_medal.png");
            this.congratulationString = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_ATTACK_GOLD");
        } else if (n4 - n > 0) {
            this.medalAwarded = 1;
            this.medalIcon = TextureManager.AddTexture("/silver_medal.png");
            this.congratulationString = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_ATTACK_SILVER");
        } else if (n5 - n > 0) {
            this.medalAwarded = 2;
            this.medalIcon = TextureManager.AddTexture("/bronze_medal.png");
            this.congratulationString = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_ATTACK_BRONZE");
        } else {
            this.congratulationString = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_ATTACK_NO");
        }
        this.mainText = Utils.splitText(this.congratulationString, "+", ApplicationData.screenWidth, 2);
        UIScreen.SetCurrentScreen(this);
    }

    public void OnDraw() {
    }

    public boolean processTouchCommand(int n, int n2) {
        return false;
    }

    public EndTimeAttackScreen() {
        this.Init();
        currentTotalTime = CGEngine.testApp.GetBolid(0).GetTotalTime();
        if (bestTotalTime == 0L || bestTotalTime > currentTotalTime) {
            bestTotalTime = currentTotalTime;
        }
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TIMEATTACK_RESULTS")));
        this.bestTimeString = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TIME_ATTACK_NEW_RECORD");
        this.currentTimeString = Utils.formatTimeAsc(currentTotalTime);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
    }

    public void draw() {
        int n = ApplicationData.defaultFont.getFontHeight();
        int n2 = ApplicationData.screenHeight / 3;
        if (ObjectsCache.menuHeader != null) {
            n2 = ObjectsCache.menuHeader.GetHeight();
        }
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_ATTACK_TOTAL_TIME"), 0, n2, 36, 0);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(this.currentTimeString), ApplicationData.screenWidth >> 1, n2 += 3 * n / 2, 33, 0);
        n2 += n;
        if (this.medalIcon != null) {
            Graphic2D.DrawImage(this.medalIcon, ApplicationData.screenWidth >> 1, n2, 17);
            n2 += this.medalIcon.GetHeight();
        }
        this.drawMainText(n2 += n);
    }

    private void drawMainText(int n) {
        int n2 = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int n3 = n + i * n2;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, n3, 17, 2);
        }
    }

    public boolean leftSoftButton() {
        return true;
    }

    public boolean rightSoftButton() {
        return false;
    }
}

