/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class GarageScreen
extends MainUSRScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    private final int LEFT_ARROW1_ID;
    private final int RIGHT_ARROW1_ID;
    private final int MAX_SETTINGS;
    private CGTexture carName;
    private String carID;
    private int m_nStartControllsY;
    private int currentMenuElement = 0;
    CGTexture carTexture = null;
    SettingsControll[] controlls = new SettingsControll[3];
    private String[] menuElements = new String[]{"ID_TUNING_MENU_TYRES", "ID_TUNING_MENU_ENGINE", "ID_TUNING_MENU_BRAKES"};

    public int GetSettingsControllHeight() {
        return ObjectsCache.settingsSelectBar[0].GetHeight() + ObjectsCache.settingsSelectBar[0].GetHeight() / 4;
    }

    public void autoSize() {
    }

    protected void UpdateForCar(int n) {
        if (CGUserCareer.isKartAvailable(n)) {
            this.carTexture = TextureManager.AddTexture("/car_" + (n + 1) + ".png");
            if (this.carTexture == null) {
                this.carTexture = TextureManager.AddTexture("/car_1.png");
            }
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.carTexture = TextureManager.AddTexture("/car_locked.png");
            this.setSoftButtonImage(null, null, null, null);
        }
        this.controlls[0].value = CGUserCareer.playerKarts[n].gearratio;
        this.controlls[1].value = CGUserCareer.playerKarts[n].suspension;
        this.controlls[2].value = CGUserCareer.playerKarts[n].brakebias;
        for (int i = 0; i < 3; ++i) {
            if (this.controlls[i].value < 0) {
                this.controlls[i].value = 0;
                continue;
            }
            if (this.controlls[i].value <= 6) continue;
            this.controlls[i].value = 6;
        }
        this.carName = TextureManager.AddTexture("/car_" + (n + 1) + "_name.png");
        this.carID = ApplicationData.defaultFont.encodeDynamicString(n + 1 + "/" + this.menuElements.length);
    }

    public GarageScreen() {
        UIAnimatedButtonH uIAnimatedButtonH;
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.LEFT_ARROW1_ID = 102;
        this.RIGHT_ARROW1_ID = 103;
        this.MAX_SETTINGS = 3;
        this.carTexture = TextureManager.AddTexture("/car_" + (CGUserCareer.currentKart + 1) + ".png");
        if (this.carTexture == null) {
            this.carTexture = TextureManager.AddTexture("/car_1.png");
        }
        int n = 3 * this.GetSettingsControllHeight();
        this.m_nStartControllsY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - n;
        this.currentMenuElement = 0;
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_GARAGE_SCREEN_HEADER")));
        this.controlls[0] = new SettingsControll("GEAR_RATIO", "GEAR_RATIO_SHORT", "GEAR_RATIO_LONG", this.m_nStartControllsY);
        this.controlls[1] = new SettingsControll("SUSPENSION", "SUSPENSION_STIFF", "SUSPENSION_SOFT", this.m_nStartControllsY + this.GetSettingsControllHeight());
        this.controlls[2] = new SettingsControll("BRAKE_BIAS", "BRAKE_BIAS_REAR", "BRAKE_BIAS_FRONT", this.m_nStartControllsY + 2 * this.GetSettingsControllHeight());
        this.UpdateForCar(CGUserCareer.currentKart);
        int n2 = ApplicationData.screenWidth / 2 - ObjectsCache.setUpImg.GetWidth() / 2;
        int n3 = this.m_nStartControllsY - ObjectsCache.scrollUpImg.GetHeight();
        UIAnimatedButtonV uIAnimatedButtonV = new UIAnimatedButtonV(n2, n3, ObjectsCache.setUpImg, ObjectsCache.setUpImg, 100);
        uIAnimatedButtonV.setScreen(this);
        uIAnimatedButtonV.setAnimDir(1);
        this.addButton(uIAnimatedButtonV);
        n3 = this.m_nStartControllsY + 3 * this.GetSettingsControllHeight();
        UIAnimatedButtonV uIAnimatedButtonV2 = new UIAnimatedButtonV(n2, n3, ObjectsCache.setDownImg, ObjectsCache.setDownImg, 101);
        uIAnimatedButtonV2.setScreen(this);
        uIAnimatedButtonV2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonV2);
        int n4 = ApplicationData.screenWidth / 2 - 7 * ObjectsCache.settingsSelectRect[1].GetWidth();
        n4 -= ObjectsCache.setLeftImg.GetWidth() / 2;
        int n5 = ApplicationData.screenWidth / 2 + 7 * ObjectsCache.settingsSelectRect[1].GetWidth();
        n5 -= ObjectsCache.setRightImg.GetWidth() / 2;
        int n6 = this.m_nStartControllsY + 3 * ObjectsCache.settingsSelectBar[0].GetHeight() / 4;
        n6 -= ObjectsCache.setLeftImg.GetHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            uIAnimatedButtonH = new UIAnimatedButtonH(n4, n6, ObjectsCache.setLeftImg, ObjectsCache.setLeftImg, 102 + i * 2);
            uIAnimatedButtonH.setScreen(this);
            uIAnimatedButtonH.setAnimDir(-1);
            this.addButton(uIAnimatedButtonH);
            UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n5, n6, ObjectsCache.setRightImg, ObjectsCache.setRightImg, 103 + i * 2);
            uIAnimatedButtonH2.setScreen(this);
            uIAnimatedButtonH2.setAnimDir(1);
            this.addButton(uIAnimatedButtonH2);
            n6 += this.GetSettingsControllHeight();
        }
        n6 = this.m_nStartControllsY / 2 - ObjectsCache.setLeftImg.GetHeight() / 2;
        n4 = ApplicationData.screenWidth / 4 - ObjectsCache.setLeftImg.GetWidth() / 2;
        n5 = 3 * ApplicationData.screenWidth / 4 - ObjectsCache.setLeftImg.GetWidth() / 2;
        UIAnimatedButtonH uIAnimatedButtonH3 = new UIAnimatedButtonH(n4, n6, ObjectsCache.setLeftImg, ObjectsCache.setLeftImg, 108);
        uIAnimatedButtonH3.setScreen(this);
        uIAnimatedButtonH3.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH3);
        uIAnimatedButtonH = new UIAnimatedButtonH(n5, n6, ObjectsCache.setRightImg, ObjectsCache.setRightImg, 109);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        this.ActualizeButtons();
    }

    protected void ActualizeButtons() {
        for (int i = 102; i < 110; ++i) {
            this.findByID(i).setVisible(false);
            this.findByID(i).setSelect(false);
        }
        this.findByID(102 + 2 * this.currentMenuElement).setVisible(true);
        this.findByID(103 + 2 * this.currentMenuElement).setVisible(true);
    }

    public void onUpdate(float f) {
        this.lifeTime = (int)((float)this.lifeTime + f);
    }

    public void draw() {
        int n = this.m_nStartControllsY / 2;
        Graphic2D.DrawImage(this.carTexture, ApplicationData.screenWidth / 2, n, 3);
        for (int i = 0; i < 3; ++i) {
            this.controlls[i].Draw(this.currentMenuElement == i);
        }
    }

    public boolean rightSoftButton() {
        if (CGUserCareer.isKartAvailable(CGUserCareer.currentKart)) {
            CGUserCareer.playerKarts[CGUserCareer.currentKart].gearratio = this.controlls[0].value;
            CGUserCareer.playerKarts[CGUserCareer.currentKart].suspension = this.controlls[1].value;
            CGUserCareer.playerKarts[CGUserCareer.currentKart].brakebias = this.controlls[2].value;
            UIScreen.SetCurrentScreen(new CareerScreen());
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onUpAction();
                return true;
            }
            if (n == 101) {
                this.onDownAction();
                return true;
            }
            if (n == 102 || n == 104 || n == 106 || n == 108) {
                this.onLeftAction();
                return true;
            }
            if (n == 103 || n == 105 || n == 107 || n == 109) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean selectUpAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectDownAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onDownAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement == this.menuElements.length + 1) {
            this.currentMenuElement = 0;
        }
        this.ActualizeButtons();
        return true;
    }

    public boolean onUpAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = this.menuElements.length;
        }
        this.ActualizeButtons();
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(102 + 2 * this.currentMenuElement);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(103 + 2 * this.currentMenuElement);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (this.currentMenuElement < 3) {
            if (CGUserCareer.isKartAvailable(CGUserCareer.currentKart)) {
                this.controlls[this.currentMenuElement].IncValue();
            }
        } else {
            if (CGUserCareer.isKartAvailable(CGUserCareer.currentKart)) {
                CGUserCareer.playerKarts[CGUserCareer.currentKart].gearratio = this.controlls[0].value;
                CGUserCareer.playerKarts[CGUserCareer.currentKart].suspension = this.controlls[1].value;
                CGUserCareer.playerKarts[CGUserCareer.currentKart].brakebias = this.controlls[2].value;
            }
            if (++CGUserCareer.currentKart >= 3) {
                CGUserCareer.currentKart = 0;
            }
            this.UpdateForCar(CGUserCareer.currentKart);
        }
        return true;
    }

    public boolean onLeftAction() {
        if (this.currentMenuElement < 3) {
            if (CGUserCareer.isKartAvailable(CGUserCareer.currentKart)) {
                this.controlls[this.currentMenuElement].DecValue();
            }
        } else {
            if (CGUserCareer.isKartAvailable(CGUserCareer.currentKart)) {
                CGUserCareer.playerKarts[CGUserCareer.currentKart].gearratio = this.controlls[0].value;
                CGUserCareer.playerKarts[CGUserCareer.currentKart].suspension = this.controlls[1].value;
                CGUserCareer.playerKarts[CGUserCareer.currentKart].brakebias = this.controlls[2].value;
            }
            if (--CGUserCareer.currentKart < 0) {
                CGUserCareer.currentKart = 3;
            }
            this.UpdateForCar(CGUserCareer.currentKart);
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public void smsSentFailed(Object object) {
    }

    public class SettingsControll {
        String caption;
        String minString;
        String maxString;
        int posY;
        int value = 0;

        public SettingsControll(String string, String string2, String string3, int n) {
            this.posY = n;
            this.caption = ApplicationData.lp.getTranslatedString(Options.languageID, string);
            this.minString = ApplicationData.lp.getTranslatedString(Options.languageID, string2);
            this.maxString = ApplicationData.lp.getTranslatedString(Options.languageID, string3);
            GarageScreen.this.drawLogo = false;
            GarageScreen.this.drawStrip1 = true;
            GarageScreen.this.strip1Y = MainUSRScreen.getStrip1Height() / 2 + 27;
        }

        public void Draw(boolean bl) {
            int n;
            int n2 = 0;
            if (bl) {
                n2 = 1;
            }
            int n3 = ObjectsCache.settingsSelectBar[n2].GetWidth();
            for (n = 0; n <= ApplicationData.screenWidth / n3; ++n) {
                Graphic2D.DrawImage(ObjectsCache.settingsSelectBar[n2], n * n3, this.posY, 20);
            }
            n3 = ObjectsCache.settingsSelectRect[0].GetWidth();
            n = ApplicationData.screenWidth / 2 - n3 / 2 - 1 - n3 - 1 - n3 - 1 - n3;
            int n4 = this.posY + 3 * ObjectsCache.settingsSelectBar[n2].GetHeight() / 4;
            for (int i = 0; i < 7; ++i) {
                Graphic2D.DrawImage(ObjectsCache.settingsSelectRect[0], n + i * (n3 + 1), n4, 6);
            }
            Graphic2D.DrawImage(ObjectsCache.settingsSelectRect[1], n + this.value * (n3 + 1), n4, 6);
            Utils.drawString(this.caption, ApplicationData.screenWidth / 2, this.posY + ObjectsCache.settingsSelectBar[n2].GetHeight() / 4, 3, 0);
            Utils.drawString(this.minString, 0, this.posY + 3 * ObjectsCache.settingsSelectBar[n2].GetHeight() / 4, 6, 0);
            Utils.drawString(this.maxString, ApplicationData.screenWidth, this.posY + 3 * ObjectsCache.settingsSelectBar[n2].GetHeight() / 4, 10, 0);
            Graphic2D.DrawImage(GarageScreen.this.carName, ApplicationData.screenWidth, GarageScreen.this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 24);
            Utils.drawString(GarageScreen.this.carID, ApplicationData.screenWidth, GarageScreen.this.strip1Y + MainUSRScreen.getStrip1Height() / 2, 40, 0);
            Graphic2D.DrawImage(GarageScreen.this.carName, ApplicationData.screenWidth, GarageScreen.this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 24);
            Utils.drawString(GarageScreen.this.carID, ApplicationData.screenWidth, GarageScreen.this.strip1Y + MainUSRScreen.getStrip1Height() / 2, 40, 0);
        }

        public void IncValue() {
            if (this.value < 6) {
                ++this.value;
            }
        }

        public void DecValue() {
            if (this.value > 0) {
                --this.value;
            }
        }

        public int GetHeight() {
            return ObjectsCache.settingsSelectBar[0].GetHeight();
        }
    }
}

