/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CarSelectionScreen;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.HintScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectTrack
extends MainUSRScreen {
    private static final int DEFAULT_NUMBER_OF_LAPS = 1;
    private static final int DEFAULT_NUMBER_OF_HS_PLAYERS = 2;
    public static int numLaps = 1;
    public static int numHSplayers = 2;
    public static final int NUMBER_OF_LAPS_IN_CHAMPIONSHIPS = 1;
    public static final int NUM_TRACKS = 9;
    public int selectedTrack;
    public static int NUM_MENU_ELEMENTS = 3;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    private CGTexture cityTexture;
    private CGTexture cityName;
    private CGTexture locked;
    private String eventID;

    public void autoSize() {
    }

    public SelectTrack() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.init(0);
    }

    public SelectTrack(int n) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.init(n);
    }

    public void init(int n) {
        this.drawFP = false;
        this.drawCash = false;
        this.drawStrip2 = false;
        this.drawLogo = false;
        this.drawStrip1 = true;
        this.currentMenuElement = this.selectedTrack = n;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SELECT_CAR")));
        this.locked = TextureManager.AddTexture("/city_locked.png");
        int n2 = ApplicationData.screenHeight / 2 - ObjectsCache.scrollRightImg.GetHeight() / 2;
        int n3 = 0;
        int n4 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        this.updateScreenInfo();
        this.strip2Y = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + ApplicationData.screenHeight / 2 + this.cityTexture.GetHeight() / 2) / 2;
        this.strip1Y = (ApplicationData.screenHeight / 2 - this.cityTexture.GetHeight() / 2) / 2;
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n4, n2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n3, n2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
    }

    public void draw() {
        if (CGUserCareer.tracksUnlocked[this.currentMenuElement * 3]) {
            Graphic2D.DrawImage(this.cityTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        } else {
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
        Graphic2D.DrawImage(this.cityName, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 24);
        Utils.drawString(this.eventID, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2 + this.cityName.GetHeight(), 24, 0);
    }

    public boolean rightSoftButton() {
        if (CGEngine.selectedGameMode == 1) {
            UIScreen.SetCurrentScreen(new MainMenu());
        } else if (CGEngine.selectedGameMode == 2) {
            UIScreen.SetCurrentScreen(new EditChampionshipsUserName());
        } else if (CGEngine.selectedGameMode == 3) {
            HintScreen.showHintedScreen(new CarSelectionScreen(), new MainMenu(), HintScreen.ID_HINT_ENTER_TIME_ATTACK, "GAME_TYPE_TIMEATTACK");
        }
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.tracksUnlocked[this.currentMenuElement * 3]) {
            this.selectedTrack = this.currentMenuElement;
            CGEngine.selectedTrack = this.currentMenuElement;
            UIScreen.SetCurrentScreen(new CarSelectionScreen());
        }
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= NUM_MENU_ELEMENTS) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = NUM_MENU_ELEMENTS - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    private void updateScreenInfo() {
        this.cityTexture = TextureManager.AddTexture("/city_" + (this.currentMenuElement + 1) + "_ico.png");
        this.cityName = TextureManager.AddTexture("/city_" + (this.currentMenuElement + 1) + "_name.png");
        if (CGUserCareer.tracksUnlocked[this.currentMenuElement * 3]) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        this.eventID = ApplicationData.defaultFont.encodeDynamicString(this.currentMenuElement + 1 + "/" + NUM_MENU_ELEMENTS);
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

