/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.IOException;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;

public class LoaderObject
extends Thread {
    private Object3D m_ObjectLoaded = null;
    private boolean m_bFinished = false;
    private String m_sArchivo;
    private int m_iSleepBefore = 0;
    private int m_iSleepAfter = 0;

    LoaderObject(String aFile, int aSleepBefore, int aSleepAfter) {
        this.m_sArchivo = aFile;
        this.m_iSleepBefore = aSleepBefore;
        this.m_iSleepAfter = aSleepAfter;
        this.setPriority(5);
        this.start();
    }

    LoaderObject(String aFile) {
        this.m_sArchivo = aFile;
        this.m_iSleepBefore = 0;
        this.m_iSleepAfter = 0;
        this.setPriority(10);
        this.start();
    }

    public void run() {
        Object3D[] o = null;
        if (this.m_iSleepBefore > 0) {
            try {
                LoaderObject.sleep(this.m_iSleepBefore);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.m_sArchivo.equals("")) {
            try {
                o = Loader.load((String)(this.m_sArchivo + ".m3g"));
            }
            catch (IOException e) {
                o = null;
            }
            catch (OutOfMemoryError e) {
                o = null;
            }
            catch (NullPointerException e) {
                o = null;
            }
            if (o != null) {
                this.m_ObjectLoaded = o[0];
            }
        }
        if (this.m_iSleepAfter > 0) {
            try {
                LoaderObject.sleep(this.m_iSleepAfter);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_bFinished = true;
    }

    public boolean finished() {
        return this.m_bFinished;
    }

    public Object3D object3D() {
        return this.m_ObjectLoaded;
    }

    public World world() {
        return (World)this.m_ObjectLoaded;
    }

    public void destroy() {
        this.m_ObjectLoaded = null;
        this.m_sArchivo = null;
    }
}

