/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.CartoonRacer;
import main.KeyState;
import main.Platform;

public abstract class Menu {
    protected int m_menuWidth;
    protected int m_menuHeight;
    protected boolean m_menuRepaint;
    protected boolean m_bUp;
    protected boolean m_bDown;
    protected int m_iGoingSense;
    protected Vector m_Opciones;
    protected int m_OpcionActual;
    protected int m_OpcionMaxima;
    protected int m_BaseY;
    protected int m_BaseX;
    private boolean m_Fbsgc;
    protected int m_ColorText;
    protected int m_ColorTextSelected;
    protected int m_ColorRectBrush;
    protected int m_ColorRectBrushSelected;
    protected int m_ColorRect;
    protected int m_ColorRectSelected;
    protected int m_iColorTitle;
    protected Font m_Font;
    protected Object m_Parent;
    protected int m_iTitlePos_X;
    protected int m_iTitlePos_Y;
    protected String m_sTitle = "";
    private boolean m_Transi;
    protected int m_iTitleIMGPos_X;
    protected int m_iTitleIMGPos_Y;
    protected Image[] m_OptionImages = new Image[]{null, null};
    protected Image m_ImageTop = null;
    protected boolean m_bCiclico = true;

    public Menu(Font p_Font, Object p_Parent, Image p_Img) {
        this.m_Font = p_Font;
        this.m_Parent = p_Parent;
        this.m_Opciones = null;
        this.m_OpcionMaxima = 0;
        this.m_OpcionActual = 0;
        this.m_ColorText = 0xFFFFFF;
        this.m_ColorTextSelected = 16711749;
        this.m_ColorRect = 0;
        this.m_ColorRectSelected = 0;
        this.m_ColorRectBrush = 0;
        this.m_ColorRectBrushSelected = 0;
        this.m_iColorTitle = 8033535;
        this.m_sTitle = "";
        this.m_iTitlePos_Y = 0;
        this.m_iTitlePos_X = 0;
        this.m_iTitleIMGPos_Y = 0;
        this.m_iTitleIMGPos_X = 0;
        this.m_Transi = true;
        this.m_Fbsgc = false;
        this.setOptionImages(CartoonRacer.m_Image[6], CartoonRacer.m_Image[7]);
        this.m_BaseX = 0;
        this.m_menuRepaint = true;
        if (p_Img != null) {
            this.setTopImage(p_Img);
        }
        this.m_menuRepaint = true;
        this.m_iGoingSense = 0;
        this.m_bUp = false;
        this.m_bDown = false;
    }

    public void setTopImage(Image p_Img) {
        if (this.m_ImageTop != p_Img) {
            this.m_ImageTop = p_Img;
            this.m_menuWidth = this.m_ImageTop.getWidth();
            this.m_menuHeight = this.m_ImageTop.getHeight();
        }
        this.m_menuRepaint = true;
    }

    public void setColorTitleText(int p_color) {
        this.m_iColorTitle = p_color;
        this.m_menuRepaint = true;
    }

    public void setMenuTitleText(String p_buf) {
        this.m_sTitle = p_buf.toUpperCase();
        this.m_menuRepaint = true;
    }

    public void setMenuTitlePos(int p_Point_X, int p_Point_Y) {
        this.m_iTitlePos_X = p_Point_X;
        this.m_iTitlePos_Y = p_Point_Y;
        this.m_menuRepaint = true;
    }

    public void setMenuTitleImgPos(int p_Point_X, int p_Point_Y) {
        this.m_iTitleIMGPos_X = p_Point_X;
        this.m_iTitleIMGPos_Y = p_Point_Y;
        this.m_menuRepaint = true;
    }

    public void insertOption(String p_opcion) {
        if (this.m_Opciones == null) {
            this.m_Opciones = new Vector();
        }
        this.m_Opciones.addElement(p_opcion);
        ++this.m_OpcionMaxima;
        this.m_menuRepaint = true;
        int iMenuYCentered = 120;
        if (this.m_ImageTop != null) {
            iMenuYCentered = this.m_ImageTop.getHeight() + (240 - this.m_ImageTop.getHeight() >> 1);
        }
        int iMenuY = iMenuYCentered - ((this.m_Font.getHeight() + 0) * (this.m_Opciones.size() - 1) >> 1);
        this.setBaseY(iMenuY);
    }

    public void setElementAt(String p_opcion, int p_iIndex) {
        if (this.m_Opciones != null && this.m_Opciones.elementAt(p_iIndex) != null) {
            this.m_Opciones.setElementAt(p_opcion, p_iIndex);
        }
    }

    public void setOptionImages(Image ps1, Image ps2) {
        this.m_OptionImages[0] = ps1;
        this.m_OptionImages[1] = ps2;
        this.m_menuRepaint = true;
    }

    public void setBaseY(int p_BaseY) {
        this.m_BaseY = p_BaseY;
        this.m_menuRepaint = true;
    }

    public void setBaseX(int p_BaseX) {
        this.m_BaseX = p_BaseX;
        this.m_menuRepaint = true;
    }

    public void setColorText(int p_color) {
        this.m_ColorText = p_color;
        this.m_menuRepaint = true;
    }

    public void setColorTextSelected(int p_color) {
        this.m_ColorTextSelected = p_color;
        this.m_menuRepaint = true;
    }

    public void setColorRect(int p_colorBrush, int p_color) {
        this.m_ColorRectBrush = p_colorBrush;
        this.m_ColorRect = p_color;
        this.m_menuRepaint = true;
    }

    public void setColorRectSelected(int p_colorBrush, int p_color) {
        this.m_ColorRectBrushSelected = p_colorBrush;
        this.m_ColorRectSelected = p_color;
        this.m_menuRepaint = true;
    }

    public int getCurrentOption() {
        return this.m_OpcionActual;
    }

    public int getMaxOption() {
        return this.m_OpcionMaxima;
    }

    protected void setCurrentOption(int p_opcion) {
        this.m_OpcionActual = p_opcion >= 0 && p_opcion <= this.m_OpcionMaxima ? p_opcion : 0;
        this.m_menuRepaint = true;
    }

    protected void paintTitle(Graphics gc) {
        if (CartoonRacer.m_Image[1] != null) {
            gc.drawImage(CartoonRacer.m_Image[1], 0, 0, 20);
        } else {
            gc.setColor(0);
            gc.setStrokeStyle(0);
            gc.fillRect(0, 0, 320, 240);
        }
        if (this.m_ImageTop != null) {
            gc.drawImage(this.m_ImageTop, this.m_iTitleIMGPos_X, this.m_iTitleIMGPos_Y, 3);
        }
        if (this.m_sTitle.length() > 0) {
            Font f = gc.getFont();
            gc.setFont(Platform.FONT_MENU_TITLE);
            gc.setColor(this.m_iColorTitle);
            gc.drawString(this.m_sTitle, this.m_iTitlePos_X, this.m_iTitlePos_Y, 17);
            gc.setFont(f);
        }
    }

    public void paint(Graphics gc) {
        this.paintTitle(gc);
        this.paintBody(gc);
    }

    public void repaint() {
        this.m_menuRepaint = true;
    }

    protected void paintBody(Graphics gc) {
        if (this.m_menuRepaint) {
            this.paintTitle(gc);
        }
        if (this.m_Opciones != null) {
            int iTemp = this.m_Font.getHeight() + 0;
            int nOpciones = this.m_Opciones.size();
            int p0_x = 160;
            for (int i = 0; i < nOpciones; ++i) {
                int p0_y = this.m_BaseY + i * iTemp - (this.m_Font.getHeight() >> 1);
                if (i == this.m_OpcionActual) {
                    this.drawOption(gc, i, p0_x, p0_y, this.m_ColorRectBrushSelected, this.m_ColorRectSelected, this.m_ColorTextSelected);
                    continue;
                }
                gc.setColor(this.m_ColorText);
                Font f = gc.getFont();
                gc.setFont(this.m_Font);
                gc.drawString((String)this.m_Opciones.elementAt(i), p0_x, p0_y, 17);
                gc.setFont(f);
            }
        }
        if (this.m_bUp) {
            this.m_bUp = false;
        }
        if (this.m_bDown) {
            this.m_bDown = false;
        }
        if (this.m_menuRepaint) {
            this.m_menuRepaint = false;
        }
    }

    public void drawOption(Graphics gc, int p_i, int p_Pos_x, int p_Pos_y, int p_BrushColor, int p_PenColor, int p_TextColor) {
        int iLong = this.m_Font.stringWidth((String)this.m_Opciones.elementAt(p_i) + "  ");
        gc.drawImage(this.m_OptionImages[0], p_Pos_x - (iLong >> 1), p_Pos_y + (this.m_Font.getHeight() >> 1), 10);
        gc.drawImage(this.m_OptionImages[1], p_Pos_x + (iLong >> 1), p_Pos_y + (this.m_Font.getHeight() >> 1), 6);
        gc.setColor(p_TextColor);
        Font f = gc.getFont();
        gc.setFont(this.m_Font);
        gc.drawString((String)this.m_Opciones.elementAt(p_i), p_Pos_x, p_Pos_y, 17);
        gc.setFont(f);
    }

    protected int getBaseY() {
        return this.m_BaseY;
    }

    protected int getBaseX() {
        return this.m_BaseX;
    }

    protected void menuUp() {
        this.m_bUp = true;
        this.m_iGoingSense = 0;
        if (this.getCurrentOption() == 0) {
            if (this.m_bCiclico) {
                this.setCurrentOption(this.getMaxOption() - 1);
                this.m_iGoingSense = -1;
            }
        } else {
            this.setCurrentOption(this.getCurrentOption() - 1);
            this.m_iGoingSense = -1;
        }
    }

    protected void menuDown() {
        this.m_bDown = true;
        this.m_iGoingSense = 0;
        if (this.getCurrentOption() == this.getMaxOption() - 1) {
            if (this.m_bCiclico) {
                this.setCurrentOption(0);
                this.m_iGoingSense = 1;
            }
        } else {
            this.setCurrentOption(this.getCurrentOption() + 1);
            this.m_iGoingSense = 1;
        }
    }

    protected void menuFire(CartoonRacer pLet) {
    }

    protected void lastActions(CartoonRacer pLet) {
    }

    protected void processOtherKeys(CartoonRacer pLet) {
    }

    protected void prevLastActions(CartoonRacer pLet) {
    }

    public void processKey(CartoonRacer pLet) {
        if (KeyState.m_ACTION_MENU_UP || KeyState.m_upPressed) {
            this.menuUp();
            this.lastActions(pLet);
        } else if (KeyState.m_ACTION_MENU_DOWN || KeyState.m_downPressed) {
            this.menuDown();
            this.lastActions(pLet);
        } else if (KeyState.m_ACTION_MENU_SELECT || KeyState.m_firePressed) {
            this.menuFire(pLet);
        } else {
            this.processOtherKeys(pLet);
        }
    }

    public void destroy() {
        if (this.m_Opciones != null) {
            this.m_Opciones.removeAllElements();
            this.m_Opciones = null;
        }
        if (this.m_ImageTop != null) {
            this.m_ImageTop = null;
        }
    }

    public abstract void cmdAction(Command var1, CartoonRacer var2);
}

