/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import main.Platform;
import main.TData;
import main.Utf8;
import main.swvVector3D;

public class Utils {
    protected static final String EXTJSR184 = ".m3g";
    protected static final String TRANSFORM = "Transform";
    public static final int UNDEFINED_PROPERTY = Integer.MIN_VALUE;
    public static Random m_Random = new Random();
    private static int m_iCurrentIndex = 0;
    private static String[] m_sError = new String[]{"", "", "", "", ""};

    public static Object3D LoadScene(String name) {
        Platform.SystemGc();
        long mem = Runtime.getRuntime().freeMemory();
        Object3D[] o = null;
        try {
            o = Loader.load((String)(name + EXTJSR184));
            long memNow = mem - Runtime.getRuntime().freeMemory();
            Utils.ShowMemory();
        }
        catch (OutOfMemoryError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (o == null) {
            return null;
        }
        return o[0];
    }

    public static void ShowMemory() {
    }

    public static Node FindNodeByID(Object3D pWorld, int piId) {
        return (Node)pWorld.find(piId);
    }

    public static Object3D FindObject3DByID(Object3D pWorld, int piId) {
        return pWorld.find(piId);
    }

    public static int GenerateID(String Name) {
        int Hash = 0;
        int i = Name.length();
        while (i > 0) {
            Hash = Hash * 1664525 + 1013904223 + Name.charAt(--i);
        }
        Hash = Hash < 0 ? -Hash : Hash;
        return Hash &= 0x3FFFFFFF;
    }

    public static void setAspectRatioActiveCamera(World p_World, float p_fAspectRatio) {
        float[] proj = new float[4];
        Camera cam = p_World.getActiveCamera();
        cam.getProjection(proj);
        cam.setPerspective(proj[0], p_fAspectRatio, proj[2], proj[3]);
        proj = null;
        cam = null;
    }

    public static void burbuja(int p_iLength, boolean p_bAscendent, int[] p_viMaster, int[] p_viNewIndex) {
        for (int iIndexOuter = 0; iIndexOuter < p_iLength; ++iIndexOuter) {
            for (int iIndexInner = p_iLength - 1; iIndexInner > iIndexOuter; --iIndexInner) {
                boolean bExchange = false;
                if (p_bAscendent) {
                    if (p_viMaster[iIndexInner] >= p_viMaster[iIndexInner - 1]) {
                        bExchange = true;
                    }
                } else if (p_viMaster[iIndexInner] <= p_viMaster[iIndexInner - 1]) {
                    bExchange = true;
                }
                if (!bExchange) continue;
                int iAux = p_viMaster[iIndexInner];
                p_viMaster[iIndexInner] = p_viMaster[iIndexInner - 1];
                p_viMaster[iIndexInner - 1] = iAux;
                if (p_viNewIndex == null) continue;
                iAux = p_viNewIndex[iIndexInner];
                p_viNewIndex[iIndexInner] = p_viNewIndex[iIndexInner - 1];
                p_viNewIndex[iIndexInner - 1] = iAux;
            }
        }
    }

    public static String timeToString(int p_iTime) {
        String cRaceTime = "";
        int iSeconds = p_iTime / 1000;
        int iHundreds = (p_iTime - iSeconds * 1000) / 10;
        int iMinutes = iSeconds / 60;
        cRaceTime = cRaceTime + (char)(48 + iMinutes / 10);
        cRaceTime = cRaceTime + (char)(48 + iMinutes % 10);
        cRaceTime = cRaceTime + ":";
        cRaceTime = cRaceTime + (char)(48 + (iSeconds -= iMinutes * 60) / 10);
        cRaceTime = cRaceTime + (char)(48 + iSeconds % 10);
        cRaceTime = cRaceTime + ":";
        cRaceTime = cRaceTime + (char)(48 + iHundreds / 10);
        cRaceTime = cRaceTime + (char)(48 + iHundreds % 10);
        return cRaceTime;
    }

    public static byte[] GetProperty(Object3D pObject, String psProp) {
        Hashtable table = (Hashtable)pObject.getUserObject();
        if (table == null) {
            return null;
        }
        Integer id = new Integer(Utils.GenerateID(psProp));
        return (byte[])table.get(id);
    }

    public static String GetPropertyAsString(Object3D pObject, String psProp) {
        String s = null;
        byte[] bytes = Utils.GetProperty(pObject, psProp);
        if (bytes != null) {
            s = new String(bytes);
        }
        return s;
    }

    public static boolean ExistsProperty(Object3D pObject, String psProp) {
        return Utils.GetProperty(pObject, psProp) != null;
    }

    public static int GetExistentPropertyAsInt(Object3D pObject, String psProp) {
        return Integer.parseInt(Utils.GetPropertyAsString(pObject, psProp));
    }

    public static int GetPropertyAsInt(Object3D pObject, String psProp) {
        String str = Utils.GetPropertyAsString(pObject, psProp);
        if (str != null) {
            return Integer.parseInt(str);
        }
        return Integer.MIN_VALUE;
    }

    public static boolean GetBoundingBox(World p_world, Object3D pObj, float[] piExtents, float[] piOrigin) {
        Vector vector = new Vector();
        float[] mMax = new float[4];
        float[] mMin = new float[4];
        float MaxZ = Float.MIN_VALUE;
        float MaxY = Float.MIN_VALUE;
        float MaxX = Float.MIN_VALUE;
        float MinZ = Float.MAX_VALUE;
        float MinY = Float.MAX_VALUE;
        float MinX = Float.MAX_VALUE;
        Utils.TraverseDescendantsForMeshes(pObj, vector);
        int iIndice = vector.size();
        while (--iIndice >= 0) {
            Mesh _mesh = (Mesh)vector.elementAt(iIndice);
            Utils._getMeshBoundingBox(p_world, _mesh, mMax, mMin);
            if (mMin[0] < MinX) {
                MinX = mMin[0];
            }
            if (mMax[0] > MaxX) {
                MaxX = mMax[0];
            }
            if (mMin[1] < MinY) {
                MinY = mMin[1];
            }
            if (mMax[1] > MaxY) {
                MaxY = mMax[1];
            }
            if (mMin[2] < MinZ) {
                MinZ = mMin[2];
            }
            if (!(mMax[2] > MaxZ)) continue;
            MaxZ = mMax[2];
        }
        float ex = piExtents[0] = (MaxX - MinX) * 0.5f;
        float ey = piExtents[1] = (MaxY - MinY) * 0.5f;
        float ez = piExtents[2] = (MaxZ - MinZ) * 0.5f;
        piOrigin[0] = MinX + ex;
        piOrigin[1] = MinY + ey;
        piOrigin[2] = MinZ + ez;
        vector.removeAllElements();
        vector = null;
        mMax = null;
        mMin = null;
        return true;
    }

    private static void _getMeshBoundingBox(World p_world, Mesh pMesh, float[] piMax, float[] piMin) {
        float[] l_Vector = new float[4];
        Transform nT = new Transform();
        VertexBuffer vB = pMesh.getVertexBuffer();
        VertexArray vA = vB.getPositions(l_Vector);
        int vertexCount = vB.getVertexCount();
        float scale = l_Vector[0];
        float bias_X = l_Vector[1];
        float bias_Y = l_Vector[2];
        float bias_Z = l_Vector[3];
        float[] vBuffer = new float[vertexCount << 2];
        nT.transform(vA, vBuffer, true);
        pMesh.getTransformTo((Node)p_world, nT);
        float minZ = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minX = Float.MAX_VALUE;
        float maxZ = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxX = Float.MIN_VALUE;
        for (int i = 0; i < vertexCount; ++i) {
            int ivar = i << 2;
            l_Vector[0] = bias_X + vBuffer[ivar] * scale;
            l_Vector[1] = bias_Y + vBuffer[++ivar] * scale;
            l_Vector[2] = bias_Z + vBuffer[++ivar] * scale;
            l_Vector[3] = 1.0f;
            nT.transform(l_Vector);
            ivar = i << 2;
            float _x = l_Vector[0];
            float _y = l_Vector[1];
            float _z = l_Vector[2];
            if (_x < minX) {
                minX = _x;
            } else if (_x > maxX) {
                maxX = _x;
            }
            if (_y < minY) {
                minY = _y;
            } else if (_y > maxY) {
                maxY = _y;
            }
            if (_z < minZ) {
                minZ = _z;
                continue;
            }
            if (!(_z > maxZ)) continue;
            maxZ = _z;
        }
        piMax[0] = maxX;
        piMax[1] = maxY;
        piMax[2] = maxZ;
        piMin[0] = minX;
        piMin[1] = minY;
        piMin[2] = minZ;
        vBuffer = null;
        l_Vector = null;
        nT = null;
    }

    public static void TraverseDescendantsForMeshes(Object3D obj, Vector pVector) {
        int numReferences = obj.getReferences(null);
        if (numReferences > 0) {
            Object3D[] objArray = new Object3D[numReferences];
            obj.getReferences(objArray);
            for (int i = 0; i < numReferences; ++i) {
                Object3D objct = objArray[i];
                if (objct instanceof Mesh) {
                    pVector.addElement(objct);
                    continue;
                }
                if (!(objct instanceof Group) && !(objct instanceof Node)) continue;
                Utils.TraverseDescendantsForMeshes(objct, pVector);
            }
        }
    }

    public static void TraverseDescendantsForAppearance(Object3D obj, Vector pVector) {
        int numReferences = obj.getReferences(null);
        if (numReferences > 0) {
            Object3D[] objArray = new Object3D[numReferences];
            obj.getReferences(objArray);
            for (int i = 0; i < numReferences; ++i) {
                Object3D objct = objArray[i];
                if (objct instanceof Appearance) {
                    pVector.addElement(objct);
                    continue;
                }
                if (!(objct instanceof Group) && !(objct instanceof Node)) continue;
                Utils.TraverseDescendantsForAppearance(objct, pVector);
            }
        }
    }

    public static void RemoveNodeFromWorld(Object3D o) {
        ((Group)((Group)o).getParent()).removeChild((Node)o);
        o = null;
    }

    public static Vector LoadFileInVector(Object parent, String p_sResource) {
        Vector<String> aVector = new Vector<String>();
        InputStream m_in = parent.getClass().getResourceAsStream(p_sResource);
        DataInputStream in = new DataInputStream(m_in);
        try {
            StringBuffer buffer = new StringBuffer();
            while (Utf8.readUtf8(in, buffer) != -1) {
                aVector.addElement(buffer.toString());
            }
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return aVector;
    }

    public static void startAnimation(Object3D aWorld, int aID, int aTime) {
        AnimationController aAC = (AnimationController)Utils.FindObject3DByID(aWorld, aID);
        if (aAC != null) {
            aAC.setWeight(1.0f);
            aAC.setPosition(0.0f, aTime);
            aAC = null;
        }
    }

    public static void startAnimation(Object3D aWorld, int aID) {
        Utils.startAnimation(aWorld, aID, (int)System.currentTimeMillis());
    }

    public static void stopAnimation(Object3D aWorld, int aID) {
        AnimationController aAC = (AnimationController)Utils.FindObject3DByID(aWorld, aID);
        if (aAC != null) {
            aAC.setWeight(0.0f);
            aAC = null;
        }
    }

    public static boolean existeFileDir(String p_sFile) {
        InputStream in = ((Object)((Object)TData.GetCanvas())).getClass().getResourceAsStream(p_sFile);
        if (in != null) {
            in = null;
            return true;
        }
        return false;
    }

    public static void SystemOut(String aString) {
    }

    public static void SystemOutXYZ(float[] aXYZ) {
        Utils.SystemOut("x:" + aXYZ[0] + " y:" + aXYZ[1] + " z:" + aXYZ[2]);
    }

    public static void SystemswvVector3D(String aString, swvVector3D aVector) {
        Utils.SystemOut(aString + "\tx:" + aVector.x + "\ty:" + aVector.y + "\tz:" + aVector.z);
    }

    public static void drawWaiting(Graphics g, int iBaseY) {
        Font aFont = g.getFont();
        g.setFont(Platform.FONT_SYSTEM_PLAIN_SMALL);
        int WAIT_ALTO_MARCO = g.getFont().getHeight() + 0;
        int WAIT_ALTO_CUADRO = WAIT_ALTO_MARCO - 6;
        int WAIT_MARGEN_Y = WAIT_ALTO_MARCO - WAIT_ALTO_CUADRO >> 1;
        int aY = iBaseY - (WAIT_ALTO_MARCO + 2);
        int iBaseX = 105;
        g.setColor(0xFFFFFF);
        g.fillRect(iBaseX, aY, 111, WAIT_ALTO_MARCO);
        g.setColor(0x222222);
        g.drawRect(iBaseX, aY, 111, WAIT_ALTO_MARCO);
        int iStartX = iBaseX + 3;
        for (int iIndex = 0; iIndex < 9; ++iIndex) {
            if (iIndex != m_iCurrentIndex) {
                g.setColor(12900082);
            } else {
                g.setColor(6394845);
            }
            g.fillRect(iStartX, aY + WAIT_MARGEN_Y, 9, WAIT_ALTO_CUADRO);
            iStartX += 12;
        }
        m_iCurrentIndex = m_iCurrentIndex < 9 ? ++m_iCurrentIndex : 0;
        g.setFont(aFont);
    }

    public static void IntToCharsParam(int iValue, char[] cChars, int iLong, boolean bZero) {
        int iIndex = 0;
        boolean bNeg = iValue < 0;
        iValue = bNeg ? -iValue : iValue;
        do {
            cChars[iLong - iIndex - 1] = (char)(iValue % 10 + 48);
        } while ((iValue /= 10) != 0 && ++iIndex < iLong);
        for (int i = iIndex; i < iLong; ++i) {
            cChars[iLong - iIndex - 1] = bZero ? 48 : 32;
            ++iIndex;
        }
        if (bNeg) {
            if (bZero) {
                cChars[iLong - iIndex] = 45;
            } else if (iLong - iIndex > 0) {
                cChars[iLong - iIndex - 1] = 45;
                ++iIndex;
            }
        }
    }

    public static void TimeToCharsParam(int p_iTime, char[] cRaceTime) {
        int iSeconds = p_iTime / 1000;
        int iHundreds = (p_iTime - iSeconds * 1000) / 10;
        int iMinutes = iSeconds / 60;
        cRaceTime[0] = (char)(48 + iMinutes / 10);
        cRaceTime[1] = (char)(48 + iMinutes % 10);
        cRaceTime[5] = 58;
        cRaceTime[2] = 58;
        cRaceTime[3] = (char)(48 + (iSeconds -= iMinutes * 60) / 10);
        cRaceTime[4] = (char)(48 + iSeconds % 10);
        cRaceTime[6] = (char)(48 + iHundreds / 10);
        cRaceTime[7] = (char)(48 + iHundreds % 10);
    }

    public static String GetLastError() {
        return m_sError[0];
    }

    public static String GetLastError(int iIndex) {
        return m_sError[iIndex];
    }

    protected static void MovePastHeader(DataInputStream aDis, String headertolookfor) throws IOException {
        int headerlenght = headertolookfor.length();
        int numCharsFound = 0;
        boolean headerfound = false;
        boolean eof = false;
        while (!headerfound && !eof) {
            byte b;
            try {
                b = aDis.readByte();
            }
            catch (EOFException e) {
                eof = true;
                continue;
            }
            if (b == headertolookfor.charAt(numCharsFound)) {
                if (++numCharsFound != headerlenght) continue;
                headerfound = true;
                continue;
            }
            numCharsFound = 0;
        }
    }

    public static class Chars {
        private static char[] m_3Chars = new char[3];
        private static char[] m_TimeChars = new char[8];
        private static char[] m_DeltaChars = new char[]{'D', 'e', 'l', 't', 'a', ':', ' ', ' ', ' '};
        public static int DELTATIME_LENGTH = m_DeltaChars.length;
        public static int TIME_LENGTH = m_TimeChars.length;

        public static char[] Time(int p_iTime) {
            Utils.TimeToCharsParam(p_iTime, m_TimeChars);
            return m_TimeChars;
        }

        public static char[] DeltaTime(int p_iValue) {
            Utils.IntToCharsParam(p_iValue, m_3Chars, 3, true);
            Chars.m_DeltaChars[6] = m_3Chars[0];
            Chars.m_DeltaChars[7] = m_3Chars[1];
            Chars.m_DeltaChars[8] = m_3Chars[2];
            return m_DeltaChars;
        }

        public static char[] ThreeDigits(int p_iValue) {
            Utils.IntToCharsParam(p_iValue, m_3Chars, 3, true);
            return m_3Chars;
        }
    }
}

