/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.rms.RecordStoreException;
import main.RMSManager;

public class GameSettings
extends RMSManager {
    public static final int INDEX_SOUND = 1;
    public static final int INDEX_VIBRA = 2;
    public static final int INDEX_BACKLIGHT = 3;
    public static final int INDEX_LAST_NAME = 4;
    public static final int INDEX_BOMB_CHASE_TYPE = 5;
    public static final int INDEX_RECEIVED_PLAYER_UID = 6;
    public static final int INDEX_GAME_VERSION = 7;
    public static boolean m_bSound = false;
    public static boolean m_bBackLight = true;
    public static boolean m_bVibra = true;
    public static String m_sLastName = "";
    public static int m_iBombChaseType = 0;
    private static int m_iVersion = Integer.MIN_VALUE;
    public static final boolean CLOSE = true;
    public static final String DEFAULT_PLAYER_UID = "-1";
    public static final String DEFAULT_PLAYER_NAME = "AAAA";
    private static String MReceivedPlayerUID = "-1";
    public static boolean MUploadThreadEnded = false;
    public static boolean MUploadThreadEndedCanceled = false;
    public static boolean MUploadThreadEndedHadSuccess = false;
    public static int MUploadReceivedRank = -1;
    public static String MUploadReceivedPlayerUID = "AAAA";
    public static final int GAME_VERSION = 7;
    private static final boolean GARBAGE_COLLECTOR = false;

    GameSettings() {
        this.mStoreName = "agrset";
        if (!this.openStore("agrset", false)) {
            this.openStore("agrset", true);
            this.recordDefaultSettings();
        } else {
            this.loadRmsData();
            if (m_iVersion < 7) {
                this.deleteAllRecords();
                this.recordDefaultSettings();
            }
        }
    }

    public void close() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void recordDefaultSettings() {
        m_bVibra = true;
        m_bBackLight = true;
        m_sLastName = "";
        m_iBombChaseType = 0;
        MReceivedPlayerUID = DEFAULT_PLAYER_UID;
        m_iVersion = 7;
        this.addRecord(m_bSound ? 1 : 0);
        this.addRecord(m_bVibra ? 1 : 0);
        this.addRecord(m_bBackLight ? 1 : 0);
        this.addRecord(m_sLastName);
        this.addRecord(m_iBombChaseType);
        this.addRecord(DEFAULT_PLAYER_UID);
        this.addRecord(7);
    }

    private void loadRmsData() {
        this.setBoolean(1, m_bSound);
        m_bVibra = this.getBoolean(2);
        m_bBackLight = this.getBoolean(3);
        m_sLastName = this.getString(4);
        m_iBombChaseType = this.getInteger(5);
        MReceivedPlayerUID = this.getString(6);
        m_iVersion = this.getInteger(7);
    }

    public void setReceivedPlayerUID(String pReceivedPlayerUID) {
        this.setAndStoreUserID(pReceivedPlayerUID);
    }

    public static String GetReceivedPlayerUID() {
        return MReceivedPlayerUID;
    }

    public void uploadingWasSuccess() {
        if (MReceivedPlayerUID.compareTo(DEFAULT_PLAYER_UID) == 0) {
            this.setReceivedPlayerUID(MUploadReceivedPlayerUID);
        }
    }

    public synchronized void setAndStoreSound(boolean p_bSound) {
        boolean iValue = false;
        m_bSound = p_bSound;
        this.setBoolean(1, m_bSound);
    }

    public synchronized void setAndStoreBombChaseType(int p_iType) {
        m_iBombChaseType = p_iType;
        this.setInteger(5, m_iBombChaseType);
    }

    public synchronized void setAndStoreBackLight(boolean p_bBackLight) {
        m_bBackLight = p_bBackLight;
        this.setBoolean(3, m_bBackLight);
    }

    public synchronized void setAndStoreVibra(boolean p_bVibra) {
        m_bVibra = p_bVibra;
        this.setBoolean(2, m_bVibra);
    }

    public void setAndStoreLastName(String p_sLastName) {
        m_sLastName = p_sLastName;
        this.setString(4, m_sLastName);
    }

    public void setAndStoreUserID(String p_sUserID) {
        MReceivedPlayerUID = p_sUserID;
        this.setString(6, MReceivedPlayerUID);
    }

    public static final int GetGameVersion() {
        return m_iVersion;
    }
}

