/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SavageCanvas_NOKIAUI
extends FullCanvas {
    public Image imgBuffer;
    public Graphics gfxBuffer = null;
    public SavageScreen pScreen = null;
    public boolean bAppPaused = false;
    public int nWidth;
    public int nHeight;
    public int nScrWidth = this.getWidth();
    public int nScrHeight = this.getHeight();
    public int rumble_counter = -1;
    public int light_counter = 0;
    public int nLightLevel = 0;
    public Sound[] sounds;
    public int nNextSound;

    public final void setDisplay(Display display) {
    }

    public final Image cacheFindImage(int n) {
        return null;
    }

    public final void cacheAddImage(int n, Image image) {
    }

    public final void setScreen(SavageScreen savageScreen) {
        if (savageScreen != null) {
            savageScreen.pCanvas = this;
            savageScreen.gfxBuffer = this.gfxBuffer;
            savageScreen.imgBuffer = this.imgBuffer;
            savageScreen.setGraphics(this.gfxBuffer);
            this.gfxBuffer.setClip(0, 0, this.nWidth, this.nHeight);
        }
        this.pScreen = savageScreen;
    }

    public final void destroy() {
        if (this.imgBuffer != null) {
            this.imgBuffer = null;
        }
        if (this.gfxBuffer != null) {
            this.gfxBuffer = null;
        }
    }

    public final void createBackBuffer(int n, int n2) {
        this.nWidth = n;
        if (this.nWidth < this.nScrWidth) {
            this.nWidth = this.nScrWidth;
        }
        this.nHeight = n2;
        if (this.nHeight < this.nScrHeight) {
            this.nHeight = this.nScrHeight;
        }
        this.imgBuffer = Image.createImage((int)this.nWidth, (int)this.nHeight);
        this.gfxBuffer = this.imgBuffer.getGraphics();
        this.gfxBuffer.setColor(255, 255, 255);
        this.gfxBuffer.fillRect(0, 0, this.nWidth, this.nHeight);
    }

    public final void flip() {
        while (this.bAppPaused || !this.isShown()) {
            Thread.yield();
        }
        this.repaint();
        this.serviceRepaints();
        if (this.rumble_counter > 0 && --this.rumble_counter == 0) {
            this.stopRumble();
        }
        if (this.light_counter++ > 10) {
            this.light_counter = 0;
            DeviceControl.setLights((int)0, (int)this.nLightLevel);
        }
    }

    public final void paint(Graphics graphics) {
        if (this.pScreen != null) {
            this.pScreen.paint(graphics);
        }
    }

    public final void setLightLevel(int n) {
        this.nLightLevel = n;
        if (this.nLightLevel > 100) {
            this.nLightLevel = 100;
        }
        try {
            DeviceControl.setLights((int)0, (int)this.nLightLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void startRumble(int n, int n2) {
        this.rumble_counter = n2;
        try {
            DeviceControl.startVibra((int)n, (long)50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void stopRumble() {
        this.rumble_counter = 0;
        try {
            DeviceControl.stopVibra();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void keyReleased(int n) {
        if (this.pScreen != null) {
            this.pScreen.keyReleased(n);
        }
    }

    public final void keyPressed(int n) {
        if (this.pScreen == null) {
            return;
        }
        this.pScreen.nLastKey = n;
        this.pScreen.bKeyPressed = true;
        this.pScreen.keyPressed(n);
    }

    public final void sndInit() {
        this.sounds = new Sound[8];
        this.nNextSound = 0;
    }

    public final int sndLoad(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.nNextSound++;
        byte[] byArray = this.pScreen.resLoad(n);
        byte by = byArray[1];
        byte[] byArray2 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
        byArray = null;
        this.sounds[n2] = new Sound(byArray2, (int)by);
        byArray2 = null;
        return n2;
    }

    public final void sndPlay(int n, int n2, int n3) {
        if (n < 0) {
            return;
        }
        if (this.sounds[n] != null && this.sounds[n].getState() == 1) {
            this.sounds[n].play(n2);
        }
    }

    public final void sndStop(int n) {
        if (n < 0) {
            return;
        }
        if (this.sounds[n] != null) {
            this.sounds[n].stop();
        }
    }

    public final void sndReset() {
        for (int i = 0; i < this.sounds.length; ++i) {
            if (this.sounds[i] == null) continue;
            this.sounds[i].release();
            this.sounds[i] = null;
        }
        this.nNextSound = 0;
    }

    public final String getKeyName(int n) {
        if (n >= 0) {
            return super.getKeyName(n);
        }
        switch (n) {
            case -6: {
                return "L Softkey";
            }
            case -7: {
                return "R Softkey";
            }
            case -10: {
                return "Send";
            }
            case -11: {
                return "End";
            }
            case -5: {
                return "Select";
            }
            case -1: {
                return "Up";
            }
            case -2: {
                return "Down";
            }
            case -3: {
                return "Left";
            }
            case -4: {
                return "Right";
            }
        }
        return "undefined";
    }

    public final void hideNotify() {
        if (!this.bAppPaused) {
            this.bAppPaused = true;
            if (this.pScreen != null) {
                this.pScreen.saveState();
            }
        }
    }

    public final void showNotify() {
        if (this.bAppPaused) {
            this.bAppPaused = false;
            if (this.pScreen != null) {
                this.pScreen.msLag = 0L;
            }
        }
    }
}

