/*
 * Decompiled with CFR 0.152.
 */
package game;

import constants.Anim3DConstants;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import constants.TunerShopConstants;
import game.AppEngine;
import game.GlobalConstants;
import game.NonUniformSpline;
import game.SceneGame;
import generic.AnimPlayer3D;
import generic.AnimationManager;
import generic.MathExt;
import generic.engine2d.Node2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.Transformable;

public final class TrackObject
implements AnimConstants,
Anim3DConstants,
ColourConstants,
IStringConstants,
ResourceConstants,
SoundEventConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants,
TunerShopConstants {
    public static final int OBJECT_INVALID = -1;
    public static final short STATE_NONE = 0;
    public static final short STATE_COP_IDLE = 1;
    public static final short STATE_COP_CRUISING = 2;
    public static final short STATE_COP_GETINFRONT = 3;
    public static final short STATE_COP_BRAKING = 4;
    public static final short STATE_COP_STOP = 5;
    public static final short STATE_DYING = 6;
    public static final short STATE_DEAD = 7;
    private static final int[] s_tempInt4_1 = new int[4];
    private static final int[] s_tempInt4_2 = new int[4];
    public static final int IDX_X_AXIS = 0;
    public static final int IDX_Y_AXIS = 1;
    public static final int IDX_Z_AXIS = 2;
    public static final int NUM_AXES = 3;
    public static final int FLAGS_CAR = 1;
    public static final int FLAGS_CIVILIAN = 2;
    public static final int FLAGS_COP = 4;
    public static final int FLAGS_ENEMY = 8;
    public static final int FLAGS_OBSTACLE = 16;
    public static final int FLAGS_VISIBLE = 64;
    public static final int FLAGS_AI_DRIVER = 128;
    public static final int FLAGS_AI_BOOST = 256;
    public static final int FLAGS_ACCELERATING = 512;
    public static final int FLAGS_BRAKING = 1024;
    public static final int FLAGS_OFFTRACK = 2048;
    public static final int FLAGS_FAR_OFFTRACK = 4096;
    public static final int FLAGS_BOOSTING = 8192;
    public static final int FLAGS_FINISHED = 16384;
    public static final int FLAGS_PROXIMITY = 32768;
    public static final int FLAGS_COLLIDING = 65536;
    public static final int FLAGS_CRASHING = 131072;
    public static final int FLAGS_ANIMATING = 262144;
    public static final int FLAGS_RECENTERING = 524288;
    public static final int FLAGS_INPURSUIT = 0x200000;
    public static final int FLAGS_PARTICLE_SYSTEM = 0x400000;
    public static final int FLAGS_RAGDOLL = 0x800000;
    public static final int FLAGS_ATTACKING = 0x1000000;
    public static final int FLAGS_PICKEDLANE = 0x2000000;
    public static final int FLAGS_ANIMRIGANIM = 0x4000000;
    public static final int FLAGS_IN_RACE = 0x8000000;
    public static final byte DIRECTION_FORWARD = 0;
    public static final byte DIRECTION_BACKWARD = 1;
    public static final byte DIRECTION_LEFT = 2;
    public static final byte DIRECTION_RIGHT = 3;
    public static final byte DIRECTION_CUSTOM = 4;
    private static final int DEFAULT_BOOST_SPEED_MULTIPLIER_F = 78643;
    private static final int DEFAULT_BOOST_ACCEL_MULTIPLIER_F = 196608;
    private static final int DEFAULT_SSTREAM_SPEED_MULTIPLIER_F = 78643;
    private static final int DEFAULT_SSTREAM_ACCEL_MULTIPLIER_F = 196608;
    private static final int DEFAULT_POST_BOOST_SLOWING_F = 65536;
    private static final int DEFAULT_BRAKING_F = 393216;
    private static final int DEFAULT_BRAKING_INC_F = 65536;
    private static final int DEFAULT_OFFTRACK_BRAKING_F = 131072;
    private static final int DEFAULT_FAR_OFFTRACK_BRAKING_F = 262144;
    private static final int GEARCHANGE_DELAY_TIME_F = 16384;
    private static final int GEARCHANGE_BOOSTING_DELAY_TIME_F = 3276;
    private static final int OFFTRACK_MIN_SPEED_F = 327680;
    private static final int OFFTRACK_MIN_SPEED_AI_F = 163840;
    private static final int SLOWEST_SPEED_LATCHANGE = 16384;
    private static final int HEALTH_FLASH_COUNT = 4;
    private static final int HEALTH_FLASH_CYCLE = 300;
    public static final int COLLISION_SIDE_LEFT = 0;
    public static final int COLLISION_SIDE_RIGHT = 1;
    private static final int LAT_FORCE_KILL_F = 524288;
    private static final int LAT_FORCE_KILL_CRASH_F = 1966;
    private static final int BASH_COOLDOWN = 1000;
    private static final int SLOWEST_ANIM_SPEED_F = 0;
    private static final int ROLL_RETURN_SPEED_F = 65536;
    private static final int VISIBILITY_FLASH_TIME = 1080;
    private static final int RESPAWN_FLASH_CYCLE = 180;
    private static final int AI_START_BOOST_TIME = 2000;
    private static final int AI_DELAY_MIN = 2000;
    private static final int AI_DELAY_MAX = 3000;
    private static final int AI_PICK_LATPOS_DELAY_MIN = 1000;
    private static final int AI_PICK_LATPOS_DELAY_MAX = 4000;
    private static final int CORNER_SPEED_EASY = 26214;
    private static final int SWERVE_SPEED_EASY = 78643;
    private static final int RELAX_DIST_MIN_EASY = 65536;
    private static final int RELAX_DIST_MAX_EASY = 0x140000;
    private static final int RELAX_SPEED_MIN_EASY = 58982;
    private static final int RELAX_SPEED_MAX_EASY = 55705;
    private static final int PANIC_DIST_MIN_EASY = 393216;
    private static final int PANIC_DIST_MAX_EASY = 0x1E0000;
    private static final int PANIC_SPEED_MIN_EASY = 66191;
    private static final int PANIC_SPEED_MAX_EASY = 77987;
    private static final int BOOST_FACTOR_EASY = 104857;
    private static final int PASS_FACTOR_EASY = 65536;
    private static final int TRACKSIDE_MARGIN_GOOD_EASY = 52428;
    private static final int TRACKSIDE_MARGIN_SLOPPY_EASY = 91750;
    private static final int CORNER_SPEED_HARD = 65536;
    private static final int SWERVE_SPEED_HARD = 131072;
    private static final int RELAX_DIST_MIN_HARD = 294912;
    private static final int RELAX_DIST_MAX_HARD = 0x1D0000;
    private static final int RELAX_SPEED_MIN_HARD = 63569;
    private static final int RELAX_SPEED_MAX_HARD = 57671;
    private static final int PANIC_DIST_MIN_HARD = 498073;
    private static final int PANIC_DIST_MAX_HARD = 655360;
    private static final int PANIC_SPEED_MIN_HARD = 66191;
    private static final int PANIC_SPEED_MAX_HARD = 77987;
    private static final int BOOST_FACTOR_HARD = 99614;
    private static final int PASS_FACTOR_HARD = 68812;
    private static final int TRACKSIDE_MARGIN_GOOD_HARD = 6553;
    private static final int TRACKSIDE_MARGIN_SLOPPY_HARD = 26214;
    private static final int PASS_DISTANCE = 32768;
    private static final int MIN_PASS_DIFFICULTY = 6553;
    private static final int AI_TOPSPEED_EASY = 516096;
    private static final int AI_TOPSPEED_HARD = 786432;
    private static final int TUTORIAL_ENEMY_SPEED_DIFF_F = 40960;
    private static final int COP_SWERVESIDE_NONE = 0;
    private static final int COP_SWERVESIDE_LEFT = 1;
    private static final int COP_SWERVESIDE_RIGHT = 2;
    private static final int COP_SWERVE_DIST_F = 26214;
    private static final int COP_DELAY_TIME = 3500;
    private static final int COP_BRAKE_TIME = 2000;
    private static final int COP_ATTACK_DELAY = 5000;
    private static final int COP_LAT_SPEED = 91750;
    private static final int COP_ATTACK_SPEED = 52428;
    private static final int COP_STOP_TIME = 2000;
    private static final int COP_MAX_OVERSPEED = 204800;
    private static final int COP_DEFAULT_MOVE_TIME = 131072;
    private static final int COP_STOPPING_EASY_F = 19660;
    private static final int COP_STOPPING_HARD_F = 327680;
    private static final int COP_STOP_INC_EASY_F = 0;
    private static final int COP_STOP_INC_HARD_F = Short.MAX_VALUE;
    private static final int COP_CRUISER_DIFF = 0;
    private static final int COP_DEAD_TIME = 2000;
    private static final int COP_MAX_DAMAGE_RANGE = 65536;
    private static final int COP_MAX_HEALTH = 4;
    public static final int COP_CHECK_RANGE_F = 557056;
    private static final int COP_DEFAULT_BRAKING_F = 425984;
    private static final int CIV_MAX_SPEED_LEFT_F = 20480;
    public static final int CIV_MAX_SPEED_RIGHT_F = 409600;
    private static final int CIV_ACCELERATION_F = 40960;
    private static final int CIV_POS_CHANGE_DELAY = 3000;
    private static final int CIV_LAT_SPEED = 13107;
    private static final int CIV_SWERVE_SPEED = 52428;
    private static final int CIV_DEFAULT_BRAKING_INIT_F = 327680;
    private static final int CIV_DEFAULT_BRAKING_INC_F = 524288;
    private static final int CIV_INT_BRAKE_INIT = 327680;
    private static final int CIV_INT_BRAKE_INC = 524288;
    private static final int CIV_REV_FAST_INT_BRAKE_INIT = 196608;
    private static final int CIV_REV_FAST_INT_BRAKE_INC = 131072;
    private static final int CIV_REV_INT_BRAKE_INIT = 0;
    private static final int CIV_REV_INT_BRAKE_INC = 131;
    private static final int CIV_MAX_PASSED_DIST_F = -262144;
    private static final int INTERSECTION_MAX_LIFE = 2500;
    private static final int INTERSECTION_TRAFFIC_SPEED_MAX_F = 196608;
    private static final int INTERSECTION_TRAFFIC_SPEED_MIN_F = 131072;
    private static final int AI_BOOST_TIME = 4000;
    private static final int BOOST_COOLDOWN = 10000;
    private static final int BOOST_ATTEMPT_COOLDOWN = 3000;
    private static final int LOWEST_AIDIFF_BOOST = 26214;
    private static final int AI_BOOST_CHANCE = 10;
    private static final int AI_BOOST_FACTOR = 72089;
    private static final int AI_BOOST_FACTOR_ACCEL = 131072;
    private int m_id = 0;
    private SceneGame m_scene;
    private TrackObject m_playerCar;
    private int m_objectType;
    private int m_flags;
    private short m_state;
    private int m_stateTime;
    private int m_lifeTime;
    private AnimPlayer3D m_animPlayer3D;
    private Node[] m_nodes;
    private int m_appearance;
    private int m_appearanceWidthF;
    private int m_appearanceLengthF;
    private int m_visibilityCounter;
    private int m_wheelRotationF;
    private NonUniformSpline m_spline;
    private int m_splineTrackingID;
    private int[] m_worldPos3F;
    private int[] m_worldOrientation3F;
    private int m_speedF;
    private int m_targetSpeedF;
    private int m_accelerationF;
    private int m_brakingForceInit;
    private int m_brakingForceInc;
    private int m_brakingForce;
    private int m_copStopForce;
    private int m_copStopInc;
    private int m_boostTime;
    private int m_maxSpeedRangeMultiplierF;
    private int m_direction;
    private int m_prevPosF;
    private int m_lateralPosF;
    private int m_lateralPosTargetF;
    private int m_lateralPosSpeedF;
    private int m_lateralSpeedMaxF;
    private int m_lateralForceF;
    private int m_latEdgeLF;
    private int m_latEdgeRF;
    private int m_prevLatPosF;
    private int m_cruiseLane;
    private int m_lastGear;
    private int m_currentGear;
    private int m_numGears;
    private int[] m_gearAccels;
    private int[] m_gearMinSpeeds;
    private int[] m_gearMaxSpeeds;
    private int m_curGearMinSpeedF;
    private int m_curGearMaxSpeedF;
    private int m_gearChangeDelayTimerSecsF;
    private int m_currentLapTime;
    private int m_cumulativeLapTimes;
    private int m_numLapsCompleted;
    private int m_racePosition;
    private byte m_currentTrackSection;
    private int m_distanceFromPlayerF;
    private int m_aiTime;
    private int m_aiDecisionTime;
    private int m_aiDifficulty;
    private int m_aiBoostTime;
    private int m_aiDelay;
    private int m_swerveSide;
    private int m_healthFlashCount;
    private int m_healthFlashTime;
    private TrackObject m_proxRacer;
    private TrackObject m_proxCivilian;
    private TrackObject m_lastProxTarget;
    private TrackObject m_overtaking;
    private int m_bumpCount;
    private int m_maxBumps;
    private int m_bashCooldown;
    private int m_collisionAnim;
    private int m_collisionYawF;
    private int m_collisionPitchF;
    private int m_collisionRollF;
    private int m_collisionYTransF;
    private int m_collisionTimeF;
    private int m_collisionBrakeForce;
    private int m_collisionStartBraking;
    private int m_collisionStopTime;
    private int m_collisionSide;
    private int m_ragdollYawF;
    private int m_yawOffset;
    private int m_rollOffset;
    private int m_rollSlope;
    private int m_rollSteer;
    private int m_cornerRollF;
    private int m_steerYawTargetF;
    private int m_steerYawF;
    private int m_offsetTargetF;
    private short m_objectRefId;
    private int m_objectYawF;
    private Node2D m_node2D = new Node2D();
    private int m_cornerSpeedF;
    private int m_swerveSpeedF;
    private int m_minRelaxDistF;
    private int m_maxRelaxDistF;
    private int m_minRelaxSpeedF;
    private int m_maxRelaxSpeedF;
    private int m_minPanicDistF;
    private int m_maxPanicDistF;
    private int m_minPanicSpeedF;
    private int m_maxPanicSpeedF;
    private int m_boostFactorF;
    private int m_passFactorF;
    private int m_goodCornerF;
    private int m_sloppyCornerF;
    private int m_topSpeedF;
    private int m_boostCooldown;
    private int m_attemptCooldown;
    private AnimPlayer3D m_carRigAnimPlayer3D;
    public static final int FROM_SLOW_SPEED = 163840;
    public static final int FROM_FAST_SPEED = 327680;
    public static final int TO_FAST_SPEED = 614400;
    private static final int[] CIVILIAN_CARS = new int[]{13, 11, 10, 12};
    private static final int[] CORNER_SPEED_FACTORS = new int[]{2621, 5242, 7864, 9830};
    public static final int BUMPANIM_GRIND = 0;
    public static final int BUMPANIM_BUMP = 1;
    public static final int BUMPANIM_SLIDE = 2;
    public static final int BUMPANIM_SPINOUT_LEFT = 3;
    public static final int BUMPANIM_SPINOUT_RIGHT = 4;
    public static final int BUMPANIM_HEADON = 5;
    public static final int BUMPANIM_FRONT = 6;
    public static final int BUMPANIM_REAR = 7;
    public static final int BUMPANIM_REARBUMP = 8;
    public static final int BUMPANIM_REARBANG = 9;
    public static final int BUMPANIM_HITOBSTACLE = 10;
    public static final int BUMPANIM_FLIP_01 = 11;
    public static final int BUMPANIM_FLIP_02 = 12;
    private static final int BUMPANIM_BUMP_BRAKE = 32768;
    private static final int BUMPANIM_SLIDE_BRAKE = 98304;
    private static final int BUMPANIM_SPINOUT_BRAKE = 98304;
    private static final int BUMPANIM_SPIN_STARTBRAKE = 0;
    private static final int BUMPANIM_FLIP_STARTBRAKE = 131072;
    private static final int BUMPANIM_SPINOUT_STOPTIME = 98304;
    private static final int BUMPANIM_FLIP_STOPTIME = 1800;
    private static final int BUMPANIM_SPINOUT_BOOST = 85196;
    private static final int CANIM_IDX_DURATION = 0;
    private static final int CANIM_IDX_ROTPITCH = 1;
    private static final int CANIM_IDX_ROTYAW = 2;
    private static final int CANIM_IDX_ROTROLL = 3;
    private static final int CANIM_IDX_LATFORCE = 4;
    private static final int CANIM_IDX_YTRANS = 5;
    private static final int CANIM_NUM_COLUMNS = 6;
    private static final int[][] CANIMS = new int[][]{{9096, 0, -8000, -8000, -10000, 0, 4096, 0, -8000, -8000, -10000, 0, 9000, 0, -4000, 0, 0, 0, 9000, 0, 0, 4000, 0, 0, 10000, 0, 0, 0, 0, 0}, {9096, 0, -28000, -12000, -100000, 0, 4096, 0, -28000, -12000, -50000, 0, 9000, 0, -14000, 0, 0, 0, 9000, 0, 0, 8000, 0, 0, 10000, 0, 0, 0, 0, 0}, {10096, 0, -38000, -10000, -100000, 0, 10096, 0, -38000, 0, -100000, 0, 15192, 0, -2000, 0, 0, 0, 13768, 0, 40000, 10000, -50000, 0, 15768, 0, 48000, 10000, 0, 0, 12096, 0, 40000, 10000, 0, 0, 28000, 0, 0, -10000, 0, 0, 10000, 0, 0, 0, 0, 0}, {21}, {20}, {4096, 9000, -28000, 0, 0, 0, 9096, 9000, -56000, 0, -90000, 0, 5000, 0, -70000, 0, -70000, 0, 14096, 0, -100000, 0, -40000, 0, 5000, 0, -100000, 0, -30000, 0, 50000, 0, -100000, 0, -20000, 0}, {5096, 5000, 0, 0, 0, 0, 5096, 5000, 0, 0, 0, 0, 10000, 0, 0, 0, 0, 0}, {4096, 4000, 0, 0, 0, 0, 9096, 4000, 0, 0, 0, 0, 5000, 0, 0, 0, 0, 0, 14096, 0, 0, 0, 0, 0, 5000, 0, 0, 0, 0, 0, 20000, 0, 0, 0, 0, 0}, {4096, 4000, -28000, 0, 0, 0, 9096, 4000, -30000, 0, -10000, 0, 5000, 0, -30000, 0, -10000, 0, 14096, 0, -30000, 0, -10000, 0, 5000, 0, -30000, 0, -10000, 0, 20000, 0, 0, 0, 0, 0}, {4096, 4000, -28000, 0, 0, 0, 9096, 4000, -56000, 0, -10000, 0, 5000, 0, -60000, 0, -10000, 0, 14096, 0, -60000, 0, -10000, 0, 5000, 0, -30000, 0, -10000, 0, 100000, 0, 0, 0, 0, 0}, {20000, 100000, -50000, 0, 0, 25000, 1000, 100000, -50000, 0, -20000, 25000, 20000, 100000, -50000, 0, -20000, 0}, {16}, {18}};
    public static final int DOTCOLOR_COP_RED = 0xFF0000;
    public static final int DOTCOLOR_COP_BLUE = 437970;
    public static final int DOTCOLOR_COP_CYCLE = 300;
    private int m_dotcolorCopTime;

    public final boolean getFlags(int n) {
        return (this.m_flags & n) != 0;
    }

    public final boolean getNotFlags(int n) {
        return (this.m_flags & n) == 0;
    }

    public final void setFlags(int n) {
        this.m_flags |= n;
    }

    public final void unsetFlags(int n) {
        this.m_flags &= ~n;
    }

    public final void setAnimPlayer3D(AnimPlayer3D animPlayer3D) {
        this.m_animPlayer3D = animPlayer3D;
    }

    public final AnimPlayer3D getAnimPlayer3D() {
        return this.m_animPlayer3D;
    }

    public final void setNodes(Node[] nodeArray) {
        this.m_nodes = nodeArray;
        if (this.isRacer() || this.isPlayerCar() || this.getFlags(4)) {
            this.m_carRigAnimPlayer3D = AppEngine.getCanvas().getAnimationManager3D().createAnimPlayer3D();
            this.m_carRigAnimPlayer3D.setNode(this.m_nodes[24]);
            this.m_carRigAnimPlayer3D.setAnimWorldTime(0);
        }
    }

    public final Node[] getNodes() {
        return this.m_nodes;
    }

    public final void setVisible(boolean bl) {
        if (bl) {
            this.setFlags(64);
        } else {
            this.unsetFlags(64);
        }
    }

    public final boolean isVisible() {
        return this.getFlags(64);
    }

    public final int getWorldXF() {
        return this.m_worldPos3F[0];
    }

    public final int getWorldYF() {
        return this.m_worldPos3F[1];
    }

    public final int getWorldZF() {
        return this.m_worldPos3F[2];
    }

    public final int getOrientationXF() {
        return this.m_worldOrientation3F[0];
    }

    public final int getOrientationYF() {
        return this.m_worldOrientation3F[1];
    }

    public final int getOrientationZF() {
        return this.m_worldOrientation3F[2];
    }

    public final int getPrevPosF() {
        return this.m_prevPosF;
    }

    public final int getPrevLateralPosF() {
        return this.m_prevLatPosF;
    }

    public final void setAccelerating(boolean bl) {
        if (bl) {
            this.setFlags(512);
        } else {
            this.unsetFlags(512);
        }
    }

    public final boolean isAccelerating() {
        return this.getFlags(512);
    }

    public final void setBraking(boolean bl) {
        if (bl) {
            this.setFlags(1024);
        } else {
            this.unsetFlags(1024);
        }
    }

    public final boolean isBraking() {
        return this.getFlags(1024);
    }

    public final void setLateralSpeedF(int n) {
        this.m_lateralPosSpeedF = n;
    }

    public final int getLateralSpeedF() {
        return this.m_lateralPosSpeedF;
    }

    public final void setLateralPosF(int n) {
        this.m_lateralPosF = n;
    }

    public final int getLateralPosF() {
        return this.m_lateralPosF;
    }

    public final int getLeftWallF() {
        return this.m_latEdgeLF;
    }

    public final int getRightWallF() {
        return this.m_latEdgeRF;
    }

    public final int getLateralForceF() {
        return this.m_lateralForceF;
    }

    public final void setLateralForceF(int n) {
        this.m_lateralForceF = n;
    }

    public final void setCurrentLapTime(int n) {
        this.m_currentLapTime = n;
    }

    public final int getCurrentLapTime() {
        return this.m_currentLapTime;
    }

    public final void setCumulativeLapTimes(int n) {
        this.m_cumulativeLapTimes = n;
    }

    public final int getCumulativeLapTimes() {
        return this.m_cumulativeLapTimes;
    }

    public final void incNumLapsCompleted() {
        ++this.m_numLapsCompleted;
    }

    public final int getNumLapsCompleted() {
        return this.m_numLapsCompleted;
    }

    public final void crossedLine() {
        this.m_flags |= 0x8000000;
    }

    public final void setFinishedRace(boolean bl) {
        if (bl) {
            this.setFlags(16384);
        } else {
            this.unsetFlags(16384);
        }
    }

    public final boolean hasFinishedRace() {
        return this.getFlags(16384);
    }

    public final void setCurrentTrackSection(byte by) {
        this.m_currentTrackSection = by;
    }

    public final byte getCurrentTrackSection() {
        return this.m_currentTrackSection;
    }

    public final int getDistanceFromPlayerF() {
        return this.m_distanceFromPlayerF;
    }

    public final int distanceToPlayer() {
        return -this.m_distanceFromPlayerF;
    }

    public final int latDistanceToPlayer() {
        return this.latDistanceToOther(this.m_playerCar);
    }

    public final int latDistanceToOther(TrackObject trackObject) {
        int n = trackObject.m_lateralPosF;
        int n2 = n - this.m_lateralPosF;
        return n2;
    }

    public final int getSpeedF() {
        return this.m_speedF;
    }

    public final boolean isCrashing() {
        return this.getFlags(131072);
    }

    public final boolean isBoosting() {
        return this.getFlags(8192);
    }

    public final void setBoosting(boolean bl) {
        if (bl && this.m_boostTime > 0) {
            this.turnBoostOn();
            this.m_scene.m_engine.playSound(13);
        } else {
            this.turnBoostOff();
        }
    }

    public final int getBoostTimeRemaining() {
        return this.m_boostTime;
    }

    public final int getBoostTime() {
        return 196608 - this.m_boostTime;
    }

    public final void setBoostTime(int n) {
        this.m_boostTime = n;
    }

    public final void setColliding(boolean bl) {
        if (bl) {
            this.setFlags(65536);
        } else {
            this.unsetFlags(65536);
        }
    }

    public final boolean isColliding() {
        return this.getFlags(65536);
    }

    public final int getBumpCount() {
        return this.m_bumpCount;
    }

    public final int getMaxBumpCount() {
        return this.m_maxBumps;
    }

    public final int getCornerRollF() {
        return this.m_cornerRollF;
    }

    public final void resetCornerRoll() {
        this.m_cornerRollF = 0;
    }

    public final void setDifficulty(int n) {
        this.m_aiDifficulty = n;
        this.m_aiDifficulty = Math.max(0, this.m_aiDifficulty);
        this.m_aiDifficulty = Math.min(this.m_aiDifficulty, 65536);
        this.initEnemyVars();
    }

    public final int getDifficulty() {
        return this.m_aiDifficulty;
    }

    public final void setAppearance(int n) {
        this.m_appearance = n;
        this.setDimensions();
    }

    public final void setID(int n) {
        this.m_id = n;
    }

    public final int getID() {
        return this.m_id;
    }

    public final void setObjectRefId(short s) {
        this.m_objectRefId = s;
    }

    public final short getObjectRefId() {
        return this.m_objectRefId;
    }

    public final void setObjectYaw(int n) {
        this.m_objectYawF = n;
    }

    public final int getObjectYaw() {
        return this.m_objectYawF;
    }

    public final Node2D getNode2D() {
        return this.m_node2D;
    }

    public final int getState() {
        return this.m_state;
    }

    public final int getStateTime() {
        return this.m_stateTime;
    }

    public final int getLifeTime() {
        return this.m_lifeTime;
    }

    public final int getAppearance() {
        return this.m_appearance;
    }

    public final void setYawTarget(int n) {
        this.m_yawOffset = n;
    }

    public final int getSteeringYawF() {
        return this.m_steerYawF;
    }

    public final int getObjectType() {
        return this.m_objectType;
    }

    public final boolean isPlayerCar() {
        return this.m_objectType == 0;
    }

    public final boolean isRacer() {
        return this.isPlayerCar() || this.getFlags(8);
    }

    public static final boolean isCivilian(int n) {
        return n == 6 || n == 10 || n == 7;
    }

    public final void setSpeedF(int n) {
        this.m_speedF = n;
    }

    public final boolean gearWasChanged() {
        return this.m_lastGear != this.m_currentGear;
    }

    public final int getDirection() {
        return this.m_direction;
    }

    public final void setDirection(int n) {
        this.m_direction = n;
    }

    public final int getSpeedFactor() {
        return MathExt.Fmul(this.m_speedF, this.m_maxSpeedRangeMultiplierF);
    }

    public final int getSpeedFactor(int n) {
        return MathExt.Fmul(n, this.m_maxSpeedRangeMultiplierF);
    }

    public final void setRollOffset(int n) {
        this.m_rollOffset = n;
    }

    public final void setRollSlope(int n) {
        this.m_rollSlope = n;
    }

    public final void setRollSteer(int n) {
        this.m_rollSteer = n;
    }

    public final int getCurrentGear() {
        return this.m_currentGear;
    }

    public final int getRacePos() {
        return this.m_racePosition;
    }

    public final void setRacePos(int n) {
        this.m_racePosition = n;
    }

    public final boolean isAnimatingCollision() {
        return this.getFlags(262144);
    }

    public final int getCollisionAnim() {
        return this.m_collisionAnim;
    }

    public TrackObject(SceneGame sceneGame) {
        this.m_scene = sceneGame;
        this.m_objectType = -1;
        this.m_state = 0;
        this.m_stateTime = 0;
        this.m_lifeTime = 0;
        this.m_animPlayer3D = null;
        this.m_nodes = null;
        this.m_spline = sceneGame.getTrackSpline();
        this.m_splineTrackingID = this.m_spline.startTracking();
        this.m_worldPos3F = new int[3];
        this.m_worldOrientation3F = new int[3];
    }

    private final void DEBUG_INIT(String string) {
    }

    public final void DEBUG_CRASHES(String string) {
    }

    public final boolean init(int n) {
        AppEngine appEngine = AppEngine.getCanvas();
        this.m_objectType = n;
        this.m_state = 0;
        this.m_stateTime = 0;
        this.m_lifeTime = 0;
        this.m_nodes = null;
        this.m_appearance = -1;
        this.m_appearanceWidthF = 0;
        this.m_appearanceLengthF = 0;
        this.m_speedF = 0;
        this.m_targetSpeedF = 0;
        this.m_accelerationF = 0;
        this.m_brakingForceInit = 393216;
        this.m_brakingForce = -1;
        this.m_brakingForceInc = 65536;
        this.m_boostTime = 196608;
        this.m_maxSpeedRangeMultiplierF = 0;
        this.m_direction = 0;
        this.m_prevPosF = 0;
        this.m_lateralPosF = 0;
        this.m_lateralPosTargetF = 0;
        this.m_lateralPosSpeedF = 0;
        this.m_lateralSpeedMaxF = 65536;
        this.m_lateralForceF = 0;
        this.m_latEdgeLF = 0;
        this.m_latEdgeRF = 0;
        this.m_prevLatPosF = 0;
        this.m_lastGear = 0;
        this.m_currentGear = 0;
        this.m_numGears = 1;
        this.m_gearAccels = null;
        this.m_gearMinSpeeds = null;
        this.m_gearMaxSpeeds = null;
        this.m_curGearMinSpeedF = 0;
        this.m_curGearMaxSpeedF = 0;
        this.m_gearChangeDelayTimerSecsF = 0;
        this.m_currentLapTime = 0;
        this.m_cumulativeLapTimes = 0;
        this.m_numLapsCompleted = -1;
        this.m_racePosition = 0;
        this.m_currentTrackSection = 0;
        this.m_distanceFromPlayerF = 0;
        this.m_flags = 0;
        this.m_aiTime = 0;
        this.m_aiDecisionTime = -1;
        this.m_aiDifficulty = 0;
        this.m_swerveSide = 0;
        this.m_proxRacer = null;
        this.m_overtaking = null;
        this.m_bumpCount = 0;
        this.m_maxBumps = 0;
        this.m_bashCooldown = 0;
        this.m_collisionAnim = -1;
        this.m_collisionYawF = 0;
        this.m_collisionPitchF = 0;
        this.m_collisionRollF = 0;
        this.m_collisionYTransF = 0;
        this.m_collisionTimeF = 0;
        this.m_collisionStartBraking = 0;
        this.m_collisionStopTime = 0;
        this.m_collisionSide = 0;
        this.m_ragdollYawF = 0;
        this.m_yawOffset = 0;
        this.m_cornerRollF = 0;
        this.m_rollOffset = 0;
        this.m_rollSlope = 0;
        this.m_rollSteer = 0;
        this.m_steerYawTargetF = 0;
        this.m_steerYawF = 0;
        this.m_offsetTargetF = 0;
        this.m_objectRefId = (short)-1;
        this.m_objectYawF = 0;
        this.m_aiBoostTime = 0;
        this.resetWalls();
        this.m_playerCar = this.m_scene.getPlayerCar();
        switch (n) {
            case 0: {
                this.DEBUG_INIT("Player car");
                this.setFlags(65);
                this.m_appearance = appEngine.getPlayerCarIndex();
                this.m_playerCar = this;
                break;
            }
            case 1: {
                TrackObject trackObject = this.m_playerCar;
                int n2 = appEngine.getPlayerCarIndex();
                short s = appEngine.getCarTextureResID(n2);
                int n3 = appEngine.getNumCarsWithTexture(s);
                AppEngine.ASSERT(n3 > 1, "no non-player cars with this texture");
                int n4 = n3 - 2;
                this.m_appearance = appEngine.getNthCarWithTexture(s, appEngine.rand(0, n4), n2);
                AppEngine.ASSERT(this.m_appearance != -1, "m_appearance == -1");
                this.setFlags(137);
                this.m_targetSpeedF = trackObject.getSpeedF() + 40960;
                this.m_speedF = trackObject.getSpeedF() + 40960;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.DEBUG_INIT("Enemy car");
                this.m_aiDelay = appEngine.rand(2000, 3000);
                this.setFlags(393);
                this.m_lateralPosF = -45875;
                this.m_lateralSpeedMaxF = 72089;
                this.m_aiBoostTime = 2000;
                this.m_brakingForceInit = this.m_brakingForce << 1;
                break;
            }
            case 5: {
                this.m_objectType = 4;
                this.crossedLine();
            }
            case 4: {
                this.DEBUG_INIT("Cop car");
                this.m_appearance = 8;
                this.setFlags(197);
                this.m_lateralPosF = 45875;
                this.m_lateralPosTargetF = 45875;
                this.m_lateralSpeedMaxF = 91750;
                this.m_maxBumps = 4;
                this.m_brakingForceInit = 425984;
                this.m_copStopForce = MathExt.minMaxFactorF(19660, 327680, 0);
                this.m_copStopInc = MathExt.minMaxFactorF(0, Short.MAX_VALUE, 0);
                this.stateTransition((short)2);
                break;
            }
            case 6: {
                this.DEBUG_INIT("Civilian car");
                this.m_appearance = TrackObject.getRandomCivilianAppearance();
                this.setFlags(0x800083);
                this.m_targetSpeedF = 409600;
                this.m_speedF = 409600;
                this.m_curGearMaxSpeedF = 409600;
                this.m_accelerationF = 40960;
                this.m_lateralPosTargetF = this.m_lateralPosF = 45875;
                this.m_lateralSpeedMaxF = 13107;
                this.m_aiTime = 3000;
                this.m_brakingForceInit = 327680;
                this.m_brakingForceInc = 524288;
                break;
            }
            case 8: {
                this.DEBUG_INIT("Civilian stationary car");
                this.m_appearance = TrackObject.getRandomCivilianAppearance();
                this.setFlags(0x800003);
                this.m_targetSpeedF = 0;
                this.m_speedF = 0;
                this.m_curGearMaxSpeedF = 0;
                this.m_accelerationF = 0;
                this.m_brakingForceInit = 327680;
                this.m_brakingForceInc = 524288;
                break;
            }
            case 7: {
                this.DEBUG_INIT("Reverse civilian car");
                this.m_appearance = TrackObject.getRandomCivilianAppearance();
                this.setFlags(0x800083);
                this.m_targetSpeedF = 20480;
                this.m_speedF = 20480;
                this.m_curGearMaxSpeedF = 409600;
                this.m_accelerationF = 40960;
                this.m_direction = 1;
                this.m_lateralPosTargetF = this.m_lateralPosF = -45875;
                this.m_lateralPosSpeedF = 13107;
                this.m_aiTime = 3000;
                break;
            }
            case 9: {
                this.DEBUG_INIT("Reverse stationary civilian car");
                this.m_appearance = TrackObject.getRandomCivilianAppearance();
                this.setFlags(0x800003);
                this.m_targetSpeedF = 0;
                this.m_speedF = 0;
                this.m_curGearMaxSpeedF = 0;
                this.m_accelerationF = 0;
                this.m_direction = 1;
                this.m_brakingForceInit = 327680;
                this.m_brakingForceInc = 524288;
                break;
            }
            case 10: {
                this.DEBUG_INIT("Intersection traffic");
                this.m_appearance = TrackObject.getRandomCivilianAppearance();
                this.setFlags(0x800083);
                this.m_lateralPosSpeedF = this.m_scene.m_engine.rand(131072, 196608);
                this.m_direction = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 39: {
                this.DEBUG_INIT("Obstacle");
                this.m_speedF = 0;
                this.setFlags(16);
                break;
            }
            case 34: {
                this.DEBUG_INIT("Sparks");
                this.setFlags(0x400000);
                break;
            }
            default: {
                this.destroy();
                return false;
            }
        }
        this.setDimensions();
        if (this.m_objectType == 6 || this.m_objectType == 7) {
            this.m_scene.incCivCount();
        } else if (this.m_objectType == 10) {
            this.m_scene.incLatCivCount();
        } else if (this.isRacer()) {
            this.m_scene.incRacerCount();
        }
        return true;
    }

    private final void setDimensions() {
        AppEngine appEngine = this.m_scene.m_engine;
        if (this.m_appearance != -1) {
            if (this.m_direction == 1 || this.m_direction == 0) {
                this.m_appearanceLengthF = appEngine.getCarLength(this.m_appearance);
                this.m_appearanceWidthF = appEngine.getCarWidth(this.m_appearance);
            } else {
                this.m_appearanceLengthF = appEngine.getCarWidth(this.m_appearance);
                this.m_appearanceWidthF = appEngine.getCarLength(this.m_appearance);
            }
        }
    }

    public void startAnimRig(int n, int n2) {
        this.unsetFlags(67446272);
        this.m_carRigAnimPlayer3D.setPlaybackSpeed(n2);
        this.m_carRigAnimPlayer3D.startAnim(n, true, false);
    }

    public boolean isAnimRigFinished() {
        return this.m_carRigAnimPlayer3D != null && this.m_carRigAnimPlayer3D.isAnimating();
    }

    public void updateAnimRig(int n) {
        AnimPlayer3D animPlayer3D = this.m_carRigAnimPlayer3D;
        if (animPlayer3D != null && animPlayer3D.isAnimating()) {
            animPlayer3D.updateAnim(n);
            int n2 = animPlayer3D.getAnimID();
            if (!animPlayer3D.isAnimating()) {
                if (n2 != 24 && n2 != 22 && n2 != 30 && n2 != 32) {
                    animPlayer3D.setAnimWorldTime(0);
                }
                if (this.getFlags(4) && (n2 == 16 || n2 == 18)) {
                    this.destroy();
                }
            } else {
                Node[] nodeArray;
                boolean bl = false;
                int n3 = animPlayer3D.getWindowIndex();
                if (n3 != -1) {
                    nodeArray = AppEngine.getCanvas().getAnimationManager3D();
                    int n4 = nodeArray.getAnimWindowFlags(n2, n3);
                    if ((n4 & 0x30) != 0) {
                        int n5 = (n4 & 8) != 0 ? 163840 : 327680;
                        int n6 = (n4 & 0x10) != 0 ? 0 : 614400;
                        int n7 = n6 - n5;
                        int n8 = animPlayer3D.getAnimWorldFrame();
                        int n9 = nodeArray.getAnimWindowStartFrame(n2, n3);
                        int n10 = nodeArray.getAnimWindowEndFrame(n2, n3);
                        int n11 = Math.max(0, n5 + (n8 - n9) * n7 / (n10 - n9));
                        this.setSpeedF(n11);
                    } else if ((n4 & 8) != 0) {
                        this.setSpeedF(163840);
                    }
                    if ((n4 & 0x38) != 0) {
                        this.updateSpline(n);
                        this.updateWheelRotation(n);
                    }
                    boolean bl2 = bl = (animPlayer3D.getWindowFlags() & 0x40) != 0;
                }
                if ((nodeArray = this.getNodes())[16] != null) {
                    nodeArray[16].setRenderingEnable(bl);
                    nodeArray[17].setRenderingEnable(bl);
                }
            }
        }
    }

    private final void updateYawTarget(int n) {
        int n2 = n << 6;
        int n3 = MathExt.Fdiv(this.m_yawOffset, 411775);
        int n4 = MathExt.Fmul(823550, n3);
        int n5 = MathExt.Fmul(n4, n2);
        this.m_ragdollYawF += n5;
        if (this.m_yawOffset > 0) {
            this.m_yawOffset -= n5;
            if (this.m_yawOffset < 0) {
                this.m_yawOffset = 0;
            }
        } else {
            this.m_yawOffset -= n5;
            if (this.m_yawOffset > 0) {
                this.m_yawOffset = 0;
            }
        }
    }

    public static final int getRandomCivilianAppearance() {
        int n = AppEngine.getCanvas().rand(0, CIVILIAN_CARS.length - 1);
        return CIVILIAN_CARS[n];
    }

    private final void updateSteering(int n) {
        int n2 = n << 6;
        int n3 = MathExt.Fdiv(this.m_lateralPosSpeedF + this.m_lateralForceF, this.m_lateralSpeedMaxF);
        this.m_steerYawTargetF = -MathExt.Fmul(12868, n3);
        int n4 = MathExt.Fmul(32768, n2);
        if (this.m_steerYawTargetF < this.m_steerYawF) {
            this.m_steerYawF -= n4;
            if (this.m_steerYawF < this.m_steerYawTargetF) {
                this.m_steerYawF = this.m_steerYawTargetF;
            }
        } else {
            this.m_steerYawF += n4;
            if (this.m_steerYawF > this.m_steerYawTargetF) {
                this.m_steerYawF = this.m_steerYawTargetF;
            }
        }
    }

    public final int facingRotation() {
        switch (this.m_direction) {
            case 0: {
                return 0;
            }
            case 1: {
                return 205887;
            }
            case 2: {
                return 102944;
            }
            case 3: {
                return 308831;
            }
            case 4: {
                return this.m_objectYawF;
            }
        }
        return 0;
    }

    public final void setLocation(int n, int n2) {
        this.m_spline.setTrackingDistance(this.m_splineTrackingID, n);
        this.m_lateralPosF = n2;
        this.m_lateralPosTargetF = n2;
    }

    public final int getWidth() {
        int n = Math.abs(this.m_collisionYawF);
        if (n > 51472 && n < 102944 || n > 257359 && n < 308831) {
            return this.m_appearanceLengthF;
        }
        return this.m_appearanceWidthF;
    }

    public final int getRotatedWidth() {
        int n = this.m_appearanceWidthF;
        int n2 = n >> 1;
        int n3 = this.m_appearanceLengthF;
        int n4 = n3 >> 1;
        int n5 = this.getCollisionYawF();
        if (this.isPlayerCar()) {
            n5 += this.m_scene.getPlayerCarSteeringOffset();
        }
        n5 = Math.abs(n5);
        int n6 = 65536;
        if (n5 > 6553) {
            n6 = 55705;
        }
        int n7 = MathExt.Fcos(n5);
        int n8 = MathExt.Fsin(n5);
        int n9 = MathExt.Fmul(n2, n7) + MathExt.Fmul(n4, n8);
        n9 = MathExt.Fmul(n9, n6);
        return Math.abs(n9) << 1;
    }

    public final int getLength() {
        int n = Math.abs(this.m_collisionYawF);
        if (n > 51472 && n < 102944 || n > 257359 && n < 308831) {
            return this.m_appearanceWidthF;
        }
        return this.m_appearanceLengthF;
    }

    public final int getRotatedLength() {
        int n = this.m_appearanceWidthF;
        int n2 = n >> 1;
        int n3 = this.m_appearanceLengthF;
        int n4 = n3 >> 1;
        int n5 = this.getCollisionYawF();
        if (this.isPlayerCar()) {
            n5 += this.m_scene.getPlayerCarSteeringOffset();
        }
        n5 = Math.abs(n5);
        int n6 = MathExt.Fsin(n5);
        int n7 = MathExt.Fcos(n5);
        int n8 = -MathExt.Fmul(n2, n6) + MathExt.Fmul(n4, n7);
        return Math.abs(n8) << 1;
    }

    public final boolean causesSlipstream() {
        return this.getFlags(1) && this.m_objectType != 0 && this.getSpeedF() > 368640 && this.m_direction == 0;
    }

    public void destroy() {
        if (this.m_animPlayer3D != null) {
            this.m_animPlayer3D.setAnimTime(0);
        }
        if (this.m_objectType == 6 || this.m_objectType == 7) {
            this.m_scene.decCivCount();
        } else if (this.m_objectType == 10) {
            this.m_scene.decLatCivCount();
        } else if (this.isRacer()) {
            this.m_scene.decRacerCount();
        }
        this.m_objectType = -1;
        this.m_state = 0;
        this.unsetFlags(64);
        this.m_scene.destroyTrackObjectAssets(this);
        this.m_nodes = null;
    }

    public final boolean isInitialised() {
        return this.m_objectType != -1;
    }

    public final void reset() {
        this.m_visibilityCounter = 0;
        this.setVisible(true);
    }

    public void update(int n) {
        int n2;
        this.m_distanceFromPlayerF = this.m_objectType == 0 ? 0 : this.m_playerCar.getSplineDistanceTo(this);
        this.updateAnimRig(n);
        this.updateSpline(n);
        this.m_lifeTime += n;
        this.m_stateTime += n;
        if (this.m_visibilityCounter > 0) {
            n2 = this.m_visibilityCounter % 360;
            this.setVisible(n2 > 180);
            this.m_visibilityCounter -= n;
            if (this.m_visibilityCounter <= 0) {
                this.m_visibilityCounter = 0;
                this.setVisible(true);
            }
        }
        if (this.m_animPlayer3D != null) {
            this.m_animPlayer3D.updateAnim(n);
        }
        this.m_lastGear = this.m_currentGear;
        switch (this.m_objectType) {
            case 0: {
                this.updateTypePlayer(n);
                break;
            }
            case 4: {
                if (this.m_collisionAnim == 11 || this.m_collisionAnim == 12) break;
                this.updateTypeCop(n);
                this.updateSteering(n);
                break;
            }
            case 6: 
            case 7: {
                this.updateTypeCivilian(n);
                break;
            }
            case 10: {
                this.updateTypeCivLateral(n);
                break;
            }
            case 3: {
                this.updateTypeEnemy(n);
                this.updateSteering(n);
                if (this.m_aiDifficulty < 26214 && this.m_scene.m_engine.isCurrentRaceCareer()) break;
                this.updateAIBoost(n);
                break;
            }
            case 1: {
                this.updateTypeTutorialEnemy(n);
                this.updateSteering(n);
                break;
            }
            case 34: {
                if (!this.m_animPlayer3D.isAnimating()) {
                    this.m_animPlayer3D = null;
                    this.m_nodes = null;
                    this.destroy();
                }
                this.m_collisionYTransF = 6553;
            }
        }
        if (!this.isInitialised()) {
            return;
        }
        if (this.getFlags(128) && this.isAIActive() && this.m_aiDecisionTime > -1) {
            this.m_aiDecisionTime -= n;
        }
        this.updateMotion(n);
        this.updateCollision(n);
        if (this.m_healthFlashTime > 0) {
            this.updateHealthMeter(n);
        }
        if (this.getFlags(0x800000) && this.m_yawOffset != 0) {
            this.updateYawTarget(n);
        }
        if (this.isPlayerCar()) {
            this.updateCornerRoll(n);
        }
        if (!this.m_scene.isSlipstreaming() && !this.m_playerCar.getFlags(262144) && this.causesSlipstream()) {
            n2 = this.m_distanceFromPlayerF;
            int n3 = Math.abs(this.latDistanceToPlayer());
            if (n2 > 0 && n2 < 262144 && n3 < 26214) {
                this.m_scene.startSlipstreaming(this);
            }
        }
        if (this.getFlags(2)) {
            int n4;
            n2 = this.m_distanceFromPlayerF;
            int n5 = n4 = this.m_objectType == 6 ? -458752 : -262144;
            if (this.m_objectType == 8 || this.m_objectType == 9) {
                if (n2 < n4) {
                    this.destroy();
                    return;
                }
            } else if (n2 > 0x130000 || n2 < n4) {
                this.destroy();
                return;
            }
        }
        if (this.getFlags(1)) {
            this.updateWheelRotation(n);
        }
        this.clearAllProximity();
    }

    private void updateWheelRotation(int n) {
        this.m_wheelRotationF = MathExt.normaliseAngleDegreesF(this.m_wheelRotationF + MathExt.Fmul(MathExt.Fmul(this.getSpeedF(), 13107), n << 16));
        AppEngine.carSetWheelRotation(this.m_wheelRotationF, this.m_nodes);
    }

    private final void updateCornerRoll(int n) {
        int n2 = n << 6;
        int n3 = this.m_rollSteer;
        int n4 = this.getSplineCurvature();
        boolean bl = this.m_scene.isSteering(1);
        boolean bl2 = this.m_scene.isSteering(2);
        int n5 = 0;
        int n6 = 0;
        int n7 = this.m_cornerRollF;
        int n8 = 0;
        if (this.m_speedF > 0) {
            if (n4 != 0) {
                n5 = -(MathExt.Fmul(Math.abs(n4) << 16, this.m_rollSlope) + this.m_rollOffset);
                n5 = MathExt.Fmul(n5, this.getSpeedFactor());
                n6 = n5 + n3;
                if (n4 < 0) {
                    n5 = -n5;
                    n6 = -n6;
                }
            }
            if (bl) {
                n5 += n3;
            } else if (bl2) {
                n5 -= n3;
            }
        }
        n8 = n5 > 0 && n7 > n5 || n5 < 0 && n7 < n5 ? 6553 : (n5 != 0 ? 19660 : 6553);
        int n9 = MathExt.Fmul(n8, n2);
        if (n5 > n7) {
            n7 += n9;
        } else if (n5 < n7) {
            n7 -= n9;
        }
        if (n8 != 6553 && (n5 > 0 && n7 > n5 || n5 < 0 && n7 < n5)) {
            n7 = n5;
        } else if (n8 == 6553 && n5 == 0 && (n7 > 0 && this.m_cornerRollF < 0 || n7 < 0 && this.m_cornerRollF > 0)) {
            n7 = 0;
        }
        this.m_cornerRollF = n7;
    }

    private final void initEnemyVars() {
        int n = this.m_aiDifficulty;
        this.m_cornerSpeedF = MathExt.minMaxFactorF(26214, 65536, n);
        this.m_swerveSpeedF = MathExt.minMaxFactorF(78643, 131072, n);
        this.m_minRelaxDistF = MathExt.minMaxFactorF(65536, 294912, n);
        this.m_maxRelaxDistF = MathExt.minMaxFactorF(0x140000, 0x1D0000, n);
        this.m_minRelaxSpeedF = MathExt.minMaxFactorF(58982, 63569, n);
        this.m_maxRelaxSpeedF = MathExt.minMaxFactorF(55705, 57671, n);
        this.m_minPanicDistF = MathExt.minMaxFactorF(393216, 498073, n);
        this.m_maxPanicDistF = MathExt.minMaxFactorF(0x1E0000, 655360, n);
        this.m_minPanicSpeedF = MathExt.minMaxFactorF(66191, 66191, n);
        this.m_maxPanicSpeedF = MathExt.minMaxFactorF(77987, 77987, n);
        this.m_boostFactorF = MathExt.minMaxFactorF(104857, 99614, n);
        this.m_passFactorF = MathExt.minMaxFactorF(65536, 68812, n);
        this.m_goodCornerF = MathExt.minMaxFactorF(52428, 6553, n);
        this.m_sloppyCornerF = MathExt.minMaxFactorF(91750, 26214, n);
        this.m_topSpeedF = MathExt.minMaxFactorF(516096, 786432, n);
    }

    private final void updateTypeEnemy(int n) {
        int n2;
        boolean bl;
        AppEngine appEngine = AppEngine.getCanvas();
        int n3 = this.distanceToPlayer();
        int n4 = Math.abs(n3);
        boolean bl2 = bl = n3 > 0 && n4 < this.m_minPanicDistF || n3 < 0 && n4 < this.m_minRelaxDistF || this.m_scene.getEventType() == 6 && n3 < 0;
        int n5 = bl ? 0 : (n3 > 0 ? MathExt.linearstepF(this.m_minPanicDistF, this.m_maxPanicDistF, n4) : MathExt.linearstepF(this.m_minRelaxDistF, this.m_maxRelaxDistF, n4));
        int n6 = 0;
        int n7 = Math.abs(this.latDistanceToPlayer());
        this.m_targetSpeedF = this.m_topSpeedF;
        if (this.m_aiBoostTime > 0) {
            this.m_aiBoostTime -= n;
            if (this.m_aiBoostTime <= 0) {
                this.unsetFlags(256);
            }
        }
        if (!bl) {
            n2 = this.m_targetSpeedF;
            n6 = n3 > 0 ? MathExt.minMaxFactorF(this.m_minPanicSpeedF, this.m_maxPanicSpeedF, n5) : MathExt.minMaxFactorF(this.m_minRelaxSpeedF, this.m_maxRelaxSpeedF, n5);
            this.m_targetSpeedF = MathExt.Fmul(n2, n6);
        } else if (n3 > 0 && !this.m_playerCar.isBoosting() && this.m_aiDifficulty >= 6553 && this.getNotFlags(32768) && n7 > 32768) {
            this.m_targetSpeedF = MathExt.Fmul(this.m_targetSpeedF, this.m_passFactorF);
        }
        if (this.m_aiDelay > 0) {
            this.m_aiDelay -= n;
            return;
        }
        n7 = this.getSplineCurvature();
        n2 = 0;
        if (n7 != 0) {
            int n8 = this.m_goodCornerF + (this.m_sloppyCornerF - this.m_goodCornerF >> 1);
            n2 = n3 < 0 ? MathExt.minMaxFactorF(n8, this.m_sloppyCornerF, n5) : MathExt.minMaxFactorF(n8, this.m_goodCornerF, n5);
        }
        if (n7 > 0) {
            this.unsetFlags(0x2000000);
            this.m_lateralPosTargetF = 72089 - n2;
        } else if (n7 < 0) {
            this.unsetFlags(0x2000000);
            this.m_lateralPosTargetF = -72089 + n2;
        } else {
            if (!this.getFlags(0x2000000) || this.m_aiDecisionTime < 0) {
                this.m_cruiseLane = appEngine.rand(-39321, 39321);
                this.setFlags(0x2000000);
                this.m_aiDecisionTime = appEngine.rand(1000, 4000);
            }
            this.m_lateralPosTargetF = this.m_cruiseLane;
        }
        this.m_lateralSpeedMaxF = this.m_cornerSpeedF;
        this.unsetFlags(1024);
        if (this.getFlags(32768) && n3 < 196608) {
            n7 = this.updateAvoidance(n);
            if (this.m_swerveSide == 1 && this.m_lateralPosTargetF > n7 || this.m_swerveSide == 2 && this.m_lateralPosTargetF < n7) {
                this.m_lateralPosTargetF = n7;
                this.m_lateralSpeedMaxF = this.m_swerveSpeedF;
            }
        }
    }

    private final void DEBUG_AI_BOOST(String string) {
    }

    private final void updateAIBoost(int n) {
        if (this.getFlags(8192)) {
            int n2 = this.m_scene.getBoostAnimTime();
            this.m_nodes[14].animate(n2);
            this.m_nodes[15].animate(n2);
            this.m_boostTime -= n;
            if (this.m_boostTime <= 0) {
                this.DEBUG_AI_BOOST("Turning boost off");
                this.stopAIBoost();
            }
        } else if (this.m_boostCooldown <= 0) {
            int n3 = -this.m_distanceFromPlayerF;
            if (n3 < 0 && n3 > -262144 || n3 > 0) {
                if (this.m_attemptCooldown <= 0) {
                    if (AppEngine.getCanvas().rand(0, 99) < 10) {
                        this.DEBUG_AI_BOOST("Successful boost attempt");
                        this.startAIBoost();
                    } else {
                        this.DEBUG_AI_BOOST("Failed boost attempt");
                        this.m_attemptCooldown = 3000;
                    }
                } else {
                    this.m_attemptCooldown -= n;
                }
            }
        } else {
            this.m_boostCooldown -= n;
        }
    }

    private final void startAIBoost() {
        this.m_nodes[13].setRenderingEnable(true);
        this.setFlags(8192);
        this.m_boostTime = 4000;
    }

    private final void stopAIBoost() {
        this.m_nodes[13].setRenderingEnable(false);
        this.unsetFlags(8192);
        this.m_boostCooldown = 10000;
    }

    public final void DEBUG_RACER(String string) {
    }

    private final void updateTypeTutorialEnemy(int n) {
        int n2;
        TrackObject trackObject = this.m_playerCar;
        int n3 = trackObject.getSpeedF();
        if (this.m_state == 6) {
            this.m_targetSpeedF = n3 - 81920;
            if (this.distanceToPlayer() > 196608) {
                this.destroy();
                return;
            }
        } else {
            int n4;
            for (n2 = 0; n2 < this.m_numGears; ++n2) {
                if (this.getGearMaxSpeed(n2) <= this.getSpeedF()) continue;
                this.setCurrentGear(n2);
                break;
            }
            if (n2 == this.m_numGears) {
                this.setCurrentGear(this.m_numGears - 1);
            }
            if ((n4 = this.distanceToPlayer() + 262144) > 0) {
                int n5;
                int n6 = Math.min(n4, 131072);
                int n7 = MathExt.Fdiv(n6, 131072);
                this.m_targetSpeedF = n5 = MathExt.minMaxFactorF(n3, n3 + 40960, n7);
            } else {
                this.m_targetSpeedF = n3 - 40960;
            }
            this.m_targetSpeedF = Math.min(this.m_targetSpeedF, 634880);
        }
        this.m_lateralPosTargetF = 19661;
        this.unsetFlags(1024);
        if (this.getFlags(32768)) {
            n2 = this.updateAvoidance(n);
            if (this.m_swerveSide == 1 && this.m_lateralPosTargetF > n2 || this.m_swerveSide == 2 && this.m_lateralPosTargetF < n2) {
                this.m_lateralPosTargetF = n2;
            }
        } else {
            this.m_swerveSide = 0;
        }
    }

    public final void startDying() {
        this.stateTransition((short)6);
    }

    private final void updateHealthMeter(int n) {
        this.m_healthFlashTime -= n;
        if (this.m_healthFlashTime <= 0) {
            ++this.m_healthFlashCount;
            if (this.m_healthFlashCount < 4) {
                this.m_healthFlashTime += 300;
            }
        }
    }

    private final void updateTypeCivLateral(int n) {
        int n2 = n << 6;
        this.m_lateralPosF = this.m_direction == 3 ? (this.m_lateralPosF += MathExt.Fmul(this.m_lateralPosSpeedF, n2)) : (this.m_lateralPosF -= MathExt.Fmul(this.m_lateralPosSpeedF, n2));
        if (this.m_lifeTime > 2500) {
            this.destroy();
        }
    }

    private final boolean isAIActive() {
        return this.getNotFlags(786432);
    }

    private void updateMotion(int n) {
        if (this.getFlags(1) && this.m_objectType != 10) {
            this.updateSpeed(n);
            this.updateLateralPosition(n);
        }
    }

    private void updateSpeed(int n) {
        int n2;
        int n3 = n << 6;
        if (this.isPlayerCar()) {
            n2 = this.m_accelerationF;
            int n4 = this.m_curGearMaxSpeedF;
            if (this.getFlags(8192)) {
                if (this.m_scene.isDriftBoosting()) {
                    n2 = MathExt.Fmul(this.m_accelerationF, 196608);
                    n4 = MathExt.Fmul(n4, 78643);
                } else {
                    int n5 = AppEngine.getCanvas().getCarNowRacingNitroExtra();
                    int n6 = MathExt.Fmul(196608, n5);
                    n2 = MathExt.Fmul(this.m_accelerationF, n6);
                    n6 = MathExt.Fmul(78643, n5);
                    n4 = MathExt.Fmul(n4, n6);
                }
            } else if (this.m_scene.isSlipstreamBoosting()) {
                n2 = MathExt.Fmul(this.m_accelerationF, 196608);
                n4 = MathExt.Fmul(n4, 78643);
            }
            if (this.getFlags(1024)) {
                if (this.m_brakingForce == -1) {
                    this.m_brakingForce = this.m_brakingForceInit;
                }
                this.m_brakingForce += MathExt.Fmul(this.m_brakingForceInc, n3);
                this.m_speedF -= MathExt.Fmul(this.m_brakingForce, n3);
                if (this.m_speedF < 0) {
                    this.m_speedF = 0;
                }
            } else if (this.getFlags(512) && this.m_speedF < n4) {
                this.m_speedF += MathExt.Fmul(n2, n3);
                if (this.m_speedF > n4) {
                    this.m_speedF = n4;
                }
            }
            if (!this.getFlags(1024)) {
                this.m_brakingForce = -1;
            }
            if (this.getFlags(2048) && this.getSpeedF() > 327680) {
                this.m_speedF -= MathExt.Fmul(131072, n3);
                if (this.m_speedF < 327680) {
                    this.m_speedF = 327680;
                }
            }
            if (this.getFlags(262144)) {
                this.m_speedF -= MathExt.Fmul(this.m_collisionBrakeForce, n3);
                if (this.m_speedF < 0) {
                    this.m_speedF = 0;
                }
            }
            if (this.m_speedF > n4) {
                this.m_speedF -= MathExt.Fmul(65536, n3);
            }
        } else {
            n2 = this.m_accelerationF;
            int n7 = this.m_targetSpeedF;
            if (this.getFlags(256)) {
                n2 = MathExt.Fmul(this.m_accelerationF, this.m_boostFactorF);
            } else if (this.getFlags(8192)) {
                n7 = MathExt.Fmul(this.m_targetSpeedF, 72089);
                n2 = MathExt.Fmul(this.m_accelerationF, 131072);
            }
            if (this.getFlags(1024)) {
                if (this.m_brakingForce == -1) {
                    this.m_brakingForce = this.m_brakingForceInit;
                }
                this.m_brakingForce += MathExt.Fmul(this.m_brakingForceInc, n3);
                if (this.m_speedF > 0) {
                    this.m_speedF -= MathExt.Fmul(this.m_brakingForce, n3);
                    if (this.m_speedF < 0) {
                        this.m_speedF = 0;
                    }
                } else {
                    this.m_speedF += MathExt.Fmul(this.m_brakingForce, n3);
                    if (this.m_speedF > 0) {
                        this.m_speedF = 0;
                    }
                }
            } else if (this.m_speedF > n7) {
                this.m_speedF -= MathExt.Fmul(this.m_accelerationF, n3);
                if (this.m_speedF < n7) {
                    this.m_speedF = n7;
                }
            } else {
                this.m_speedF += MathExt.Fmul(n2, n3);
                if (this.m_speedF > n7) {
                    this.m_speedF = n7;
                }
            }
            if (!this.getFlags(1024)) {
                this.m_brakingForce = -1;
            }
            if (this.getFlags(6144) && this.m_speedF > 163840) {
                int n8 = this.getFlags(4096) ? 262144 : 131072;
                this.m_speedF -= MathExt.Fmul(n8, n3);
                if (this.m_speedF < 163840) {
                    this.m_speedF = 163840;
                }
            }
            if (this.getFlags(262144)) {
                if (this.m_speedF > 0) {
                    this.m_speedF -= MathExt.Fmul(this.m_collisionBrakeForce, n3);
                    if (this.m_speedF < 0) {
                        this.m_speedF = 0;
                    }
                } else {
                    this.m_speedF += MathExt.Fmul(this.m_collisionBrakeForce, n3);
                    if (this.m_speedF > 0) {
                        this.m_speedF = 0;
                    }
                }
            }
        }
        if (this.m_state != 6 && !this.getFlags(2)) {
            if (this.m_speedF >= this.m_curGearMaxSpeedF && this.m_currentGear < this.m_numGears - 1) {
                int n9 = n2 = this.isBoosting() ? 3276 : 16384;
                if (this.m_gearChangeDelayTimerSecsF >= n2) {
                    this.incrementGear();
                    this.m_gearChangeDelayTimerSecsF = 0;
                } else {
                    this.m_speedF = this.m_curGearMaxSpeedF;
                    this.m_gearChangeDelayTimerSecsF += n3;
                }
            } else if (this.m_speedF < this.m_curGearMinSpeedF && this.m_currentGear > 0) {
                this.decrementGear();
            }
        }
    }

    private void updateBoost(int n) {
        int n2 = n << 6;
        if (this.getFlags(8192)) {
            this.m_boostTime -= n2;
            if (this.m_boostTime <= 0) {
                this.m_boostTime = 196608;
                this.turnBoostOff();
            }
        }
    }

    private void updateLateralPosition(int n) {
        int n2 = n << 6;
        if (!this.isPlayerCar()) {
            if (this.m_lateralPosF < this.m_latEdgeLF) {
                this.m_lateralPosF = this.m_latEdgeLF;
                this.resetWalls();
            } else if (this.m_lateralPosF > this.m_latEdgeRF) {
                this.m_lateralPosF = this.m_latEdgeRF;
                this.resetWalls();
            }
        }
        if (this.getFlags(128) && this.isAIActive() && this.m_lateralForceF == 0) {
            this.updateAILateralPosition(n);
        }
        this.m_lateralPosF += MathExt.Fmul(this.m_lateralForceF, n2);
        if (this.m_lateralForceF != 0) {
            if (this.m_lateralForceF > 0) {
                this.m_lateralForceF -= MathExt.Fmul(524288, n2);
                if (this.m_lateralForceF < 0) {
                    this.m_lateralForceF = 0;
                }
            } else {
                this.m_lateralForceF += MathExt.Fmul(524288, n2);
                if (this.m_lateralForceF > 0) {
                    this.m_lateralForceF = 0;
                }
            }
        }
        if (this.getNotFlags(131072)) {
            int n3;
            int n4 = n3 = this.isPlayerCar() ? 91749 : 111409;
            if (this.m_lateralPosF < -n3) {
                this.m_lateralPosF = -n3;
            } else if (this.m_lateralPosF > n3) {
                this.m_lateralPosF = n3;
            }
        }
    }

    private void updateTypePlayer(int n) {
        SceneGame sceneGame = this.m_scene;
        if (this.getNotFlags(16384)) {
            this.m_currentLapTime += n;
        }
        if (this.isCrashing()) {
            sceneGame.m_engine.vibrate(250);
        }
        this.updateBoost(n);
        if ((this.m_lateralPosF < -72089 || this.m_lateralPosF > 72089) && (sceneGame.isSlipstreaming() || sceneGame.isSlipstreamBoosting())) {
            sceneGame.stopSlipstreaming();
        }
    }

    private final void DEBUG_COP(String string) {
    }

    public final void blockPlayer() {
        this.stateTransition((short)5);
    }

    private final boolean activateCop() {
        int n = this.distanceToPlayer();
        return this.m_scene.inMainState() && Math.abs(n) <= 557056;
    }

    private final void updateTypeCop(int n) {
        TrackObject trackObject = this.m_playerCar;
        this.unsetFlags(0x1000000);
        this.m_lateralSpeedMaxF = 91750;
        switch (this.m_state) {
            case 1: {
                this.m_speedF = 0;
                if (this.activateCop()) {
                    this.stateTransition((short)3);
                }
            }
            case 2: {
                if (this.m_speedF > 409600 || this.getFlags(32768)) {
                    this.unsetFlags(512);
                    this.setFlags(1024);
                } else if (this.m_speedF < 409600 && this.getNotFlags(32768)) {
                    this.setFlags(512);
                    this.unsetFlags(1024);
                }
                if (!this.activateCop()) break;
                this.stateTransition((short)3);
                break;
            }
            case 3: {
                this.updateTypeCopForward();
                int n2 = Math.min(MathExt.Fdiv(trackObject.getSpeedF(), 368640), 65536);
                this.m_offsetTargetF = MathExt.minMaxFactorF(45875, 131072, n2);
                this.updateToOffset(n, 131072);
                if (this.getFlags(32768)) {
                    int n3 = this.updateAvoidance(n);
                    if (this.m_swerveSide == 1 && this.m_lateralPosTargetF > n3 || this.m_swerveSide == 2 && this.m_lateralPosTargetF < n3) {
                        this.m_lateralPosTargetF = n3;
                    }
                }
                if (this.distanceToPlayer() < 0) {
                    if (this.m_speedF > trackObject.getSpeedF() + 204800) {
                        this.m_speedF = trackObject.getSpeedF() + 204800;
                    }
                    if (!this.m_scene.isSlipstreamBoosting()) break;
                    this.stateTransition((short)4);
                    break;
                }
                this.m_aiDecisionTime = 3500;
                break;
            }
            case 4: {
                if (this.m_distanceFromPlayerF > 0) {
                    this.m_brakingForceInit = this.m_copStopForce;
                    this.m_brakingForceInc = this.m_copStopInc;
                    this.setFlags(1024);
                }
                if (this.getFlags(32768)) {
                    int n4 = this.updateAvoidance(n);
                    if (this.m_swerveSide == 1 && this.m_lateralPosTargetF > n4 || this.m_swerveSide == 2 && this.m_lateralPosTargetF < n4) {
                        this.m_lateralPosTargetF = n4;
                    }
                }
                this.m_aiTime -= n;
                if (this.m_aiTime < 0) {
                    this.setFlags(0x1000000);
                    this.m_lateralPosTargetF = trackObject.getLateralPosF();
                    this.m_lateralSpeedMaxF = 52428;
                }
                if (this.m_aiDecisionTime >= 0) break;
                this.stateTransition((short)3);
                break;
            }
            case 5: {
                this.m_lateralPosTargetF = trackObject.getLateralPosF();
                this.updateTypeCopForward();
                int n5 = Math.min(MathExt.Fdiv(this.m_stateTime, 2000), 65536);
                this.m_offsetTargetF = MathExt.minMaxFactorF(131072, 0, n5);
                this.updateToOffset(n, 131072);
                if (this.getFlags(32768)) {
                    int n6 = this.updateAvoidance(n);
                    if (this.m_swerveSide == 1 && this.m_lateralPosTargetF > n6 || this.m_swerveSide == 2 && this.m_lateralPosTargetF < n6) {
                        this.m_lateralPosTargetF = n6;
                    }
                }
                if (trackObject.getFlags(2048)) {
                    this.m_aiTime = 2000;
                    break;
                }
                this.m_aiTime -= n;
                if (this.m_aiTime >= 0 && this.distanceToPlayer() <= 0) break;
                this.stateTransition((short)3);
                this.m_scene.stoppedBlocking();
                break;
            }
            case 6: {
                if (!this.getNotFlags(262144)) break;
                this.stateTransition((short)7);
                break;
            }
            case 7: {
                if (this.m_stateTime < 2000) break;
                this.DEBUG_COP("removing");
                this.destroy();
                break;
            }
            default: {
                this.DEBUG_COP("Unknown state");
                return;
            }
        }
        this.m_dotcolorCopTime -= n;
        if (this.m_dotcolorCopTime < 0) {
            this.m_dotcolorCopTime = 300;
        }
    }

    private final void updateToOffset(int n, int n2) {
        int n3;
        TrackObject trackObject = this.m_playerCar;
        int n4 = this.distanceToPlayer();
        int n5 = trackObject.getSpeedF();
        int n6 = this.m_speedF;
        int n7 = n5 - n6;
        int n8 = n4 + this.m_offsetTargetF;
        int n9 = n7 > 0 ? MathExt.Fdiv(n8, n7) : Integer.MAX_VALUE;
        int n10 = this.m_lateralPosTargetF;
        this.unsetFlags(1024);
        if (trackObject.getFlags(1024) && n4 < 0) {
            n3 = 0;
            this.setFlags(1024);
            this.DEBUG_COP("Braking because player is");
        } else {
            if (Math.abs(n8) < 13107) {
                n3 = n5;
            } else if (n8 > 0) {
                if (n9 > n2) {
                    n3 = MathExt.Fdiv(n8, n2);
                    n3 = n5 + n3;
                } else {
                    n3 = MathExt.Fdiv(n8, n2);
                    n3 = n5 + n3;
                }
            } else {
                n3 = MathExt.Fdiv(n8, n2);
                n3 += n5;
                if (n9 > 98304) {
                    this.setFlags(1024);
                    this.DEBUG_COP("Braking because target is far behind");
                }
            }
            if (this.m_state != 4 && n4 < 0 && -n4 < 557056 && n7 > 81920) {
                n10 = trackObject.getLateralPosF() > 0 ? (this.m_lateralPosF > 0 ? 72089 : -72089) : this.m_lateralPosF;
            }
        }
        n3 = Math.min(n3, this.getGearMaxSpeed(this.m_numGears - 1));
        this.m_targetSpeedF = n3 = Math.max(n3, 0);
        this.m_lateralPosTargetF = n10;
    }

    public final int worldDistTo(TrackObject trackObject) {
        int n = this.m_worldPos3F[0];
        int n2 = trackObject.m_worldPos3F[0];
        int n3 = this.m_worldPos3F[2];
        int n4 = trackObject.m_worldPos3F[2];
        int n5 = Math.abs(n - n2);
        int n6 = Math.abs(n3 - n4);
        int n7 = MathExt.Fmul(n5, n5) + MathExt.Fmul(n6, n6);
        return MathExt.Fsqrt(n7);
    }

    private final TrackObject getClosestProxTarget() {
        int n;
        int n2;
        TrackObject trackObject = this.m_proxRacer != null && this.m_proxCivilian != null ? ((n2 = this.worldDistTo(this.m_proxRacer)) > (n = this.worldDistTo(this.m_proxCivilian)) ? this.m_proxCivilian : this.m_proxRacer) : (this.m_proxRacer != null ? this.m_proxRacer : this.m_proxCivilian);
        return trackObject;
    }

    private final void DEBUG_AVOIDANCE(String string) {
    }

    private final int updateAvoidance(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        TrackObject trackObject;
        TrackObject trackObject2 = this.getClosestProxTarget();
        TrackObject trackObject3 = trackObject = trackObject2 == this.m_proxRacer ? this.m_proxCivilian : this.m_proxRacer;
        if (trackObject2 != this.m_lastProxTarget) {
            this.m_swerveSide = 0;
        }
        this.m_lastProxTarget = trackObject2;
        int n6 = this.getSplineDistanceTo(trackObject2);
        int n7 = this.latDistanceToOther(trackObject2);
        int n8 = Math.abs(n7);
        int n9 = trackObject != null ? this.latDistanceToOther(trackObject) : 0;
        int n10 = trackObject2.getSpeedF() - this.getSpeedF();
        int n11 = this.m_appearanceWidthF + trackObject2.getWidth() >> 1;
        int n12 = this.m_swerveSide;
        boolean bl2 = false;
        int n13 = this.m_lateralPosTargetF;
        boolean bl3 = bl = trackObject2.getDirection() == 0 && n10 >= 0 && n6 > 196608;
        if (n12 == 0 && !bl) {
            if (trackObject2.getObjectType() == 10) {
                if (trackObject2.getDirection() == 2) {
                    this.DEBUG_AVOIDANCE("prox is heading left");
                    n12 = 2;
                } else {
                    this.DEBUG_AVOIDANCE("prox is heading right");
                    n12 = 1;
                }
            } else if (n8 < 19660) {
                if (AppEngine.getCanvas().randPercent() < 50) {
                    n12 = 1;
                    this.DEBUG_AVOIDANCE("Random pick left");
                } else {
                    n12 = 2;
                    this.DEBUG_AVOIDANCE("Random pick right");
                }
            } else if (n7 < 0) {
                n12 = 2;
                this.DEBUG_AVOIDANCE("Already on right. pick");
            } else {
                n12 = 1;
                this.DEBUG_AVOIDANCE("Already on left. pick");
            }
            if (trackObject != null && (n9 < 0 && n12 == 1 || n9 > 0 && n12 == 2)) {
                n12 = this.swapSwerveSides(n12);
                bl2 = true;
            }
        }
        if (trackObject2.getObjectType() != 10 && ((n5 = this.getLatPosForSwerve(trackObject2, n12)) < -52428 || n5 > 52428)) {
            if (bl2) {
                this.m_targetSpeedF = trackObject2.getSpeedF();
                this.setFlags(1024);
            } else if (n6 > 131072) {
                n4 = this.swapSwerveSides(n12);
                n5 = this.getLatPosForSwerve(trackObject2, n12);
                if (n5 > -52428 || n5 < 52428) {
                    this.DEBUG_AVOIDANCE("Safe to swap");
                    n12 = n4;
                } else {
                    this.DEBUG_AVOIDANCE("Tried to swap to offtrack");
                }
            } else {
                this.m_targetSpeedF = MathExt.Fmul(trackObject2.getSpeedF(), 45875);
            }
        }
        if ((n5 = this.getSpeedF()) > 204800 && Math.abs(n7) < n11 && (n3 = n5 - (n4 = TrackObject.isOppositeDirection(this, trackObject2) ? -trackObject2.getSpeedF() : trackObject2.getSpeedF())) > 0 && (n2 = MathExt.Fdiv(n6, n3)) < 32768) {
            this.DEBUG_AVOIDANCE("Panic!! Braking...");
            this.setFlags(1024);
        }
        n13 = this.getLatPosForSwerve(trackObject2, n12);
        this.m_swerveSide = n12;
        return n13;
    }

    private final int swapSwerveSides(int n) {
        return n == 2 ? 1 : 2;
    }

    private final int getLatPosForSwerve(TrackObject trackObject, int n) {
        int n2;
        int n3 = trackObject.getLateralPosF();
        int n4 = trackObject.getWidth();
        switch (n) {
            case 1: {
                n2 = n3 - n4 - 26214;
                break;
            }
            case 2: {
                n2 = n3 + n4 + 26214;
                break;
            }
            default: {
                n2 = this.m_lateralPosF;
            }
        }
        return n2;
    }

    private final void updateTypeCopForward() {
        int n;
        int n2 = this.latDistanceToOther(this.m_playerCar);
        int n3 = 0;
        TrackObject[] trackObjectArray = this.m_scene.getPursuers();
        for (n = 0; n < trackObjectArray.length; ++n) {
            int n4;
            int n5;
            TrackObject trackObject = trackObjectArray[n];
            if (trackObject == null || trackObject == this || trackObject.distanceToPlayer() >= 0 || (n5 = Math.abs(n4 = this.latDistanceToOther(trackObject))) >= 32768) continue;
            int n6 = 32768 - n5;
            int n7 = n6 = n6 < 0 ? 0 : n6;
            if (n4 < 0) {
                n3 += n6;
                continue;
            }
            n3 -= n6;
        }
        n3 = MathExt.Fmul(n3, 262144);
        n = n2 + n3;
        this.m_lateralPosTargetF = this.m_lateralPosF + n;
    }

    private void startPursuit() {
        if (this.getNotFlags(0x200000)) {
            this.m_scene.startPursuit(this);
        }
        this.setFlags(0x200000);
    }

    public void stopPursuit() {
        if (this.getFlags(0x200000)) {
            this.m_scene.stopPursuit(this);
        }
        this.unsetFlags(0x200000);
        this.stateTransition((short)2);
    }

    private void updateTypeCivilian(int n) {
        int n2;
        int n3;
        if (this.m_state == 6) {
            this.setFlags(1024);
            return;
        }
        int n4 = this.m_targetSpeedF = this.m_objectType == 6 ? 409600 : 20480;
        if (this.m_playerCar.getSpeedF() < 163840) {
            this.m_targetSpeedF = 409600;
        }
        this.unsetFlags(1024);
        int n5 = this.getSplineNodeFlags();
        if ((n5 & 2) != 0) {
            if (this.m_objectType == 6) {
                this.m_brakingForceInit = 327680;
                this.m_brakingForceInc = 524288;
            } else if (this.m_targetSpeedF == 409600) {
                this.m_brakingForceInit = 196608;
                this.m_brakingForceInc = 131072;
            } else {
                this.m_brakingForceInit = 0;
                this.m_brakingForceInc = 131;
            }
            this.setFlags(1024);
            return;
        }
        this.m_brakingForceInit = 327680;
        this.m_brakingForceInc = 524288;
        this.m_aiTime -= n;
        if (this.m_objectType == 6) {
            if (this.getFlags(32768)) {
                TrackObject trackObject = this.getClosestProxTarget();
                if (trackObject.getObjectType() == 0 && trackObject.getSpeedF() < this.m_speedF) {
                    n3 = trackObject.getLateralPosF();
                    int n6 = n3 - (trackObject.getWidth() >> 1);
                    int n7 = n3 + (trackObject.getWidth() >> 1);
                    if (this.m_objectType == 6 && trackObject.getDirection() == 0) {
                        int n8 = 19661;
                        int n9 = 72089;
                        if (n6 - n8 > this.getWidth()) {
                            this.m_lateralPosTargetF = n8;
                            this.m_overtaking = trackObject;
                            this.m_lateralSpeedMaxF = 52428;
                        } else if (n9 - n7 > this.getWidth()) {
                            this.m_lateralPosTargetF = n9;
                            this.m_overtaking = trackObject;
                            this.m_lateralSpeedMaxF = 52428;
                        }
                    }
                } else if (trackObject.getLateralPosF() > 0) {
                    this.setFlags(1024);
                }
            }
        } else if (this.getFlags(32768) && this.m_proxRacer.getLateralPosF() < 0) {
            this.setFlags(1024);
        }
        if (this.m_aiTime <= 0 && this.m_overtaking == null) {
            int n10 = 72089;
            n3 = AppEngine.getCanvas().rand(0, 52428);
            if (this.m_objectType == 6) {
                n10 = 72089 - n3;
            } else if (this.m_objectType == 7) {
                n10 = -72089 + n3;
            }
            this.m_lateralPosTargetF = n10;
            this.m_aiTime = 3000;
        }
        if (this.m_overtaking != null && ((n2 = this.getSplineDistanceTo(this.m_overtaking)) < 0 || this.m_overtaking.getSpeedF() > this.m_speedF)) {
            this.m_overtaking = null;
            this.m_lateralSpeedMaxF = 13107;
        }
    }

    public void setRacerProximity(TrackObject trackObject) {
        this.setFlags(32768);
        this.m_proxRacer = trackObject;
    }

    public void setCivilainProximity(TrackObject trackObject) {
        this.setFlags(32768);
        this.m_proxCivilian = trackObject;
    }

    private void clearAllProximity() {
        this.unsetFlags(32768);
        this.m_proxRacer = null;
        this.m_proxCivilian = null;
    }

    public final TrackObject getRacerProximity() {
        return this.m_proxRacer;
    }

    public final TrackObject getCivilianProximity() {
        return this.m_proxCivilian;
    }

    private void updateAILateralPosition(int n) {
        int n2 = n << 6;
        int n3 = Math.abs(this.m_lateralPosTargetF - this.m_lateralPosF);
        if (this.getSpeedF() < 16384) {
            return;
        }
        if (this.m_lateralPosF < this.m_lateralPosTargetF) {
            if (this.m_lateralPosSpeedF < 0) {
                this.m_lateralPosSpeedF = 0;
            } else {
                int n4 = MathExt.Fmul(n3, 187250);
                n4 = n4 > 65536 ? 65536 : n4;
                this.m_lateralPosSpeedF = MathExt.Fmul(this.m_lateralSpeedMaxF, n4);
                if (this.getFlags(131072)) {
                    this.m_lateralPosSpeedF -= MathExt.Fmul(1966, n2);
                }
            }
            if (this.getNotFlags(65536)) {
                this.m_lateralPosF += MathExt.Fmul(this.m_lateralPosSpeedF, n2);
                if (this.m_lateralPosF > this.m_lateralPosTargetF) {
                    this.m_lateralPosF = this.m_lateralPosTargetF;
                }
            }
        } else if (this.m_lateralPosF > this.m_lateralPosTargetF) {
            if (this.m_lateralPosSpeedF > 0) {
                this.m_lateralPosSpeedF = 0;
            } else {
                int n5 = MathExt.Fmul(n3, 187250);
                n5 = n5 > 65536 ? 65536 : n5;
                this.m_lateralPosSpeedF = -MathExt.Fmul(this.m_lateralSpeedMaxF, n5);
                if (this.getFlags(131072)) {
                    this.m_lateralPosSpeedF += MathExt.Fmul(1966, n2);
                }
            }
            if (this.getNotFlags(65536)) {
                this.m_lateralPosF += MathExt.Fmul(this.m_lateralPosSpeedF, n2);
                if (this.m_lateralPosF < this.m_lateralPosTargetF) {
                    this.m_lateralPosF = this.m_lateralPosTargetF;
                }
            }
        }
        if (this.m_lateralPosF < -72089 || this.m_lateralPosF > 72089) {
            if (this.m_lateralPosF < -91749 || this.m_lateralPosF > 91749) {
                this.setFlags(4096);
            } else {
                this.setFlags(2048);
            }
        } else {
            this.unsetFlags(6144);
        }
    }

    public final int getCornerSpeedF() {
        int n = this.getSpeedF();
        int n2 = this.getSplineCurvature();
        if (n2 != 0) {
            int n3 = this.m_lateralPosF;
            int n4 = MathExt.Fmul(Math.abs(n3), 46812);
            int n5 = MathExt.Fmul(CORNER_SPEED_FACTORS[Math.abs(n2)], n4);
            n5 = MathExt.Fmul(n, n5);
            n = n2 > 0 && n3 > 0 || n2 < 0 && n3 < 0 ? (n += n5) : (n -= n5);
        }
        return n;
    }

    private void turnBoostOn() {
        this.setFlags(8192);
    }

    private void turnBoostOff() {
        this.m_boostTime = 196608;
        this.unsetFlags(8192);
        if (this.isPlayerCar()) {
            this.m_scene.playerStoppedBoost();
        }
    }

    public int getGearMaxSpeed(int n) {
        return this.m_gearMaxSpeeds[n];
    }

    public int getTopGearMaxSpeed() {
        return this.m_gearMaxSpeeds[this.m_numGears - 1];
    }

    public void setNumGears(byte by) {
        this.m_numGears = by;
    }

    public int getNumGears() {
        return this.m_numGears;
    }

    public void setGearAccelData(int[] nArray) {
        this.m_gearAccels = nArray;
        this.m_accelerationF = nArray[this.m_currentGear];
    }

    public void setGearMinSpeedData(int[] nArray) {
        this.m_gearMinSpeeds = nArray;
        this.m_curGearMinSpeedF = nArray[this.m_currentGear];
    }

    public void setGearMaxSpeedData(int[] nArray) {
        this.m_gearMaxSpeeds = nArray;
        this.m_curGearMaxSpeedF = nArray[this.m_currentGear];
        this.m_maxSpeedRangeMultiplierF = MathExt.Fdiv(65536, this.getTopGearMaxSpeed());
    }

    public void incrementGear() {
        if (this.m_currentGear < this.m_numGears - 1) {
            this.setCurrentGear(this.m_currentGear + 1);
        }
    }

    public void decrementGear() {
        if (this.m_currentGear > 0) {
            this.setCurrentGear(this.m_currentGear - 1);
        }
    }

    private void setCurrentGear(int n) {
        this.m_curGearMinSpeedF = this.m_gearMinSpeeds[n];
        this.m_curGearMaxSpeedF = this.m_gearMaxSpeeds[n];
        this.m_accelerationF = this.m_gearAccels[n];
        this.m_currentGear = n;
    }

    private final void DEBUG_TRANSITION(String string) {
    }

    public final void stateTransition(short s) {
        this.m_stateTime = 0;
        switch (this.m_state) {
            case 4: {
                this.m_brakingForceInit = 425984;
                this.m_brakingForceInc = 65536;
                break;
            }
        }
        switch (s) {
            case 2: {
                this.m_targetSpeedF = 409600;
                this.m_lateralPosTargetF = 45875;
                break;
            }
            case 3: {
                this.startPursuit();
                this.m_aiDecisionTime = 7000;
                break;
            }
            case 4: {
                this.m_aiTime = 5000;
                this.m_aiDecisionTime = 4000;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.m_speedF = 0;
                this.m_flags = 0;
                this.m_lateralPosTargetF = this.m_lateralPosF;
                break;
            }
        }
        this.m_state = s;
    }

    private final void copDied() {
        if (this.getFlags(0x200000)) {
            this.m_scene.stopPursuit(this);
        }
        this.unsetFlags(0x200000);
        this.m_scene.signalCopDied(this);
    }

    public void setLeftWall(int n) {
        this.m_latEdgeLF = n;
    }

    public void setRightWall(int n) {
        this.m_latEdgeRF = n;
    }

    public void resetWalls() {
        this.m_latEdgeLF = -111409;
        this.m_latEdgeRF = 111409;
    }

    private final void DEBUG_COLLISION(String string) {
    }

    public final boolean isAnimatingRearSpinOutOrSlide() {
        return this.getFlags(262144) && (this.m_collisionAnim == 3 || this.m_collisionAnim == 4 || this.m_collisionAnim == 2);
    }

    public final int getCollisionYawF() {
        if (this.getFlags(0x800000)) {
            return this.m_collisionYawF + this.m_ragdollYawF;
        }
        return this.m_collisionYawF;
    }

    public final int getRagdollYawF() {
        return this.m_ragdollYawF;
    }

    public final void setRagdollYawF(int n) {
        this.m_ragdollYawF = n;
    }

    public final int getCollisionPitchF() {
        return this.m_collisionPitchF;
    }

    public final int getCollisionRollF() {
        return this.m_collisionRollF;
    }

    public final int getCollisionYTransF() {
        return this.m_collisionYTransF;
    }

    public void playBumpAnim(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        this.m_collisionBrakeForce = 0;
        AppEngine.ASSERT(n < CANIMS.length, "Bump anim out of range!");
        if (this.m_collisionAnim > 0 && this.m_collisionAnim > n) {
            this.DEBUG_COLLISION("trying to play lower precedence anim over higher");
        }
        if (this.m_collisionAnim == n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.DEBUG_COLLISION("Non restartable anim");
                    return;
                }
            }
        }
        if (this.getFlags(4) && this.m_bashCooldown <= 0 && this.distanceToPlayer() < 65536) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    ++this.m_bumpCount;
                    this.m_healthFlashTime = 300;
                    this.m_healthFlashCount = 0;
                    break;
                }
            }
            if (this.m_bumpCount >= this.m_maxBumps && !this.m_carRigAnimPlayer3D.isAnimating()) {
                n = this.m_scene.m_engine.randPercent() < 50 ? 11 : 12;
            }
        }
        switch (n) {
            case 1: {
                this.m_collisionBrakeForce = 32768;
                break;
            }
            case 2: {
                this.m_collisionBrakeForce = 98304;
                this.m_scene.m_engine.playSound(11);
                break;
            }
            case 3: 
            case 4: {
                this.m_collisionBrakeForce = 98304;
                n3 = 0;
                n4 = 98304;
                this.m_speedF = MathExt.Fmul(this.m_speedF, 85196);
                break;
            }
            case 11: 
            case 12: {
                this.setBoosting(false);
                n3 = 131072;
                n4 = 1800;
                if (!this.getFlags(4)) break;
                this.copDied();
            }
        }
        this.startCannedCollision(n, n2, n3, n4);
        this.m_bashCooldown = 1000;
    }

    public final void startCannedCollision(int n, int n2, int n3, int n4) {
        this.unsetFlags(0x4080000);
        this.setFlags(262144);
        this.m_collisionTimeF = 0;
        this.m_collisionAnim = n;
        this.m_collisionSide = n2;
        this.m_collisionStartBraking = n3;
        this.m_collisionStopTime = n4;
        if (CANIMS[n].length == 1) {
            this.setFlags(0x4000000);
            this.m_carRigAnimPlayer3D.setPlaybackSpeed(128);
            this.m_carRigAnimPlayer3D.startAnim(CANIMS[n][0], true, false);
        }
    }

    private final void updateCannedCollision(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.getFlags(0x4000000)) {
            if (!this.m_carRigAnimPlayer3D.isAnimating()) {
                this.DEBUG_COLLISION("Finished collision animation");
                this.unsetFlags(262144);
                this.startRecentering();
                if (this.isPlayerCar() && (this.m_collisionAnim == 3 || this.m_collisionAnim == 4)) {
                    this.m_visibilityCounter = 1080;
                }
                if ((this.m_collisionAnim == 11 || this.m_collisionAnim == 12) && this.getFlags(4)) {
                    this.stateTransition((short)6);
                }
                this.m_collisionAnim = -1;
                this.unsetFlags(0x4000000);
                return;
            }
        } else {
            int n8;
            int n9;
            int[] nArray = CANIMS[this.m_collisionAnim];
            for (n9 = 0; n9 < nArray.length; n9 += 6) {
                if ((n3 += nArray[n9]) > this.m_collisionTimeF) {
                    n8 = nArray[n9 + 2];
                    int n10 = nArray[n9 + 1];
                    int n11 = nArray[n9 + 3];
                    int n12 = nArray[n9 + 4];
                    int n13 = nArray[n9 + 5];
                    if (this.m_collisionSide == 0) {
                        n8 *= -1;
                        n11 *= -1;
                        n12 *= -1;
                        n4 *= -1;
                        n6 *= -1;
                    }
                    int n14 = MathExt.Fdiv(this.m_collisionTimeF - n2, nArray[n9 + 0]);
                    this.m_collisionYawF = MathExt.minMaxFactorF(n4, n8, n14);
                    this.m_collisionPitchF = MathExt.minMaxFactorF(n5, n10, n14);
                    this.m_collisionRollF = MathExt.minMaxFactorF(n6, n11, n14);
                    this.m_collisionYTransF = MathExt.minMaxFactorF(n7, n13, n14);
                    int n15 = MathExt.Fmul(n12, n);
                    if (this.m_direction == 1) {
                        n15 *= -1;
                    }
                    this.m_lateralPosF += n15;
                    break;
                }
                n2 = n3;
                n4 = nArray[n9 + 2];
                n5 = nArray[n9 + 1];
                n6 = nArray[n9 + 3];
                n7 = nArray[n9 + 5];
            }
            if (n9 == nArray.length) {
                this.DEBUG_COLLISION("Finished collision animation");
                if (this.getFlags(16)) {
                    this.destroy();
                } else {
                    n8 = nArray.length - 6;
                    this.m_collisionYawF = nArray[n8 + 2];
                    this.m_collisionPitchF = nArray[n8 + 1];
                    this.m_collisionRollF = nArray[n8 + 3];
                    this.m_collisionYTransF = nArray[n8 + 5];
                    if (this.m_collisionSide == 0) {
                        this.m_collisionYawF *= -1;
                        this.m_collisionPitchF *= -1;
                        this.m_collisionRollF *= -1;
                    }
                    this.unsetFlags(262144);
                    this.startRecentering();
                }
                this.m_collisionAnim = -1;
                return;
            }
        }
        if (this.m_collisionTimeF > this.m_collisionStartBraking && this.m_collisionStopTime != -1 && this.m_speedF > 0) {
            int n16 = this.m_collisionStopTime - this.m_collisionTimeF;
            if (n16 > 0) {
                this.m_speedF -= MathExt.Fmul(this.m_speedF, MathExt.Fdiv(n, n16));
                if (this.m_speedF < 0) {
                    this.m_speedF = 0;
                }
            } else {
                this.m_speedF = 0;
            }
        }
    }

    private final void startRecentering() {
        int n = this.m_collisionYawF % 411775;
        if (n < 0) {
            n = 411775 + n;
        }
        this.DEBUG_COLLISION("Starting to recenter");
        this.setFlags(524288);
        this.m_collisionTimeF = 0;
    }

    private final void updateRecentering(int n) {
        int n2 = n << 6;
        boolean bl = false;
        if (this.getFlags(131072)) {
            this.m_visibilityCounter = 1080;
            this.unsetFlags(131072);
            return;
        }
        if (this.m_collisionYawF != 0) {
            int n3;
            int n4;
            this.m_collisionYawF %= 411775;
            if (this.m_collisionYawF < 0) {
                this.m_collisionYawF = 411775 + this.m_collisionYawF;
            }
            if (this.m_collisionYawF > 205887) {
                n4 = 411775;
                n3 = 1;
            } else {
                n4 = 0;
                n3 = -1;
            }
            int n5 = MathExt.Fmul(this.m_speedF, 8192);
            int n6 = MathExt.Fmul(411775, n5);
            int n7 = MathExt.Fmul(n6, n2);
            this.m_collisionYawF += (n7 *= n3);
            if (n3 == -1 && Math.abs(this.m_collisionYawF - 102944) < 102944 || n3 == 1 && Math.abs(this.m_collisionYawF - 308831) < 102944) {
                int n8 = MathExt.Fmul(this.m_speedF, 8192);
                int n9 = MathExt.Fmul(196608, n8);
                int n10 = MathExt.Fmul(n9, n2);
                n10 *= n3;
                if (this.m_direction == 1) {
                    n10 *= -1;
                }
                this.m_lateralPosF += n10;
            }
            if (n3 == 1 && this.m_collisionYawF >= n4 || n3 == -1 && this.m_collisionYawF <= n4) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.DEBUG_COLLISION("resetting");
            this.m_collisionYawF = 0;
            this.unsetFlags(786432);
        }
    }

    public boolean canCollide() {
        return !this.getFlags(0x424000) && this.m_objectType != -1 && this.m_objectType != 39 && this.m_objectType != 35 && this.m_state != 7 && (!this.getFlags(16) || !this.getFlags(262144));
    }

    public void startDramaticCrash(int n) {
        this.m_collisionPitchF = 0;
        this.m_collisionYawF = 0;
        this.m_collisionRollF = 0;
        this.setFlags(131072);
        this.playBumpAnim(n, 1);
        this.m_scene.m_engine.playSound(12);
    }

    public final void onCollision(TrackObject trackObject) {
        switch (this.m_objectType) {
            case 0: {
                if (!this.m_scene.isSlipstreamBoosting()) break;
                this.m_scene.stopSlipstreaming();
                break;
            }
            case 4: {
                if (!this.getFlags(0x1000000)) break;
                this.unsetFlags(0x1000000);
                this.m_aiTime = 5000;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.m_scene.getEventType() == 4 && this.m_state != 6 && this.m_state != 7) {
                    this.m_scene.addBountyScore(this.m_objectType);
                }
                this.m_targetSpeedF = 0;
                this.m_brakingForceInit = 655360;
                this.m_brakingForceInc = 524288;
                this.setFlags(1024);
                this.stateTransition((short)6);
                break;
            }
            case 3: {
                this.m_aiDelay = 500;
            }
        }
        this.updateWorldPos();
    }

    public void hitObstacle(int n) {
        this.playBumpAnim(10, n);
    }

    private final void updateCollision(int n) {
        int n2 = n << 6;
        this.m_bashCooldown -= n;
        if (this.m_bashCooldown < 0) {
            this.m_bashCooldown = 0;
        }
        this.m_collisionTimeF += n2;
        boolean bl = this.getFlags(1);
        if (bl && this.getFlags(262144) && this.getSpeedF() < 0 && this.m_collisionStopTime == -1) {
            this.unsetFlags(262144);
            this.setFlags(524288);
        }
        if (this.getNotFlags(262144) && bl) {
            this.updateRollCorrect(n);
        }
        if (this.getFlags(524288)) {
            this.updateRecentering(n);
        } else if (this.getFlags(262144)) {
            this.updateCannedCollision(n2);
        }
    }

    private final void updateRollCorrect(int n) {
        int n2 = n << 6;
        if (this.m_collisionRollF != 0) {
            if (this.m_collisionRollF < 0) {
                this.m_collisionRollF += MathExt.Fmul(65536, n2);
                if (this.m_collisionRollF > 0) {
                    this.m_collisionRollF = 0;
                }
            } else if (this.m_collisionRollF > 0) {
                this.m_collisionRollF -= MathExt.Fmul(65536, n2);
                if (this.m_collisionRollF < 0) {
                    this.m_collisionRollF = 0;
                }
            }
        }
    }

    public final NonUniformSpline getSpline() {
        return this.m_spline;
    }

    private final void updateSpline(int n) {
        int n2 = n << 6;
        int n3 = this.m_splineTrackingID;
        NonUniformSpline nonUniformSpline = this.m_spline;
        int n4 = nonUniformSpline.getMaxDistance();
        this.m_prevPosF = this.getSplineDistance();
        this.m_prevLatPosF = this.getLateralPosF();
        int n5 = this.getCornerSpeedF();
        n5 = MathExt.Fmul(n5, 58982);
        int n6 = MathExt.Fmul(n2, n5);
        if (this.getDirection() == 1) {
            n6 = -n6;
        }
        if (this.getObjectType() == 10) {
            n6 = 0;
        }
        if ((this.m_scene.getTrackFlags() & 2) != 0) {
            if (this.m_prevPosF + n6 > n4) {
                n6 = n4 - this.m_prevPosF;
            } else if (this.m_prevPosF + n6 < 0) {
                n6 = -this.m_prevPosF;
            }
        }
        nonUniformSpline.updateTracking(n3, n6);
        this.updateWorldPos();
    }

    public final void updateWorldPos() {
        int n;
        int n2;
        NonUniformSpline nonUniformSpline = this.getSpline();
        int n3 = this.m_splineTrackingID;
        int[] nArray = nonUniformSpline.getTrackingPosition(n3);
        int[] nArray2 = nonUniformSpline.getTrackingTangent(n3);
        int[] nArray3 = s_tempInt4_1;
        nArray3[0] = nArray2[0];
        nArray3[1] = nArray2[2];
        MathExt.normalise2(nArray3);
        int[] nArray4 = s_tempInt4_2;
        MathExt.getLineNormal2DCW(nArray3, nArray4);
        int n4 = nArray[1];
        int n5 = this.getLateralPosF();
        if (n5 != 0) {
            n2 = nArray[0] + MathExt.Fmul(nArray4[0], n5);
            n = nArray[2] + MathExt.Fmul(nArray4[1], n5);
        } else {
            n2 = nArray[0];
            n = nArray[2];
        }
        this.m_worldPos3F[0] = n2;
        this.m_worldPos3F[1] = n4;
        this.m_worldPos3F[2] = n;
        this.m_worldOrientation3F[0] = nArray2[0];
        this.m_worldOrientation3F[1] = nArray2[1];
        this.m_worldOrientation3F[2] = nArray2[2];
    }

    public final void updateNodes() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Node[] nodeArray = this.m_nodes;
        if (nodeArray == null) {
            return;
        }
        int n4 = MathExt.getVectorYawRad(this.getOrientationXF(), this.getOrientationYF(), this.getOrientationZF());
        int n5 = 0;
        int n6 = this.getCornerRollF();
        n4 += this.facingRotation();
        n4 += this.getCollisionYawF();
        n5 += this.getCollisionPitchF();
        n6 += this.getCollisionRollF();
        n4 += this.getSteeringYawF();
        int n7 = this.getObjectYaw();
        Transform transform = SceneGame.s_tempTransform;
        transform.setIdentity();
        if (this.getFlags(1)) {
            Group group = (Group)nodeArray[1];
            AppEngine.setOrientationx((Transformable)group, MathExt.radiansToDegrees(n4), 0, 65536, 0);
            AppEngine.setTranslationx((Transformable)group, this.getWorldXF() - n3 << 0, 0, this.getWorldZF() - n << 0);
            Group group2 = (Group)nodeArray[3];
            AppEngine.postTranslatex(transform, 0, this.getWorldYF() + this.getCollisionYTransF() - n2 << 0, 0);
            AppEngine.postRotatex(transform, MathExt.radiansToDegrees(n5), 65536, 0, 0);
            AppEngine.postRotatex(transform, MathExt.radiansToDegrees(n6), 0, 0, 65536);
            group2.setTransform(transform);
        } else {
            Group group = (Group)nodeArray[1];
            AppEngine.postTranslatex(transform, this.getWorldXF() - n3 << 0, this.getWorldYF() + this.getCollisionYTransF() - n2 << 0, this.getWorldZF() - n << 0);
            AppEngine.postRotatex(transform, MathExt.radiansToDegrees(n4) - n7, 0, 65536, 0);
            AppEngine.postRotatex(transform, MathExt.radiansToDegrees(n5), 65536, 0, 0);
            AppEngine.postRotatex(transform, MathExt.radiansToDegrees(n6), 0, 0, 65536);
            group.setTransform(transform);
        }
    }

    public final int getCopDotTime() {
        return this.m_dotcolorCopTime;
    }

    public final void updateMiniMapNodes() {
        NonUniformSpline nonUniformSpline = this.getSpline();
        int n = this.m_splineTrackingID;
        int[] nArray = nonUniformSpline.getTrackingPosition(n);
        int n2 = this.m_dotcolorCopTime < 150 ? 0xFF0000 : 437970;
        Node2D node2D = this.m_node2D;
        if (this.m_objectType == 4 || this.m_objectType == 1 || this.m_objectType == 3) {
            node2D.setRenderingEnable(true);
            node2D.setColor(this.m_objectType == 4 ? n2 : 0xFF0000);
            node2D.setTranslationx(nArray[0], nArray[2]);
        } else if (this.m_objectType == 0) {
            node2D.setRenderingEnable(false);
            node2D.setTranslationx(nArray[0], nArray[2]);
        } else if (this.m_objectType == 39) {
            node2D.setTranslationx(nArray[0], nArray[2]);
            node2D.setRenderingEnable(true);
            node2D.setColor(0xCC00FF);
        } else {
            node2D.setRenderingEnable(false);
        }
    }

    public int getSplineDistanceTo(TrackObject trackObject) {
        return this.m_spline.getTrackingRelativeDistance(this.m_splineTrackingID, trackObject.m_splineTrackingID);
    }

    public final int getSplineNode() {
        return this.m_spline.getTrackingNode(this.m_splineTrackingID);
    }

    public final int getSplineNodeFlags() {
        return this.m_spline.getNodeFlags(this.getSplineNode());
    }

    public final int getSplineSection() {
        return this.m_spline.getSectionAtNode(this.getSplineNode());
    }

    public final int getSplineCurvature() {
        int n = this.m_spline.getTrackingNode(this.m_splineTrackingID);
        return this.m_spline.getNodeCornerRating(n);
    }

    public final int getSplineDistance() {
        return this.m_spline.getTrackingDistance(this.m_splineTrackingID);
    }

    public final void setSplineDistance(int n) {
        this.m_spline.setTrackingDistance(this.m_splineTrackingID, n);
    }

    public static boolean isOppositeDirection(TrackObject trackObject, TrackObject trackObject2) {
        return trackObject.m_direction != trackObject2.m_direction;
    }

    public final void renderHealthMeter(Graphics graphics, int n, int n2) {
        int n3 = this.m_maxBumps;
        int n4 = 2 + n3 * 2 + 1;
        int n5 = n3 * 2 + 1;
        int n6 = n - 5;
        int n7 = n2 - n4;
        AnimationManager.drawAnimFrame(graphics, 12, 0, n - 1, n2 + 5);
        graphics.setColor(0xC50000);
        graphics.fillRect(n6, n7, 10, n4);
        graphics.setColor(0);
        graphics.fillRect(n6 + 1, n7 + 2, 8, n5);
        int n8 = this.m_bumpCount;
        if (this.m_healthFlashTime > 0) {
            --n8;
        }
        int n9 = n7 + 3;
        for (int i = 0; i < n3; ++i) {
            if (i >= n8) {
                if (this.m_healthFlashTime > 0 && i == n8) {
                    if (this.m_healthFlashTime < 150) {
                        graphics.setColor(0xFFFFFF);
                    } else {
                        graphics.setColor(0x550000);
                    }
                } else {
                    graphics.setColor(60928);
                }
            } else {
                graphics.setColor(0x550000);
            }
            graphics.fillRect(n6 + 2, n9, 6, 1);
            n9 += 2;
        }
    }
}

