/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.AnimationManager3D;
import javax.microedition.m3g.Node;

public final class AnimPlayer3D {
    private AnimationManager3D m_animMgr3D;
    private int m_animID;
    private int m_frameTime;
    private int m_animTime;
    private int m_animStartTime;
    private int m_animEndTime;
    private int m_playbackSpeed;
    private int m_flags;
    private Node m_node;
    private static final int FLAG_INITIALISED = 1;
    private static final int FLAG_ANIMATING = 2;
    private static final int FLAG_LOOPED = 4;
    private static final int FLAG_REVERSED = 8;
    public static final short DEFAULT_PLAYBACKSPEED = 128;
    public static final byte DEFAULT_PLAYBACKSPEED_SHIFT = 7;
    public static final byte DEFAULT_FRAME_TIME = 40;

    protected AnimPlayer3D(AnimationManager3D animationManager3D) {
        this.m_animMgr3D = animationManager3D;
        this.m_animID = -1;
        this.m_frameTime = 40;
        this.m_playbackSpeed = 128;
        this.m_flags = 1;
    }

    public final void updateAnim(int n) {
        int n2 = this.m_flags;
        if ((n2 & 1) == 0) {
            return;
        }
        if ((n2 & 2) == 0) {
            return;
        }
        int n3 = this.m_animTime;
        int n4 = n * this.m_playbackSpeed >> 7;
        int n5 = this.m_animStartTime;
        int n6 = this.m_animEndTime;
        if ((n2 & 8) != 0) {
            if ((n3 -= n4) < n5) {
                if ((n2 & 4) != 0) {
                    n3 = n4 < n6 - n5 ? n3 + n6 + n5 : n6;
                } else {
                    n3 = n5;
                    n2 &= 0xFFFFFFFD;
                }
            }
        } else if ((n3 += n4) > n6) {
            if ((n2 & 4) != 0) {
                n3 = n4 < n6 - n5 ? n3 - n6 + n5 : n6;
            } else {
                n3 = n6;
                n2 &= 0xFFFFFFFD;
            }
        }
        this.m_animTime = n3;
        this.m_flags = n2;
        if (this.m_node != null) {
            this.m_node.animate(n3);
        }
    }

    public final void startAnim(int n, boolean bl, boolean bl2) {
        int n2;
        if ((this.m_flags & 1) == 0 || n >= this.m_animMgr3D.getNumAnimations() || n < 0) {
            return;
        }
        if (bl || this.m_animID != n) {
            this.m_animID = (short)n;
            n2 = this.m_animMgr3D.getAnimStartFrame(n);
            int n3 = this.m_animMgr3D.getAnimEndFrame(n);
            this.m_animStartTime = n2 * this.m_frameTime;
            this.m_animEndTime = n3 * this.m_frameTime;
            this.m_animTime = (this.m_flags & 8) != 0 ? this.m_animEndTime : this.m_animStartTime;
        } else if (this.m_animTime > this.m_animEndTime) {
            this.m_animTime = this.m_animEndTime;
        } else if (this.m_animTime < this.m_animStartTime) {
            this.m_animTime = this.m_animStartTime;
        }
        n2 = 3;
        if (bl2) {
            n2 |= 4;
        }
        this.m_flags = n2 |= this.m_flags & 8;
        if (this.m_node != null) {
            this.m_node.animate(this.m_animTime);
        }
    }

    public final int getAnimID() {
        return this.m_animID;
    }

    public final boolean isAnimating() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean isReverse() {
        return (this.m_flags & 8) != 0;
    }

    public final boolean isLooping() {
        return (this.m_flags & 4) != 0;
    }

    public final int getAnimTime() {
        if ((this.m_flags & 1) == 0) {
            return 0;
        }
        return this.m_animTime - this.m_animStartTime;
    }

    public final int getAnimWorldTime() {
        return this.m_animTime;
    }

    public final int getAnimWorldFrame() {
        return this.m_animTime / this.m_frameTime;
    }

    public final int getAnimDuration() {
        if ((this.m_flags & 1) == 0) {
            return 0;
        }
        return (this.m_animEndTime - this.m_animStartTime) * 128 / this.m_playbackSpeed;
    }

    public final int getWindowIndex() {
        if ((this.m_flags & 1) == 0) {
            return -1;
        }
        int n = this.m_animTime / this.m_frameTime;
        int n2 = this.m_animMgr3D.getAnimNumWindows(this.m_animID);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_animMgr3D.getAnimWindowStartFrame(this.m_animID, i);
            int n4 = this.m_animMgr3D.getAnimWindowEndFrame(this.m_animID, i);
            if (n < n3 || n > n4) continue;
            return i;
        }
        return -1;
    }

    public final int getWindowFlags() {
        if ((this.m_flags & 1) == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.m_animTime / this.m_frameTime;
        int n3 = this.m_animMgr3D.getAnimNumWindows(this.m_animID);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.m_animMgr3D.getAnimWindowStartFrame(this.m_animID, i);
            int n5 = this.m_animMgr3D.getAnimWindowEndFrame(this.m_animID, i);
            if (n2 < n4 || n2 > n5) continue;
            n |= this.m_animMgr3D.getAnimWindowFlags(this.m_animID, i);
        }
        return n;
    }

    public final boolean isWithinWindow() {
        return this.getWindowIndex() != -1;
    }

    public final boolean isWithinWindow(int n) {
        if ((this.m_flags & 1) == 0) {
            return false;
        }
        int n2 = this.m_animMgr3D.getAnimNumWindows(this.m_animID);
        if (n >= 0 && n < n2) {
            int n3 = this.m_animTime / this.m_frameTime;
            int n4 = this.m_animMgr3D.getAnimWindowStartFrame(this.m_animID, n);
            int n5 = this.m_animMgr3D.getAnimWindowEndFrame(this.m_animID, n);
            if (n3 >= n4 && n3 <= n5) {
                return true;
            }
        }
        return false;
    }

    public final boolean hasPassedWindow() {
        if ((this.m_flags & 1) == 0) {
            return false;
        }
        int n = this.m_animTime / this.m_frameTime;
        int n2 = this.m_animMgr3D.getAnimNumWindows(this.m_animID);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_animMgr3D.getAnimWindowEndFrame(this.m_animID, i);
            if (n < n3) continue;
            return true;
        }
        return false;
    }

    public final boolean hasPassedWindow(int n) {
        int n2;
        int n3;
        if ((this.m_flags & 1) == 0) {
            return false;
        }
        int n4 = this.m_animMgr3D.getAnimNumWindows(this.m_animID);
        return n >= 0 && n < n4 && (n3 = this.m_animTime / this.m_frameTime) >= (n2 = this.m_animMgr3D.getAnimWindowEndFrame(this.m_animID, n));
    }

    public final void setReverse(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
    }

    public final void setAnimating(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
    }

    public final void setAnimTime(int n) {
        this.m_animTime = this.m_animStartTime + n;
        if (this.m_node != null) {
            this.m_node.animate(this.m_animTime);
        }
    }

    public final void setAnimWorldTime(int n) {
        this.m_animTime = n;
        if (this.m_node != null) {
            this.m_node.animate(this.m_animTime);
        }
    }

    public final void setFrameTime(int n) {
        this.m_frameTime = n;
    }

    public final int getFrameTime() {
        return this.m_frameTime;
    }

    public final void setFramesPerSecond(int n) {
        this.m_frameTime = 1000 / n;
    }

    public final void setPlaybackSpeed(int n) {
        this.m_playbackSpeed = n;
    }

    public final int getPlaybackSpeed() {
        return this.m_playbackSpeed;
    }

    public final void setDuration(int n) {
        int n2 = this.m_animEndTime - this.m_animStartTime;
        this.m_playbackSpeed = n2 * 128 / n;
    }

    public void setNode(Node node) {
        this.m_node = node;
    }

    public Node getNode() {
        return this.m_node;
    }
}

