/*
 * Decompiled with CFR 0.152.
 */
package generic;

import constants.SoundEventConstants;
import game.AppEngine;
import generic.ResourceManager;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class SoundManager
implements PlayerListener {
    public static final int SOUNDTYPE_AMR = 0;
    public static final int SOUNDTYPE_MP3 = 1;
    public static final int SOUNDTYPE_QCP = 2;
    public static final int SOUNDTYPE_MID = 3;
    public static final int SOUNDTYPE_WAV = 4;
    private static final byte PLAYSOUND_ERR_SOUNDSTARTDELAY = 1;
    private static final byte PLAYSOUND_ERR_NOTENABLED = 2;
    private static final byte PLAYSOUND_ERR_INVALIDID = 4;
    private static final byte PLAYSOUND_ERR_SOUNDISNULL = 8;
    private static final byte PLAYSOUND_ERR_SOUNDALREADY = 16;
    private static final byte LOADSOUND_ERR_INVALIDID = 1;
    private static final byte LOADSOUND_ERR_SOUNDISNOTNULL = 2;
    private static final String[] MIME_TYPES = new String[]{"audio/amr", "audio/mpeg", "audio/vnd.qcelp", "audio/midi", "audio/x-wav"};
    private ResourceManager m_resourceManager;
    private boolean m_enabled;
    private int m_soundStartDelay;
    private Player[] m_sounds;
    private int m_currentPlayingSound;
    private int m_reloadSound;
    private int m_musicID;
    private int m_lastMusicID;

    private final void DEBUG_SOUND(String string) {
    }

    public SoundManager(ResourceManager resourceManager) {
        int n = SoundEventConstants.SOUND_DATA_SETS.length;
        this.m_resourceManager = resourceManager;
        this.m_enabled = false;
        this.m_soundStartDelay = 0;
        this.m_sounds = new Player[n];
        this.m_currentPlayingSound = -1;
        this.m_reloadSound = -1;
        this.m_musicID = -1;
        this.m_lastMusicID = -1;
    }

    public synchronized void playerUpdate(Player player, String string, Object object) {
        if (string.equals("endOfMedia") || string.equals("stopped") || string.equals("stoppedAtTime")) {
            this.DEBUG_SOUND("sound finished");
            this.m_currentPlayingSound = -1;
        }
    }

    public boolean loadSound(int n, int n2, int n3) {
        int n4 = 0;
        if (n < 0 || n >= this.m_sounds.length) {
            n4 |= 1;
        } else if (this.m_sounds[n] != null) {
            n4 |= 2;
        }
        if (n4 != 0) {
            return true;
        }
        try {
            int n5 = SoundEventConstants.SOUND_DATA_SETS[n];
            int n6 = SoundEventConstants.SOUND_DATA_FORMATS[n];
            String string = MIME_TYPES[n6];
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(n5);
            this.m_sounds[n] = Manager.createPlayer((InputStream)inputStream, (String)string);
            this.m_sounds[n].addPlayerListener((PlayerListener)this);
            this.m_sounds[n].prefetch();
            this.m_sounds[n].realize();
            AppEngine.doGC();
            this.DEBUG_SOUND("load success");
        }
        catch (Exception exception) {
            this.m_sounds[n] = null;
            return false;
        }
        return true;
    }

    public void freeSound(int n) {
        if (this.m_sounds == null) {
            return;
        }
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return;
        }
        this.stopSound(n);
        if (this.m_sounds[n] == null) {
            return;
        }
        this.m_sounds[n].deallocate();
        this.m_sounds[n].removePlayerListener((PlayerListener)this);
        this.m_sounds[n].close();
        this.m_sounds[n] = null;
        AppEngine.doGC();
    }

    public void freeAllSounds() {
        for (int i = 0; i < this.m_sounds.length; ++i) {
            this.freeSound(i);
        }
    }

    public synchronized void playSound(int n) {
        int n2 = 0;
        if (this.m_soundStartDelay > 0) {
            n2 |= 1;
        }
        if (!this.m_enabled) {
            n2 |= 2;
            return;
        }
        if (n < 0 || n >= this.m_sounds.length) {
            n2 |= 4;
        } else if (this.m_sounds[n] == null) {
            n2 |= 8;
        }
        if (this.m_currentPlayingSound != -1) {
            n2 |= 0x10;
        }
        if (n2 != 0) {
            return;
        }
        try {
            this.m_currentPlayingSound = n;
            VolumeControl volumeControl = (VolumeControl)this.m_sounds[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(60);
            }
            this.m_sounds[n].start();
        }
        catch (Throwable throwable) {
            this.m_currentPlayingSound = -1;
        }
    }

    public synchronized void startMusic(int n) {
        if (n != this.m_musicID) {
            this.stopMusic();
        }
        this.m_musicID = n;
    }

    public synchronized void stopMusic() {
        if (this.m_musicID != -1 && this.isSoundPlaying(this.m_musicID)) {
            this.stopSound(this.m_musicID);
            this.m_musicID = -1;
        }
    }

    public synchronized void stopSound(int n) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return;
        }
        try {
            this.DEBUG_SOUND("stopping...");
            this.m_sounds[n].stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n == this.m_currentPlayingSound) {
            this.m_currentPlayingSound = -1;
        }
    }

    public void update(int n) {
        if (this.m_soundStartDelay > 0) {
            this.m_soundStartDelay -= n;
        }
        if (this.m_enabled && this.m_musicID != -1 && !this.isSoundPlaying(this.m_musicID)) {
            try {
                this.m_sounds[this.m_musicID].setMediaTime(-1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.playSound(this.m_musicID);
        }
    }

    public synchronized void appPause() {
        this.DEBUG_SOUND("appPause:");
        if (this.m_currentPlayingSound != -1) {
            this.m_reloadSound = this.m_currentPlayingSound;
            this.freeSound(this.m_currentPlayingSound);
        }
        this.stopAllSounds();
    }

    public synchronized void appResume() {
        this.DEBUG_SOUND("appResume:");
        if (this.m_reloadSound != -1) {
            this.loadSound(this.m_reloadSound, 1, 0);
        }
    }

    public synchronized void stopAllSounds() {
        for (int i = 0; i < this.m_sounds.length; ++i) {
            this.stopSound(i);
        }
        this.m_currentPlayingSound = -1;
    }

    public boolean isSoundPlaying(int n) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return false;
        }
        return this.m_sounds[n].getState() == 400;
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.stopAllSounds();
        }
        this.m_enabled = bl;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }
}

