/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.nfsmw2.MonkeyApp;
import com.ea.sdk.SDKString;
import constants.AnimConstants;
import game.AppEngine;
import game.MoreGames;
import game.Scene;
import game.SceneMTX;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import generic.ResourceManager;
import generic.SoundManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;

public final class SceneMenu
extends Scene {
    private short[] m_menuMain = null;
    private short[] m_menuOptions = null;
    private short[] m_menuSafeHouse = null;
    private short[] m_menuCarSelect = null;
    private short[] m_menuSelectUpgrade = null;
    private static byte m_currentSector;
    private static byte m_currentEvent;
    private static byte m_nextNorthSector;
    private static byte m_nextEastSector;
    private static byte m_nextSouthSector;
    private static byte m_nextWestSector;
    private static byte m_nextNorthEvent;
    private static byte m_nextEastEvent;
    private static byte m_nextSouthEvent;
    private static byte m_nextWestEvent;
    private static boolean m_eventFlashBoss;
    private static boolean m_eventFlashEvents;
    public static boolean moregames_resume;
    private AnimPlayer m_mapIconHighlight;
    private static final byte STATE_PHASE_INVALID = -1;
    private static final byte STATE_PHASE_PRE = 0;
    private static final byte STATE_PHASE_ACTIVE = 1;
    private static final byte STATE_PHASE_POST = 2;
    private byte m_statePhase = (byte)-1;
    public static final byte STATE_INVALID = -1;
    public static final byte STATE_LOADING = 99;
    public static final byte STATE_CONFIRMSOUND = 1;
    public static final byte STATE_EALOGO = 2;
    public static final byte STATE_LOGO = 3;
    public static final byte STATE_CALLTOACTION = 4;
    public static final byte STATE_TUTORIAL = 5;
    public static final byte STATE_MAINMENU = 6;
    public static final byte STATE_CAREERMENU = 7;
    public static final byte STATE_OPTIONS = 8;
    public static final byte STATE_HELP = 10;
    public static final byte STATE_ABOUT = 11;
    public static final byte STATE_MOREGAMES = 12;
    public static final byte STATE_EXITGAME = 13;
    public static final byte STATE_QUICKRACE_CARSELECT = 14;
    public static final byte STATE_QUICKRACE_SECTORSELECT = 15;
    public static final byte STATE_QUICKRACE_EVENTSELECT = 16;
    public static final byte STATE_CAREER_BUY_CAR = 17;
    public static final byte STATE_CAREER_SELL_CAR = 18;
    public static final byte STATE_CAREER_CHOOSE_CAR = 19;
    public static final byte STATE_CAREER_TUNER_SHOP = 20;
    public static final byte STATE_CAREER_SECTORSELECT = 21;
    public static final byte STATE_CAREER_BOSSBEATEN = 22;
    public static final byte STATE_CAREER_BOSSUNLOCKED = 23;
    public static final byte STATE_CAREER_EVENTSELECT = 24;
    public static final byte STATE_CAREERMENU_TUTORIAL = 25;
    public static final byte STATE_START_GAME = 26;
    public static final byte STATE_MTX = 27;
    public static final byte SUBSTATE_CONFIRMSOUND_CURSORIN = 0;
    public static final byte SUBSTATE_CONFIRMSOUND_REVEAL = 1;
    public static final byte SUBSTATE_SPLASH_REVEALEALOGO = 0;
    public static final byte SUBSTATE_SPLASH_HIDEEALOGO = 1;
    public static final byte SUBSTATE_SPLASH_REVEALLOGO = 2;
    public static final byte SUBSTATE_SPLASH_HIDELOGO = 3;
    public static final byte SUBSTATE_SPLASH_REVEALLEGAL = 4;
    public static final byte SUBSTATE_SPLASH_HIDELEGAL = 5;
    public byte m_state = (byte)-1;
    public byte m_nextState = (byte)-1;
    private byte m_prevState = (byte)-1;
    private int m_stateTime;
    private int m_subStateTime;
    private static final byte CONFIRM_INVALID = -1;
    public static final byte CONFIRM_SOUND = 0;
    public static final byte CONFIRM_NEWCAREER = 1;
    public static final byte CONFIRM_RESETDATA = 2;
    public static final byte CONFIRM_RACEAGAIN = 3;
    public static final byte CONFIRM_BUYUPGRADE = 4;
    public static final byte CONFIRM_PLAYTUTORIAL = 5;
    public static final byte CONFIRM_TUTORIAL = 6;
    public static final byte CONFIRM_NO_MONEY = 7;
    public static final byte CONFIRM_EXIT = 8;
    public static final byte CONFIRM_BUYCAR = 9;
    public byte m_confirmType = (byte)-1;
    private byte m_confirmStatePhase = (byte)-1;
    private int m_confirmStatePhaseTime;
    private static final int STATE_TRANSITION_TIME_LONG = 800;
    private static final int STATE_TRANSITION_TIME_SHORT = 400;
    private static final int STATE_TIME_LOGO = 3000;
    private static final int STATE_TIME_EALOGO = 3000;
    private static final int STATE_TIME_CALLTOACTION = 3000;
    private static final int CHUNK_TITLE = 0;
    private static final int CHUNK_CONFIRM = 1;
    public int m_confirmWrapWidth;
    private int m_confirmLeft;
    private int m_confirmTop;
    private int m_confirmWidth;
    private int m_confirmHeight;
    private static final byte CONFIRM_EDGE_PADDING = 10;
    private int m_imageIndexCounter;
    private int m_loadedMenuImages;
    private int m_loadingProgress;
    private int m_numImagesToLoad;
    private int m_numMeshesToLoad;
    private int m_meshLoads;
    private int m_updateLoadingTime = 0;
    private static final int MAX_UPDATE_LOADING_TIME = 0;
    private int m_initialState;
    private static final int STAT_BAR_PADDING = 8;
    private static final int STAT_BAR_HORIZONTAL_LENGTH = 35;
    private static final int MARGIN_HORIZONTAL = 8;
    private static final int MARGIN_VERTICAL = 8;
    private static final int MARGIN_HPADDING = 6;
    private static final int MARGIN_VPADDING = 2;
    private static final int MARGIN_STRIPEHEIGHT = 11;
    private static final int MARGIN_TITLEVPADDING = 2;
    private static final int MARGIN_STATBAR_WIDTH = 60;
    private static final int MARGIN_CORNERPADDING = 1;
    private static int m_marginLeft;
    private static int m_marginRight;
    private static int m_marginLeftInner;
    private static int m_marginRightInner;
    private static int m_marginCenterLeft;
    private static int m_marginCenterRight;
    private static int m_marginTitleTop;
    private static int m_marginTitleBottom;
    private static int m_marginContentTop;
    private static int m_marginContentBottom;
    private static int m_marginSafeHouseMenuTop;
    private static int m_marginSafeHouseTextBottom;
    private static int m_marginChooseEventBoxTop;
    private static int m_marginChooseEventBoxBottom;
    private static int m_marginChooseEventTextTop;
    private static int m_marginChooseEventTextBottom;
    private static int m_marginChooseEventIconTop;
    private static int m_marginChooseEventIconBottom;
    private static int m_marginTunerMenuTitleTop;
    private static int m_marginTunerMenuIconTop;
    private static int m_marginTunerMenuUpgradeTop;
    private static int m_marginChooseCarBoxTop;
    private static int m_marginChooseCarTextTop;
    private static int m_marginChooseCarBoxBottom;
    private static int m_marginChooseCarTextBottom;
    private static int m_marginNarratorTop;
    private static int m_marginNarratorTextLeft;
    private static int m_marginMapLeft;
    private static int m_marginMapTop;
    private static int m_marginMapRight;
    private static int m_marginMapBottom;
    private static int m_marginMainMenuLeft;
    private static int m_marginMainMenuTop;
    private static int m_mapPosX;
    private static int m_mapPosY;
    private static int m_mapStartX;
    private static int m_mapStartY;
    private static int m_mapDestX;
    private static int m_mapDestY;
    private static int m_mapDuration;
    private static int m_mapTime;
    public static int m_menuPosX;
    public static int m_menuPosY;
    private static int m_menuStartX;
    private static int m_menuStartY;
    private static int m_menuDestX;
    private static int m_menuDestY;
    private static int m_menuDuration;
    private static int m_menuTime;
    private SDKString m_stringBufferReward = null;
    private SDKString m_stringBufferLaps = null;
    private SDKString m_stringBufferBestTime = null;
    private SDKString m_stringBufferLength = null;
    private SDKString m_stringBufferCarPrice = null;
    private SDKString m_stringBufferCash = null;
    private int m_carPriceOffset;
    private AnimPlayer m_animSafeHouse;
    private int m_safeHouseCurPage;
    private int m_safeHouseMaxPages;
    private int m_safeHouseLinesPerPage;
    private boolean m_noMoreCarsToPurchase = false;
    private boolean m_fireKeyEnabled;
    private boolean m_carLoaded = false;
    private static final int CARCAM_NEARCLIP = 6553;
    private static final int CARCAM_FARCLIP = 0x4B0000;
    private static final int CAMERA_FOV_NORMAL = 0x320000;
    private Camera m_carCamera;
    private Transform m_carCameraTransform;
    private Background m_carBackground;
    private Node[] m_carNodes;
    private Node m_garageMesh;
    private int m_cameraRotationRadF;
    private static final int CARSELECT_ROTATE_SPEED = 19660;
    private int[] m_cameraCoords;
    private int[] m_cameraInterpFromCoords;
    private int[] m_cameraInterpToCoords;
    private boolean m_cameraInterping;
    private int m_cameraAnimation;
    private static int CARSELECT_LEFT;
    private static int CARSELECT_TOP;
    private static int CARSELECT_WIDTH;
    private static int CARSELECT_HEIGHT;
    private static int ASPECT_RATIO;
    private static final byte[][] WORLD_MAP;
    private int m_carLoadProgress = -1;
    private boolean m_askTutorial;
    private static byte[] s_unlockCarLevels;
    private static int UPGRADE_MIN_VALUE_TOP_SPEED;
    private static int UPGRADE_MAX_VALUE_TOP_SPEED;
    private static int UPGRADE_MIN_VALUE_ACCELERATION;
    private static int UPGRADE_MAX_VALUE_ACCELERATION;
    private static int UPGRADE_MIN_VALUE_HANDLING;
    private static int UPGRADE_MAX_VALUE_HANDLING;
    private static int UPGRADE_MAX_VALUE_NITRO;
    private static final int PAGE_TITLE_PADDING_LEFT = 8;
    private static final int SAFEHOUSE_INVALID = -1;
    private static final int SAFEHOUSE_INTRO = 0;
    private static final int SAFEHOUSE_DEFEATED_BOSS1 = 1;
    private static final int SAFEHOUSE_DEFEATED_BOSS2 = 2;
    private static final int SAFEHOUSE_DEFEATED_BOSS3 = 3;
    private static final int SAFEHOUSE_CLOSEWINDOW = 4;
    private byte m_safeHouseState = (byte)-1;
    private int[][] m_carSelectStats = new int[4][3];
    private static final int TUNERSHOP_ANIM_ENG = 0;
    private static final int TUNERSHOP_ANIM_TRAN = 1;
    private static final int TUNERSHOP_ANIM_TYRE = 2;
    private static final int TUNERSHOP_ANIM_NITRO = 3;
    private static final int TUNERSHOP_ANIM_BODYKIT = 4;
    private static final int TUNERSHOP_ANIM_INIT = 5;
    private static final int TUNERSHOP_ANIM_WALL = 6;
    private static final int[][] CARCAMERA_ANIMS;
    private Node m_carShadow;
    private Node[][] m_carMeshes;
    private boolean[] m_carWasLocked;
    private static final int CARCAM_SHIFT = 3;
    private boolean m_loadCarNext = false;
    private int m_tunerShopFocusTime;
    private static final int TUNER_SHOP_FOCUS_TIME = 400;
    private static final int[] s_tempInt2;

    public SceneMenu(AppEngine appEngine) {
        super(appEngine);
        this.m_confirmWrapWidth = (short)(appEngine.getWidth() - 20);
        this.initValues();
        this.initLanguageDependantValues();
        this.initMargins();
        appEngine.cornerBracketVisible(false);
        appEngine.initCornerBracket(-1, -1, appEngine.getWidth() + 1, appEngine.getHeight() + 1, -1, -1, appEngine.getWidth() + 1, appEngine.getHeight() + 1, 200);
        this.m_mapIconHighlight = new AnimPlayer();
    }

    public void start(int n) {
        if (n == 25) {
            n = 7;
            this.m_safeHouseState = 0;
        }
        if (n == -1 && !this.m_engine.getTurorialCompleted() && !this.m_engine.rmsGameExists()) {
            this.m_askTutorial = true;
        }
        this.m_loadingProgress = 0;
        this.m_initialState = n;
        this.m_animSafeHouse = AnimationManager.createAnimPlayer();
        this.m_state = (byte)99;
    }

    private final void loadSounds() {
        AppEngine appEngine = this.m_engine;
        SoundManager soundManager = appEngine.getSoundManager();
        soundManager.loadSound(0, 1, 1);
        soundManager.loadSound(6, 1, 1);
        soundManager.loadSound(7, 1, 1);
    }

    private final void unloadSounds() {
        AppEngine appEngine = this.m_engine;
        SoundManager soundManager = appEngine.getSoundManager();
        soundManager.stopMusic();
        soundManager.freeSound(0);
        soundManager.freeSound(6);
        soundManager.freeSound(7);
    }

    public void updateLoading(int n) {
        AppEngine.doGC();
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        if (this.m_loadingProgress <= 0) {
            int n2;
            this.m_loadedMenuImages = 0;
            this.m_numImagesToLoad = 0;
            this.m_imageIndexCounter = 0;
            for (n2 = 0; n2 < appEngine.IMAGE_COUNT; ++n2) {
                int n3 = n2 << 1;
                long l = AppEngine.IMAGE_IDS[n3 + 1];
                if ((l & 2L) == 0L) continue;
                ++this.m_numImagesToLoad;
            }
            n2 = appEngine.getNumCars();
            this.m_carMeshes = new Node[n2][];
            this.m_carWasLocked = new boolean[n2];
            this.m_numMeshesToLoad = n2 + 5;
            this.m_loadingProgress = 10;
        } else if (this.m_loadingProgress < 30) {
            if (this.m_updateLoadingTime > 0) {
                this.m_updateLoadingTime -= n;
            } else {
                int n4 = 0;
                while (n4 < 1 && this.m_imageIndexCounter < appEngine.IMAGE_COUNT) {
                    int n5 = this.m_imageIndexCounter << 1;
                    int n6 = (int)AppEngine.IMAGE_IDS[n5 + 0];
                    long l = AppEngine.IMAGE_IDS[n5 + 1];
                    boolean bl = false;
                    if ((l & 2L) != 0L) {
                        if (AnimationManager.loadImage(resourceManager, n6)) {
                            ++n4;
                            ++this.m_loadedMenuImages;
                            this.DEBUG_PRERACE("...loaded");
                        } else {
                            bl = true;
                            this.DEBUG_PRERACE("... failed to load.");
                        }
                    }
                    if (bl) continue;
                    ++this.m_imageIndexCounter;
                    this.m_updateLoadingTime = 0;
                }
                this.m_loadingProgress = 10 + 20 * this.m_loadedMenuImages / this.m_numImagesToLoad;
            }
        } else if (this.m_loadingProgress < 97) {
            switch (this.m_meshLoads) {
                case 0: {
                    resourceManager.cachedLoadM3GImage2D(47);
                    break;
                }
                case 1: {
                    resourceManager.cachedLoadM3GImage2D(52);
                    break;
                }
                case 2: {
                    resourceManager.cachedLoadM3GNode(6);
                    break;
                }
                case 3: {
                    Image2D image2D = resourceManager.cachedLoadM3GImage2D(47);
                    Node node = resourceManager.cachedLoadMergedM3GNode(1548);
                    AppEngine.helperApplyTexture(node, image2D);
                    this.m_carShadow = node;
                    break;
                }
                case 4: {
                    Image2D image2D = resourceManager.cachedLoadM3GImage2D(48);
                    this.m_garageMesh = resourceManager.cachedLoadM3GNode(62);
                    AppEngine.helperApplyTexture(this.m_garageMesh, image2D);
                    this.m_garageMesh.setScale(0.1f, 0.1f, 0.1f);
                    break;
                }
                default: {
                    this.loadCar(this.m_meshLoads - 5);
                }
            }
            ++this.m_meshLoads;
            this.m_loadingProgress = 30 + 67 / this.m_numMeshesToLoad * this.m_meshLoads;
            if (this.m_meshLoads == this.m_numMeshesToLoad) {
                this.m_loadingProgress = 97;
            }
        } else if (this.m_loadingProgress < 100) {
            this.loadSounds();
            this.m_loadingProgress = 100;
        }
        if (this.m_loadingProgress >= 100) {
            this.initializeCarSelect();
            if (this.m_initialState == -1) {
                this.m_state = (byte)this.m_initialState;
                this.stateTransitionOut((byte)1);
            } else {
                this.m_state = (byte)-1;
                AnimationManager.loadImage(appEngine.getResourceManager(), 31);
                this.stateTransitionOut((byte)this.m_initialState);
            }
            appEngine.cornerBracketVisible(true);
            appEngine.setFadeStep(394758);
            appEngine.startFadeIn();
            this.m_engine.startMusic(0);
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void end() {
        AppEngine appEngine = this.m_engine;
        this.unloadSounds();
        appEngine.requestGC(false);
        AppEngine.releaseStringBuffer(this.m_stringBufferCarPrice);
        AppEngine.releaseStringBuffer(this.m_stringBufferCash);
        AppEngine.releaseStringBuffer(this.m_stringBufferReward);
        AppEngine.releaseStringBuffer(this.m_stringBufferLaps);
        AppEngine.releaseStringBuffer(this.m_stringBufferBestTime);
        AppEngine.releaseStringBuffer(this.m_stringBufferLength);
        AppEngine.doGC();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateConfirm(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_confirmStatePhase == 0) {
            if (appEngine.cornerBracketFinished()) {
                this.m_confirmStatePhase = 1;
            }
        } else if (this.m_confirmStatePhase != 1 && this.m_confirmStatePhase == 2 && appEngine.cornerBracketFinished()) {
            this.clearConfirm();
        }
    }

    private void updateLanguageMenu(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.cornerBracketFinished()) {
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2) {
            this.stateTransitionIn();
        }
    }

    private void updateConfirmSound(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.cornerBracketFinishedPause()) {
                this.stateActive();
                this.confirm((byte)0);
                return;
            }
        } else if (this.m_statePhase == 1) {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), appEngine.getHalfHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), 200);
            this.stateTransitionOut((byte)2);
        } else if (this.m_statePhase == 2 && appEngine.cornerBracketFinished()) {
            this.stateTransitionIn();
        }
    }

    private void updateEALogo(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.fadeColourReached()) {
                this.stateActive();
            }
        } else if (this.m_statePhase == 1) {
            if (this.m_stateTime >= 3000) {
                this.stateTransitionOut((byte)3);
                appEngine.startFadeOut();
            }
        } else if (this.m_statePhase == 2 && appEngine.fadeColourReached()) {
            AnimationManager.unloadImage(57);
            this.stateTransitionIn();
        }
    }

    private void updateLogo(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.fadeColourReached()) {
                this.stateActive();
            }
        } else if (this.m_statePhase == 1) {
            if (this.m_stateTime >= 3000) {
                this.stateTransitionOut((byte)4);
                appEngine.startFadeOut();
            }
        } else if (this.m_statePhase == 2 && appEngine.fadeColourReached()) {
            AnimationManager.unloadImage(22);
            this.stateTransitionIn();
        }
    }

    private void updateCallToAction(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.fadeColourReached()) {
                this.stateActive();
            }
        } else if (this.m_statePhase == 1) {
            AnimationManager.loadImage(appEngine.getResourceManager(), 31);
            if (this.m_stateTime >= 3000) {
                if (this.m_askTutorial) {
                    appEngine.setTurorialCompleted(true);
                    appEngine.saveRMSGameData();
                    this.m_askTutorial = false;
                    this.stateTransitionOut((byte)5);
                } else {
                    this.stateTransitionOut((byte)6);
                }
                appEngine.startFadeOut();
            }
        } else if (this.m_statePhase == 2 && appEngine.fadeColourReached()) {
            this.stateTransitionIn();
        }
    }

    private void updateTutorial(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.fadeColourReached()) {
                this.confirm((byte)6);
                this.stateActive();
            }
        } else if (this.m_statePhase == 1) {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), appEngine.getHalfHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), 200);
            this.stateTransitionOut((byte)6);
        } else if (this.m_statePhase == 2 && appEngine.cornerBracketFinished()) {
            this.stateTransitionIn();
        }
    }

    private void updateMainMenu(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (this.finishedMenuAnim()) {
                this.cornerHighlightMenuSelection(this.m_menuMain);
                this.stateActive();
            } else {
                this.updateMenuAnim();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2) {
            if (this.m_nextState == 14 || this.m_nextState == 7) {
                if (appEngine.fadeColourReached()) {
                    this.stateTransitionIn();
                }
            } else {
                this.stateTransitionIn();
            }
        }
    }

    private void updateSafeHouse(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (this.m_stateTime > 800) {
                if (this.m_safeHouseState != -1) {
                    appEngine.initCornerBracket(m_marginLeft - 1, m_marginNarratorTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 400);
                } else {
                    this.cornerHighlightMenuSelection(this.m_menuSafeHouse);
                }
                this.stateActive();
            } else {
                this.updateMenuAnim();
            }
        } else if (this.m_statePhase == 1) {
            this.m_animSafeHouse.updateAnim(n);
            if (this.m_animSafeHouse.getAnimID() == 54 && !this.m_animSafeHouse.isAnimating()) {
                this.m_animSafeHouse.startAnim(50, true, true);
            } else if (this.m_animSafeHouse.getAnimID() == 53 && !this.m_animSafeHouse.isAnimating() && this.m_safeHouseState != -1) {
                this.m_safeHouseState = (byte)-1;
                this.cornerHighlightMenuSelection(this.m_menuSafeHouse);
                this.setupSoftkeys();
            }
        } else if (this.m_statePhase == 2) {
            if (appEngine.fadeColourReached() && this.m_nextState == 6 && appEngine.cornerBracketFinishedPause() || this.m_stateTime > 400 && this.m_nextState != 6) {
                this.stateTransitionIn();
            } else {
                this.updateMenuAnim();
            }
        }
        if (this.m_carNodes != null) {
            this.updateCarSelect(n);
        }
    }

    private void updateOptions(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.cornerBracketFinished()) {
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2) {
            this.stateTransitionIn();
        }
    }

    private void updateHelpAbout(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (appEngine.cornerBracketFinished()) {
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2) {
            this.stateTransitionIn();
        }
    }

    private void updateQuickRaceCarSelect(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (this.m_stateTime > 800) {
                appEngine.initCornerBracket(m_marginLeft - 1, m_marginChooseCarBoxTop - 1, m_marginRight + 1, m_marginChooseCarBoxBottom + 1, 200);
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2 && (appEngine.fadeColourReached() && this.m_nextState == 6 || this.m_stateTime > 400 && this.m_nextState != 6)) {
            this.stateTransitionIn();
        }
        if (this.m_carNodes != null) {
            this.updateCarSelect(n);
        }
    }

    private void updateChooseEvent(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (this.m_stateTime > 800) {
                appEngine.initCornerBracket(m_marginLeft - 1, m_marginContentTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 200);
                this.stateActive();
            }
        } else if (this.m_statePhase == 1) {
            this.m_mapIconHighlight.updateAnim(n);
            this.m_animSafeHouse.updateAnim(n);
            if (this.m_animSafeHouse.getAnimID() == 54 && !this.m_animSafeHouse.isAnimating()) {
                this.m_animSafeHouse.startAnim(50, true, true);
            } else if (this.m_animSafeHouse.getAnimID() == 53 && !this.m_animSafeHouse.isAnimating() && this.m_safeHouseState != -1) {
                this.m_safeHouseState = (byte)-1;
                this.setupSoftkeys();
            }
        } else if (this.m_statePhase == 2 && this.m_stateTime > 400 && appEngine.fadeColourReached()) {
            this.stateTransitionIn();
        }
        if (this.m_carNodes != null) {
            this.updateCarSelect(n);
        }
        this.updateMapAnim(n);
    }

    private void updateBuyCar(int n) {
        AppEngine appEngine = this.m_engine;
        if (this.m_statePhase == 0) {
            if (this.m_stateTime > 800) {
                appEngine.initCornerBracket(m_marginLeft - 1, m_marginChooseCarBoxTop - 1, m_marginRight + 1, m_marginChooseCarBoxBottom + 1, 200);
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2 && this.m_stateTime > 400) {
            this.stateTransitionIn();
        }
        if (this.m_carNodes != null) {
            this.updateCarSelect(n);
        }
    }

    private void updateTunerShop(int n) {
        AppEngine appEngine = this.m_engine;
        if (appEngine.getCarAccessoryLevel((byte)appEngine.getPlayerCarIndex(), 4) != 0) {
            this.m_carNodes[6].setRenderingEnable(true);
        } else {
            this.m_carNodes[6].setRenderingEnable(false);
        }
        if (this.m_statePhase == 0) {
            if (this.m_stateTime > 800) {
                appEngine.initCornerBracket(m_marginLeft - 1, m_marginTunerMenuTitleTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 200);
                this.stateActive();
            }
        } else if (this.m_statePhase != 1 && this.m_statePhase == 2 && this.m_stateTime > 400) {
            this.stateTransitionIn();
        }
        if (this.m_carNodes != null) {
            this.updateCarSelect(n);
        }
    }

    public void update(int n) {
        AppEngine appEngine = this.m_engine;
        if (appEngine.cheatUsed(1) || appEngine.cheatUsed(0)) {
            this.cheats();
        }
        if (this.waitingForConfirm()) {
            this.updateConfirm(n);
        } else {
            switch (this.m_state) {
                case 99: {
                    this.updateLoading(n);
                    break;
                }
                case 1: {
                    this.updateConfirmSound(n);
                    break;
                }
                case 2: {
                    this.updateEALogo(n);
                    break;
                }
                case 3: {
                    this.updateLogo(n);
                    break;
                }
                case 4: {
                    this.updateCallToAction(n);
                    break;
                }
                case 5: {
                    this.updateTutorial(n);
                    break;
                }
                case 6: {
                    this.updateMainMenu(n);
                    break;
                }
                case 7: {
                    this.updateSafeHouse(n);
                    break;
                }
                case 8: {
                    this.updateOptions(n);
                    break;
                }
                case 10: 
                case 11: {
                    this.updateHelpAbout(n);
                    break;
                }
                case 14: 
                case 19: {
                    this.updateQuickRaceCarSelect(n);
                    break;
                }
                case 15: 
                case 21: {
                    this.updateChooseEvent(n);
                    break;
                }
                case 17: {
                    this.updateBuyCar(n);
                    break;
                }
                case 20: {
                    this.updateTunerShop(n);
                    break;
                }
                case 13: {
                    if (appEngine.isFading()) break;
                    appEngine.endGame();
                    break;
                }
                case 26: {
                    if (appEngine.isFading()) break;
                    appEngine.changeScene(1);
                    break;
                }
                case 12: {
                    break;
                }
                case 27: {
                    if (this.m_statePhase == 0) {
                        if (!appEngine.cornerBracketFinished()) break;
                        SceneMTX.setCall2ActionType((byte)0);
                        this.m_engine.initMTX(0);
                        break;
                    }
                    if (this.m_statePhase != 2 || !appEngine.cornerBracketFinished()) break;
                    this.stateTransitionIn();
                }
            }
        }
        appEngine.updateCornerBrackets(n);
        this.m_stateTime += n;
        this.m_subStateTime += n;
        this.m_confirmStatePhaseTime += n;
    }

    private void clearScreen(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
    }

    public void initMargins() {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getWidth();
        int n2 = appEngine.getHeight();
        this.m_confirmWrapWidth = (short)(appEngine.getWidth() - 20);
        m_marginLeft = 8;
        m_marginRight = n - 8;
        m_marginTitleTop = 8;
        m_marginTitleBottom = m_marginTitleTop + appEngine.getLineHeight(3) * 2 + 4;
        m_marginContentTop = m_marginTitleBottom + 8;
        m_marginCenterLeft = n - 8 >> 1;
        m_marginCenterRight = m_marginCenterLeft + 8;
        m_marginLeftInner = m_marginLeft + 6;
        m_marginRightInner = m_marginRight - 6;
        m_marginContentBottom = n2 - 14 - 4;
        m_marginSafeHouseTextBottom = m_marginContentBottom - 2;
        m_marginSafeHouseMenuTop = m_marginSafeHouseTextBottom - 44;
        m_marginTunerMenuUpgradeTop = m_marginSafeHouseTextBottom - 22;
        m_marginTunerMenuIconTop = m_marginTunerMenuUpgradeTop - AnimationManager.getAnimFrameHeight(45, 0) - 2 - 8;
        m_marginTunerMenuTitleTop = m_marginTunerMenuIconTop - appEngine.getLineHeight(3) - 4;
        m_marginChooseEventBoxBottom = m_marginContentBottom;
        m_marginChooseEventTextBottom = m_marginChooseEventBoxBottom - 2;
        m_marginChooseEventTextTop = m_marginChooseEventTextBottom - 33;
        m_marginChooseEventIconBottom = m_marginChooseEventBoxTop = m_marginChooseEventTextTop - 2;
        m_marginChooseEventIconTop = m_marginChooseEventIconBottom - AnimationManager.getAnimFrameHeight(85, 0) - 2 - 2;
        m_marginMapLeft = m_marginLeftInner;
        m_marginMapRight = m_marginRightInner;
        m_marginMapTop = m_marginContentTop + 8;
        m_marginMapBottom = m_marginChooseEventIconTop - 8;
        m_marginChooseCarBoxBottom = m_marginContentBottom;
        m_marginChooseCarTextBottom = m_marginContentBottom - 2;
        m_marginChooseCarTextTop = m_marginChooseCarTextBottom - 44;
        m_marginChooseCarBoxTop = m_marginChooseCarTextTop - 2;
        m_marginNarratorTop = m_marginContentBottom - 4 - AnimationManager.getAnimFrameHeight(50, 0);
        m_marginNarratorTextLeft = 6 + AnimationManager.getAnimFrameWidth(50, 0) + 6;
        int[] nArray = s_tempInt2;
        AnimationManager.getAnimFrameFirePoint(nArray, 23, 0, 0);
        m_marginMainMenuLeft = nArray[0];
        m_marginMainMenuTop = nArray[1];
    }

    private void initValues() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        AppEngine appEngine = this.m_engine;
        int n7 = appEngine.getWidth();
        m_menuPosX = n7 >> 2;
        int n8 = 0;
        for (n6 = 0; n6 < appEngine.getNumCarsBuyable(); ++n6) {
            short s = appEngine.getCarDescriptionStringID(n6);
            n5 = appEngine.getStringWidth(s, 1);
            if (n5 <= n8) continue;
            n8 = n5;
        }
        this.m_stringBufferCarPrice = AppEngine.getStringBuffer();
        this.m_stringBufferCash = AppEngine.getStringBuffer();
        this.m_stringBufferReward = AppEngine.getStringBuffer();
        this.m_stringBufferLaps = AppEngine.getStringBuffer();
        this.m_stringBufferBestTime = AppEngine.getStringBuffer();
        this.m_stringBufferLength = AppEngine.getStringBuffer();
        n6 = appEngine.getNumCarsBuyable();
        short[][] sArray = appEngine.getCareerTunerSubMenuStringIDs();
        n5 = sArray.length;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = Integer.MAX_VALUE;
        int n13 = Integer.MAX_VALUE;
        int n14 = Integer.MAX_VALUE;
        for (n4 = 0; n4 < n6; ++n4) {
            block7: for (n3 = 0; n3 < n5; ++n3) {
                switch (n3) {
                    case 0: {
                        n2 = (byte)(appEngine.getCarNumGears(n4) - 1);
                        n = appEngine.getCarGearMaxSpeed(n4, (byte)n2);
                        if (n12 > n) {
                            n12 = n;
                        }
                        if (n9 >= n) continue block7;
                        n9 = n;
                        continue block7;
                    }
                    case 1: {
                        n = appEngine.getCarGearAccel(n4, (byte)0);
                        if (n13 > n) {
                            n13 = n;
                        }
                        if (n10 >= n) continue block7;
                        n10 = n;
                        continue block7;
                    }
                    case 2: {
                        n2 = appEngine.getCarParamTyres(n4);
                        if (n14 > n2) {
                            n14 = n2;
                        }
                        if (n11 >= n2) continue block7;
                        n11 = n2;
                        continue block7;
                    }
                }
            }
        }
        n4 = sArray[0].length;
        n3 = appEngine.getCareerAccessoryAdjustment(0, 0, n4);
        UPGRADE_MIN_VALUE_TOP_SPEED = n12 - (n12 >> 2);
        UPGRADE_MAX_VALUE_TOP_SPEED = MathExt.Fmul(n9, n3);
        n2 = sArray[1].length;
        n = appEngine.getCareerAccessoryAdjustment(1, 0, n2);
        UPGRADE_MIN_VALUE_ACCELERATION = n13 - (n13 >> 2);
        UPGRADE_MAX_VALUE_ACCELERATION = MathExt.Fmul(n10, n);
        int n15 = sArray[2].length;
        int n16 = appEngine.getCareerAccessoryAdjustment(2, 0, n15);
        UPGRADE_MIN_VALUE_HANDLING = n14 - (n14 >> 2);
        UPGRADE_MAX_VALUE_HANDLING = MathExt.Fmul(n11, n16);
    }

    private void initLanguageDependantValues() {
        AppEngine appEngine = this.m_engine;
        this.m_stringBufferCarPrice.setLength(0);
        appEngine.appendString(this.m_stringBufferCarPrice, 119);
        appEngine.appendString(this.m_stringBufferCarPrice, 100);
        appEngine.appendString(this.m_stringBufferCarPrice, " ");
        this.m_carPriceOffset = this.m_stringBufferCarPrice.length();
    }

    public void renderScreenBackground(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = AnimationManager.getAnimFrameWidth(25, 0);
        int n2 = AnimationManager.getAnimFrameHeight(25, 0);
        int n3 = appEngine.getWidth();
        int n4 = appEngine.getHeight();
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(n, 0, n3 - n, n4);
        graphics.fillRect(0, n2, n3, n4 - n2);
        if (AppEngine.isFlipped) {
            AnimationManager.drawAnimFrame(graphics, 26, 0, 0, 0);
            if (this.m_state == 6 || this.m_state == 8 || this.m_state == 10 || this.m_state == 11) {
                AnimationManager.drawAnimFrame(graphics, 22, 0, 0, 0);
            }
            AnimationManager.drawAnimFrame(graphics, 87, 0, this.m_stateTime / 10 % (n3 << 2) - n3, 5);
        } else {
            AnimationManager.drawAnimFrame(graphics, 25, 0, 0, 0);
            if (this.m_state == 6 || this.m_state == 8 || this.m_state == 10 || this.m_state == 11) {
                AnimationManager.drawAnimFrame(graphics, 21, 0, 0, 0);
            }
            AnimationManager.drawAnimFrame(graphics, 86, 0, this.m_stateTime / 10 % (n3 << 2) - n3, 5);
        }
    }

    public void render(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        if (this.m_state == 99) {
            this.clearScreen(graphics);
            appEngine.renderLoading(graphics, this.m_loadingProgress);
            return;
        }
        switch (this.m_state) {
            case 1: {
                this.renderConfirmSound(graphics);
                break;
            }
            case 2: {
                this.renderEALogo(graphics);
                break;
            }
            case 3: {
                this.renderLogo(graphics);
                break;
            }
            case 4: {
                this.renderCallToAction(graphics);
                break;
            }
            case 5: {
                this.clearScreen(graphics);
                break;
            }
            case 6: {
                this.renderMainMenu(graphics);
                break;
            }
            case 7: {
                this.renderCarWindow(graphics);
                this.renderSafeHouse(graphics);
                break;
            }
            case 8: {
                this.renderOptions(graphics);
                break;
            }
            case 10: 
            case 11: {
                this.renderHelpAbout(graphics);
                break;
            }
            case 14: 
            case 19: {
                this.renderCarWindow(graphics);
                this.renderCarSelect(graphics);
                break;
            }
            case 15: 
            case 21: {
                this.renderCarWindow(graphics);
                this.renderChooseEvent(graphics);
                break;
            }
            case 17: {
                this.renderCarWindow(graphics);
                this.renderCarSelect(graphics);
                break;
            }
            case 20: {
                this.renderCarWindow(graphics);
                this.renderCareerTunerShop(graphics);
                break;
            }
            case 27: {
                this.clearScreen(graphics);
            }
        }
        if (this.waitingForConfirm() && this.m_confirmStatePhase == 1) {
            appEngine.renderSoftKeys(graphics);
            this.renderConfirm(graphics);
        }
        if (!this.inStateTransition() && !this.inStateConfirmTransition()) {
            appEngine.renderSoftKeys(graphics);
        }
    }

    private void renderConfirmSound(Graphics graphics) {
        this.clearScreen(graphics);
    }

    private void renderEALogo(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.clearScreen(graphics);
        AnimationManager.drawAnimFrame(graphics, 7, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight());
    }

    private void renderLogo(Graphics graphics) {
        this.clearScreen(graphics);
        if (AppEngine.isFlipped) {
            AnimationManager.drawAnimFrame(graphics, 40, 0, 0, 0);
        } else {
            AnimationManager.drawAnimFrame(graphics, 39, 0, 0, 0);
        }
    }

    private void renderCallToAction(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getWidth() - 20;
        this.clearScreen(graphics);
        appEngine.wrapString(162, 1, n);
        int n2 = appEngine.getNumWrappedLines() * appEngine.getLineHeight(1);
        int n3 = appEngine.getHeight() - n2 >> 1;
        appEngine.drawWrappedString(graphics, 1, appEngine.getHalfWidth(), n3, 17);
    }

    private void renderMainMenu(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.renderScreenBackground(graphics);
        appEngine.renderMenuVertical(graphics, m_menuPosX, m_menuPosY, this.m_menuMain, appEngine.cornerBracketFinished() && this.m_statePhase == 1 && !this.waitingForConfirm());
    }

    private void renderSafeHouse(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.renderPageTitle(graphics, false, false, true);
        appEngine.renderMenuVertical(graphics, m_menuPosX, m_menuPosY, this.m_menuSafeHouse, appEngine.cornerBracketFinished() && this.m_statePhase == 1);
        this.renderNarrator(graphics);
    }

    private void renderNarrator(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = m_marginLeft;
        int n2 = this.m_state == 7 ? m_marginNarratorTop : m_marginChooseEventIconTop;
        int n3 = m_marginRight - m_marginLeft;
        int n4 = m_marginContentBottom - m_marginNarratorTop;
        int n5 = 2 + AnimationManager.getAnimFrameWidth(50, 0) + 2;
        if (this.m_safeHouseState != -1 && this.m_statePhase == 1 && appEngine.cornerBracketFinished()) {
            appEngine.renderTitledWindow(graphics, -1, n, n2, n3, n4);
            AnimationManager.drawAnim(graphics, this.m_animSafeHouse, n + 2, n2 + 2);
            appEngine.drawPartWrappedString(graphics, 1, n + n5, n2 + 2, 20, this.m_safeHouseCurPage * this.m_safeHouseLinesPerPage, this.m_safeHouseLinesPerPage);
        }
    }

    private void renderOptions(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.renderScreenBackground(graphics);
        appEngine.renderMenuVertical(graphics, m_menuPosX, m_menuPosY, this.m_menuMain, false);
        appEngine.renderBackgroundDim(graphics, true);
        if (this.m_statePhase == 1) {
            int n = AppEngine.menuGetWidth(3, this.m_menuOptions) + 12;
            int n2 = AppEngine.menuGetLength(this.m_menuOptions) * appEngine.getLineHeight(3) + 12 + appEngine.getTitleHeight();
            int n3 = appEngine.getWidth() - n >> 1;
            int n4 = m_menuPosY - appEngine.getTitleHeight() - 6;
            int n5 = n;
            int n6 = n2;
            appEngine.renderTitledWindow(graphics, 22, n3, n4, n5, n6);
            appEngine.renderMenuVertical(graphics, n3 + 6, m_menuPosY, this.m_menuOptions, true);
        }
    }

    private void renderHelpAbout(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.renderScreenBackground(graphics);
        appEngine.renderMenuVertical(graphics, m_menuPosX, m_menuPosY, this.m_menuMain, false);
        appEngine.renderBackgroundDim(graphics, true);
        if (this.m_statePhase == 1) {
            appEngine.renderWindow(graphics);
        }
    }

    private boolean isCarUnlocked(short[] sArray) {
        AppEngine appEngine = this.m_engine;
        if (sArray != null) {
            short s = AppEngine.menuGetSelectedItem(sArray);
            byte by = appEngine.getCarFromDescriptionStringID(s);
            int n = appEngine.getBossLockedSector();
            if (by == 7) {
                return true;
            }
            if (by != -1 && by > s_unlockCarLevels[n] && !appEngine.cheatUsed(0)) {
                return false;
            }
        }
        return true;
    }

    private boolean canPurchaseSelectedCar(short[] sArray) {
        AppEngine appEngine = this.m_engine;
        if (sArray != null) {
            int n;
            int n2 = appEngine.rmsGetCareerMoney();
            short s = AppEngine.menuGetSelectedItem(sArray);
            byte by = appEngine.getCarFromDescriptionStringID(s);
            if (by != -1 && n2 < (n = appEngine.getCarPrice(by))) {
                return false;
            }
        }
        return true;
    }

    private void renderStatBarsHorizontal(Graphics graphics, int n, int n2) {
        this.renderStatBars(graphics, n, n2);
    }

    private void renderStatBars(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = (byte)appEngine.getCareerTunerMenuStringIDs().length - 1;
        --n3;
        if (SceneMTX.isUnlocked()) {
            if (this.m_state != 17 && this.m_state != 27 && this.m_state != 19 && this.m_state != 20 && this.m_state != 14) {
                ++n3;
            }
            if (this.m_state == 17) {
                --n3;
            }
        } else {
            --n3;
            if (this.m_state != 17 && this.m_state != 27) {
                ++n3;
            }
        }
        int n4 = n2;
        for (int n5 = 0; n5 < n3; n5 = (int)((byte)(n5 + 1))) {
            n4 = n2 + appEngine.getLineHeight(1) * n5;
            int n6 = 0;
            switch (n5) {
                case 0: {
                    n6 = 242;
                    break;
                }
                case 1: {
                    n6 = 243;
                    break;
                }
                case 2: {
                    n6 = 245;
                    break;
                }
                case 3: {
                    n6 = 244;
                }
            }
            this.renderStatBarHorizontal(graphics, n, n4, 4, 35, n6, this.m_carSelectStats[n5][0], this.m_carSelectStats[n5][1], this.m_carSelectStats[n5][2]);
        }
    }

    private void renderStatBarHorizontal(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        AppEngine appEngine = this.m_engine;
        int n9 = appEngine.getStringWidth(243, 1);
        int n10 = n + n9 + 4;
        int n11 = n4 << 16;
        appEngine.drawString(graphics, n5, 1, n, n2, 20);
        AnimationManager.setColor(graphics, 110);
        graphics.fillRect(n10, ++n2, n4, n3);
        AnimationManager.setColor(graphics, 102);
        int n12 = MathExt.Fmul(n7, n11) >> 16;
        int n13 = MathExt.Fmul(n8, n11) >> 16;
        if (n8 > n7 && n13 - n12 < 1) {
            n13 = n12 + 1;
        }
        graphics.fillRect(n10, n2, n13, n3);
        AnimationManager.setColor(graphics, 84);
        graphics.fillRect(n10, n2, n12, n3);
        AnimationManager.setColor(graphics, 89);
        graphics.fillRect(n10, n2, MathExt.Fmul(n6, n11) >> 16, n3);
        AnimationManager.setColor(graphics, 0);
        graphics.drawRect(n10 - 1, n2 - 1, n4 + 1, n3 + 1);
        AnimationManager.setColor(graphics, 112);
        graphics.fillRect(n10 - 1, n2 - 2, n4 + 2, 1);
        graphics.fillRect(n10 - 2, n2 - 1, 1, n3 + 2);
        graphics.fillRect(n10 + n4 + 1, n2 - 1, 1, n3 + 2);
        graphics.fillRect(n10 - 1, n2 + n3 + 1, n4 + 2, 1);
    }

    private void renderCarSelect(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getWidth();
        if (this.m_state == 14) {
            this.renderPageTitle(graphics, true, false, false);
        } else {
            this.renderPageTitle(graphics, true, false, true);
        }
        if (appEngine.cornerBracketFinished() && this.m_statePhase == 1 || this.m_confirmStatePhase != -1) {
            int n2 = this.m_state == 17 ? 11 : 0;
            int n3 = AnimationManager.getAnimFrameWidth(97, 0);
            AnimationManager.setColor(graphics, 115);
            graphics.fillRect(m_marginLeft, m_marginChooseCarBoxTop, m_marginRight - m_marginLeft, m_marginChooseCarBoxBottom - m_marginChooseCarBoxTop);
            appEngine.renderStripedWindow(graphics, m_marginLeft, m_marginChooseCarTextTop, m_marginRight - m_marginLeft, 11, 4, 115, 117);
            AnimationManager.setColor(graphics, 114);
            graphics.fillRect(m_marginLeft, m_marginChooseCarBoxTop, m_marginRight - m_marginLeft, 1);
            graphics.fillRect(m_marginLeft, m_marginChooseCarBoxBottom - 1, m_marginRight - m_marginLeft, 1);
            if (AppEngine.menuGetLength(this.m_menuCarSelect) > AppEngine.menuGetHeight(this.m_menuCarSelect)) {
                int n4 = n - 8 - n3;
                AnimationManager.drawAnimFrame(graphics, 97, 0, n4, m_marginChooseCarTextTop + n2);
                AnimationManager.drawAnimFrame(graphics, 94, 0, n4, m_marginChooseCarTextBottom);
            }
            appEngine.renderMenuScrollCars(graphics, m_marginLeftInner, m_marginChooseCarTextTop + n2, m_marginChooseCarBoxBottom - m_marginChooseCarBoxTop - n2, this.m_menuCarSelect, n - m_marginLeftInner - 8 - n3);
            if (this.m_state == 17) {
                appEngine.drawString(graphics, this.m_stringBufferCarPrice, 1, m_marginRightInner, m_marginChooseCarTextTop, 24);
                AnimationManager.setColor(graphics, 114);
                graphics.fillRect(m_marginLeft, m_marginChooseCarBoxTop + n2, m_marginRight - m_marginLeft, 1);
            }
        }
        if (!this.isCarUnlocked(this.m_menuCarSelect) && this.m_state != 14) {
            AnimationManager.drawAnimFrame(graphics, 17, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight());
        }
    }

    private void initNextEventChoice() {
        AppEngine appEngine = this.m_engine;
        byte by = appEngine.getNumSectorsInCareer();
        int[] nArray = s_tempInt2;
        AnimationManager.getAnimFrameFirePoint(nArray, 88, m_currentSector, m_currentEvent);
        int n = nArray[0];
        int n2 = nArray[1];
        m_nextNorthSector = m_currentSector;
        m_nextEastSector = m_currentSector;
        m_nextSouthSector = m_currentSector;
        m_nextWestSector = m_currentSector;
        m_nextNorthEvent = m_currentEvent;
        m_nextEastEvent = m_currentEvent;
        m_nextSouthEvent = m_currentEvent;
        m_nextWestEvent = m_currentEvent;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byte by3 = appEngine.getEventCount(by2);
            for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                AnimationManager.getAnimFrameFirePoint(nArray, 88, by2, by4);
                int n7 = nArray[0] - n;
                int n8 = nArray[1] - n2;
                int n9 = n7 * n7 + n8 * n8;
                int n10 = n7 * 1 + n8 * 1;
                int n11 = n7 * -1 + n8 * 1;
                int n12 = n7 * 1 + n8 * -1;
                int n13 = n7 * 1 + n8 * 1;
                int n14 = n7 * -1 + n8 * -1;
                int n15 = n7 * -1 + n8 * 1;
                int n16 = n7 * 1 + n8 * -1;
                int n17 = n7 * -1 + n8 * -1;
                if (n10 > 0 && n11 > 0 && n9 < n3 && n9 > 0) {
                    n3 = n9;
                    m_nextSouthSector = by2;
                    m_nextSouthEvent = by4;
                }
                if (n12 > 0 && n13 > 0 && n9 < n4 && n9 > 0) {
                    n4 = n9;
                    m_nextEastSector = by2;
                    m_nextEastEvent = by4;
                }
                if (n14 > 0 && n15 > 0 && n9 < n5 && n9 > 0) {
                    n5 = n9;
                    m_nextWestSector = by2;
                    m_nextWestEvent = by4;
                }
                if (n16 <= 0 || n17 <= 0 || n9 >= n6 || n9 <= 0) continue;
                n6 = n9;
                m_nextNorthSector = by2;
                m_nextNorthEvent = by4;
            }
        }
    }

    private boolean isSectorLocked(byte by) {
        AppEngine appEngine = this.m_engine;
        int n = by - 1;
        if (n < 0) {
            return false;
        }
        int n2 = appEngine.getEventCount((byte)n) - 1;
        return !appEngine.getEventClearedStatus((byte)n, (byte)n2);
    }

    private boolean isEventLocked(byte by, byte by2) {
        AppEngine appEngine = this.m_engine;
        boolean bl = false;
        if (this.m_state == 15) {
            bl = by == 0 && by2 == 0 ? false : !appEngine.getEventClearedStatus(by, by2);
        } else if (appEngine.isSectorLocked(by) || appEngine.getEventType(by, by2) == 7 && !appEngine.isNonBossEventsUnlocked(by)) {
            bl = true;
        }
        if (appEngine.cheatUsed(0)) {
            bl = false;
        }
        return bl;
    }

    private void renderChooseEvent(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        byte by = m_currentSector;
        byte by2 = m_currentEvent;
        int n = m_marginMapRight - m_marginMapLeft;
        this.renderPageTitle(graphics, false, false, this.m_state != 15);
        if (appEngine.cornerBracketFinished() && this.m_statePhase == 1) {
            int n2;
            int n3;
            int n4;
            int n5;
            AnimationManager.setColor(graphics, 115);
            graphics.fillRect(m_marginLeft, m_marginContentTop, m_marginRight - m_marginLeft, m_marginContentBottom - m_marginContentTop);
            AnimationManager.setColor(graphics, 114);
            graphics.fillRect(m_marginLeft, m_marginContentTop, m_marginRight - m_marginLeft, 1);
            graphics.fillRect(m_marginLeft, m_marginContentBottom - 1, m_marginRight - m_marginLeft, 1);
            graphics.setColor(-16312286);
            graphics.fillRect(m_marginMapLeft, m_marginMapTop, n, m_marginMapBottom - m_marginMapTop);
            int n6 = graphics.getClipX();
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipWidth();
            int n9 = graphics.getClipHeight();
            graphics.setClip(m_marginMapLeft, m_marginMapTop, n, m_marginMapBottom - m_marginMapTop);
            int[] nArray = s_tempInt2;
            int n10 = m_marginMapLeft - m_mapPosX + (n >> 1);
            int n11 = m_marginMapTop - m_mapPosY + (m_marginMapBottom - m_marginMapTop >> 1);
            for (n5 = 0; n5 < WORLD_MAP.length; ++n5) {
                for (n4 = 0; n4 < WORLD_MAP[0].length; ++n4) {
                    AnimationManager.drawAnimFrame(graphics, 91, WORLD_MAP[n5][n4], n10 + n4 * 16, n11 + n5 * 16);
                }
            }
            for (n4 = 0; n4 < appEngine.getNumSectorsInCareer(); n4 = (byte)(n4 + 1)) {
                if (!this.isSectorLocked((byte)n4) || n4 == m_currentSector) continue;
                AnimationManager.drawAnimFrame(graphics, 88, n4 + appEngine.getNumSectorsInCareer(), n10, n11);
            }
            for (n4 = 0; n4 < appEngine.getNumSectorsInCareer(); n4 = (byte)(n4 + 1)) {
                if (this.isSectorLocked((byte)n4) || n4 == m_currentSector) continue;
                AnimationManager.drawAnimFrame(graphics, 88, n4, n10, n11);
            }
            n5 = this.isSectorLocked(m_currentSector) ? appEngine.getNumSectorsInCareer() : (byte)0;
            AnimationManager.drawAnimFrame(graphics, 88, m_currentSector + n5, n10, n11);
            if (this.m_safeHouseState == -1 || this.m_stateTime % 400 > 200) {
                AnimationManager.drawAnimFrame(graphics, 88, m_currentSector + n5, n10 + 1, n11);
                AnimationManager.drawAnimFrame(graphics, 88, m_currentSector + n5, n10 - 1, n11);
                AnimationManager.drawAnimFrame(graphics, 88, m_currentSector + n5, n10, n11 + 1);
                AnimationManager.drawAnimFrame(graphics, 88, m_currentSector + n5, n10, n11 - 1);
            }
            for (n4 = 0; n4 < appEngine.getNumSectorsInCareer(); n4 = (int)((byte)(n4 + 1))) {
                for (n3 = 0; n3 < appEngine.getEventCount(n4); ++n3) {
                    n2 = 1;
                    AnimationManager.getAnimFrameFirePoint(nArray, 88, n4, n3);
                    if (n3 == appEngine.getEventCount(n4) - 1) {
                        n2 = 3;
                    }
                    if (appEngine.getEventClearedStatus(n4, (byte)n3)) {
                        ++n2;
                    }
                    if (this.isEventLocked((byte)n4, (byte)n3)) {
                        n2 = 0;
                    }
                    if (!(this.m_safeHouseState == -1 && !m_eventFlashBoss || n2 == 0 || n4 != m_currentSector || m_eventFlashBoss && n2 != 3 || m_eventFlashEvents && n2 != 1) && this.m_stateTime % 400 <= 200) continue;
                    AnimationManager.drawAnimFrame(graphics, 90, n2, n10 + nArray[0], n11 + nArray[1]);
                }
            }
            AnimationManager.getAnimFrameFirePoint(nArray, 88, by, by2);
            if (this.m_safeHouseState == -1) {
                this.m_mapIconHighlight.drawAnim(graphics, n10 + nArray[0], n11 + nArray[1]);
            }
            graphics.setClip(n6, n7, n8, n9);
            AnimationManager.setColor(graphics, 112);
            graphics.fillRect(m_marginMapLeft, m_marginMapTop - 1, n, 1);
            graphics.fillRect(m_marginMapLeft, m_marginMapTop + m_marginMapBottom - m_marginMapTop, n, 1);
            graphics.fillRect(m_marginMapLeft - 1, m_marginMapTop, 1, m_marginMapBottom - m_marginMapTop);
            graphics.fillRect(m_marginMapLeft + n, m_marginMapTop, 1, m_marginMapBottom - m_marginMapTop);
            n4 = m_marginChooseEventTextTop + 2;
            AnimationManager.setColor(graphics, 114);
            graphics.fillRect(m_marginLeft, m_marginChooseEventBoxTop, m_marginRight - m_marginLeft, 1);
            appEngine.renderStripedWindow(graphics, m_marginLeft, m_marginChooseEventTextTop, m_marginRight - m_marginLeft, 11, 3, 117, 115);
            n3 = appEngine.getEventType(by, by2);
            n2 = appEngine.getEventName(n3);
            int n12 = m_marginLeftInner;
            int n13 = m_marginRightInner;
            int n14 = appEngine.getStringWidth(18, 1);
            int n15 = n12;
            int n16 = AnimationManager.getAnimFrameWidth(85, 1);
            AnimationManager.drawAnimFrame(graphics, 85, 1, n15, m_marginChooseEventIconTop);
            AnimationManager.drawAnimFrame(graphics, 85, 2 + n3, n15, m_marginChooseEventIconTop);
            appEngine.drawString(graphics, appEngine.getSectorName(by), 3, n15 + n16 + 2, m_marginChooseEventIconTop, 20);
            appEngine.drawString(graphics, n2, 1, n15 + n16 + 2, m_marginChooseEventIconTop + appEngine.getLineHeight(3), 20);
            if (this.isEventLocked(m_currentSector, m_currentEvent)) {
                AnimationManager.drawAnimFrame(graphics, 92, 0, n13 - AnimationManager.getAnimFrameWidth(92, 0), m_marginChooseEventIconTop + 11);
            }
            switch (n3) {
                default: 
            }
            if (n3 == 0 || n3 == 2 || n3 == 1 || n3 == 7) {
                appEngine.drawString(graphics, 17, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferLength, 1, n13 - n14, n4, 24);
                appEngine.drawString(graphics, 18, 1, n13, n4, 24);
                n4 += 11;
            }
            if (n3 == 4) {
                appEngine.drawString(graphics, 261, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferLaps, 1, n13, n4, 24);
                n4 += 11;
            }
            if (n3 == 5) {
                appEngine.drawString(graphics, 262, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferLaps, 1, n13, n4, 24);
                n4 += 11;
            }
            if (n3 == 3) {
                appEngine.drawString(graphics, 263, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferLaps, 1, n13, n4, 24);
                n4 += 11;
            }
            if (n3 == 0 || n3 == 2) {
                appEngine.drawString(graphics, 53, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferLaps, 1, n13, n4, 24);
                n4 += 11;
            }
            if (n3 == 5) {
                appEngine.drawString(graphics, 95, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferBestTime, 1, n13, n4, 24);
                n4 += 11;
            } else if (n3 == 4) {
                appEngine.drawString(graphics, 96, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferBestTime, 1, n13, n4, 24);
                n4 += 11;
            } else {
                appEngine.drawString(graphics, 97, 1, n12, n4, 20);
                appEngine.drawString(graphics, this.m_stringBufferBestTime, 1, n13, n4, 24);
                n4 += 11;
            }
            appEngine.drawString(graphics, this.m_stringBufferReward, 1, n13, m_marginChooseEventIconTop, 24);
        }
        this.renderNarrator(graphics);
    }

    private void cheats() {
        AppEngine appEngine = this.m_engine;
        if (appEngine.cheatUsed(1)) {
            appEngine.awardCareerPrizeMoney(1000000);
            this.setPlayerCashString();
            if (this.m_state == 17 && this.canPurchaseSelectedCar(this.m_menuCarSelect)) {
                byte by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(this.m_menuCarSelect));
                this.setCarSelectionScreen(by);
            }
            appEngine.cheatUnset(1);
        }
        this.setupSoftkeys();
    }

    public void setPlayerCashString() {
        AppEngine appEngine = this.m_engine;
        appEngine.moneyToSDKString(appEngine.rmsGetCareerMoney(), this.m_stringBufferCash);
    }

    private void renderPageTitle(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        this.renderPageTitle(graphics, bl, bl2, bl3, this.m_statePhase);
    }

    public void renderPageTitle(Graphics graphics, boolean bl, boolean bl2, boolean bl3, byte by) {
        int n;
        AppEngine appEngine = this.m_engine;
        int n2 = appEngine.getWidth();
        int n3 = m_marginTitleBottom - m_marginTitleTop;
        int n4 = m_marginTitleTop + (n3 >> 1);
        int n5 = 65536;
        int n6 = n3;
        int n7 = m_marginCenterLeft;
        int n8 = m_marginRight;
        int n9 = m_marginRight;
        if (by == 0) {
            n5 = MathExt.smoothstepF(400, 800, this.m_stateTime);
        } else if (by == 2) {
            n5 = 65536 - MathExt.smoothstepF(0, 400, this.m_stateTime);
        }
        if (this.m_nextState == 6 && by == 2 || by == 0 && this.m_prevState == 6) {
            n6 = MathExt.Fmul(n3, n5);
            n7 = MathExt.Fmul(m_marginCenterLeft, n5);
            n8 = m_marginRight + (m_marginCenterRight - MathExt.Fmul(m_marginCenterRight, n5));
        }
        n9 = m_marginRight + (m_marginCenterRight - MathExt.Fmul(m_marginCenterRight, n5));
        int n10 = -m_marginCenterLeft + MathExt.Fmul(m_marginLeft + m_marginCenterLeft, n5);
        if (n6 > 0) {
            n = n6 >> 1;
            AnimationManager.setColor(graphics, 110);
            graphics.fillRect(0, n4 - n, n2, n6);
            AnimationManager.setColor(graphics, 100);
            graphics.fillRect(n7, n4 - n, 2, n6);
            AnimationManager.setColor(graphics, 112);
            graphics.fillRect(0, n4 - n, n2, 1);
            graphics.fillRect(0, n4 + n, n2, 1);
        }
        appEngine.drawWrappedStringChunk(0, graphics, 3, n10, m_marginTitleTop + 2, 20);
        if (bl3) {
            SDKString sDKString = AppEngine.getStringBuffer();
            appEngine.appendString(sDKString, 113);
            appEngine.appendString(sDKString, 100);
            appEngine.appendString(sDKString, " ");
            appEngine.appendString(sDKString, this.m_stringBufferCash);
            appEngine.drawString(graphics, sDKString, 1, n8, m_marginTitleTop + 2 + 1, 24);
            AppEngine.releaseStringBuffer(sDKString);
        }
        if (bl) {
            this.renderStatBarsHorizontal(graphics, n9 - 60, m_marginContentTop);
        }
        if (bl2) {
            n = appEngine.getCarMakeStringID(appEngine.rmsGetCareerActiveCarIndex());
            short s = appEngine.getCarDescriptionStringID(appEngine.rmsGetCareerActiveCarIndex());
            appEngine.drawString(graphics, n, 1, n10, m_marginContentTop, 20);
            appEngine.drawString(graphics, s, 1, n10, m_marginContentTop + appEngine.getLineHeight(1), 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderCarWindow(Graphics graphics) {
        int n = CARSELECT_LEFT;
        int n2 = CARSELECT_TOP;
        int n3 = CARSELECT_WIDTH;
        int n4 = CARSELECT_HEIGHT;
        AppEngine appEngine = this.m_engine;
        Graphics3D graphics3D = appEngine.getGraphics3D();
        try {
            graphics3D.bindTarget((Object)graphics);
            graphics3D.setViewport(n, n2, n3, n4);
            AppEngine.setPerspectivex(this.m_carCamera, 0x320000, ASPECT_RATIO, 6553, 0x4B0000);
            graphics3D.setCamera(this.m_carCamera, this.m_carCameraTransform);
            this.m_carBackground.setColorClearEnable(true);
            this.m_carBackground.setDepthClearEnable(true);
            graphics3D.clear(this.m_carBackground);
            graphics3D.render(this.m_carNodes[0], null);
        }
        finally {
            graphics3D.releaseTarget();
        }
    }

    private boolean inSafeHousePopup() {
        return this.m_safeHouseState != -1 && this.m_state == 7 || this.m_safeHouseState != -1 && this.m_state == 21;
    }

    private void processKeysSafeHouse(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 8)) {
            ++this.m_safeHouseCurPage;
            if (this.m_safeHouseCurPage >= this.m_safeHouseMaxPages && this.m_safeHouseState != 4) {
                this.m_safeHouseCurPage = this.m_safeHouseMaxPages - 1;
                this.m_animSafeHouse.startAnim(53, true, false);
                this.m_safeHouseState = (byte)4;
            }
        }
    }

    private void renderCareerTunerShop(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
        int n2 = AnimationManager.getAnimFrameWidth(41, 0);
        int n3 = AnimationManager.getAnimFrameHeight(41, 0);
        int n4 = 6;
        if (!SceneMTX.isUnlocked()) {
            --n4;
        }
        byte by = appEngine.rmsGetCareerActiveCarIndex();
        this.renderPageTitle(graphics, true, false, true);
        if (appEngine.cornerBracketFinished() && this.m_statePhase == 1 || this.m_confirmStatePhase != -1) {
            int n5;
            int n6;
            int n7;
            AnimationManager.setColor(graphics, 115);
            graphics.fillRect(m_marginLeft, m_marginTunerMenuTitleTop, m_marginRight - m_marginLeft, m_marginTunerMenuIconTop - m_marginTunerMenuTitleTop);
            graphics.fillRect(m_marginLeft, m_marginSafeHouseTextBottom, m_marginRight - m_marginLeft, m_marginContentBottom - m_marginSafeHouseTextBottom);
            AnimationManager.setColor(graphics, 114);
            graphics.fillRect(m_marginLeft, m_marginTunerMenuTitleTop, m_marginRight - m_marginLeft, 1);
            graphics.fillRect(m_marginLeft, m_marginContentBottom - 1, m_marginRight - m_marginLeft, 1);
            AnimationManager.setColor(graphics, 110);
            graphics.fillRect(m_marginLeft, m_marginTunerMenuIconTop, m_marginRight - m_marginLeft, m_marginTunerMenuUpgradeTop - m_marginTunerMenuIconTop);
            appEngine.renderStripedWindow(graphics, m_marginLeft, m_marginTunerMenuUpgradeTop, m_marginRight - m_marginLeft, 11, 2, 117, 115);
            appEngine.drawString(graphics, AppEngine.menuGetSelectedItem(this.m_menuSelectUpgrade), 3, m_marginLeftInner, m_marginTunerMenuTitleTop + 2, 20);
            AnimationManager.drawAnimFrame(graphics, 95, 0, m_marginLeft, m_marginTunerMenuIconTop + (n3 >> 1));
            AnimationManager.drawAnimFrame(graphics, 96, 0, m_marginLeftInner + 1 + (n2 + 1) * n4, m_marginTunerMenuIconTop + (n3 >> 1));
            for (n7 = 0; n7 < n4; ++n7) {
                int n8;
                int n9;
                Object object;
                int n10 = m_marginLeftInner + n7 * (n2 + 1);
                AnimationManager.drawAnimFrame(graphics, 41, n7 == n ? 1 : 0, n10, m_marginTunerMenuIconTop + 2);
                if (SceneMTX.isUnlocked()) {
                    if (n7 != n4 - 1) {
                        AnimationManager.drawAnimFrame(graphics, 41, n7 + 2, n10, m_marginTunerMenuIconTop + 2);
                    } else {
                        Image image = null;
                        for (n6 = 0; n6 < 28; ++n6) {
                            if (AnimConstants.IMAGE_RES_IDS[n6] != 7) continue;
                            image = AnimationManager.getImage(n6);
                            break;
                        }
                        graphics.drawImage(image, n10 + 1, m_marginTunerMenuIconTop + 2 + 1, 0);
                    }
                } else {
                    AnimationManager.drawAnimFrame(graphics, 41, n7 + 2, n10, m_marginTunerMenuIconTop + 2);
                    if (n7 == 0 || n7 == 1) {
                        Image image = null;
                        if (n7 == 0) {
                            for (n6 = 0; n6 < 28; ++n6) {
                                if (AnimConstants.IMAGE_RES_IDS[n6] != 2) continue;
                                image = AnimationManager.getImage(n6);
                                break;
                            }
                        }
                        if (n7 == 1) {
                            while (n6 < 28) {
                                if (AnimConstants.IMAGE_RES_IDS[n6] == 3) {
                                    image = AnimationManager.getImage(n6);
                                    break;
                                }
                                ++n6;
                            }
                        }
                        graphics.drawImage(image, n10 + 1, m_marginTunerMenuIconTop + 2 + 1, 0);
                        object = null;
                        for (n6 = 0; n6 < 28; ++n6) {
                            if (AnimConstants.IMAGE_RES_IDS[n6] != 28) continue;
                            object = AnimationManager.getImage(n6);
                            break;
                        }
                        n9 = AnimationManager.getAnimFrameWidth(41, n7 + 2);
                        n8 = AnimationManager.getAnimFrameHeight(41, n7 + 2);
                        int n11 = object.getWidth() - 1;
                        int n12 = object.getHeight() - 1;
                        int n13 = n10 + (n9 - n11 >> 1);
                        int n14 = m_marginTunerMenuIconTop + 2 + (n8 - n12 >> 1);
                        graphics.drawImage((Image)object, n13, n14, 0);
                    }
                }
                n6 = appEngine.getCareerTunerSubMenuStringIDs()[n7].length;
                n5 = appEngine.getCarAccessoryLevel(appEngine.rmsGetCareerActiveCarIndex(), n7);
                object = new int[]{n6 + 1, n6 + 1, n6 + 1};
                if (SceneMTX.isUnlocked() && n7 == n4 - 1) {
                    block5: for (n9 = 0; n9 < n6; ++n9) {
                        if (!SceneMTX.haveBoost[n9]) continue;
                        for (n8 = 0; n8 < ((int[])object).length; ++n8) {
                            if (object[n8] <= n6) continue;
                            object[n8] = n9;
                            continue block5;
                        }
                    }
                }
                for (n9 = 0; n9 < n6; ++n9) {
                    if (SceneMTX.isUnlocked()) {
                        if (n7 != n4 - 1) {
                            if (n9 <= n5 - 1) {
                                AnimationManager.setColor(graphics, 100);
                            } else {
                                AnimationManager.setColor(graphics, 112);
                            }
                        } else if (object[n9] < n6) {
                            AnimationManager.setColor(graphics, 100);
                        } else {
                            AnimationManager.setColor(graphics, 112);
                        }
                    } else if (n9 <= n5 - 1) {
                        AnimationManager.setColor(graphics, 100);
                    } else {
                        AnimationManager.setColor(graphics, 112);
                    }
                    graphics.fillRect(2 + n10 + n9 * 5, m_marginTunerMenuIconTop + 2 + n3 + 1, 3, 3);
                }
            }
            if (this.getNumSelectedUpgradesLeft() > 0) {
                n7 = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
                if (SceneMTX.isUnlocked() && n7 == 5) {
                    appEngine.drawString(graphics, 272, 1, m_marginLeftInner, m_marginTunerMenuUpgradeTop + 1, 20);
                } else {
                    int[][] nArray = appEngine.getCareerTunerAccessoryPrices();
                    n6 = appEngine.getCarAccessoryLevel(by, n);
                    n5 = appEngine.getCarUpgradeScale(by);
                    int n15 = MathExt.Fmul(nArray[n][n6], n5);
                    appEngine.drawString(graphics, 264, 1, m_marginLeftInner, m_marginTunerMenuUpgradeTop + 1, 20);
                    appEngine.drawString(graphics, appEngine.getCareerTunerSubMenuStringIDs()[n][n6], 1, m_marginLeftInner, m_marginTunerMenuUpgradeTop + 11 + 1, 20);
                    SDKString sDKString = AppEngine.getStringBuffer();
                    appEngine.moneyToSDKString(n15, sDKString);
                    appEngine.drawString(graphics, sDKString, 1, m_marginRightInner, m_marginTunerMenuUpgradeTop + 11 + 1, 12);
                    AppEngine.releaseStringBuffer(sDKString);
                }
            } else {
                appEngine.drawString(graphics, 265, 1, m_marginLeftInner, m_marginTunerMenuUpgradeTop + 1, 20);
            }
        }
    }

    private void renderConfirm(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getWidth();
        int n2 = appEngine.getFontLeading(0);
        int n3 = appEngine.getLineHeight(0);
        int n4 = appEngine.getNumWrappedLinesChunk(1) * n3 - n2 + 12;
        int n5 = appEngine.getHeight() - n4 >> 1;
        appEngine.renderBackgroundDim(graphics, true);
        int n6 = appEngine.getCornerBracketX() + 1;
        int n7 = appEngine.getCornerBracketY() + 1;
        int n8 = appEngine.getCornerBracketWidth() - 2;
        int n9 = appEngine.getCornerBracketHeight() - 2;
        AnimationManager.setColor(graphics, 112);
        graphics.fillRect(n6, n7, n8, n9);
        AnimationManager.setColor(graphics, 110);
        graphics.fillRect(n6 + 1, n7 + 1, n8 - 2, n9 - 2);
        if (this.m_confirmStatePhase == 1) {
            appEngine.drawWrappedStringChunk(1, graphics, 0, n >> 1, n5 + 6, 17);
        }
    }

    public void processKeys(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        if (this.waitingForConfirm()) {
            this.processKeysConfirm(n, n2);
            return;
        }
        if (this.inStateTransition()) {
            return;
        }
        if (this.inSafeHousePopup()) {
            this.processKeysSafeHouse(n, n2);
            return;
        }
        switch (this.m_state) {
            case 6: 
            case 7: 
            case 8: {
                short[] sArray = this.m_menuMain;
                if (this.m_state == 6) {
                    sArray = this.m_menuMain;
                } else if (this.m_state == 7) {
                    sArray = this.m_menuSafeHouse;
                } else if (this.m_state == 8) {
                    sArray = this.m_menuOptions;
                }
                if (this.checkKeys(n, n2, 8196, 0)) {
                    AppEngine.menuSelectPrev(sArray);
                    if (this.m_state == 8) break;
                    this.cornerHighlightMenuSelection(sArray);
                    break;
                }
                if (this.checkKeys(n, n2, 16640, 0)) {
                    AppEngine.menuSelectNext(sArray);
                    if (this.m_state == 8) break;
                    this.cornerHighlightMenuSelection(sArray);
                    break;
                }
                if (this.checkKeys(n, n2, 4128, 16)) {
                    this.processMenuSelect();
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 68)) break;
                this.processMenuBack();
                if (this.m_state != 7) break;
                this.cornerCenterMenuSelection(sArray, m_marginLeft, m_marginSafeHouseMenuTop);
                break;
            }
            case 20: {
                this.processKeysTunerShop(n, n2);
                break;
            }
            case 15: 
            case 21: {
                this.processKeysChooseEvent(n, n2);
                break;
            }
            case 17: {
                this.processKeysCareerBuyCar(n, n2);
                break;
            }
            case 14: 
            case 19: {
                this.processKeysCarSelect(n, n2);
                break;
            }
            case 10: 
            case 11: {
                appEngine.processKeysWindow(n, n2);
                if (!this.checkKeys(n, n2, 0, 4)) break;
                this.stateTransitionOut((byte)6);
            }
        }
    }

    private final void keyPressSoundFwd() {
    }

    private final void keyPressSoundBkwd() {
        this.m_engine.getSoundManager().playSound(7);
    }

    private void processMenuSelect() {
        AppEngine appEngine = this.m_engine;
        this.keyPressSoundFwd();
        switch (this.m_state) {
            case 6: {
                short s = AppEngine.menuGetSelectedItem(this.m_menuMain);
                switch (s) {
                    case 19: {
                        this.resetCarCameraAnim();
                        appEngine.centerCornerBracket(200);
                        appEngine.startFadeOut();
                        this.stateTransitionOut((byte)14);
                        break;
                    }
                    case 20: {
                        this.resetCarCameraAnim();
                        appEngine.centerCornerBracket(200);
                        appEngine.startFadeOut();
                        appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCarIndex());
                        this.stateTransitionOut((byte)7);
                        break;
                    }
                    case 21: {
                        this.resetCarCameraAnim();
                        if (appEngine.rmsGameExists()) {
                            this.confirm((byte)1);
                            break;
                        }
                        this.startNewCareer();
                        break;
                    }
                    case 22: {
                        this.stateTransitionOut((byte)8);
                        break;
                    }
                    case 25: {
                        this.stateTransitionOut((byte)10);
                        break;
                    }
                    case 24: {
                        this.stateTransitionOut((byte)11);
                        break;
                    }
                    case 26: {
                        System.out.println("11111111111");
                        this.stateTransitionOut((byte)12);
                        break;
                    }
                    case 14: {
                        this.confirm((byte)8);
                        break;
                    }
                    case 272: {
                        appEngine.centerCornerBracket(200);
                        this.stateTransitionOut((byte)27);
                    }
                }
                break;
            }
            case 7: {
                short s = AppEngine.menuGetSelectedItem(this.m_menuSafeHouse);
                switch (s) {
                    case 48: {
                        this.stateTransitionOut((byte)20);
                        break;
                    }
                    case 47: {
                        this.stateTransitionOut((byte)19);
                        break;
                    }
                    case 121: {
                        this.stateTransitionOut((byte)17);
                        break;
                    }
                    case 49: {
                        this.stateTransitionOut((byte)21);
                    }
                }
                this.initMenuAnim(m_marginLeftInner - appEngine.getWidth(), m_marginSafeHouseMenuTop, 400);
                this.cornerCenterMenuSelection(this.m_menuSafeHouse, m_marginLeftInner, m_marginSafeHouseMenuTop);
                break;
            }
            case 8: {
                short s = AppEngine.menuGetSelectedItem(this.m_menuOptions);
                short s2 = AppEngine.menuGetSelection(this.m_menuOptions);
                switch (s) {
                    case 80: {
                        SoundManager soundManager = appEngine.getSoundManager();
                        soundManager.setEnabled(!AppEngine.menuItemIsToggled(this.m_menuOptions, s2));
                        AppEngine.menuSetItemToggled(this.m_menuOptions, s2, soundManager.getEnabled());
                        if (soundManager.getEnabled()) {
                            this.keyPressSoundFwd();
                        }
                        appEngine.saveRMSAppSettings();
                        break;
                    }
                    case 81: {
                        appEngine.setVibrationEnabled(!AppEngine.menuItemIsToggled(this.m_menuOptions, s2));
                        appEngine.vibrate(400);
                        AppEngine.menuSetItemToggled(this.m_menuOptions, s2, appEngine.isVibrationEnabled());
                        appEngine.saveRMSAppSettings();
                        break;
                    }
                    case 82: {
                        appEngine.setCarMarkersEnabled(!AppEngine.menuItemIsToggled(this.m_menuOptions, s2));
                        AppEngine.menuSetItemToggled(this.m_menuOptions, s2, appEngine.areCarMarkersEnabled());
                        appEngine.saveRMSAppSettings();
                        break;
                    }
                    case 83: {
                        this.confirm((byte)5);
                        break;
                    }
                    case 163: {
                        this.confirm((byte)2);
                    }
                }
                break;
            }
            case 14: {
                if (!SceneMTX.isUnlocked()) {
                    SceneMTX.setQuickRaceResult(true);
                }
                short s = AppEngine.menuGetSelectedItem(this.m_menuCarSelect);
                appEngine.setPlayerCarIndex(appEngine.getCarFromDescriptionStringID(s));
                this.startRace(2, false);
                break;
            }
            case 15: {
                this.startRace(2, false);
                break;
            }
            case 17: {
                if (this.canPurchaseSelectedCar(this.m_menuCarSelect)) {
                    this.confirm((byte)9);
                    break;
                }
                if (SceneMTX.isUnlocked()) {
                    SceneMTX.setCall2ActionType((byte)2);
                    this.m_engine.initMTX(3);
                    break;
                }
                this.confirm((byte)7);
                break;
            }
            case 19: {
                short s = AppEngine.menuGetSelectedItem(this.m_menuCarSelect);
                byte by = appEngine.getCarFromDescriptionStringID(s);
                appEngine.setPlayerCarIndex(by);
                appEngine.rmsSetCareerActiveCarIndex(by);
                appEngine.saveRMSGameData();
                this.stateTransitionOut((byte)7);
                break;
            }
            case 20: {
                short s = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
                byte by = appEngine.rmsGetCareerActiveCarIndex();
                byte by2 = appEngine.getCarAccessoryLevel(by, s);
                int n = MathExt.Fmul(appEngine.getCareerTunerAccessoryPrices()[s][by2], appEngine.getCarUpgradeScale(by));
                if (appEngine.rmsGetCareerMoney() < n) {
                    if (SceneMTX.isUnlocked()) {
                        SceneMTX.setCall2ActionType((byte)1);
                        this.m_engine.initMTX(3);
                        break;
                    }
                    if (s == 0 || s == 1) {
                        SceneMTX.needInitTunerShop = true;
                        this.m_engine.initMTX(1);
                        break;
                    }
                    this.confirm((byte)7);
                    break;
                }
                if (SceneMTX.isUnlocked()) {
                    this.confirm((byte)4);
                    break;
                }
                if (s == 0 || s == 1) {
                    SceneMTX.needInitTunerShop = true;
                    this.m_engine.initMTX(1);
                    break;
                }
                this.confirm((byte)4);
                break;
            }
            case 21: {
                if (SceneMTX.isUnlocked()) {
                    this.startRace(3, false);
                    break;
                }
                if (SceneMTX.getCareerTims() < SceneMTX.getMaxCareerTimes()) {
                    SceneMTX.addCareerTimes();
                    SceneMTX.SetRaceOver(m_currentEvent);
                    this.m_engine.saveRMSAppSettings();
                    this.startRace(3, false);
                    break;
                }
                if (SceneMTX.isRaceAgain(m_currentEvent)) {
                    this.startRace(3, false);
                    break;
                }
                this.m_engine.initMTX(1);
                SceneMTX.setTnBFlowType(true);
            }
        }
    }

    private void processMenuBack() {
        AppEngine appEngine = this.m_engine;
        this.keyPressSoundBkwd();
        switch (this.m_state) {
            case 6: {
                this.confirm((byte)8);
                break;
            }
            case 8: {
                this.stateTransitionOut((byte)6);
                break;
            }
            case 7: 
            case 14: {
                appEngine.startFadeOut();
                this.initMenuAnim(m_marginLeftInner - appEngine.getWidth(), m_marginSafeHouseMenuTop, 400);
                this.stateTransitionOut((byte)6);
                break;
            }
            case 15: {
                this.stateTransitionOut((byte)14);
                break;
            }
            case 17: 
            case 19: {
                this.stateTransitionOut((byte)7);
                break;
            }
            case 20: {
                this.stateTransitionOut((byte)7);
                break;
            }
            case 21: {
                this.stateTransitionOut((byte)7);
            }
        }
    }

    private void processKeysConfirm(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_confirmStatePhase != 1) {
            return;
        }
        if (this.checkKeys(n, n2, 4128, 128)) {
            bl2 = true;
            bl = true;
        } else if (this.checkKeys(n, n2, 0, 260)) {
            bl2 = false;
            bl = true;
        }
        if (bl) {
            switch (this.m_confirmType) {
                case 0: {
                    appEngine.getSoundManager().setEnabled(bl2);
                    break;
                }
                case 1: {
                    if (!bl2) break;
                    this.startNewCareer();
                    AppEngine.s_rmsCareerMoney = 2000;
                    break;
                }
                case 2: {
                    if (bl2) {
                        appEngine.resetRMSGameData();
                        appEngine.resetData();
                        appEngine.loadRMSAppSettings();
                        appEngine.saveRMSGameData();
                    }
                    this.initStateOptions();
                    break;
                }
                case 3: {
                    if (bl2) {
                        if (appEngine.isCurrentRaceCareer()) {
                            this.startRace(3, true);
                            break;
                        }
                        this.startRace(2, true);
                        break;
                    }
                    if (appEngine.isCurrentRaceCareer()) {
                        this.stateTransitionOut((byte)7);
                        break;
                    }
                    this.stateTransitionOut((byte)6);
                    break;
                }
                case 4: {
                    if (bl2) {
                        byte by = appEngine.rmsGetCareerActiveCarIndex();
                        short s = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
                        byte by2 = (byte)(appEngine.getCarAccessoryLevel(by, s) + 1);
                        appEngine.purchaseCareerTunerAccessory(by, s, by2);
                        appEngine.saveRMSGameData();
                        this.setCarStatBar(appEngine.rmsGetCareerActiveCarIndex());
                        this.setPlayerCashString();
                    }
                    appEngine.initCornerBracket(m_marginLeft - 1, m_marginTunerMenuTitleTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 200);
                    break;
                }
                case 5: {
                    if (bl2) {
                        appEngine.setPostTutorialState((byte)6);
                        appEngine.initCornerBracket(-1, -1, appEngine.getWidth() + 1, appEngine.getHeight() + 1, 200);
                        this.startRace(0, false);
                        break;
                    }
                    this.initStateOptions();
                    break;
                }
                case 6: {
                    if (!bl2) break;
                    appEngine.initCornerBracket(-1, -1, appEngine.getWidth() + 1, appEngine.getHeight() + 1, 200);
                    appEngine.setPostTutorialState((byte)6);
                    this.startRace(0, false);
                    break;
                }
                case 7: {
                    switch (this.m_state) {
                        case 20: {
                            appEngine.initCornerBracket(m_marginLeft - 1, m_marginTunerMenuTitleTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 200);
                            break;
                        }
                        case 17: {
                            appEngine.initCornerBracket(m_marginLeft - 1, m_marginChooseCarBoxTop - 1, m_marginRight + 1, m_marginChooseCarBoxBottom + 1, 200);
                        }
                    }
                    break;
                }
                case 8: {
                    if (!bl2) break;
                    this.cornerHighlightMenuSelection(this.m_menuMain);
                    appEngine.startFadeOut();
                    this.stateTransitionOut((byte)13);
                    appEngine.initCornerBracket(0, 0, appEngine.getWidth(), appEngine.getHeight(), 200);
                    break;
                }
                case 9: {
                    if (bl2) {
                        byte by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(this.m_menuCarSelect));
                        appEngine.purchaseCareerCar(by);
                        appEngine.rmsSetCareerActiveCarIndex(by);
                        appEngine.setPlayerCarIndex(by);
                        appEngine.saveRMSGameData();
                        short s = AppEngine.menuGetSelection(this.m_menuCarSelect);
                        this.setPlayerCashString();
                        if (AppEngine.menuGetLength(this.m_menuCarSelect) - 1 >= s) {
                            AppEngine.menuSetSelection(this.m_menuCarSelect, s);
                        } else {
                            AppEngine.menuSetSelection(this.m_menuCarSelect, (short)(AppEngine.menuGetLength(this.m_menuCarSelect) - 1));
                        }
                        this.setCarSelectionMenuOffset(this.m_menuCarSelect);
                        byte by3 = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(this.m_menuCarSelect));
                        this.setCarSelectionScreen(by3);
                        this.initMenuCareerBuyCar();
                    }
                    if (appEngine.getCareerNumCarsOwned() >= appEngine.getNumCarsBuyable()) {
                        this.stateTransitionOut((byte)7);
                    } else {
                        appEngine.initCornerBracket(m_marginLeft - 1, m_marginTunerMenuTitleTop - 1, m_marginRight + 1, m_marginContentBottom + 1, 200);
                    }
                    appEngine.initCornerBracket(m_marginLeft - 1, m_marginChooseCarBoxTop - 1, m_marginRight + 1, m_marginChooseCarBoxBottom + 1, 200);
                }
            }
            this.m_confirmStatePhaseTime = 0;
            this.m_confirmStatePhase = (byte)2;
            if (!bl2 && this.m_confirmType != 2 && this.m_confirmType != 5 && this.m_confirmType != 4 && this.m_confirmType != 9) {
                this.cornerHighlightMenuSelection(this.m_menuMain);
            }
        }
    }

    private void processKeysChooseEvent(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        boolean bl = false;
        if (this.checkKeys(n, n2, 8196, 0)) {
            m_currentSector = m_nextNorthSector;
            m_currentEvent = m_nextNorthEvent;
            bl = true;
        } else if (this.checkKeys(n, n2, 16640, 0)) {
            m_currentSector = m_nextSouthSector;
            m_currentEvent = m_nextSouthEvent;
            bl = true;
        } else if (this.checkKeys(n, n2, 32784, 0)) {
            m_currentSector = m_nextWestSector;
            m_currentEvent = m_nextWestEvent;
            bl = true;
        } else if (this.checkKeys(n, n2, 65600, 0)) {
            m_currentSector = m_nextEastSector;
            m_currentEvent = m_nextEastEvent;
            bl = true;
        } else if (this.checkKeys(n, n2, 4128, 16) && this.m_fireKeyEnabled) {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginContentBottom + m_marginContentTop >> 1, appEngine.getHalfWidth(), m_marginContentBottom + m_marginContentTop >> 1, 200);
            this.processMenuSelect();
        } else if (this.checkKeys(n, n2, 0, 68)) {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginContentBottom + m_marginContentTop >> 1, appEngine.getHalfWidth(), m_marginContentBottom + m_marginContentTop >> 1, 200);
            this.processMenuBack();
        }
        if (bl) {
            this.setEventSelectWindowValues(m_currentSector, m_currentEvent);
            this.initNextEventChoice();
            this.initMapAnim();
            this.setupSoftkeys();
        }
    }

    public void setCarStatBar(int n) {
        int n2;
        boolean bl;
        AppEngine appEngine = this.m_engine;
        int[][] nArray = this.m_carSelectStats;
        int n3 = nArray.length;
        boolean bl2 = bl = this.m_state != 14;
        if (this.m_state == 27) {
            bl = false;
        }
        boolean bl3 = false;
        int n4 = 0;
        if (this.m_menuSelectUpgrade != null && (n4 = appEngine.getCarAccessoryLevel(n, n2 = AppEngine.menuGetSelection(this.m_menuSelectUpgrade))) > appEngine.getCareerTunerSubMenuStringIDs()[n2].length - 1) {
            n4 = appEngine.getCareerTunerSubMenuStringIDs()[n2].length - 1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = appEngine.getCareerAccessoryAdjustment(n2, n);
            int n10 = 0;
            if (this.m_state == 20 && AppEngine.menuGetSelection(this.m_menuSelectUpgrade) == n2) {
                n5 = n4 + 1;
                bl3 = true;
                n10 = appEngine.getCareerAccessoryAdjustment(n2, n, n5);
            }
            switch (n2) {
                case 0: {
                    n5 = (byte)(appEngine.getCarNumGears(n) - 1);
                    int n11 = appEngine.getCarGearMaxSpeed(n, (byte)n5);
                    n6 = MathExt.linearstepF(UPGRADE_MIN_VALUE_TOP_SPEED, UPGRADE_MAX_VALUE_TOP_SPEED, n11);
                    if (bl) {
                        n7 = MathExt.linearstepF(UPGRADE_MIN_VALUE_TOP_SPEED, UPGRADE_MAX_VALUE_TOP_SPEED, MathExt.Fmul(n11, n9));
                    }
                    if (!bl3) break;
                    int n12 = MathExt.Fmul(n11, n10);
                    n8 = MathExt.linearstepF(UPGRADE_MIN_VALUE_TOP_SPEED, UPGRADE_MAX_VALUE_TOP_SPEED, n12);
                    break;
                }
                case 1: {
                    int n11 = appEngine.getCarGearAccel(n, (byte)0);
                    n6 = MathExt.linearstepF(UPGRADE_MIN_VALUE_ACCELERATION, UPGRADE_MAX_VALUE_ACCELERATION, n11);
                    if (bl) {
                        n7 = MathExt.linearstepF(UPGRADE_MIN_VALUE_ACCELERATION, UPGRADE_MAX_VALUE_ACCELERATION, MathExt.Fmul(n11, n9));
                    }
                    if (!bl3) break;
                    int n12 = MathExt.Fmul(n11, n10);
                    n8 = MathExt.linearstepF(UPGRADE_MIN_VALUE_ACCELERATION, UPGRADE_MAX_VALUE_ACCELERATION, n12);
                    break;
                }
                case 2: {
                    n5 = appEngine.getCarParamTyres(n);
                    n6 = MathExt.linearstepF(UPGRADE_MIN_VALUE_HANDLING, UPGRADE_MAX_VALUE_HANDLING, n5);
                    if (bl) {
                        n7 = MathExt.linearstepF(UPGRADE_MIN_VALUE_HANDLING, UPGRADE_MAX_VALUE_HANDLING, MathExt.Fmul(n5, n9));
                    }
                    if (!bl3) break;
                    int n11 = MathExt.Fmul(n5, n10);
                    n8 = MathExt.linearstepF(UPGRADE_MIN_VALUE_HANDLING, UPGRADE_MAX_VALUE_HANDLING, n11);
                    break;
                }
                case 3: {
                    n6 = 0;
                    int n13 = n5 = this.m_state == 14 ? 65536 : appEngine.getCarAccessoryLevel(n, 3) << 16;
                    if (this.m_state == 27) {
                        n5 = 0;
                    }
                    n7 = MathExt.Fdiv(n5, UPGRADE_MAX_VALUE_NITRO);
                    if (!bl3) break;
                    int n11 = n4 + 1 << 16;
                    n8 = MathExt.Fdiv(n11, UPGRADE_MAX_VALUE_NITRO);
                    break;
                }
            }
            if (bl3) {
                bl3 = false;
            }
            nArray[n2][0] = n6;
            nArray[n2][1] = n7;
            nArray[n2][2] = n8;
        }
        this.m_carSelectStats = nArray;
    }

    private void processKeysCareerBuyCar(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        boolean bl = false;
        if (this.checkKeys(n, n2, 8196, 0)) {
            if (!this.m_noMoreCarsToPurchase) {
                AppEngine.menuSelectPrev(this.m_menuCarSelect);
                bl = true;
            }
        } else if (this.checkKeys(n, n2, 16640, 0)) {
            if (!this.m_noMoreCarsToPurchase) {
                AppEngine.menuSelectNext(this.m_menuCarSelect);
                bl = true;
            }
        } else if (this.checkKeys(n, n2, 4128, 16) && this.m_fireKeyEnabled) {
            this.processMenuSelect();
        } else if (this.checkKeys(n, n2, 0, 68)) {
            this.processMenuBack();
            appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, 200);
        }
        if (bl) {
            byte by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(this.m_menuCarSelect));
            this.setupSoftkeys();
            this.setCarPrice(by);
            this.setCarStatBar(by);
            this.setCarSelectionScreen(by);
        }
    }

    private void processKeysCarSelect(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        boolean bl = false;
        if (this.checkKeys(n, n2, 8196, 0)) {
            AppEngine.menuSelectPrev(this.m_menuCarSelect);
            bl = true;
        } else if (this.checkKeys(n, n2, 16640, 0)) {
            AppEngine.menuSelectNext(this.m_menuCarSelect);
            bl = true;
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            this.processMenuSelect();
            appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, 200);
        } else if (this.checkKeys(n, n2, 0, 68)) {
            this.processMenuBack();
            appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, appEngine.getHalfWidth(), m_marginChooseCarBoxBottom + m_marginChooseCarBoxTop >> 1, 200);
        }
        if (bl) {
            this.setupSoftkeys();
            byte by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(this.m_menuCarSelect));
            this.setCarStatBar(by);
            this.setCarSelectionScreen(by);
        }
    }

    private void setTunerShopSelectAnim() {
        short s = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
        AppEngine.ASSERT(true, "argh!");
        AppEngine.ASSERT(true, "argh!");
        AppEngine.ASSERT(true, "argh!");
        AppEngine.ASSERT(true, "argh!");
        AppEngine.ASSERT(true, "argh!");
        AppEngine.ASSERT(s <= 4, "argh!");
        this.setCarCameraAnim(s, false);
    }

    private void resetCarCameraAnim() {
        this.m_cameraInterping = false;
        System.arraycopy(CARCAMERA_ANIMS[5], 0, this.m_cameraCoords, 0, this.m_cameraCoords.length);
    }

    public void setCarCameraAnim(int n, boolean bl) {
        if (bl) {
            this.m_cameraInterping = false;
            System.arraycopy(CARCAMERA_ANIMS[n], 0, this.m_cameraCoords, 0, this.m_cameraCoords.length);
            this.m_cameraRotationRadF = 0;
        } else if (this.m_cameraAnimation != n) {
            this.m_cameraInterping = true;
            this.m_tunerShopFocusTime = 0;
            System.arraycopy(CARCAMERA_ANIMS[n], 0, this.m_cameraInterpToCoords, 0, this.m_cameraInterpToCoords.length);
            System.arraycopy(this.m_cameraCoords, 0, this.m_cameraInterpFromCoords, 0, this.m_cameraInterpFromCoords.length);
            this.m_cameraRotationRadF = 0;
        }
        this.m_cameraAnimation = n;
    }

    private void processKeysTunerShop(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        AppEngine appEngine = this.m_engine;
        if (this.checkKeys(n, n2, 32784, 0)) {
            if (!this.m_cameraInterping) {
                bl = true;
                bl2 = true;
                AppEngine.menuSelectPrev(this.m_menuSelectUpgrade);
            }
        } else if (this.checkKeys(n, n2, 65600, 0)) {
            if (!this.m_cameraInterping) {
                bl = true;
                bl2 = true;
                AppEngine.menuSelectNext(this.m_menuSelectUpgrade);
            }
        } else if (this.checkKeys(n, n2, 4128, 16) && this.m_fireKeyEnabled) {
            short s = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
            if (SceneMTX.isUnlocked() && s == 5) {
                SceneMTX.setCall2ActionType((byte)1);
                this.m_engine.initMTX(4);
            } else {
                this.processMenuSelect();
            }
        } else if (this.checkKeys(n, n2, 0, 68)) {
            if (SceneMTX.isUnlocked()) {
                this.processMenuBack();
                appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, 200);
            } else if (this.m_prevState != 7 && !SceneMTX.popTnB) {
                SceneMTX.popTnB = true;
                SceneMTX.needInitTunerShop = true;
                this.m_engine.saveRMSAppSettings();
                this.m_engine.initMTX(1);
            } else {
                this.processMenuBack();
                appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, 200);
            }
        }
        if (bl) {
            this.setCarStatBar(appEngine.rmsGetCareerActiveCarIndex());
            this.setupSoftkeys();
            if (bl2) {
                this.setTunerShopSelectAnim();
            }
        }
    }

    public void initMenuMain() {
        boolean bl;
        AppEngine appEngine = this.m_engine;
        int n = 7;
        ++n;
        short[] sArray = AppEngine.menuMake(++n);
        boolean bl2 = bl = appEngine.rmsGameExists() && appEngine.getCareerNumCarsOwned() > 0;
        if (bl) {
            AppEngine.menuAppendItem(sArray, 20);
        }
        if (SceneMTX.isUnlocked() || !bl) {
            AppEngine.menuAppendItem(sArray, 21);
        }
        AppEngine.menuAppendItem(sArray, 19);
        if (SceneMTX.isUnlocked()) {
            AppEngine.menuAppendItem(sArray, 272);
        }
        AppEngine.menuAppendItem(sArray, 22);
        AppEngine.menuAppendItem(sArray, 25);
        AppEngine.menuAppendItem(sArray, 24);
        MonkeyApp cfr_ignored_0 = this.m_engine.m_midlet;
        if (MonkeyApp.moreGames.isEnabled()) {
            AppEngine.menuAppendItem(sArray, 26);
        }
        AppEngine.menuAppendItem(sArray, 14);
        this.m_menuMain = sArray;
        this.setMenuSelectionIndex();
    }

    private void initMenuOptions() {
        AppEngine appEngine = this.m_engine;
        if (this.m_menuOptions == null) {
            int n = 5;
            short[] sArray = AppEngine.menuMake(n);
            AppEngine.menuAppendItem(sArray, 80, true, appEngine.getSoundManager().getEnabled());
            AppEngine.menuAppendItem(sArray, 81, true, appEngine.isVibrationEnabled());
            AppEngine.menuAppendItem(sArray, 82, true, appEngine.areCarMarkersEnabled());
            AppEngine.menuAppendItem(sArray, 83);
            AppEngine.menuAppendItem(sArray, 163);
            this.m_menuOptions = sArray;
        }
    }

    public void initSafeHouseTitle(int n) {
        AppEngine appEngine = this.m_engine;
        int n2 = appEngine.getStringWidth(n, 3);
        if (n2 > m_marginCenterLeft - m_marginLeft) {
            n2 = m_marginCenterLeft - m_marginLeft;
        }
        if (appEngine.stringHasSpaces(n)) {
            --n2;
        }
        appEngine.wrapStringChunk(0, n, 3, n2);
    }

    private void initMenuCarSelect() {
        byte by;
        short[] sArray;
        AppEngine appEngine = this.m_engine;
        short s = 0;
        byte by2 = appEngine.getCareerNumCarsOwned();
        if (by2 > 0) {
            sArray = AppEngine.menuMake(by2);
            for (by = 0; by != by2; by = (byte)(by + 1)) {
                byte by3 = appEngine.getNthOwnedCar(by);
                AppEngine.menuAppendItem(sArray, appEngine.getCarDescriptionStringID(by3));
                if (by3 != appEngine.getPlayerCarIndex()) continue;
                s = by;
            }
        } else {
            sArray = AppEngine.menuMake(1);
            AppEngine.menuAppendItem(sArray, appEngine.getCarDescriptionStringID(0));
        }
        AppEngine.menuSetSelection(sArray, s);
        this.setCarSelectionMenuOffset(sArray);
        by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(sArray));
        this.m_menuCarSelect = sArray;
        this.setCarStatBar(by);
        this.setCarSelectionScreen(by);
    }

    private void initMenuQuickRaceCarSelect() {
        byte by;
        AppEngine appEngine = this.m_engine;
        byte by2 = appEngine.getNumCarsBuyable();
        short[] sArray = AppEngine.menuMake(by2);
        if (!SceneMTX.isUnlocked()) {
            AppEngine.menuAppendItem(sArray, appEngine.getCarDescriptionStringID(0));
        } else {
            for (by = 0; by != by2; by = (byte)((byte)(by + 1))) {
                if (by == 7 ? !SceneMTX.isBuyCarAlready() : by > s_unlockCarLevels[appEngine.getBossLockedSector()]) continue;
                AppEngine.menuAppendItem(sArray, appEngine.getCarDescriptionStringID(by));
            }
        }
        this.m_menuCarSelect = sArray;
        this.setCarSelectionMenuOffset(this.m_menuCarSelect);
        by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(sArray));
        this.setCarPrice(by);
        this.setCarSelectionScreen(by);
        this.setCarStatBar(by);
    }

    public void cornerHighlightMenuSelection(short[] sArray) {
        AppEngine appEngine = this.m_engine;
        this.m_subStateTime = 0;
        if (sArray != null) {
            int n = AppEngine.menuGetWidth(3, sArray);
            int n2 = m_menuPosY + AppEngine.menuGetSelection(sArray) * 11;
            appEngine.initCornerBracket(m_menuPosX - 6 + 1, n2 - 2, m_menuPosX + n + 6, n2 + 10, 200);
        } else {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), appEngine.getHalfHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), 200);
        }
    }

    private void cornerCenterMenuSelection(short[] sArray, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        this.m_subStateTime = 0;
        if (sArray != null) {
            int n3 = AppEngine.menuGetWidth(3, sArray);
            int n4 = n2 + AppEngine.menuGetSelection(sArray) * 11;
            appEngine.initCornerBracket(n + (n3 >> 1), n4 + 5, n + (n3 >> 1), n4 + 5, 400);
        } else {
            appEngine.initCornerBracket(appEngine.getHalfWidth(), appEngine.getHalfHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), 400);
        }
    }

    public void initMapAnim(int n, int n2, int n3, int n4, int n5) {
        m_mapStartX = n;
        m_mapStartY = n2;
        m_mapDestX = n3;
        m_mapDestY = n4;
        m_mapDuration = n5;
        m_mapTime = 0;
    }

    public void initMapAnim() {
        int[] nArray = s_tempInt2;
        AnimationManager.getAnimFrameFirePoint(nArray, 88, m_currentSector, m_currentEvent);
        m_mapStartX = m_mapPosX;
        m_mapStartY = m_mapPosY;
        m_mapDestX = nArray[0];
        m_mapDestY = nArray[1];
        m_mapDuration = 400;
        m_mapTime = 0;
    }

    private void updateMapAnim(int n) {
        int n2 = MathExt.smoothstepF(0, m_mapDuration, m_mapTime += n);
        m_mapPosX = m_mapStartX + MathExt.Fmul(n2, m_mapDestX - m_mapStartX);
        m_mapPosY = m_mapStartY + MathExt.Fmul(n2, m_mapDestY - m_mapStartY);
        if (m_mapTime > m_mapDuration) {
            m_mapTime = m_mapDuration;
        }
    }

    public void initMenuAnim(int n, int n2, int n3, int n4, int n5) {
        m_menuStartX = n;
        m_menuStartY = n2;
        m_menuPosX = m_menuStartX;
        m_menuPosY = m_menuStartY;
        m_menuDestX = n3;
        m_menuDestY = n4;
        m_menuDuration = n5;
        m_menuTime = 0;
    }

    public void initMenuAnim(int n, int n2, int n3) {
        m_menuStartX = m_menuPosX;
        m_menuStartY = m_menuPosY;
        m_menuDestX = n;
        m_menuDestY = n2;
        m_menuDuration = n3;
        m_menuTime = 0;
    }

    private void updateMenuAnim() {
        int n = MathExt.smoothstepF(0, m_menuDuration, this.m_stateTime);
        m_menuPosX = m_menuStartX + MathExt.Fmul(n, m_menuDestX - m_menuStartX);
        m_menuPosY = m_menuStartY + MathExt.Fmul(n, m_menuDestY - m_menuStartY);
        m_menuTime = this.m_stateTime;
    }

    private boolean finishedMenuAnim() {
        return m_menuTime > m_menuDuration;
    }

    private void setMenuAnim(int n, int n2) {
        m_menuStartX = n;
        m_menuStartY = n2;
        m_menuDestX = n;
        m_menuDestY = n2;
        m_menuPosX = n;
        m_menuPosY = n2;
    }

    private void initMenuCareerBuyCar() {
        byte by;
        AppEngine appEngine = this.m_engine;
        byte by2 = appEngine.getNumCarsBuyable();
        short[] sArray = AppEngine.menuMake(by2);
        for (by = 0; by != by2; by = (byte)(by + 1)) {
            if (appEngine.careerCarOwned(by) || by == 7) continue;
            AppEngine.menuAppendItem(sArray, appEngine.getCarDescriptionStringID(by));
        }
        this.m_menuCarSelect = sArray;
        this.setCarSelectionMenuOffset(this.m_menuCarSelect);
        if (AppEngine.menuGetLength(sArray) == 0) {
            this.m_noMoreCarsToPurchase = true;
        } else {
            by = appEngine.getCarFromDescriptionStringID(AppEngine.menuGetSelectedItem(sArray));
            this.setCarPrice(by);
            this.setCarSelectionScreen(by);
            this.setCarStatBar(by);
        }
        this.setupSoftkeys();
    }

    private void setCarPrice(byte by) {
        SDKString sDKString = AppEngine.getStringBuffer();
        this.m_engine.moneyToSDKString(this.m_engine.getCarPrice(by), sDKString);
        this.m_stringBufferCarPrice.setLength(this.m_carPriceOffset);
        this.m_stringBufferCarPrice.append(sDKString);
        AppEngine.releaseStringBuffer(sDKString);
    }

    private void setEventSelectWindowValues(byte by, byte by2) {
        int n;
        AppEngine appEngine = this.m_engine;
        byte by3 = appEngine.getEventTrackID(by, by2);
        appEngine.moneyToSDKString(appEngine.getEventPurse(by, by2), this.m_stringBufferReward);
        byte by4 = appEngine.getEventType(by, by2);
        if (by4 == 0 || by4 == 2 || by4 == 1 || by4 == 7) {
            int n2 = appEngine.getTrackDistance(by3);
            n2 = MathExt.Fmul(n2, 296);
            byte by5 = appEngine.getEventLaps(by, by2);
            if (by5 > 0) {
                n2 *= by5;
            }
            appEngine.intToSDKString(n2 >> 16, false, this.m_stringBufferLength);
            appEngine.appendString(this.m_stringBufferLength, 101);
            appEngine.appendInt(this.m_stringBufferLength, (n2 & 0x10000) / 6554);
            appEngine.appendString(this.m_stringBufferLength, " ");
        }
        if (by4 == 4) {
            appEngine.moneyToSDKString(appEngine.getEventCostTarget(by, by2), this.m_stringBufferLaps);
        }
        if (by4 == 5) {
            appEngine.intToSDKString(appEngine.getEventCostTarget(by, by2), false, this.m_stringBufferLaps);
        }
        if (by4 == 3) {
            n = appEngine.getEventCostTarget(by, by2) * 1000;
            appEngine.timeToSDKString(n, 1, this.m_stringBufferLaps);
        }
        if (by4 == 0 || by4 == 2) {
            n = appEngine.getEventLaps(by, by2);
            if (n > 0) {
                appEngine.intToSDKString(n, false, this.m_stringBufferLaps);
            } else {
                this.m_stringBufferLaps.setLength(0);
                appEngine.appendString(this.m_stringBufferLaps, 98);
            }
        }
        if ((n = appEngine.rmsGetTrackBestRaceTime(by3)) <= 0) {
            appEngine.copyString(this.m_stringBufferBestTime, 98);
        } else if (by4 == 5) {
            appEngine.intToSDKString(n, false, this.m_stringBufferBestTime);
        } else if (by4 == 4) {
            appEngine.moneyToSDKString(appEngine.rmsGetTrackBestRaceTime(by3), this.m_stringBufferBestTime);
        } else {
            appEngine.timeToSDKString(n, 1, this.m_stringBufferBestTime);
        }
    }

    public void initCareerTunerShop() {
        int n;
        AppEngine appEngine = this.m_engine;
        if (this.m_menuSelectUpgrade != null) {
            for (n = 0; n < this.m_menuSelectUpgrade.length; ++n) {
                this.m_menuSelectUpgrade[n] = 0;
            }
        }
        this.m_menuSelectUpgrade = null;
        if (this.m_menuSelectUpgrade == null) {
            short[] sArray = appEngine.getCareerTunerMenuStringIDs();
            int n2 = sArray.length;
            if (!SceneMTX.isUnlocked()) {
                --n2;
            }
            short[] sArray2 = AppEngine.menuMake(n2);
            for (int i = 0; i != n2; ++i) {
                AppEngine.menuAppendItem(sArray2, sArray[i]);
            }
            this.m_menuSelectUpgrade = sArray2;
        }
        n = (byte)appEngine.getPlayerCarIndex();
        this.setCarStatBar(n);
        this.setupSoftkeys();
        this.setTunerShopSelectAnim();
        this.initSafeHouseTitle(114);
        appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, appEngine.getHalfWidth(), m_marginTunerMenuTitleTop + m_marginContentBottom >> 1, 200);
    }

    private void setCarSelectionMenuOffset(short[] sArray) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getLineHeight(1);
        int n2 = m_marginChooseCarTextBottom - m_marginChooseCarTextTop - (this.m_state == 17 ? 11 : 0);
        AppEngine.menuSetHeight(sArray, n2 / n);
        if (AppEngine.menuGetSelection(sArray) >= AppEngine.menuGetHeight(sArray)) {
            AppEngine.menuSetOffset(sArray, (short)(AppEngine.menuGetSelection(sArray) - (AppEngine.menuGetHeight(sArray) - 1)));
        }
    }

    private void setMenuSelectionIndex() {
        AppEngine appEngine = this.m_engine;
        short s = 0;
        if (this.m_state == 14 || this.m_state == 17 || this.m_state == 19 || this.m_state == 18) {
            return;
        }
        switch (this.m_prevState) {
            case 8: {
                s = 22;
                break;
            }
            case 10: {
                s = 25;
                break;
            }
            case 11: {
                s = 24;
                break;
            }
            case 12: {
                s = 26;
                break;
            }
            case 14: {
                s = 19;
                break;
            }
            case 17: {
                s = 121;
                break;
            }
            case 20: {
                s = 48;
                break;
            }
            case 19: {
                s = 47;
                break;
            }
            case 21: {
                s = 49;
                break;
            }
            case 7: {
                if (appEngine.getCareerNumCarsOwned() < 1) {
                    s = 19;
                    break;
                }
                if (appEngine.getCareerNumCarsOwned() <= 0) break;
                s = 20;
            }
        }
        if (this.m_nextState == 15 || this.m_nextState == 21) {
            s = appEngine.getSectorName(AppEngine.menuGetSelection(this.m_menuMain));
        }
        AppEngine.menuSelectFromString(this.m_menuMain, s);
    }

    private void initMenuSafeHouse() {
        short[] sArray;
        AppEngine appEngine = this.m_engine;
        if (this.m_menuSafeHouse == null) {
            sArray = AppEngine.menuMake(4);
        } else {
            sArray = this.m_menuSafeHouse;
            AppEngine.menuClear(sArray, -1);
        }
        AppEngine.menuAppendItem(sArray, 49);
        AppEngine.menuAppendItem(sArray, 47);
        if (appEngine.getCareerNumCarsOwned() != appEngine.getNumCarsBuyable()) {
            AppEngine.menuAppendItem(sArray, 121);
        }
        AppEngine.menuAppendItem(sArray, 48);
        this.m_menuSafeHouse = sArray;
    }

    private void stateTransitionFade(byte by) {
        AppEngine appEngine = this.m_engine;
        if (this.m_state == by) {
            return;
        }
        this.m_nextState = by;
        if (this.m_state != -1) {
            appEngine.startFadeOutDim();
            this.m_statePhase = (byte)2;
        } else {
            this.stateTransitionIn();
        }
    }

    public void stateTransitionOut(byte by) {
        if (this.m_state == by) {
            return;
        }
        this.m_stateTime = 0;
        this.m_nextState = by;
        if (this.m_state != -1 && this.m_state != 12) {
            this.m_statePhase = (byte)2;
        } else {
            this.stateTransitionIn();
        }
    }

    private boolean inStateTransition() {
        return this.m_statePhase == 0 || this.m_statePhase == 2;
    }

    private boolean inStateConfirmTransition() {
        return this.m_confirmStatePhase == 0 || this.m_confirmStatePhase == 2;
    }

    private void initStateConfirmSound() {
        AppEngine appEngine = this.m_engine;
        appEngine.initCornerBracket(0, 0, appEngine.getWidth(), appEngine.getHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), appEngine.getHalfWidth(), appEngine.getHalfHeight(), 400);
    }

    private void initStateEALogo() {
        AppEngine appEngine = this.m_engine;
        appEngine.startFadeIn();
        AnimationManager.loadImage(appEngine.getResourceManager(), 57);
        appEngine.initCornerBracket(0, 0, appEngine.getWidth(), appEngine.getHeight(), 400);
    }

    private void initStateLogo() {
        AnimationManager.loadImage(this.m_engine.getResourceManager(), 22);
        this.m_engine.startFadeIn();
    }

    private void initStateCallToAction() {
        this.m_engine.startFadeIn();
    }

    public void initStateMainMenu() {
        AppEngine appEngine = this.m_engine;
        int n = m_marginMainMenuLeft;
        int n2 = m_marginMainMenuTop;
        this.initMenuMain();
        if (this.m_prevState == 4 || this.m_prevState == 2 || this.m_prevState == 3 || this.m_prevState == 14 || this.m_prevState == 7) {
            appEngine.startFadeIn();
            this.initMenuAnim(n, appEngine.getHeight(), n, n2, 1000);
        } else {
            this.setMenuAnim(n, n2);
        }
        this.cornerCenterMenuSelection(this.m_menuMain, n, n2);
        AnimationManager.loadImage(appEngine.getResourceManager(), 31);
        if (!SceneMTX.isUnlocked() && SceneMTX.isQuickRaceOver()) {
            SceneMTX.setQuickRaceResult(false);
            this.m_engine.initMTX(1);
        }
    }

    private void initStateSafeHouse() {
        AppEngine appEngine = this.m_engine;
        appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCarIndex());
        this.initMenuSafeHouse();
        byte by = (byte)appEngine.getPlayerCarIndex();
        this.setPlayerCashString();
        this.setCarSelectionScreen(by);
        if (this.m_prevState == 20 || this.m_prevState == 21) {
            this.setCarCameraAnim(5, false);
        } else if (this.m_prevState == 6) {
            this.setCarCameraAnim(5, true);
        }
        this.m_animSafeHouse.startAnim(54, true, false);
        this.initMenuAnim(m_marginLeftInner - appEngine.getWidth(), m_marginSafeHouseMenuTop, m_marginLeftInner, m_marginSafeHouseMenuTop, 400);
        if (this.m_prevState == 6) {
            appEngine.startFadeIn();
        }
        this.cornerCenterMenuSelection(this.m_menuSafeHouse, m_marginLeftInner, m_marginSafeHouseMenuTop);
        this.initSafeHouseTitle(115);
        int n = m_marginRightInner - m_marginNarratorTextLeft;
        switch (this.m_safeHouseState) {
            case 0: {
                appEngine.wrapString(248, 1, n);
            }
        }
        this.m_safeHouseCurPage = 0;
        this.m_safeHouseLinesPerPage = (m_marginContentBottom - m_marginNarratorTop - 2) / appEngine.getLineHeight(1);
        this.m_safeHouseMaxPages = (appEngine.getNumWrappedLines() - 1) / this.m_safeHouseLinesPerPage + 1;
    }

    private void initStateOptions() {
        AppEngine appEngine = this.m_engine;
        this.initMenuOptions();
        int n = AppEngine.menuGetWidth(3, this.m_menuOptions) + 12;
        int n2 = AppEngine.menuGetLength(this.m_menuOptions) * appEngine.getLineHeight(3) + 12 + appEngine.getTitleHeight();
        int n3 = appEngine.getWidth() - n >> 1;
        int n4 = m_menuPosY - appEngine.getTitleHeight() - 6;
        int n5 = n;
        int n6 = n2;
        appEngine.initCornerBracket(n3 - 1, n4 - 1, n3 + n5 + 1, n4 + n6 + 1, 200);
    }

    private void initStateHelp() {
        AppEngine appEngine = this.m_engine;
        appEngine.initWindow(25, 51, 5, 5, appEngine.getWidth() - 10, appEngine.getHeight() - 14 - 10);
        appEngine.initCornerBracket(4, 4, appEngine.getWidth() - 5 + 1, appEngine.getHeight() - 14 - 5 + 1, 400);
    }

    private void initStateAbout() {
        AppEngine appEngine = this.m_engine;
        appEngine.initWindow(24, 50, 5, 5, appEngine.getWidth() - 10, appEngine.getHeight() - 14 - 10);
        appEngine.initCornerBracket(4, 4, appEngine.getWidth() - 5 + 1, appEngine.getHeight() - 14 - 5 + 1, 400);
    }

    private void initStateCarSelect() {
        AppEngine appEngine = this.m_engine;
        if (this.m_state == 14) {
            this.initMenuQuickRaceCarSelect();
        } else {
            this.initMenuCarSelect();
        }
        if (this.m_prevState == 6) {
            this.setCarCameraAnim(5, true);
            appEngine.startFadeIn();
        } else {
            this.setCarCameraAnim(5, false);
        }
        appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginChooseCarBoxTop + m_marginChooseCarBoxBottom >> 1, appEngine.getHalfWidth(), m_marginChooseCarBoxTop + m_marginChooseCarBoxBottom >> 1, 400);
        this.initSafeHouseTitle(118);
    }

    private void initStateChooseEvent() {
        int n;
        AppEngine appEngine = this.m_engine;
        this.setCarCameraAnim(6, this.m_prevState == -1);
        this.initMenuCarSelect();
        byte by = (byte)appEngine.getPlayerCarIndex();
        this.setCarStatBar(by);
        this.setPlayerCashString();
        this.setCarSelectionScreen(by);
        appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginContentTop + m_marginContentBottom >> 1, appEngine.getHalfWidth(), m_marginContentTop + m_marginContentBottom >> 1, 400);
        int n2 = appEngine.getNumSectorsInCareer();
        block5: for (n = 0; n < n2; n = (byte)(n + 1)) {
            byte by2 = appEngine.getEventCount(n);
            for (byte by3 = 0; by3 < by2; by3 = (byte)(by3 + 1)) {
                if (this.isEventLocked((byte)n, by3) || appEngine.getEventClearedStatus(n, by3)) continue;
                m_currentSector = n;
                m_currentEvent = by3;
                continue block5;
            }
        }
        if (this.m_state == 15) {
            m_currentSector = 0;
            m_currentEvent = 0;
        }
        this.setEventSelectWindowValues(m_currentSector, m_currentEvent);
        this.initNextEventChoice();
        this.initMapAnim();
        this.initSafeHouseTitle(116);
        this.m_mapIconHighlight.startAnim(89, true, true);
        m_eventFlashBoss = false;
        m_eventFlashEvents = false;
        if (this.m_state == 23) {
            this.m_state = (byte)21;
            m_eventFlashBoss = true;
        }
        if (this.m_state == 22) {
            m_eventFlashEvents = true;
            this.m_animSafeHouse.startAnim(54, true, false);
            this.m_state = (byte)21;
            n = m_marginRightInner - m_marginNarratorTextLeft;
            switch (m_currentSector) {
                case 1: {
                    this.m_safeHouseState = 1;
                    appEngine.wrapString(239, 1, n);
                    break;
                }
                case 2: {
                    this.m_safeHouseState = (byte)2;
                    appEngine.wrapString(240, 1, n);
                    break;
                }
                case 3: {
                    if (appEngine.eventsCompletedInSector(3)) {
                        this.m_safeHouseState = 1;
                        appEngine.wrapString(238, 1, n);
                        break;
                    }
                    this.m_safeHouseState = (byte)3;
                    appEngine.wrapString(241, 1, n);
                }
            }
            this.m_safeHouseCurPage = 0;
            this.m_safeHouseLinesPerPage = (m_marginContentBottom - m_marginNarratorTop - 2) / appEngine.getLineHeight(1);
            this.m_safeHouseMaxPages = appEngine.getNumWrappedLines() / this.m_safeHouseLinesPerPage + 1;
        }
    }

    private void initStateCareerBuyCar() {
        AppEngine appEngine = this.m_engine;
        this.initMenuCareerBuyCar();
        appEngine.initCornerBracket(appEngine.getHalfWidth(), m_marginChooseCarBoxTop + m_marginChooseCarBoxBottom >> 1, appEngine.getHalfWidth(), m_marginChooseCarBoxTop + m_marginChooseCarBoxBottom >> 1, 400);
        this.initSafeHouseTitle(120);
    }

    private void stateTransitionIn() {
        AppEngine appEngine = this.m_engine;
        this.m_prevState = this.m_state;
        this.m_state = this.m_nextState;
        this.m_statePhase = 0;
        this.m_stateTime = 0;
        this.m_subStateTime = 0;
        switch (this.m_state) {
            case 1: {
                this.initStateConfirmSound();
                break;
            }
            case 2: {
                this.initStateEALogo();
                break;
            }
            case 3: {
                this.initStateLogo();
                break;
            }
            case 4: {
                this.initStateCallToAction();
                break;
            }
            case 5: {
                appEngine.startFadeIn();
                break;
            }
            case 6: {
                this.initStateMainMenu();
                break;
            }
            case 7: {
                this.initStateSafeHouse();
                break;
            }
            case 8: {
                this.initStateOptions();
                break;
            }
            case 10: {
                this.initStateHelp();
                break;
            }
            case 11: {
                this.initStateAbout();
                break;
            }
            case 12: {
                moregames_resume = true;
                System.out.println("into more games");
                try {
                    MonkeyApp cfr_ignored_0 = this.m_engine.m_midlet;
                    MonkeyApp.moreGames.showMoreGames();
                    System.out.println("m_engine.getMoreGamesMode()" + this.m_engine.getMoreGamesMode());
                    if (this.m_engine.getMoreGamesMode() == 2) {
                        this.m_engine.wrapString(26, 1, 145);
                        break;
                    }
                    this.m_engine.wrapString(26, 1, 145);
                }
                catch (Exception exception) {}
                break;
            }
            case 14: 
            case 19: {
                this.initStateCarSelect();
                break;
            }
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                this.initStateChooseEvent();
                break;
            }
            case 17: {
                this.initStateCareerBuyCar();
                break;
            }
            case 20: {
                byte by = (byte)appEngine.getPlayerCarIndex();
                this.setCarSelectionScreen(by);
                this.m_loadCarNext = false;
                this.m_carLoaded = true;
                this.setPlayerCashString();
                this.initCareerTunerShop();
                break;
            }
        }
        this.setupSoftkeys();
    }

    private void stateActive() {
        this.m_statePhase = 1;
        this.m_stateTime = 0;
        this.m_subStateTime = 0;
    }

    private boolean waitingForConfirm() {
        return this.m_confirmStatePhase != -1;
    }

    public void confirm(byte by) {
        AppEngine appEngine = this.m_engine;
        int n = this.m_confirmWrapWidth;
        int n2 = 0;
        switch (by) {
            case 0: {
                n2 = 55;
                break;
            }
            case 1: {
                n2 = 57;
                break;
            }
            case 2: {
                n2 = 164;
                break;
            }
            case 3: {
                n2 = 105;
                break;
            }
            case 4: {
                n2 = 198;
                break;
            }
            case 5: {
                n2 = 84;
                break;
            }
            case 6: {
                n2 = 268;
                break;
            }
            case 7: {
                n2 = 269;
                break;
            }
            case 8: {
                n2 = 56;
                break;
            }
            case 9: {
                n2 = 198;
            }
        }
        appEngine.wrapStringChunk(1, n2, 0, n);
        this.m_confirmType = by;
        int n3 = appEngine.getWidth();
        int n4 = appEngine.getFontLeading(0);
        int n5 = appEngine.getLineHeight(0);
        this.m_confirmWidth = this.m_confirmWrapWidth + 12;
        this.m_confirmLeft = n3 - this.m_confirmWidth >> 1;
        this.m_confirmHeight = appEngine.getNumWrappedLinesChunk(1) * n5 - n4 + 12;
        this.m_confirmTop = appEngine.getHeight() - this.m_confirmHeight >> 1;
        appEngine.initCornerBracket(this.m_confirmLeft, this.m_confirmTop, this.m_confirmLeft + this.m_confirmWidth, this.m_confirmTop + this.m_confirmHeight, 200);
        this.m_confirmStatePhaseTime = 0;
        this.m_confirmStatePhase = 0;
        this.setupSoftkeys();
    }

    private void clearConfirm() {
        this.m_confirmStatePhase = (byte)-1;
        this.m_confirmType = (byte)-1;
        this.setupSoftkeys();
    }

    private void setupSoftkeys() {
        AppEngine appEngine = this.m_engine;
        int n = 0;
        int n2 = 0;
        this.m_fireKeyEnabled = false;
        if (this.waitingForConfirm()) {
            n = 128;
            n2 = 256;
            if (this.m_confirmType == 7) {
                n2 = 0;
            }
        } else if (this.inSafeHousePopup()) {
            n = 8;
        } else {
            switch (this.m_state) {
                case 6: {
                    n = 16;
                    n2 = 64;
                    break;
                }
                case 7: 
                case 8: 
                case 12: 
                case 14: 
                case 19: {
                    n = 16;
                    n2 = 4;
                    this.m_fireKeyEnabled = true;
                    break;
                }
                case 15: 
                case 21: {
                    n = 16;
                    n2 = 4;
                    this.m_fireKeyEnabled = true;
                    if (!this.isEventLocked(m_currentSector, m_currentEvent)) break;
                    n = 0;
                    this.m_fireKeyEnabled = false;
                    break;
                }
                case 17: {
                    n2 = 4;
                    if (!this.isCarUnlocked(this.m_menuCarSelect) || this.m_noMoreCarsToPurchase) break;
                    n = 16;
                    this.m_fireKeyEnabled = true;
                    break;
                }
                case 20: {
                    if (this.getNumSelectedUpgradesLeft() > 0) {
                        n = 16;
                        n2 = 4;
                        this.m_fireKeyEnabled = true;
                        break;
                    }
                    n2 = 4;
                    this.m_fireKeyEnabled = false;
                    break;
                }
                case 10: 
                case 11: {
                    n2 = 4;
                }
            }
        }
        appEngine.setSoftKeys(n2, n);
    }

    private final void loadCar(int n) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        Node[] nodeArray = null;
        if (appEngine.getCarFlags(n, 1)) {
            Image2D image2D = resourceManager.cachedLoadM3GImage2D(appEngine.getCarTextureResID(n));
            Node node = resourceManager.cachedLoadMergedM3GNode(appEngine.getCarMeshChassisResID(n));
            Node node2 = resourceManager.cachedLoadMergedM3GNode(appEngine.getCarMeshWheelsResID(n));
            Node node3 = resourceManager.cachedLoadMergedM3GNode(appEngine.getCarMeshBodykitResID(n));
            AppEngine.helperApplyTexture(node, image2D);
            AppEngine.helperApplyTexture(node2, image2D);
            AppEngine.helperApplyTexture(node3, image2D);
            nodeArray = appEngine.prepareCarNodes(n, node, node2, node3, null, null, null, null, this.m_carShadow, false);
        }
        this.m_carMeshes[n] = nodeArray;
        this.m_carWasLocked[n] = false;
    }

    public void initializeCarSelect() {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getHeight();
        CARSELECT_LEFT = 0;
        CARSELECT_TOP = 0;
        CARSELECT_WIDTH = appEngine.getWidth();
        CARSELECT_HEIGHT = n;
        ASPECT_RATIO = MathExt.Fdiv(CARSELECT_WIDTH << 16, CARSELECT_HEIGHT << 16);
        this.m_carCamera = new Camera();
        AppEngine.setPerspectivex(this.m_carCamera, 0x320000, ASPECT_RATIO, 6553, 0x4B0000);
        this.m_cameraRotationRadF = 0;
        this.m_carCameraTransform = new Transform();
        this.m_cameraCoords = new int[6];
        this.resetCarCameraAnim();
        this.m_cameraInterpFromCoords = new int[6];
        this.m_cameraInterpToCoords = new int[6];
        this.m_tunerShopFocusTime = 0;
    }

    private void loadCarSelect() {
        this.loadCarSelect(-1);
    }

    public void loadCarSelect(int n) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        int n2 = 0;
        if (n == -1) {
            for (int i = 0; i < appEngine.getNumCars(); ++i) {
                if (appEngine.getCarDescriptionStringID(i) != AppEngine.menuGetSelectedItem(this.m_menuCarSelect)) continue;
                n2 = i;
                break;
            }
        } else {
            n2 = n;
        }
        if (this.m_carNodes != null) {
            ((Group)this.m_carNodes[1]).removeChild(this.m_garageMesh);
        }
        Node[] nodeArray = this.m_carMeshes[n2];
        if (!this.isCarUnlocked(this.m_menuCarSelect) && this.m_state != 14 && this.m_state != 19 && this.m_state != 7 && this.m_state != 20 && this.m_state != 27 && SceneMTX.subState != 2) {
            Image2D image2D = resourceManager.cachedLoadM3GImage2D(49);
            AppEngine.helperApplyTexture(nodeArray[5], image2D);
            AppEngine.helperApplyTexture(nodeArray[11], image2D);
            AppEngine.helperApplyTexture(nodeArray[8], image2D);
            AppEngine.helperApplyTexture(nodeArray[10], image2D);
            AppEngine.helperApplyTexture(nodeArray[9], image2D);
            this.m_carWasLocked[n2] = true;
        } else if (this.m_carWasLocked[n2]) {
            short s = appEngine.getCarTextureResID(n2);
            Image2D image2D = resourceManager.cachedLoadM3GImage2D(s);
            AppEngine.helperApplyTexture(nodeArray[5], image2D);
            AppEngine.helperApplyTexture(nodeArray[11], image2D);
            AppEngine.helperApplyTexture(nodeArray[8], image2D);
            AppEngine.helperApplyTexture(nodeArray[10], image2D);
            AppEngine.helperApplyTexture(nodeArray[9], image2D);
            this.m_carWasLocked[n2] = false;
        }
        ((Group)nodeArray[1]).addChild(this.m_garageMesh);
        this.m_carNodes = nodeArray;
        nodeArray[1].setScale(1.0f, 1.0f, 1.0f);
        this.m_carBackground = new Background();
        if (appEngine.getCarAccessoryLevel(n2, 4) == 0 || this.m_state == 14 || this.m_state == 15 || this.m_state == 27) {
            this.m_carNodes[6].setRenderingEnable(false);
        }
    }

    private void updateCarSelect(int n) {
        this.updateCarSelect(n, false);
    }

    public void updateCarSelect(int n, boolean bl) {
        if (this.m_cameraInterping) {
            this.m_tunerShopFocusTime += n;
            int n2 = MathExt.smoothstepF(0, 400, this.m_tunerShopFocusTime);
            int n3 = 65536 - n2;
            int n4 = this.m_cameraCoords.length;
            for (int i = 0; i < n4; ++i) {
                this.m_cameraCoords[i] = MathExt.Fmul(this.m_cameraInterpToCoords[i], n2) + MathExt.Fmul(this.m_cameraInterpFromCoords[i], n3);
            }
            if (this.m_tunerShopFocusTime >= 400) {
                this.m_cameraInterping = false;
            }
        } else if (this.m_state != 20 && this.m_state != 21 && this.m_state != 15) {
            this.m_cameraRotationRadF = MathExt.normaliseAngleRadiansF(this.m_cameraRotationRadF + MathExt.Fmul(19660, n << 6));
            int[] nArray = CARCAMERA_ANIMS[5];
            int[] nArray2 = s_tempInt2;
            MathExt.rotate2DVecF(nArray[0], nArray[2], nArray2, this.m_cameraRotationRadF);
            this.m_cameraCoords[0] = nArray2[0];
            this.m_cameraCoords[1] = nArray[1];
            this.m_cameraCoords[2] = nArray2[1];
            MathExt.rotate2DVecF(nArray[3], nArray[5], nArray2, this.m_cameraRotationRadF);
            this.m_cameraCoords[3] = nArray2[0];
            this.m_cameraCoords[4] = nArray[4];
            this.m_cameraCoords[5] = nArray2[1];
        }
        AppEngine.helperCreateLookAtTransform(this.m_carCameraTransform, this.m_cameraCoords[0] << 3, this.m_cameraCoords[1] << 3, this.m_cameraCoords[2] << 3, this.m_cameraCoords[3] << 3, this.m_cameraCoords[4] << 3, this.m_cameraCoords[5] << 3);
        if (!bl) {
            if (this.m_loadCarNext) {
                if (this.m_state != 7) {
                    this.loadCarSelect();
                }
                this.m_carLoaded = true;
                this.m_loadCarNext = false;
            } else if (!this.m_carLoaded) {
                this.m_loadCarNext = true;
            }
        }
    }

    private void updateMoreGames() {
        AppEngine appEngine = this.m_engine;
        MoreGames moreGames = appEngine.getMoreGames();
        if (moreGames.isActive()) {
            moreGames.update();
        } else {
            appEngine.setMoreGamesActive(false);
            this.stateTransitionOut((byte)6);
        }
    }

    private void setCarSelectionScreen(int n) {
        this.loadCarSelect(n);
    }

    private void startRace(int n, boolean bl) {
        AppEngine appEngine = this.m_engine;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        byte by = 0;
        if (bl) {
            n2 = appEngine.getCurrentRaceSectorIndex();
            n3 = appEngine.getCurrentRaceEventIndex();
            n4 = appEngine.getEventTrackID(n2, n3);
        } else {
            switch (n) {
                case 0: {
                    n2 = appEngine.getNumSectors() - 1;
                    n3 = 0;
                    n4 = appEngine.getEventTrackID(n2, n3);
                    appEngine.setPlayerCarIndex(0);
                    break;
                }
                case 3: {
                    n2 = m_currentSector;
                    n3 = m_currentEvent;
                    n4 = appEngine.getEventTrackID(n2, n3);
                    break;
                }
                case 2: {
                    int n5 = appEngine.getPlayerCarIndex();
                    n2 = appEngine.getCarSector(n5);
                    n3 = appEngine.getQuickraceFromSector(n2);
                    n4 = appEngine.getEventTrackID(n2, n3);
                    break;
                }
                default: {
                    AppEngine.ASSERT(false, "Unknown race type for startRace()");
                }
            }
        }
        by = appEngine.getEventLaps(n2, n3);
        appEngine.setRaceParameters(n, n2, n3);
        appEngine.setNextRaceNumLaps(by);
        appEngine.loadTrack(n4);
        this.stateTransitionFade((byte)26);
    }

    private void startNewCareer() {
        AppEngine appEngine = this.m_engine;
        appEngine.resetRMSGameData();
        appEngine.rmsSetGameExists(true);
        appEngine.purchaseCareerCar((byte)0, false);
        appEngine.rmsSetCareerActiveCarIndex((byte)0);
        appEngine.setPlayerCarIndex(0);
        appEngine.saveRMSGameData();
        this.m_noMoreCarsToPurchase = false;
        appEngine.startFadeOut();
        this.stateTransitionOut((byte)7);
        this.m_safeHouseState = 0;
        this.DEBUG_PRERACE("starting new career");
    }

    private int getNumSelectedUpgradesLeft() {
        AppEngine appEngine = this.m_engine;
        byte by = appEngine.rmsGetCareerActiveCarIndex();
        short s = AppEngine.menuGetSelection(this.m_menuSelectUpgrade);
        byte by2 = appEngine.getCarAccessoryLevel(by, s);
        short[] sArray = appEngine.getCareerTunerSubMenuStringIDs()[s];
        int n = sArray.length;
        return n - by2;
    }

    private void DEBUG_PRERACE(String string) {
    }

    static {
        WORLD_MAP = new byte[][]{{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}, {5, 5, 5, 5, 5, 5, 0, 1, 1, 2, 5, 5, 5, 5}, {5, 5, 5, 5, 5, 5, 7, 4, 16, 7, 2, 5, 5, 5}, {5, 5, 1, 1, 11, 1, 3, 3, 10, 7, 7, 2, 5, 5}, {5, 0, 9, 7, 17, 8, 9, 10, 4, 3, 0, 7, 2, 5}, {0, 7, 11, 7, 7, 2, 7, 9, 14, 3, 4, 17, 8, 5}, {6, 10, 4, 3, 3, 7, 2, 1, 0, 11, 9, 17, 4, 8}, {12, 15, 16, 17, 17, 13, 16, 17, 3, 17, 3, 11, 4, 8}, {5, 6, 7, 17, 0, 3, 1, 1, 4, 7, 13, 4, 7, 5}, {5, 12, 13, 1, 9, 10, 11, 17, 2, 1, 1, 9, 8, 5}, {5, 5, 5, 6, 15, 16, 3, 7, 13, 11, 17, 9, 8, 5}, {5, 5, 5, 12, 13, 14, 6, 9, 1, 17, 3, 7, 14, 5}, {5, 5, 5, 5, 5, 5, 12, 13, 13, 3, 13, 14, 5, 5}, {5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
        s_unlockCarLevels = new byte[]{2, 4, 5, 6, 7};
        UPGRADE_MAX_VALUE_NITRO = 262144;
        CARCAMERA_ANIMS = new int[][]{{-10092, 16384, 50462, 0, 0, 0}, {-62259, 6553, 0, 0, 4587, 0}, {-30015, 7864, 22937, 16384, -3932, 6553}, {-23592, 7864, Short.MIN_VALUE, -6553, 4587, -24248}, {Short.MIN_VALUE, 7864, -39321, 6553, 0, 0}, {-29491, 9830, 45875, 0, 6553, 0}, {32768, 16384, 0, 65536, 16384, 0}};
        s_tempInt2 = new int[2];
    }
}

