/*
 * Decompiled with CFR 0.152.
 */
package com.divum.googleanalyticsme;

import com.divum.googleanalyticsme.Request;
import com.divum.googleanalyticsme.TrackingURL;
import com.divum.googleanalyticsme.util.StringUtil;
import com.divum.googleanalyticsme.util.URLEncoder;

public final class Event
implements Request {
    private String event;

    public Event(String category, String action, String label, Integer value) {
        if (StringUtil.isEmpty(category)) {
            throw new IllegalArgumentException("Category must not be empty.");
        }
        if (StringUtil.isEmpty(action)) {
            throw new IllegalArgumentException("Action must not be empty.");
        }
        StringBuffer event = new StringBuffer();
        event.append("5(");
        event.append(category);
        event.append('*');
        event.append(action);
        if (!StringUtil.isEmpty(label)) {
            event.append('*');
            event.append(label);
        }
        event.append(')');
        if (value != null) {
            event.append('(');
            event.append(value);
            event.append(')');
        }
        this.event = event.toString();
    }

    public String url(String trackingCode) {
        TrackingURL params = new TrackingURL(trackingCode);
        params.addParameter("utmt", "event");
        params.addParameter("utme", URLEncoder.encode(this.event));
        return params.toString();
    }
}

