/*
 * Decompiled with CFR 0.152.
 */
package com.divum.screens;

import com.divum.configs.AssetsConfig;
import com.divum.configs.GameConfig;
import com.divum.configs.ImageNamesConfig;
import com.divum.configs.Log;
import com.divum.configs.SetterGetter;
import com.divum.configs.StringConfig;
import com.divum.parsers.ImageParsing;
import com.divum.parsers.MoreGamesDataType;
import com.divum.parsers.MoreGamesParser;
import com.divum.parsers.XmlCallback;
import com.divum.screens.BaseScreen;
import com.divum.screens.MidletScreen;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MoreGamesScreen
extends BaseScreen
implements XmlCallback {
    Image moregamesScreen;
    Image img_loading;
    String gamesUrl = "http://s3-ap-southeast-1.amazonaws.com/divum/Others/otherapps/s40.xml";
    Vector _vecMoreGames;
    boolean connectionError;
    boolean parserFinished;
    MoreGamesDataType item;
    String[] title;
    String[] desc;
    String[] otherImg;
    String[] appId;
    int counter = 0;
    Sprite sprite_next;
    Sprite sprite_next_hover;
    Sprite sprite_previous;
    Sprite sprite_previous_hover;
    Sprite sprite_back;
    Sprite sprite_back_hover;
    Sprite sprite_download;
    Sprite sprite_download_hover;
    public long start_time = System.currentTimeMillis();
    public long end_time;
    boolean isBack;
    boolean isDownload;

    public MoreGamesScreen() {
        new Thread(){

            public void run() {
                MoreGamesScreen.this.loadMoreGamesParser();
            }
        }.start();
        try {
            this.moregamesScreen = Image.createImage((String)ImageNamesConfig.MORE_GAMES);
            this.img_loading = Image.createImage((String)ImageNamesConfig.LOADING);
            this.sprite_download = new Sprite(Image.createImage((String)"/moregames/download.png"));
            this.sprite_download_hover = new Sprite(Image.createImage((String)"/moregames/download-hover.png"));
            this.sprite_download.setPosition(GameConfig.dispWidth - (this.sprite_download.getWidth() + 10), GameConfig.dispHeight - (this.sprite_download.getHeight() + 5));
            this.sprite_download_hover.setPosition(GameConfig.dispWidth - (this.sprite_download.getWidth() + 10), GameConfig.dispHeight - (this.sprite_download.getHeight() + 5));
            this.sprite_back = new Sprite(Image.createImage((String)"/moregames/back.png"));
            this.sprite_back_hover = new Sprite(Image.createImage((String)"/moregames/back-hover.png"));
            this.sprite_back.setPosition(20, GameConfig.dispHeight - this.sprite_download.getHeight());
            this.sprite_back_hover.setPosition(20, GameConfig.dispHeight - this.sprite_download.getHeight());
            this.sprite_next = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_next_hover = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_next.setPosition(GameConfig.dispWidth - (this.sprite_next.getWidth() + 5), GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_next_hover.setPosition(GameConfig.dispWidth - (this.sprite_next.getWidth() + 5), GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_previous = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_previous_hover = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_previous.setTransform(3);
            this.sprite_previous_hover.setTransform(3);
            this.sprite_previous.setPosition(5, GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_previous_hover.setPosition(5, GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
        }
        catch (Exception e) {
            Log.debug("caught while reading images");
        }
        MidletScreen.pingAnalytics("MoreGamesScreen");
    }

    void draw(Graphics g) {
        this.end_time = System.currentTimeMillis();
        g.drawImage(this.moregamesScreen, 0, 0, 20);
        if (this.parserFinished) {
            if (this.counter < this._vecMoreGames.size() - 1) {
                this.sprite_next.paint(g);
            }
            if (this.counter > 0) {
                this.sprite_previous.paint(g);
            }
            if (!this.isBack) {
                this.sprite_back.paint(g);
            } else {
                this.sprite_back_hover.paint(g);
            }
            if (!this.isDownload) {
                this.sprite_download.paint(g);
            } else {
                this.sprite_download_hover.paint(g);
            }
            if (this.appId != null) {
                this.drawMoreGameScreen(g);
            }
        } else {
            g.drawImage(this.img_loading, GameConfig.dispWidth / 2 - this.img_loading.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_loading.getHeight() / 2, 20);
            if (this.end_time - this.start_time >= 10000L && !this.parserFinished) {
                if (!this.isBack) {
                    this.sprite_back.paint(g);
                } else {
                    this.sprite_back_hover.paint(g);
                }
            }
        }
    }

    SetterGetter getAction(int x, int y) {
        SetterGetter obj = new SetterGetter();
        if (AssetsConfig.pointerSprite.collidesWith(this.sprite_back, false)) {
            this.isBack = true;
            obj.setChangeScreen(true);
            obj.setActionPerformed(StringConfig.BACK);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_download, false)) {
            this.isDownload = true;
            this.otherGamesScreenDownloadingApp();
        } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_next, false)) {
            ++this.counter;
            if (this.counter == this._vecMoreGames.size()) {
                this.counter = this._vecMoreGames.size() - 1;
            }
        } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_previous, false)) {
            --this.counter;
            if (this.counter == -1) {
                this.counter = 0;
            }
        }
        return obj;
    }

    private void otherGamesScreenDownloadingApp() {
        try {
            GameConfig.midlet.platformRequest(this.appId[this.counter]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("otherGamesScreenDownloadingApp some problem");
        }
    }

    void freeMemory() {
        this.moregamesScreen = null;
        this.sprite_next = null;
        this.sprite_next_hover = null;
        this.sprite_previous = null;
        this.sprite_previous_hover = null;
        this.sprite_back = null;
        this.sprite_back_hover = null;
        this.sprite_download = null;
        this.sprite_download_hover = null;
        Runtime.getRuntime().freeMemory();
        System.gc();
    }

    void drawMoreGameScreen(Graphics g) {
        if (this.counter == this._vecMoreGames.size()) {
            this.counter = this._vecMoreGames.size() - 1;
        } else if (this.counter == -1) {
            this.counter = 0;
        }
        if (this.counter == 0) {
            Image img = this.scaleImage(ImageParsing.getImageFromUrl(this.otherImg[0]), 80, 120);
            g.drawImage(img, 30, 50, 20);
            Font myFont = Font.getFont((int)0, (int)0, (int)8);
            this.drawMultilineString(g, myFont, this.desc[0], GameConfig.dispWidth / 3 + 10, 50, 20, 190);
        } else if (this.counter < this._vecMoreGames.size()) {
            Image img = this.scaleImage(ImageParsing.getImageFromUrl(this.otherImg[this.counter]), 80, 120);
            g.drawImage(img, 30, 50, 20);
            Font myFont = Font.getFont((int)0, (int)0, (int)8);
            this.drawMultilineString(g, myFont, this.desc[this.counter], GameConfig.dispWidth / 3 + 10, 50, 20, 190);
        }
    }

    void loadMoreGamesParser() {
        try {
            this._vecMoreGames = new Vector();
            MoreGamesParser mp = new MoreGamesParser();
            mp.setRSSListener(this);
            mp.parse(this.gamesUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void MoreGamesParserException(Exception e) {
        this.connectionError = true;
    }

    public void MoreGamesParseDidFinish() {
        if (!this.connectionError) {
            this.title = new String[this._vecMoreGames.size()];
            this.desc = new String[this._vecMoreGames.size()];
            this.otherImg = new String[this._vecMoreGames.size()];
            this.appId = new String[this._vecMoreGames.size()];
            int i = 0;
            while (i < this._vecMoreGames.size()) {
                this.item = (MoreGamesDataType)this._vecMoreGames.elementAt(i);
                this.title[i] = this.item.getAppName();
                this.otherImg[i] = this.item.getAppImage();
                this.desc[i] = this.item.getAppDesc();
                this.appId[i] = this.item.getAppId();
                ++i;
            }
            this.parserFinished = true;
        }
    }

    public void MoreGames_listeneritemParsed(MoreGamesDataType items) {
        this._vecMoreGames.addElement(items);
    }

    Image scaleImage(Image sourceImage, int newImageWidth, int newImageHeight) {
        int srcWidth = sourceImage.getWidth();
        int srcHeight = sourceImage.getHeight();
        int[] rgbSource = new int[srcWidth * srcHeight];
        int[] rgb2Scaled = new int[newImageWidth * newImageHeight];
        sourceImage.getRGB(rgbSource, 0, srcWidth, 0, 0, srcWidth, srcHeight);
        int tempScaleRatioWidth = (srcWidth << 16) / newImageWidth;
        int tempScaleRatioHeight = (srcHeight << 16) / newImageHeight;
        int i = 0;
        int y = 0;
        while (y < newImageHeight) {
            int x = 0;
            while (x < newImageWidth) {
                rgb2Scaled[i++] = rgbSource[srcWidth * (y * tempScaleRatioHeight >> 16) + (x * tempScaleRatioWidth >> 16)];
                ++x;
            }
            ++y;
        }
        return Image.createRGBImage((int[])rgb2Scaled, (int)newImageWidth, (int)newImageHeight, (boolean)true);
    }

    public int drawMultilineString(Graphics g, Font font, String str, int x, int y, int anchor, int width) {
        g.setColor(0xFFFFFF);
        g.setFont(font);
        Vector lines = this.wrap(str, font, width);
        int i = 0;
        while (i < (lines.size() > 7 ? 7 : lines.size())) {
            int liney = y + i * font.getHeight();
            if (i == 6) {
                g.drawString(String.valueOf((String)lines.elementAt(i)) + "...", x, liney, anchor);
            } else {
                g.drawString((String)lines.elementAt(i), x, liney, anchor);
            }
            ++i;
        }
        return y + lines.size() * font.getHeight();
    }

    Vector wrap(String text, Font font, int width) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = font.substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }
}

