/*
 * Decompiled with CFR 0.152.
 */
package com.divum.configs;

import com.divum.configs.GameConfig;
import com.divum.screens.RaceScreen;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.midlet.MIDlet;

public class Utilities {
    Sprite numbersprite1;
    Sprite numbersprite2;
    Sprite numbersprite3;
    Sprite numbersprite4;
    Sprite numbersprite5;

    public Utilities() {
        try {
            this.numbersprite1 = new Sprite(Image.createImage((String)"/gamescreen/numbersprite.png"), 25, 25);
            this.numbersprite2 = new Sprite(Image.createImage((String)"/gamescreen/numbersprite.png"), 25, 25);
            this.numbersprite3 = new Sprite(Image.createImage((String)"/gamescreen/numbersprite.png"), 25, 25);
            this.numbersprite4 = new Sprite(Image.createImage((String)"/gamescreen/numbersprite.png"), 25, 25);
            this.numbersprite5 = new Sprite(Image.createImage((String)"/gamescreen/numbersprite.png"), 25, 25);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showAlertLoading() {
        Alert ExitAlrt = new Alert("Loading...", "", null, AlertType.INFO);
        Gauge gauge = new Gauge(null, false, -1, 2);
        ExitAlrt.setIndicator(gauge);
        Command cmd_cancel = new Command("Cancel", 2, 1);
        ExitAlrt.addCommand(cmd_cancel);
        ExitAlrt.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable arg1) {
            }
        });
        Display.getDisplay((MIDlet)GameConfig.midlet).setCurrent((Displayable)ExitAlrt);
    }

    public Image rotateImage(Image image, int angle) throws Exception {
        if (angle == 0) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rowData = new int[width];
        int[] rotatedData = new int[width * height];
        int rotatedIndex = 0;
        int i = 0;
        while (i < height) {
            image.getRGB(rowData, 0, width, 0, i, width, 1);
            int j = 0;
            while (j < width) {
                rotatedIndex = angle == 90 ? height - i - 1 + j * height : (angle == 270 ? i + height * (width - j - 1) : width * height - (i * width + j) - 1);
                rotatedData[rotatedIndex] = rowData[j];
                ++j;
            }
            ++i;
        }
        return Image.createRGBImage((int[])rotatedData, (int)width, (int)height, (boolean)true);
    }

    public float getRatioOfMaxSpeed(int pGearNumber, float pMax_speed) {
        float ratio = 0.0f;
        switch (pGearNumber) {
            case 1: {
                ratio = pMax_speed * RaceScreen.default_speed_ratio / 100.0f;
                break;
            }
            case 2: {
                ratio = pMax_speed * 4.0f / 10.0f;
                break;
            }
            case 3: {
                ratio = pMax_speed * 6.0f / 10.0f;
                break;
            }
            case 4: {
                ratio = pMax_speed * 8.0f / 10.0f;
                break;
            }
            case 5: {
                ratio = pMax_speed * 9.0f / 10.0f;
                break;
            }
            case 6: {
                ratio = pMax_speed * 1.0f;
                break;
            }
        }
        return ratio;
    }

    public Image scaleImage(Image sourceImage, int newImageWidth, int newImageHeight) {
        int srcWidth = sourceImage.getWidth();
        int srcHeight = sourceImage.getHeight();
        int[] rgbSource = new int[srcWidth * srcHeight];
        int[] rgb2Scaled = new int[newImageWidth * newImageHeight];
        sourceImage.getRGB(rgbSource, 0, srcWidth, 0, 0, srcWidth, srcHeight);
        int tempScaleRatioWidth = (srcWidth << 16) / newImageWidth;
        int tempScaleRatioHeight = (srcHeight << 16) / newImageHeight;
        int i = 0;
        int y = 0;
        while (y < newImageHeight) {
            int x = 0;
            while (x < newImageWidth) {
                rgb2Scaled[i++] = rgbSource[srcWidth * (y * tempScaleRatioHeight >> 16) + (x * tempScaleRatioWidth >> 16)];
                ++x;
            }
            ++y;
        }
        return Image.createRGBImage((int[])rgb2Scaled, (int)newImageWidth, (int)newImageHeight, (boolean)true);
    }

    public void showAlert(String msg) {
        Alert warningAlert = new Alert("");
        warningAlert.setString(msg);
        warningAlert.setTimeout(-2);
        Display.getDisplay((MIDlet)GameConfig.midlet).setCurrent((Displayable)warningAlert);
    }

    public String[] getScoreFrames(int score) {
        String[] frames = null;
        String stringscore = "" + score;
        if (score < 10) {
            frames = new String[]{"0", "0", "0", stringscore};
        } else if (score < 100) {
            frames = new String[]{"0", "0", stringscore.substring(0, 1), stringscore.substring(1, 2)};
        } else if (score < 1000) {
            frames = new String[]{"0", stringscore.substring(0, 1), stringscore.substring(1, 2), stringscore.substring(2, 3)};
        } else if (score < 10000) {
            frames = new String[]{stringscore.substring(0, 1), stringscore.substring(1, 2), stringscore.substring(2, 3), stringscore.substring(3, 4)};
        } else if (score < 100000) {
            frames = new String[]{stringscore.substring(0, 1), stringscore.substring(1, 2), stringscore.substring(2, 3), stringscore.substring(3, 4), stringscore.substring(4, 5)};
        }
        return frames;
    }

    public void drawScores(String[] frames, int x_sound, int y_sound, Graphics g) {
        this.numbersprite1.setPosition(x_sound, y_sound);
        this.numbersprite2.setPosition(x_sound + 10, y_sound);
        this.numbersprite3.setPosition(x_sound + 20, y_sound);
        this.numbersprite4.setPosition(x_sound + 30, y_sound);
        this.numbersprite1.setFrame(Integer.parseInt(frames[0]));
        this.numbersprite2.setFrame(Integer.parseInt(frames[1]));
        this.numbersprite3.setFrame(Integer.parseInt(frames[2]));
        this.numbersprite4.setFrame(Integer.parseInt(frames[3]));
        this.numbersprite1.paint(g);
        this.numbersprite2.paint(g);
        this.numbersprite3.paint(g);
        this.numbersprite4.paint(g);
        if (frames.length > 4) {
            this.numbersprite5.setPosition(x_sound + 42, y_sound);
            this.numbersprite5.setFrame(Integer.parseInt(frames[4]));
            this.numbersprite5.paint(g);
        }
    }

    public void drawTime(String frames, int x_sound, int y_sound, Graphics g) {
        this.numbersprite1.setPosition(x_sound, y_sound);
        this.numbersprite2.setPosition(x_sound + 10, y_sound);
        g.drawString(":", x_sound + 28, y_sound, 20);
        this.numbersprite3.setPosition(x_sound + 25, y_sound);
        this.numbersprite4.setPosition(x_sound + 35, y_sound);
        this.numbersprite1.setFrame(Integer.parseInt(frames.substring(0, 1)));
        this.numbersprite2.setFrame(Integer.parseInt(frames.substring(1, 2)));
        this.numbersprite3.setFrame(Integer.parseInt(frames.substring(2, 3)));
        this.numbersprite4.setFrame(Integer.parseInt(frames.substring(3, 4)));
        this.numbersprite1.paint(g);
        this.numbersprite2.paint(g);
        this.numbersprite3.paint(g);
        this.numbersprite4.paint(g);
    }

    public void printCarsNumber(int selectedCar, int totalCars, Graphics g) {
        int y_pos = 60;
        if (selectedCar < 10) {
            int x_pos = GameConfig.dispWidth / 2 - 10;
            this.numbersprite1.setPosition(x_pos, y_pos);
            this.numbersprite1.setFrame(selectedCar);
            this.numbersprite1.paint(g);
            g.drawString("/", x_pos + 15, y_pos + 3, 20);
            if (totalCars < 10) {
                this.numbersprite2.setPosition(x_pos + 15, y_pos);
                this.numbersprite2.setFrame(totalCars);
                this.numbersprite2.paint(g);
            } else {
                String str = Integer.toString(totalCars);
                this.numbersprite2.setPosition(x_pos + 15, y_pos);
                this.numbersprite2.setFrame(Integer.parseInt(str.substring(0, 1)));
                this.numbersprite2.paint(g);
                this.numbersprite3.setPosition(x_pos + 25, y_pos);
                this.numbersprite3.setFrame(Integer.parseInt(str.substring(1, 2)));
                this.numbersprite3.paint(g);
            }
        } else {
            int x_pos = GameConfig.dispWidth / 2 - 20;
            String str_selectedcar = Integer.toString(selectedCar);
            this.numbersprite1.setPosition(x_pos, y_pos);
            this.numbersprite1.setFrame(Integer.parseInt(str_selectedcar.substring(0, 1)));
            this.numbersprite1.paint(g);
            this.numbersprite2.setPosition(x_pos + 10, y_pos);
            this.numbersprite2.setFrame(Integer.parseInt(str_selectedcar.substring(1, 2)));
            this.numbersprite2.paint(g);
            g.drawString("/", x_pos + 25, y_pos + 3, 20);
            String str_totalcars = Integer.toString(totalCars);
            this.numbersprite3.setPosition(x_pos + 25, y_pos);
            this.numbersprite3.setFrame(Integer.parseInt(str_totalcars.substring(0, 1)));
            this.numbersprite3.paint(g);
            this.numbersprite4.setPosition(x_pos + 35, y_pos);
            this.numbersprite4.setFrame(Integer.parseInt(str_totalcars.substring(1, 2)));
            this.numbersprite4.paint(g);
        }
    }
}

