/*
 * Decompiled with CFR 0.152.
 */
package com.divum.googleanalyticsme;

import com.divum.googleanalyticsme.Request;
import com.divum.googleanalyticsme.TrackingURL;
import com.divum.googleanalyticsme.util.StringUtil;
import com.divum.googleanalyticsme.util.URLEncoder;

public final class PageView
implements Request {
    private String title;
    private String uri;

    public PageView(String uri) {
        this(null, uri);
    }

    public PageView(String title, String uri) {
        if (StringUtil.isEmpty(uri)) {
            throw new IllegalArgumentException("URI must not be empty.");
        }
        this.title = title;
        this.uri = !uri.startsWith("/") ? "/" + uri : uri;
    }

    public String url(String trackingCode) {
        TrackingURL params = new TrackingURL(trackingCode);
        params.addParameter("utmp", this.uri);
        if (!StringUtil.isEmpty(this.title)) {
            params.addParameter("utmdt", URLEncoder.encode(this.title));
        }
        return params.toString();
    }
}

