/*
 * Decompiled with CFR 0.152.
 */
package com.divum.screens;

import com.divum.configs.AssetsConfig;
import com.divum.configs.GameConfig;
import com.divum.configs.ImageNamesConfig;
import com.divum.configs.Log;
import com.divum.configs.SetterGetter;
import com.divum.configs.StringConfig;
import com.divum.configs.Utilities;
import com.divum.parsers.LeaderBoardParser;
import com.divum.parsers.MoreGamesDataType;
import com.divum.parsers.XmlCallback;
import com.divum.screens.BaseScreen;
import com.divum.screens.MidletScreen;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class LeaderBoardScreen
extends BaseScreen
implements XmlCallback {
    String[] raceScore;
    int levelCrossed;
    Image img_bg;
    Utilities obj_utilities;
    boolean raceSelected;
    boolean menuSelected;
    boolean nextSelected;
    Sprite race_sprite;
    Sprite race_hover_sprite;
    Sprite next_sprite;
    Sprite next_hover_sprite;
    Sprite menu_sprite;
    Sprite menu_hover_sprite;
    Image img_loading;
    public long start_time = System.currentTimeMillis();
    public long end_time;
    Vector vectorScore;
    int x = 40;
    int y = 50;
    SetterGetter obj = null;
    boolean parserFinished;

    public LeaderBoardScreen() {
        this.obj_utilities = new Utilities();
        this.raceScore = this.obj_utilities.getScoreFrames(GameConfig.gameScore);
        this.levelCrossed = (GameConfig.main_level - 1) * 4 + (GameConfig.sub_level - 1);
        try {
            int x = 50;
            this.img_bg = Image.createImage((String)"/leaderboard/leader-board-bg.png");
            this.img_loading = Image.createImage((String)ImageNamesConfig.LOADING);
            this.race_sprite = new Sprite(Image.createImage((String)"/leaderboard/race.png"));
            this.race_hover_sprite = new Sprite(Image.createImage((String)"/leaderboard/race-hover.png"));
            this.race_sprite.setPosition(x, GameConfig.dispHeight - this.race_sprite.getHeight());
            this.race_hover_sprite.setPosition(x, GameConfig.dispHeight - this.race_sprite.getHeight());
            this.next_sprite = new Sprite(Image.createImage((String)"/leaderboard/next.png"));
            this.next_hover_sprite = new Sprite(Image.createImage((String)"/leaderboard/next-hover.png"));
            this.next_sprite.setPosition(x + 2 * this.race_sprite.getWidth(), GameConfig.dispHeight - this.race_sprite.getHeight());
            this.next_hover_sprite.setPosition(x + 2 * this.race_sprite.getWidth(), GameConfig.dispHeight - this.race_sprite.getHeight());
            this.menu_sprite = new Sprite(Image.createImage((String)"/leaderboard/menu.png"));
            this.menu_hover_sprite = new Sprite(Image.createImage((String)"/leaderboard/menu-hover.png"));
            this.menu_sprite.setPosition(x + this.race_sprite.getWidth(), GameConfig.dispHeight - this.race_sprite.getHeight());
            this.menu_hover_sprite.setPosition(x + this.race_sprite.getWidth(), GameConfig.dispHeight - this.race_sprite.getHeight());
        }
        catch (Exception e) {
            Log.debug("caught in LBS " + e);
        }
        new Thread(){

            public void run() {
                LeaderBoardScreen.this.loadScoreParser();
            }
        }.start();
        MidletScreen.pingAnalytics("LeaderBoardScreen");
    }

    private void loadScoreParser() {
        String scoreURL = "http://api.divum.in/cgi-bin/scripts/Games/SpeedClub/v0.1/getLeaderboard.php?device_id=" + MidletScreen.visitorId + "&device=" + MidletScreen.deviceName + "&score=" + GameConfig.gameScore;
        this.vectorScore = new Vector();
        try {
            LeaderBoardParser obj = new LeaderBoardParser();
            obj.setRSSListener(this);
            obj.parser(scoreURL.trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void draw(Graphics g) {
        g.drawImage(this.img_bg, 0, 0, 20);
        this.end_time = System.currentTimeMillis();
        if (this.parserFinished) {
            if (!this.raceSelected) {
                this.race_sprite.paint(g);
            } else {
                this.race_hover_sprite.paint(g);
            }
            if (GameConfig.moveToNextLevel) {
                if (!this.nextSelected) {
                    this.next_sprite.paint(g);
                } else {
                    this.next_hover_sprite.paint(g);
                }
            }
            if (!this.menuSelected) {
                this.menu_sprite.paint(g);
            } else {
                this.menu_hover_sprite.paint(g);
            }
            this.y = 50;
            int i = 0;
            while (i < this.vectorScore.size()) {
                MoreGamesDataType item = (MoreGamesDataType)this.vectorScore.elementAt(i);
                if (item.getScore() == GameConfig.gameScore) {
                    g.setColor(0xFF0000);
                } else {
                    g.setColor(0xFFFFFF);
                }
                g.drawString(item.getDeviceName(), this.x, this.y, 20);
                this.obj_utilities.drawScores(this.obj_utilities.getScoreFrames(item.getScore()), GameConfig.dispWidth / 2 + 10, this.y, g);
                this.y += 20;
                ++i;
            }
        } else {
            g.drawImage(this.img_loading, GameConfig.dispWidth / 2 - this.img_loading.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_loading.getHeight() / 2, 20);
            if (this.end_time - this.start_time >= 10000L && !this.parserFinished) {
                if (!this.nextSelected) {
                    this.next_sprite.paint(g);
                } else {
                    this.next_hover_sprite.paint(g);
                }
            }
        }
    }

    SetterGetter getAction(int x, int y) {
        if (AssetsConfig.pointerSprite.collidesWith(this.next_sprite, false)) {
            if (this.obj == null) {
                this.nextSelected = true;
                if (GameConfig.moveToNextLevel) {
                    GameConfig.moveToNextLevel = false;
                }
                this.obj = new SetterGetter();
                this.obj.setChangeScreen(true);
                this.obj.setActionPerformed(StringConfig.NEXT);
            }
        } else if (AssetsConfig.pointerSprite.collidesWith(this.menu_sprite, false)) {
            this.menuSelected = true;
            if (GameConfig.moveToNextLevel) {
                GameConfig.moveToNextLevel = false;
            }
            this.obj = new SetterGetter();
            this.obj.setChangeScreen(true);
            this.obj.setActionPerformed(StringConfig.MAIN_MENU);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.race_sprite, false) && this.obj == null) {
            this.raceSelected = true;
            this.obj = new SetterGetter();
            this.obj.setChangeScreen(true);
            this.obj.setActionPerformed(StringConfig.PLAY_AGAIN);
        }
        return this.obj;
    }

    void freeMemory() {
        this.race_sprite = null;
        this.race_hover_sprite = null;
        this.next_sprite = null;
        this.next_hover_sprite = null;
        this.menu_sprite = null;
        this.menu_hover_sprite = null;
        this.img_bg = null;
        Runtime.getRuntime().freeMemory();
        System.gc();
    }

    public void MoreGames_listeneritemParsed(MoreGamesDataType items) {
        this.vectorScore.addElement(items);
    }

    public void MoreGamesParseDidFinish() {
        this.parserFinished = true;
    }

    public void MoreGamesParserException(Exception e) {
    }
}

