/*
 * Decompiled with CFR 0.152.
 */
package com.divum.configs;

import com.divum.configs.GameConfig;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundEffect
implements PlayerListener {
    public Player player = null;
    private static Vector playing = new Vector();
    private static final int maxSimultaneousPlaybacks = 10;
    private static String[] filenames = new String[]{"/musicfiles/gear_change.wav", "/musicfiles/engine_2_idle.mp3", "/musicfiles/engine_2_start.mp3", "/musicfiles/car-sound.mp3", "/musicfiles/engine_2_max.mp3", "/musicfiles/SpeedClubMenu.mid"};
    private static String[] fileExtension = new String[]{"audio/mpeg", "audio/mpeg", "audio/mpeg", "audio/mpeg", "audio/mpeg", "audio/mid"};
    private int percussion = 0;
    private boolean hit = false;

    public final void loadSample(int percussion) {
        this.percussion = percussion;
        try {
            InputStream stream = this.getClass().getResourceAsStream(filenames[percussion]);
            this.player = Manager.createPlayer((InputStream)stream, (String)fileExtension[percussion]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void activeLoop() {
        this.player.setLoopCount(-1);
    }

    public void play() {
        if (!GameConfig.isMute && this.player.getState() == 100) {
            new Thread(){

                public void run() {
                    try {
                        SoundEffect.this.player.realize();
                        SoundEffect.this.player.prefetch();
                        SoundEffect.this.player.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    try {
                        if (!GameConfig.isMute && SoundEffect.this.player.getState() != 400 && SoundEffect.this.player.getState() != 0) {
                            SoundEffect.this.player.start();
                        }
                    }
                    catch (MediaException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public boolean pressed(int x, int y) {
        return this.hit;
    }

    public void unpressed() {
        this.hit = false;
    }

    public boolean isHit() {
        return this.hit;
    }

    public static synchronized void limitPlaybacks(Player p) {
        playing.removeElement(p);
        playing.addElement(p);
        while (playing.size() > 10) {
            Player s = (Player)playing.firstElement();
            playing.removeElementAt(0);
            if (s == null || s.getState() != 400) continue;
            try {
                s.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void freePlayer() {
        if (this.player != null) {
            try {
                this.player.deallocate();
                this.player.close();
                this.player = null;
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopPlaying() {
        try {
            if (this.player != null && this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public int getPercussion() {
        return this.percussion;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
    }
}

