/*
 * Decompiled with CFR 0.152.
 */
package com.divum.googleanalyticsme;

import com.divum.googleanalyticsme.Request;
import com.divum.googleanalyticsme.util.StringUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public final class Tracker {
    private static Hashtable trackerPool;
    private String trackingCode;
    private Vector queue;
    private Timer timer;
    private Task task;
    private long flushInterval;

    public static synchronized Tracker getInstance(String trackingCode) {
        return Tracker.getInstance(trackingCode, 90L);
    }

    public static synchronized Tracker getInstance(String trackingCode, long flushInterval) {
        Tracker tracker;
        if (StringUtil.isEmpty(trackingCode)) {
            throw new IllegalArgumentException("Tracking code must not be empty.");
        }
        if (trackerPool == null) {
            trackerPool = new Hashtable();
        }
        if ((tracker = (Tracker)trackerPool.get(trackingCode)) == null) {
            tracker = new Tracker(trackingCode, flushInterval);
            trackerPool.put(trackingCode, tracker);
        }
        return tracker;
    }

    private Tracker(String trackingCode, long flushInterval) {
        this.trackingCode = trackingCode;
        this.flushInterval = flushInterval *= 1000L;
        this.queue = new Vector(5);
        this.timer = new Timer();
        this.task = new Task();
        if (flushInterval > 0L) {
            this.timer.schedule((TimerTask)this.task, flushInterval, flushInterval);
        }
    }

    public void track(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        try {
            this.process(request);
        }
        catch (IOException e) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(request);
        }
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void flush(boolean asynchronously) {
        if (this.queue.size() > 0) {
            if (asynchronously) {
                this.runTask(1000L);
            } else {
                this.processQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void processQueue() {
        int size = this.queue.size();
        int head = 0;
        while (size-- > 0) {
            try {
                this.process((Request)this.queue.elementAt(head));
                Vector vector = this.queue;
                synchronized (vector) {
                    this.queue.removeElementAt(head);
                }
            }
            catch (IOException e) {
                ++head;
            }
        }
    }

    synchronized void process(Request request) throws IOException {
        String userAgent = "Google Analytics ME/1.1 (compatible; Profile/MIDP-2.0 Configuration/CLDC-1.0)";
        String url = request.url(this.trackingCode);
        HttpConnection conn = null;
        try {
            try {
                conn = (HttpConnection)Connector.open((String)url);
                conn.setRequestProperty("User-Agent", "Google Analytics ME/1.1 (compatible; Profile/MIDP-2.0 Configuration/CLDC-1.0)");
                if (conn.getResponseCode() != 200) {
                    throw new IOException();
                }
            }
            catch (SecurityException e) {
                if (conn != null) {
                    conn.close();
                }
                System.out.println("Security exception handled!");
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException e) {
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    void runTask(long delay) {
        if (!this.task.isRunning) {
            if (this.flushInterval > 0L) {
                long delayNextRun = this.task.endExecutionTime + this.flushInterval - System.currentTimeMillis();
                if (delayNextRun > delay) {
                    this.task.cancel();
                    this.task = new Task();
                    this.timer.schedule((TimerTask)this.task, delay, this.flushInterval);
                }
            } else {
                this.task = new Task();
                this.timer.schedule((TimerTask)this.task, delay);
            }
        }
    }

    private class Task
    extends TimerTask {
        public long endExecutionTime = System.currentTimeMillis();
        public boolean isRunning;

        private Task() {
        }

        public void run() {
            this.isRunning = true;
            Tracker.this.processQueue();
            this.isRunning = false;
            this.endExecutionTime = System.currentTimeMillis();
        }
    }
}

