/*
 * Decompiled with CFR 0.152.
 */
package com.divum.screens;

import com.divum.configs.AssetsConfig;
import com.divum.configs.GameConfig;
import com.divum.configs.Log;
import com.divum.configs.SetterGetter;
import com.divum.configs.StringConfig;
import com.divum.configs.Utilities;
import com.divum.screens.BaseScreen;
import com.divum.screens.MidletScreen;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class GarageScreen
extends BaseScreen {
    static int main_level;
    static int sub_level;
    int current_car_num;
    int no_of_cars_in_garage;
    Graphics g;
    Image carselection_bgImage;
    Image tyre;
    Sprite sprite_race;
    Sprite sprite_race_hover;
    Sprite sprite_next;
    Sprite sprite_next_hover;
    Sprite sprite_previous;
    Sprite sprite_previous_hover;
    Utilities obj_utilities;
    Sprite sprite_car;
    int tyre1_xPos;
    int tyre2_xPos;
    boolean raceSelected;
    boolean prevSelected;
    boolean nextSelected;

    public GarageScreen() {
        try {
            this.obj_utilities = new Utilities();
            this.carselection_bgImage = Image.createImage((String)"/garagescreen/garage.png");
            this.sprite_next = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_next_hover = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_next.setPosition(GameConfig.dispWidth - (this.sprite_next.getWidth() + 10), GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_next_hover.setPosition(GameConfig.dispWidth - (this.sprite_next.getWidth() + 10), GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_previous = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_previous_hover = new Sprite(Image.createImage((String)"/garagescreen/right.png"));
            this.sprite_previous.setTransform(3);
            this.sprite_previous_hover.setTransform(3);
            this.sprite_previous.setPosition(10, GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_previous_hover.setPosition(10, GameConfig.dispHeight / 2 - this.sprite_next.getHeight() / 2);
            this.sprite_race = new Sprite(Image.createImage((String)"/garagescreen/race.png"));
            this.sprite_race_hover = new Sprite(Image.createImage((String)"/garagescreen/race-hover.png"));
            this.sprite_race.setPosition(GameConfig.dispWidth / 2 - this.sprite_race.getWidth() / 2, GameConfig.dispHeight - this.sprite_race.getHeight());
            this.sprite_race_hover.setPosition(GameConfig.dispWidth / 2 - this.sprite_race.getWidth() / 2, GameConfig.dispHeight - this.sprite_race.getHeight());
            this.tyre = Image.createImage((String)"/gamescreen/wheel_common.png");
            this.no_of_cars_in_garage = (GameConfig.main_level - 1) * 4 + (GameConfig.sub_level - 1);
            Log.debug("GameConfig.main_level: " + GameConfig.main_level);
            Log.debug("GameConfig.sub_level: " + GameConfig.sub_level);
            Log.debug("no_of_cars_in_garage: " + this.no_of_cars_in_garage);
            this.current_car_num = this.no_of_cars_in_garage;
            this.getLevelNumber();
        }
        catch (Exception e) {
            Log.debug("caught while reading images !");
        }
        MidletScreen.pingAnalytics("GarageScreen");
    }

    void draw(Graphics g) {
        this.g = g;
        g.drawImage(this.carselection_bgImage, 0, 0, 20);
        g.setColor(0xFFFFFF);
        this.obj_utilities.printCarsNumber(this.current_car_num + 1, this.no_of_cars_in_garage + 1, g);
        this.drawCar();
        if (!this.raceSelected) {
            this.sprite_race.paint(g);
        } else {
            this.sprite_race_hover.paint(g);
        }
        if (!this.prevSelected) {
            this.sprite_previous.paint(g);
        } else {
            this.sprite_previous_hover.paint(g);
        }
        if (!this.nextSelected) {
            this.sprite_next.paint(g);
        } else {
            this.sprite_next_hover.paint(g);
        }
    }

    private void drawCar() {
        try {
            this.sprite_car = new Sprite(Image.createImage((String)("/gamescreen/car_" + main_level + "_" + sub_level + ".png")));
            this.sprite_car.setPosition(GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2, 120);
            this.sprite_car.paint(this.g);
            if (main_level == 0) {
                this.tyre1_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 21;
                this.tyre2_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 101;
            }
            if (main_level == 2) {
                this.tyre1_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 23;
                this.tyre2_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 100;
            } else if (main_level == 3) {
                this.tyre1_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 19;
                this.tyre2_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 104;
            } else if (GameConfig.team_main_level == 4) {
                this.tyre1_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 22;
                this.tyre2_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 102;
            } else {
                this.tyre1_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 23;
                this.tyre2_xPos = GameConfig.dispWidth / 2 - this.sprite_car.getWidth() / 2 + 103;
            }
            this.g.drawImage(this.tyre, this.tyre1_xPos, 150, 20);
            this.g.drawImage(this.tyre, this.tyre2_xPos, 150, 20);
        }
        catch (Exception e) {
            System.out.println("caught in drawcar");
            e.printStackTrace();
        }
    }

    private void getLevelNumber() {
        if (this.current_car_num == 0) {
            main_level = 0;
            sub_level = 0;
        } else {
            sub_level = this.current_car_num % 4;
            if (sub_level == 0) {
                sub_level = 4;
                main_level = this.current_car_num / 4;
            } else {
                main_level = this.current_car_num / 4 + 1;
            }
        }
    }

    SetterGetter getAction(int x, int y) {
        SetterGetter obj = new SetterGetter();
        if (AssetsConfig.pointerSprite.collidesWith(this.sprite_previous, false)) {
            this.prevSelected = true;
            this.nextSelected = false;
            this.showPreviousCar();
        } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_next, false)) {
            this.nextSelected = true;
            this.prevSelected = false;
            this.showNextCar();
        } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_race, false)) {
            this.raceSelected = true;
            this.nextSelected = false;
            this.prevSelected = false;
            obj.setActionPerformed(StringConfig.PLAY);
            obj.setChangeScreen(true);
        }
        return obj;
    }

    private void showPreviousCar() {
        this.current_car_num = this.current_car_num > 0 ? --this.current_car_num : this.no_of_cars_in_garage;
        this.getLevelNumber();
    }

    private void showNextCar() {
        this.current_car_num = this.current_car_num < this.no_of_cars_in_garage ? ++this.current_car_num : 0;
        this.getLevelNumber();
    }

    void freeMemory() {
        this.carselection_bgImage = null;
        this.tyre = null;
        this.sprite_race = null;
        this.sprite_next = null;
        this.sprite_previous = null;
        this.sprite_race_hover = null;
        this.sprite_next_hover = null;
        this.sprite_previous_hover = null;
        Runtime.getRuntime().freeMemory();
        System.gc();
    }
}

