/*
 * Decompiled with CFR 0.152.
 */
package com.divum.screens;

import com.divum.configs.AssetsConfig;
import com.divum.configs.GameConfig;
import com.divum.configs.ImageNamesConfig;
import com.divum.configs.Log;
import com.divum.configs.SetterGetter;
import com.divum.configs.SoundEffect;
import com.divum.configs.StringConfig;
import com.divum.screens.BaseScreen;
import com.divum.screens.MidletScreen;
import com.divum.screens.SplashScreen;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MenuScreen
extends BaseScreen {
    Image menubgImage;
    Sprite race_sprite;
    Sprite race_hover_sprite;
    Sprite garage_sprite;
    Sprite garage_hover_sprite;
    Sprite more_sprite;
    Sprite more_hover_sprite;
    Sprite about_sprite;
    Sprite about_hover_sprite;
    Sprite help_sprite;
    Sprite help_hover_sprite;
    Sprite unmute_sprite;
    Sprite mute_sprite;
    Graphics g;
    int x_pos_menu = 10;
    boolean raceSelected;
    boolean garageSelected;
    boolean optionsSelected;
    boolean moreSelected;
    boolean aboutSelected;
    boolean helpSelected;

    public MenuScreen() {
        try {
            this.menubgImage = Image.createImage((String)ImageNamesConfig.MENU_BG);
            this.race_sprite = new Sprite(Image.createImage((String)"/menuscreen/race.png"));
            this.race_hover_sprite = new Sprite(Image.createImage((String)"/menuscreen/race-hover.png"));
            this.race_sprite.setPosition(this.x_pos_menu, 20);
            this.race_hover_sprite.setPosition(this.x_pos_menu, 20);
            this.garage_sprite = new Sprite(Image.createImage((String)"/menuscreen/garage.png"));
            this.garage_hover_sprite = new Sprite(Image.createImage((String)"/menuscreen/garage-hover.png"));
            this.garage_sprite.setPosition(this.x_pos_menu, 70);
            this.garage_hover_sprite.setPosition(this.x_pos_menu, 70);
            this.more_sprite = new Sprite(Image.createImage((String)"/menuscreen/more-games.png"));
            this.more_hover_sprite = new Sprite(Image.createImage((String)"/menuscreen/more-games-hover.png"));
            this.more_sprite.setPosition(this.x_pos_menu, 120);
            this.more_hover_sprite.setPosition(this.x_pos_menu, 120);
            this.about_sprite = new Sprite(Image.createImage((String)"/menuscreen/about-us.png"));
            this.about_hover_sprite = new Sprite(Image.createImage((String)"/menuscreen/about-us-hover.png"));
            this.about_sprite.setPosition(this.x_pos_menu + 10, 170);
            this.about_hover_sprite.setPosition(this.x_pos_menu + 10, 170);
            this.help_sprite = new Sprite(Image.createImage((String)"/menuscreen/help.png"));
            this.help_hover_sprite = new Sprite(Image.createImage((String)"/menuscreen/help-hover.png"));
            this.help_sprite.setPosition(this.x_pos_menu + this.about_sprite.getWidth() + 5, 170);
            this.help_hover_sprite.setPosition(this.x_pos_menu + this.about_sprite.getWidth() + 5, 170);
            this.unmute_sprite = new Sprite(Image.createImage((String)"/menuscreen/sound.png"));
            this.mute_sprite = new Sprite(Image.createImage((String)"/menuscreen/sound-hover.png"));
            this.unmute_sprite.setPosition(this.x_pos_menu + 2 * this.about_sprite.getWidth(), 170);
            this.mute_sprite.setPosition(this.x_pos_menu + 2 * this.about_sprite.getWidth(), 170);
            if (SplashScreen.sound_race == null) {
                SplashScreen.sound_race = new SoundEffect();
                SplashScreen.sound_race.loadSample(5);
                SplashScreen.sound_race.activeLoop();
            }
            SplashScreen.sound_race.play();
        }
        catch (Exception e) {
            Log.debug("caught while reading images");
        }
        MidletScreen.pingAnalytics("MenuScreen");
    }

    public void draw(Graphics g) {
        this.g = g;
        g.drawImage(this.menubgImage, 0, 0, 20);
        if (!this.raceSelected) {
            this.race_sprite.paint(g);
        } else {
            this.race_hover_sprite.paint(g);
        }
        if (!this.garageSelected) {
            this.garage_sprite.paint(g);
        } else {
            this.garage_hover_sprite.paint(g);
        }
        if (!GameConfig.isMute) {
            this.unmute_sprite.paint(g);
            SplashScreen.sound_race.play();
        } else {
            this.mute_sprite.paint(g);
            SplashScreen.sound_race.stopPlaying();
        }
        if (!this.moreSelected) {
            this.more_sprite.paint(g);
        } else {
            this.more_hover_sprite.paint(g);
        }
        if (!this.aboutSelected) {
            this.about_sprite.paint(g);
        } else {
            this.about_hover_sprite.paint(g);
        }
        if (!this.helpSelected) {
            this.help_sprite.paint(g);
        } else {
            this.help_hover_sprite.paint(g);
        }
    }

    public SetterGetter getAction(int x, int y) {
        SetterGetter obj = new SetterGetter();
        if (AssetsConfig.pointerSprite.collidesWith(this.race_sprite, false)) {
            this.raceSelected = true;
            obj.setActionPerformed(StringConfig.PLAY);
            obj.setChangeScreen(true);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.help_sprite, false)) {
            this.helpSelected = true;
            obj.setActionPerformed(StringConfig.HELP);
            obj.setChangeScreen(true);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.garage_sprite, false)) {
            this.garageSelected = true;
            obj.setActionPerformed(StringConfig.GARAGE);
            obj.setChangeScreen(true);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.about_sprite, false)) {
            this.aboutSelected = true;
            obj.setActionPerformed(StringConfig.ABOUT);
            obj.setChangeScreen(true);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.more_sprite, false)) {
            this.moreSelected = true;
            obj.setActionPerformed(StringConfig.MOREGAMES);
            obj.setChangeScreen(true);
        } else if (AssetsConfig.pointerSprite.collidesWith(this.unmute_sprite, false)) {
            GameConfig.isMute = !GameConfig.isMute;
        }
        return obj;
    }

    void freeMemory() {
        this.menubgImage = null;
        this.race_sprite = null;
        this.race_hover_sprite = null;
        this.garage_sprite = null;
        this.garage_hover_sprite = null;
        this.more_sprite = null;
        this.more_hover_sprite = null;
        this.unmute_sprite = null;
        this.mute_sprite = null;
        this.about_sprite = null;
        this.about_hover_sprite = null;
        this.help_sprite = null;
        this.help_hover_sprite = null;
        Runtime.getRuntime().freeMemory();
        System.gc();
    }
}

