/*
 * Decompiled with CFR 0.152.
 */
package com.divum.configs;

import java.util.Vector;
import javax.microedition.lcdui.Font;

public class StringUtil {
    static boolean flag = true;

    private StringUtil() {
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    public static String replace(String s, String f, String r) {
        if (s == null) {
            return s;
        }
        if (f == null) {
            return s;
        }
        if (r == null) {
            r = "";
        }
        int index01 = s.indexOf(f);
        while (index01 != -1) {
            s = String.valueOf(s.substring(0, index01)) + r + s.substring(index01 + f.length());
            index01 += r.length();
            index01 = s.indexOf(f, index01);
        }
        return s;
    }

    public static String removeHtml2(String text) {
        try {
            int idx = text.indexOf("<");
            if (idx == -1) {
                text = StringUtil.decodeEntities(text);
                return text;
            }
            String htmlText = text;
            int htmlStartIndex = htmlText.indexOf("<", 0);
            if (htmlStartIndex == -1) {
                return text;
            }
            htmlText = StringUtil.replace(htmlText, "</p>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<br/>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<br>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "\n\n", "\r\n");
            htmlText = StringUtil.replace(htmlText, "</A>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<i>", "");
            htmlText = StringUtil.replace(htmlText, "<b>", "");
            htmlText = StringUtil.replace(htmlText, "</b>", "");
            htmlText = StringUtil.replace(htmlText, "</i>", "");
            htmlText = StringUtil.replace(htmlText, "</BR>", "");
            htmlText = StringUtil.replace(htmlText, "<BR>", "");
            htmlText = StringUtil.replace(htmlText, "<B>", "");
            htmlText = StringUtil.replace(htmlText, "</B>", "");
            return htmlText;
        }
        catch (Exception e) {
            System.out.println("Error while removing HTML: " + e.toString());
            return text;
        }
    }

    public static String decodeEntities(String html) {
        String result = StringUtil.replace(html, "&lt;", "<");
        result = StringUtil.replace(result, "&gt;", ">");
        result = StringUtil.replace(result, "&nbsp;", " ");
        result = StringUtil.replace(result, "&amp;", "&");
        result = StringUtil.replace(result, "&auml;", "\u00e4");
        result = StringUtil.replace(result, "&ouml;", "\u00f6");
        result = StringUtil.replace(result, "&quot;", "'");
        result = StringUtil.replace(result, "&lquot;", "'");
        result = StringUtil.replace(result, "&rquot;", "'");
        result = StringUtil.replace(result, "&#xd;", "\r");
        result = StringUtil.replace(result, "&amp;", " ");
        result = StringUtil.replace(result, "&dagger;", " ");
        result = StringUtil.replace(result, "\u00c2", "");
        return result;
    }

    public static String removeHtml(String text) {
        try {
            int idx = text.indexOf("<");
            if (idx == -1) {
                text = StringUtil.decodeEntities(text);
                return text;
            }
            String plainText = "";
            String htmlText = text;
            int htmlStartIndex = htmlText.indexOf("<", 0);
            if (htmlStartIndex == -1) {
                return text;
            }
            htmlText = StringUtil.replace(htmlText, "</p>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<br/>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<br>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "\n\n", "\r\n");
            htmlText = StringUtil.replace(htmlText, "</A>", "\r\n");
            htmlText = StringUtil.replace(htmlText, "<i>", "");
            htmlText = StringUtil.replace(htmlText, "<b>", "");
            htmlText = StringUtil.replace(htmlText, "</b>", "");
            htmlText = StringUtil.replace(htmlText, "</i>", "");
            htmlText = StringUtil.replace(htmlText, "</BR>", "");
            htmlText = StringUtil.replace(htmlText, "<BR>", "");
            htmlText = StringUtil.replace(htmlText, "<B>", "");
            htmlText = StringUtil.replace(htmlText, "</B>", "");
            if (flag) {
                boolean concat = true;
                int i = 0;
                while (i < htmlText.length()) {
                    if (htmlText.charAt(i) == '<') {
                        concat = false;
                    } else if (htmlText.charAt(i) == '>') {
                        concat = true;
                    }
                    if (concat) {
                        plainText = String.valueOf(plainText) + htmlText.charAt(i);
                    }
                    ++i;
                }
                plainText = StringUtil.replace(plainText, ">", "");
                plainText = plainText.trim();
                plainText = StringUtil.decodeEntities(plainText);
                return plainText;
            }
            return htmlText;
        }
        catch (Exception e) {
            System.out.println("Error while removing HTML: " + e.toString());
            return text;
        }
    }

    public static String[] formatMessage(String[] message, int width, Font font) {
        Vector<String> result = new Vector<String>(message.length);
        int i = 0;
        while (i < message.length) {
            if (font.stringWidth(message[i]) <= width) {
                result.addElement(message[i]);
            } else {
                String[] splitUp = StringUtil.chopStrings(message[i], " ", font, width);
                int j = 0;
                while (j < splitUp.length) {
                    result.addElement(splitUp[j]);
                    ++j;
                }
            }
            ++i;
        }
        String[] finalResult = new String[result.size()];
        int i2 = 0;
        while (i2 < finalResult.length) {
            finalResult[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return finalResult;
    }

    public static String[] chopStrings(String origional, String separator, Font font, int width) {
        String[] words = StringUtil.split(origional, separator);
        Vector<String> result = new Vector<String>();
        StringBuffer currentLine = new StringBuffer();
        int currentWidth = 0;
        int i = 0;
        while (i < words.length) {
            String currentToken = words[i];
            if (currentWidth == 0 || currentWidth + font.stringWidth(" " + currentToken) <= width) {
                if (currentWidth == 0) {
                    currentLine.append(currentToken);
                    currentWidth += font.stringWidth(currentToken);
                } else {
                    currentLine.append(' ').append(currentToken);
                    currentWidth += font.stringWidth(" " + currentToken);
                }
            } else {
                result.addElement(currentLine.toString());
                currentLine.delete(0, currentLine.length());
                currentLine.append(currentToken);
                currentWidth = font.stringWidth(currentToken);
            }
            ++i;
        }
        if (currentLine.length() != 0) {
            String[] lines = StringUtil.split(currentLine.toString(), "\n");
            int line = 0;
            while (line < lines.length) {
                result.addElement(lines[line]);
                ++line;
            }
        }
        String[] finalResult = new String[result.size()];
        int i2 = 0;
        while (i2 < finalResult.length) {
            finalResult[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return finalResult;
    }
}

