/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.PickerContainer;
import com.nokia.lwuit.components.PickerItemContainer;
import com.nokia.lwuit.components.PickerItemContainerListener;
import com.nokia.lwuit.components.UnitPickerListener;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.ComponentGroup;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class UnitPicker
extends Form
implements ActionListener,
PickerItemContainerListener {
    private static final String ON = UIManager.getInstance().localize("On", "On");
    private static final String OFF = UIManager.getInstance().localize("Off", "Off");
    private static final String OK_TEXT = UIManager.getInstance().localize("ok", "OK");
    private boolean pickerOpen = false;
    private CheckBox pickerOnOffSwitch;
    private Label unitPickerLabel;
    private Label itemNameLabel;
    private Label statuslabel;
    private Label unithPIContainerLabel;
    private Label tenthPIContainerLabel;
    private Label hundrethPIContainerLabel;
    private Label unitInitialPIContainerLabel;
    private Vector twoCharUnitInitails;
    private Vector unitValues;
    private Container pickerNameValueCont;
    private PickerContainer unitValuesContainer;
    private PickerItemContainer unithPIContainer;
    private PickerItemContainer tenthPIContainer;
    private PickerItemContainer hundrethPIContainer;
    private PickerItemContainer unitInitialPIContainer;
    private Command okCommand;
    private Command backCommand;
    private UnitPickerListener unitPickerListener;
    private Form previousForm;
    int cachedLeftBit;
    int cachedMiddleBit;
    int cachedRightBit;
    String cachedUnitInitial;

    private UnitPicker() {
    }

    public UnitPicker(String unitPickerLabelString, String itemNameString, Vector unitInitails) {
        this.setUIID("Form");
        if (this.isNullOrEmpty(unitPickerLabelString) || this.isNullOrEmpty(itemNameString)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        if (unitInitails == null || unitInitails.isEmpty()) {
            throw new IllegalArgumentException("Unit initials vector cannot be null or empty");
        }
        this.setLayout(new BoxLayout(2));
        this.okCommand = new Command(OK_TEXT);
        this.backCommand = new Command("Back");
        this.addCommandListener(this);
        this.twoCharUnitInitails = unitInitails;
        this.unitPickerLabel = new Label(unitPickerLabelString);
        this.unitPickerLabel.getStyle().setAlignment(1);
        this.statuslabel = new Label(OFF);
        this.statuslabel.setUIID("UnitPickerStatusLabel");
        this.statuslabel.getStyle().setAlignment(1);
        this.itemNameLabel = new Label(itemNameString);
        this.itemNameLabel.getStyle().setAlignment(1);
        this.unitValues = new Vector();
        for (int i = 0; i < 10; ++i) {
            this.unitValues.addElement(String.valueOf(i));
        }
        this.unithPIContainerLabel = new Label("");
        this.tenthPIContainerLabel = new Label("");
        this.hundrethPIContainerLabel = new Label("");
        this.unitInitialPIContainerLabel = new Label("");
        this.unithPIContainerLabel.setUIID("DatePickerValue");
        this.tenthPIContainerLabel.setUIID("DatePickerValue");
        this.hundrethPIContainerLabel.setUIID("DatePickerValue");
        this.unitInitialPIContainerLabel.setUIID("DatePickerValue");
        Font font = Font.createDirectUtilsSystemFont(0, 1, 26);
        this.setFont(this.unithPIContainerLabel, font);
        this.setFont(this.tenthPIContainerLabel, font);
        this.setFont(this.hundrethPIContainerLabel, font);
        this.setFont(this.unitInitialPIContainerLabel, font);
        this.unithPIContainerLabel.getStyle().setMargin(0, 0, 0, 0);
        this.tenthPIContainerLabel.getStyle().setMargin(0, 0, 0, 0);
        this.hundrethPIContainerLabel.getStyle().setMargin(0, 0, 0, 0);
        this.unitInitialPIContainerLabel.getStyle().setMargin(0, 0, 5, 10);
        this.unitValuesContainer = new PickerContainer();
        this.unitValuesContainer.setLayout(new GridLayout(1, 4));
        this.unithPIContainer = new PickerItemContainer(this.unitValues, this.unithPIContainerLabel);
        this.tenthPIContainer = new PickerItemContainer(this.unitValues, this.tenthPIContainerLabel);
        this.hundrethPIContainer = new PickerItemContainer(this.unitValues, this.hundrethPIContainerLabel);
        this.unitInitialPIContainer = new PickerItemContainer(this.twoCharUnitInitails, this.unitInitialPIContainerLabel);
        this.unitInitialPIContainer.setCyclic(false);
        this.unithPIContainer.setDataChangeListener(this);
        this.tenthPIContainer.setDataChangeListener(this);
        this.hundrethPIContainer.setDataChangeListener(this);
        this.unitInitialPIContainer.setDataChangeListener(this);
        this.unitValuesContainer.addComponent(this.hundrethPIContainer);
        this.unitValuesContainer.addComponent(this.tenthPIContainer);
        this.unitValuesContainer.addComponent(this.unithPIContainer);
        this.unitValuesContainer.addComponent(this.unitInitialPIContainer);
        Container statusCont = new Container(new BorderLayout());
        Container leftChildCont = new Container(new GridLayout(2, 1));
        leftChildCont.addComponent(this.unitPickerLabel);
        leftChildCont.addComponent(this.statuslabel);
        ComponentGroup checkboxGroup = new ComponentGroup();
        checkboxGroup.getStyle().setMargin(3, 10);
        this.pickerOnOffSwitch = new CheckBox();
        this.pickerOnOffSwitch.getStyle().setMargin(0, 0, 0, 0);
        this.pickerOnOffSwitch.getPressedStyle().setBgTransparency(0);
        checkboxGroup.addComponent(this.pickerOnOffSwitch);
        FlowLayout fl = new FlowLayout();
        fl.setValign(4);
        Container pickerOnOffSwitchCont = new Container(fl);
        pickerOnOffSwitchCont.addComponent(checkboxGroup);
        this.pickerOnOffSwitch.addActionListener(this);
        statusCont.addComponent("Center", (Component)leftChildCont);
        statusCont.addComponent("East", (Component)pickerOnOffSwitchCont);
        this.pickerNameValueCont = new Container(new BorderLayout());
        Container pickerValueCont = new Container(new BoxLayout(1));
        pickerValueCont.addComponent(this.hundrethPIContainerLabel);
        pickerValueCont.addComponent(this.tenthPIContainerLabel);
        pickerValueCont.addComponent(this.unithPIContainerLabel);
        pickerValueCont.addComponent(this.unitInitialPIContainerLabel);
        this.pickerNameValueCont.addComponent("Center", (Component)this.itemNameLabel);
        this.pickerNameValueCont.addComponent("East", (Component)pickerValueCont);
        this.addComponent(statusCont);
        this.addComponent(this.pickerNameValueCont);
        this.addComponent(this.unitValuesContainer);
        this.addCommand(this.okCommand);
        this.setBackCommand(this.backCommand);
        this.setScrollable(false);
        this.setUnitPickerOn(false);
    }

    public boolean isUnitPickerOn() {
        return this.pickerOpen;
    }

    public void setUnitPickerOn(boolean on) {
        this.pickerOpen = on;
        if (this.pickerOpen) {
            this.showUnitPicker();
        } else {
            this.hideUnitPicker();
        }
    }

    public void setValue(int leftBit, int middleBit, int rightBit, String unit) {
        if (this.hundrethPIContainer.setSelectedValue(String.valueOf(leftBit)) == -1) {
            throw new IllegalArgumentException("Value of left bit must be in range 0 to 9");
        }
        if (this.tenthPIContainer.setSelectedValue(String.valueOf(middleBit)) == -1) {
            throw new IllegalArgumentException("Value of middle bit must be in range 0 to 9");
        }
        if (this.unithPIContainer.setSelectedValue(String.valueOf(rightBit)) == -1) {
            throw new IllegalArgumentException("Value of right bit must be in range 0 to 9");
        }
        if (this.unitInitialPIContainer.setSelectedValue(unit) == -1) {
            throw new IllegalArgumentException("Value of unit is not valid");
        }
        if (String.valueOf(this.hundrethPIContainer.getSelectedValue()).equals("0") && String.valueOf(this.tenthPIContainer.getSelectedValue()).equals("0") && String.valueOf(this.unithPIContainer.getSelectedValue()).equals("0")) {
            this.setUnitPickerOn(false);
        } else {
            this.setUnitPickerOn(true);
        }
    }

    public String getValue() {
        String value = String.valueOf(this.hundrethPIContainer.getSelectedValue()) + String.valueOf(this.tenthPIContainer.getSelectedValue()) + String.valueOf(this.unithPIContainer.getSelectedValue()) + " " + String.valueOf(this.unitInitialPIContainer.getSelectedValue());
        return value;
    }

    private void setFont(Label label, Font font) {
        Style style = label.getStyle();
        style.setFont(font, true);
        label.setSelectedStyle(style);
        label.setUnselectedStyle(style);
        label.setPressedStyle(style);
        label.setDisabledStyle(style);
    }

    private void cacheValues() {
        this.cachedLeftBit = Integer.parseInt(String.valueOf(this.hundrethPIContainer.getSelectedValue()));
        this.cachedMiddleBit = Integer.parseInt(String.valueOf(this.tenthPIContainer.getSelectedValue()));
        this.cachedRightBit = Integer.parseInt(String.valueOf(this.unithPIContainer.getSelectedValue()));
        this.cachedUnitInitial = String.valueOf(this.unitInitialPIContainer.getSelectedValue());
    }

    private void setCachedValue() {
        this.setValue(this.cachedLeftBit, this.cachedMiddleBit, this.cachedRightBit, this.cachedUnitInitial);
    }

    public void show() {
        this.previousForm = Display.getInstance().getCurrent();
        this.cacheValues();
        super.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.okCommand) {
            if (String.valueOf(this.hundrethPIContainer.getSelectedValue()).equals("0") && String.valueOf(this.tenthPIContainer.getSelectedValue()).equals("0") && String.valueOf(this.unithPIContainer.getSelectedValue()).equals("0")) {
                this.setUnitPickerOn(false);
            }
            if (this.unitPickerListener != null) {
                if (this.previousForm != null) {
                    this.previousForm.show();
                }
                this.unitPickerListener.notifyUnitPickerListener(this);
            }
        }
        if (evt.getSource() == this.backCommand) {
            this.setCachedValue();
            if (this.unitPickerListener != null) {
                if (this.previousForm != null) {
                    this.previousForm.show();
                }
                this.unitPickerListener.notifyUnitPickerListener(this);
            }
        }
        if (evt.getSource() == this.pickerOnOffSwitch) {
            this.setUnitPickerOn(this.pickerOnOffSwitch.isSelected());
        }
    }

    private void showUnitPicker() {
        this.statuslabel.setText(ON);
        this.pickerNameValueCont.setVisible(true);
        this.unitValuesContainer.setVisible(true);
        this.pickerOnOffSwitch.setSelected(true);
        this.repaint();
    }

    private void hideUnitPicker() {
        this.statuslabel.setText(OFF);
        this.unitInitialPIContainer.setSelectedIndex(0);
        this.unithPIContainer.setSelectedIndex(0);
        this.tenthPIContainer.setSelectedIndex(0);
        this.hundrethPIContainer.setSelectedIndex(0);
        this.pickerNameValueCont.setVisible(false);
        this.unitValuesContainer.setVisible(false);
        this.pickerOnOffSwitch.setSelected(false);
        this.repaint();
    }

    public void setUnitPickerListener(UnitPickerListener listener) {
        this.unitPickerListener = listener;
    }

    public UnitPickerListener getUnitPickerListener() {
        return this.unitPickerListener;
    }

    public void notifyPickerItemContainerListener(PickerItemContainer container) {
    }

    private boolean isNullOrEmpty(String text) {
        if (text == null) {
            return true;
        }
        return text.equals("");
    }
}

