/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class RadioButton
extends Button {
    private boolean selected = false;
    private ButtonGroup group;
    private boolean oppositeSide;

    public RadioButton(String text) {
        this(text, (Image)null);
    }

    public RadioButton() {
        this("");
    }

    public RadioButton(Image icon) {
        this("", icon);
    }

    public RadioButton(String text, Image icon) {
        super(text, icon);
        this.setUIID("RadioButton");
        this.updateSide();
    }

    public String toString() {
        return "Radio Button " + this.getText();
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel l = UIManager.getInstance().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getRadioButtonImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelectedImpl(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public void setSelected(boolean selected) {
        this.setSelectedImpl(selected);
        if (this.group != null && selected) {
            this.group.setSelected(this);
        }
    }

    public void released(int x, int y) {
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        super.released(x, y);
    }

    public void paint(Graphics g) {
        if (this.isToggle()) {
            UIManager.getInstance().getLookAndFeel().drawButton(g, this);
        } else {
            UIManager.getInstance().getLookAndFeel().drawRadioButton(g, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getRadioButtonPreferredSize(this);
    }

    void setButtonGroup(ButtonGroup group) {
        this.group = group;
    }

    void fireActionEvent() {
        if (this.group != null) {
            this.group.setSelected(this);
        }
        super.fireActionEvent();
    }

    public void setGroup(String groupName) {
        this.putClientProperty("$group", groupName);
        this.initNamedGroup();
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.initNamedGroup();
    }

    private void updateSide() {
        Boolean v = UIManager.getInstance().isThemeConstant("radioOppositeSideBool");
        if (v != null) {
            this.oppositeSide = v;
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.updateSide();
    }

    private void initNamedGroup() {
        String s;
        if (this.isInitialized() && (s = this.getGroup()) != null) {
            Form f = this.getComponentForm();
            ButtonGroup b = (ButtonGroup)f.getClientProperty("$radio" + s);
            if (b == null) {
                b = new ButtonGroup();
                f.putClientProperty("$radio" + s, b);
            }
            b.add(this);
        }
    }

    public String getGroup() {
        return (String)this.getClientProperty("$group");
    }

    public boolean isOppositeSide() {
        return this.oppositeSide;
    }

    public void setOppositeSide(boolean oppositeSide) {
        this.oppositeSide = oppositeSide;
    }
}

