/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Vector;

class HTMLInputFormat {
    private static char[] literals = new char[]{'a', 'A', 'n', 'N', 'x', 'X', 'm', 'M'};
    private static int[] literalConstraints = new int[]{9, 10, 12, 4, 13, 14, 17, 18};
    private int minLength;
    private int maxLength;
    private Vector formatConstraints = new Vector();

    static HTMLInputFormat getInputFormat(String formatString) {
        if (formatString == null) {
            return null;
        }
        try {
            HTMLInputFormat format = new HTMLInputFormat(formatString);
            if (format.formatConstraints.size() == 0) {
                return null;
            }
            return format;
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + " at input format string " + formatString);
            return null;
        }
    }

    private HTMLInputFormat(String formatString) {
        String count = "";
        for (int i = 0; i < formatString.length(); ++i) {
            char c = formatString.charAt(i);
            if (c == '*') {
                if (!count.equals("")) {
                    throw new IllegalArgumentException("Malformed format string. The wildcard * can't appear after any other count indicator.");
                }
                count = count + c;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (count.equals("*")) {
                    throw new IllegalArgumentException("Malformed format string. Count indicators cannot appear after the wildcard *");
                }
                count = count + c;
                continue;
            }
            int constraint = -1;
            for (int j = 0; j < literals.length; ++j) {
                if (c != literals[j]) continue;
                constraint = literalConstraints[j];
                break;
            }
            if (constraint == -1) {
                throw new IllegalArgumentException("Malformed format string. Unrecognized literal " + c);
            }
            FormatConstraint fc = new FormatConstraint(constraint, count);
            this.formatConstraints.addElement(fc);
            if (this.maxLength != Integer.MAX_VALUE) {
                this.maxLength = fc.count == Integer.MIN_VALUE ? ++this.maxLength : (fc.count == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.maxLength += fc.count));
            }
            if (fc.count == Integer.MIN_VALUE) {
                ++this.minLength;
            }
            count = "";
        }
    }

    TextArea applyConstraints(TextArea ta) {
        int widestConstraint = 0;
        Enumeration e = this.formatConstraints.elements();
        while (e.hasMoreElements()) {
            FormatConstraint constraint = (FormatConstraint)e.nextElement();
            for (int i = 1; i <= 16; i *= 2) {
                if ((constraint.type & i) == 0) continue;
                widestConstraint |= i;
            }
        }
        if (this.maxLength != Integer.MAX_VALUE) {
            ta.setMaxSize(this.maxLength);
        }
        if (widestConstraint == 4) {
            ta.setConstraint(ta.getConstraint() | 2);
        }
        if (ta instanceof TextField) {
            TextField tf = (TextField)ta;
            if ((widestConstraint & 8) == 0 && (widestConstraint & 0x10) == 0) {
                tf = new TextField(ta.getText()){

                    protected void showSymbolDialog() {
                    }
                };
                ta = tf;
            }
            if ((widestConstraint & 0x10) != 0) {
                if ((widestConstraint & 2) != 0) {
                    tf.setInputMode("ABC");
                } else {
                    tf.setInputMode("abc");
                }
            } else {
                if ((widestConstraint & 1) == 0) {
                    this.excludeInputMode(tf, "abc");
                    this.excludeInputMode(tf, "Abc");
                }
                if ((widestConstraint & 2) == 0) {
                    this.excludeInputMode(tf, "ABC");
                    this.excludeInputMode(tf, "Abc");
                }
                if ((widestConstraint & 4) == 0) {
                    this.excludeInputMode(tf, "123");
                }
            }
        }
        return ta;
    }

    private void excludeInputMode(TextField tf, String modeToExclude) {
        String[] curModes = tf.getInputModeOrder();
        String[] newModes = new String[curModes.length - 1];
        int j = 0;
        for (int i = 0; i < curModes.length; ++i) {
            if (curModes[i].equals(modeToExclude)) continue;
            if (j < newModes.length) {
                newModes[j] = curModes[i];
                ++j;
                continue;
            }
            return;
        }
        tf.setInputModeOrder(newModes);
    }

    boolean verifyString(String str) {
        if (str.length() > this.maxLength || str.length() < this.minLength) {
            return false;
        }
        int i = 0;
        Enumeration e = this.formatConstraints.elements();
        if (!str.equals("")) {
            char c = str.charAt(i);
            while (e.hasMoreElements()) {
                FormatConstraint constraint = (FormatConstraint)e.nextElement();
                if (constraint.count == Integer.MIN_VALUE) {
                    if (!this.verifyChar(c, constraint.type)) {
                        return false;
                    }
                    if (++i >= str.length()) break;
                    c = str.charAt(i);
                    continue;
                }
                for (int charNum = 0; i < str.length() && charNum < constraint.count && this.verifyChar(c, constraint.type); ++charNum) {
                    if (++i >= str.length()) break;
                    c = str.charAt(i);
                }
                if (i < str.length()) continue;
                break;
            }
            if (i < str.length()) {
                return false;
            }
        }
        while (e.hasMoreElements()) {
            FormatConstraint constraint = (FormatConstraint)e.nextElement();
            if (constraint.count != Integer.MIN_VALUE) continue;
            return false;
        }
        return true;
    }

    private boolean verifyChar(char c, int constraint) {
        if ((constraint & 0x10) != 0 || (constraint & 4) != 0 && c >= '0' && c <= '9' || (constraint & 2) != 0 && c >= 'A' && c <= 'Z' || (constraint & 1) != 0 && c >= 'a' && c <= 'z') {
            return true;
        }
        if ((constraint & 8) != 0) {
            char[] symbols = TextField.getSymbolTable();
            for (int i = 0; i < symbols.length; ++i) {
                if (symbols[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String str = "";
        String followedBy = "";
        int lastType = -1;
        String lastString = "";
        int singlesCount = 0;
        Enumeration e = this.formatConstraints.elements();
        while (e.hasMoreElements()) {
            FormatConstraint constraint = (FormatConstraint)e.nextElement();
            if (constraint.count == Integer.MIN_VALUE) {
                if (lastType != -1) {
                    if (lastType != constraint.type) {
                        str = str + followedBy + singlesCount + lastString;
                        followedBy = " followed by ";
                        singlesCount = 1;
                        lastType = constraint.type;
                        lastString = constraint.toString();
                        continue;
                    }
                    ++singlesCount;
                    continue;
                }
                lastType = constraint.type;
                lastString = constraint.toString();
                singlesCount = 1;
                continue;
            }
            if (lastType != -1) {
                str = str + followedBy + singlesCount + lastString;
                followedBy = " followed by ";
                lastType = -1;
                singlesCount = 0;
                lastString = "";
            }
            str = str + followedBy + constraint.toString();
            followedBy = " followed by ";
        }
        if (lastType != -1) {
            str = str + followedBy + singlesCount + lastString;
        }
        return str;
    }

    class FormatConstraint {
        static final int TYPE_LOWERCASE = 1;
        static final int TYPE_UPPERCASE = 2;
        static final int TYPE_NUMERIC = 4;
        static final int TYPE_SYMBOL = 8;
        static final int TYPE_ANY = 16;
        static final int COUNT_EXACTLY_ONE = Integer.MIN_VALUE;
        static final int COUNT_NO_LIMIT = Integer.MAX_VALUE;
        int type;
        int count;

        FormatConstraint(int type, String countStr) {
            if (countStr.equals("*")) {
                this.count = Integer.MAX_VALUE;
            } else if (countStr.equals("")) {
                this.count = Integer.MIN_VALUE;
            } else {
                try {
                    this.count = Integer.parseInt(countStr);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Invalid FormatConstraint count " + countStr);
                }
            }
            this.type = type;
        }

        public String toString() {
            String str = "";
            if (this.count != Integer.MIN_VALUE) {
                str = this.count == Integer.MAX_VALUE ? str + UIManager.getInstance().localize("html.format.anynumber", "any number of") : str + UIManager.getInstance().localize("html.format.upto", "up to") + " " + this.count;
            }
            str = str + " ";
            String orString = " " + UIManager.getInstance().localize("html.format.or", "or") + " ";
            String or = "";
            if ((this.type & 0x10) != 0) {
                str = str + "any";
            } else {
                if ((this.type & 1) != 0) {
                    str = str + UIManager.getInstance().localize("html.format.lowercase", "lowercase");
                    or = orString;
                }
                if ((this.type & 2) != 0) {
                    str = str + or + UIManager.getInstance().localize("html.format.uppercase", "uppercase");
                    or = orString;
                }
                if ((this.type & 4) != 0) {
                    str = str + or + UIManager.getInstance().localize("html.format.numeric", "numeric");
                    or = orString;
                }
                if ((this.type & 8) != 0) {
                    str = str + or + UIManager.getInstance().localize("html.format.symbol", "symbol");
                }
            }
            str = str + " ";
            str = this.count != Integer.MIN_VALUE && this.count != 1 ? str + UIManager.getInstance().localize("html.format.chars", "characters") : str + UIManager.getInstance().localize("html.format.char", "character");
            return str;
        }
    }
}

