/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.CSSParser;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLElement;
import com.sun.lwuit.html.HTMLUtils;
import com.sun.lwuit.xml.Element;
import com.sun.lwuit.xml.XMLParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class HTMLParser
extends XMLParser {
    HTMLComponent htmlC;
    private static String[] EMPTY_TAGS = new String[]{"br", "link", "meta", "base", "area", "basefont", "col", "frame", "hr", "img", "input", "isindex", "param"};

    public HTMLParser() {
        this.addCharEntity("bull", 8226);
        this.addCharEntity("euro", 8364);
        this.setIncludeWhitespacesBetweenTags(true);
    }

    void setHTMLComponent(HTMLComponent htmlC) {
        if (htmlC != null && this.htmlC != null) {
            throw new IllegalStateException("This HTMLParser is already paired with an HTMLComponent");
        }
        this.htmlC = htmlC;
    }

    protected void parseTagContent(Element element, Reader is) throws IOException {
        if (this.htmlC.loadCSS && ((HTMLElement)element).getTagId() == 54) {
            CSSElement addTo = CSSParser.getInstance().parseCSSSegment(is, null, this.htmlC, null);
            this.htmlC.addToEmebeddedCSS(addTo);
            return;
        }
        super.parseTagContent(element, is);
    }

    protected Element createNewElement(String name) {
        HTMLElement elem = new HTMLElement(name);
        return elem;
    }

    protected Element createNewTextElement(String text) {
        HTMLElement elem = new HTMLElement(text, true);
        return elem;
    }

    protected String convertCharEntity(String charEntity) {
        try {
            return HTMLUtils.convertCharEntity(charEntity, true, null);
        }
        catch (IllegalArgumentException iae) {
            return super.convertCharEntity(charEntity);
        }
    }

    protected boolean isEmptyTag(String tagName) {
        boolean found = false;
        for (int i = 0; i < EMPTY_TAGS.length && !found; ++i) {
            if (!tagName.equals(EMPTY_TAGS[i])) continue;
            found = true;
        }
        return found;
    }

    public HTMLElement parseHTML(InputStreamReader isr) {
        return (HTMLElement)super.parse(isr);
    }

    protected String getSupportedStandardName() {
        return "XHTML-MP 1.0";
    }

    protected boolean isSupported(Element element) {
        return ((HTMLElement)element).getTagId() != -1;
    }

    protected boolean shouldEvaluate(Element element) {
        return ((HTMLElement)element).getTagId() != -1 || !element.getTagName().equalsIgnoreCase("script");
    }
}

