/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.PeerComponent;
import com.sun.lwuit.VideoComponent;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class LWUITImplementation {
    private static final char RTL_RANGE_BEGIN = '\u0590';
    private static final char RTL_RANGE_END = '\u07bf';
    private Object lightweightClipboard;
    private Hashtable linearGradientCache;
    private Hashtable radialGradientCache;
    private boolean builtinSoundEnabled = true;
    private int dragEventCounter = 0;
    private int dragStartPercentage = 5;
    private int dragStartPixels = 20;
    private boolean dragStarted = false;
    private Form currentForm;
    private static Object displayLock;
    private Animation[] paintQueue = new Animation[50];
    private Animation[] paintQueueTemp = new Animation[50];
    private int paintQueueFill = 0;
    private Graphics lwuitGraphics;
    private static boolean bidi;
    private int[] xPointerEvent = new int[1];
    private int[] yPointerEvent = new int[1];
    private int pointerPressedX;
    private int pointerPressedY;
    private Hashtable builtinSounds = new Hashtable();

    public abstract void init(Object var1);

    public void initEDT() {
    }

    public void deinitialize() {
    }

    public void playDialogSound(int type) {
    }

    public void vibrate(int duration) {
    }

    public void flashBacklight(int duration) {
    }

    public abstract int getDisplayWidth();

    public abstract int getDisplayHeight();

    public boolean handleEDTException(Throwable err) {
        return false;
    }

    public abstract void editString(Component var1, int var2, int var3, String var4, int var5);

    public void saveTextEditingState() {
    }

    public boolean hasPendingPaints() {
        return this.paintQueueFill != 0;
    }

    public Object getVideoControl(Object player) {
        return null;
    }

    public int numAlphaLevels() {
        return 255;
    }

    public int numColors() {
        return 65536;
    }

    public Graphics getComponentScreenGraphics(Component cmp, Graphics currentContext) {
        return currentContext;
    }

    protected void paintOverlay(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirty() {
        int size = 0;
        Object object = displayLock;
        synchronized (object) {
            size = this.paintQueueFill;
            System.arraycopy(this.paintQueue, 0, this.paintQueueTemp, 0, this.paintQueueFill);
            this.paintQueue = new Animation[50];
            this.paintQueueFill = 0;
        }
        if (size > 0) {
            Graphics wrapper = this.getLWUITGraphics();
            int topX = this.getDisplayWidth();
            int topY = this.getDisplayHeight();
            int bottomX = 0;
            int bottomY = 0;
            for (int iter = 0; iter < size; ++iter) {
                Animation ani = this.paintQueueTemp[iter];
                if (ani == null) continue;
                this.paintQueueTemp[iter] = null;
                wrapper.translate(-wrapper.getTranslateX(), -wrapper.getTranslateY());
                wrapper.setClip(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                if (ani instanceof Component) {
                    Component cmp = (Component)ani;
                    Rectangle dirty = cmp.getDirtyRegion();
                    if (dirty != null) {
                        wrapper.setClip(dirty.getX(), dirty.getY(), dirty.getSize().getWidth(), dirty.getSize().getHeight());
                        cmp.setDirtyRegion(null);
                    }
                    cmp.paintComponent(wrapper);
                    int cmpAbsX = cmp.getAbsoluteX() + cmp.getScrollX();
                    topX = Math.min(cmpAbsX, topX);
                    bottomX = Math.max(cmpAbsX + cmp.getWidth(), bottomX);
                    int cmpAbsY = cmp.getAbsoluteY() + cmp.getScrollY();
                    topY = Math.min(cmpAbsY, topY);
                    bottomY = Math.max(cmpAbsY + cmp.getHeight(), bottomY);
                    continue;
                }
                bottomX = this.getDisplayWidth();
                bottomY = this.getDisplayHeight();
                topX = 0;
                topY = 0;
                ani.paint(wrapper);
            }
            this.paintOverlay(wrapper);
            this.flushGraphics(topX, topY, bottomX - topX, bottomY - topY);
        }
    }

    public void edtIdle(boolean enter) {
    }

    public abstract void flushGraphics(int var1, int var2, int var3, int var4);

    public abstract void flushGraphics();

    protected Graphics getLWUITGraphics() {
        return this.lwuitGraphics;
    }

    public void setLWUITGraphics(Graphics g) {
        this.lwuitGraphics = g;
    }

    public void setDisplayLock(Object lock) {
        displayLock = lock;
    }

    public Object getDisplayLock() {
        return displayLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRepaint(Animation cmp) {
        Object object = displayLock;
        synchronized (object) {
            for (int iter = 0; iter < this.paintQueueFill; ++iter) {
                if (this.paintQueue[iter] != cmp) continue;
                this.paintQueue[iter] = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(Animation cmp) {
        Object object = displayLock;
        synchronized (object) {
            for (int iter = 0; iter < this.paintQueueFill; ++iter) {
                Animation ani = this.paintQueue[iter];
                if (ani != cmp) continue;
                return;
            }
            if (this.paintQueueFill >= this.paintQueue.length) {
                System.out.println("Warning paint queue size exceeded, please watch the amount of repaint calls");
                return;
            }
            this.paintQueue[this.paintQueueFill] = cmp;
            ++this.paintQueueFill;
            displayLock.notify();
        }
    }

    public abstract void getRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7);

    public abstract Object createImage(int[] var1, int var2, int var3);

    public abstract Object createImage(String var1) throws IOException;

    public abstract Object createImage(InputStream var1) throws IOException;

    public abstract Object createMutableImage(int var1, int var2, int var3);

    public boolean isAlphaMutableImageSupported() {
        return false;
    }

    public abstract Object createImage(byte[] var1, int var2, int var3);

    public abstract int getImageWidth(Object var1);

    public abstract int getImageHeight(Object var1);

    public abstract Object scale(Object var1, int var2, int var3);

    private static int round(double d) {
        double f = Math.floor(d);
        double c = Math.ceil(d);
        if (c - d < d - f) {
            return (int)c;
        }
        return (int)f;
    }

    public Object rotate(Object image, int degrees) {
        int width = this.getImageWidth(image);
        int height = this.getImageHeight(image);
        int[] arr = new int[width * height];
        int[] dest = new int[arr.length];
        this.getRGB(image, arr, 0, 0, 0, width, height);
        int centerX = width / 2;
        int centerY = height / 2;
        double radians = Math.toRadians(-degrees);
        double cosDeg = Math.cos(radians);
        double sinDeg = Math.sin(radians);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int destOffset;
                int x2 = LWUITImplementation.round(cosDeg * (double)(x - centerX) - sinDeg * (double)(y - centerY) + (double)centerX);
                int y2 = LWUITImplementation.round(sinDeg * (double)(x - centerX) + cosDeg * (double)(y - centerY) + (double)centerY);
                if (x2 < 0 || y2 < 0 || x2 >= width || y2 >= height || (destOffset = x2 + y2 * width) < 0 || destOffset >= dest.length) continue;
                dest[x + y * width] = arr[destOffset];
            }
        }
        return this.createImage(dest, width, height);
    }

    public abstract int getSoftkeyCount();

    public abstract int[] getSoftkeyCode(int var1);

    public abstract int getClearKeyCode();

    public abstract int getBackspaceKeyCode();

    public abstract int getBackKeyCode();

    public abstract int getGameAction(int var1);

    public abstract int getKeyCode(int var1);

    public abstract boolean isTouchDevice();

    public void setCurrentForm(Form f) {
        this.currentForm = f;
    }

    public void confirmControlView() {
    }

    public Form getCurrentForm() {
        return this.currentForm;
    }

    public boolean isTranslationSupported() {
        return false;
    }

    public void translate(Object graphics, int x, int y) {
    }

    public int getTranslateX(Object graphics) {
        return 0;
    }

    public int getTranslateY(Object graphics) {
        return 0;
    }

    public abstract int getColor(Object var1);

    public abstract void setColor(Object var1, int var2);

    public abstract void setAlpha(Object var1, int var2);

    public abstract int getAlpha(Object var1);

    public boolean isAlphaGlobal() {
        return false;
    }

    public boolean isAntiAliasingSupported() {
        return false;
    }

    public boolean isAntiAliasedTextSupported() {
        return false;
    }

    public void setAntiAliased(Object graphics, boolean a2) {
    }

    public boolean isAntiAliased(Object graphics) {
        return false;
    }

    public void setAntiAliasedText(Object graphics, boolean a2) {
    }

    public boolean isAntiAliasedText(Object graphics) {
        return false;
    }

    public abstract void setNativeFont(Object var1, Object var2);

    public Rectangle getClipRect(Object graphics) {
        return new Rectangle(this.getClipX(graphics), this.getClipY(graphics), new Dimension(this.getClipWidth(graphics), this.getClipHeight(graphics)));
    }

    public abstract int getClipX(Object var1);

    public abstract int getClipY(Object var1);

    public abstract int getClipWidth(Object var1);

    public abstract int getClipHeight(Object var1);

    public void setClipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.setClip(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void setClip(Object var1, int var2, int var3, int var4, int var5);

    public void clipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.clipRect(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void clipRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    public abstract void fillRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawString(Object var1, String var2, int var3, int var4);

    public abstract void drawImage(Object var1, Object var2, int var3, int var4);

    public void drawImage(Object graphics, Object img, int x, int y, int w, int h) {
    }

    public boolean isScaledImageDrawingSupported() {
        return false;
    }

    public void drawImageArea(Object nativeGraphics, Object img, int x, int y, int imageX, int imageY, int imageWidth, int imageHeight) {
        int clipX = this.getClipX(nativeGraphics);
        int clipY = this.getClipY(nativeGraphics);
        int clipWidth = this.getClipWidth(nativeGraphics);
        int clipHeight = this.getClipHeight(nativeGraphics);
        this.clipRect(nativeGraphics, x, y, imageWidth, imageHeight);
        if (this.getClipWidth(nativeGraphics) > 0 && this.getClipHeight(nativeGraphics) > 0) {
            this.drawImage(nativeGraphics, img, x - imageX, y - imageY);
        }
        this.setClip(nativeGraphics, clipX, clipY, clipWidth, clipHeight);
    }

    public void drawImageRotated(Object graphics, Object img, int x, int y, int degrees) {
    }

    public boolean isRotationDrawingSupported() {
        return false;
    }

    public void fillTriangle(Object graphics, int x1, int y1, int x2, int y2, int x3, int y3) {
        this.fillPolygon(graphics, new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
    }

    public abstract void drawRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract Object getNativeGraphics();

    public abstract Object getNativeGraphics(Object var1);

    public abstract int charsWidth(Object var1, char[] var2, int var3, int var4);

    public abstract int stringWidth(Object var1, String var2);

    public abstract int charWidth(Object var1, char var2);

    public abstract int getHeight(Object var1);

    public abstract Object getDefaultFont();

    public int getFace(Object nativeFont) {
        return 0;
    }

    public int getSize(Object nativeFont) {
        return 0;
    }

    public int getStyle(Object nativeFont) {
        return 0;
    }

    public abstract Object createFont(int var1, int var2, int var3);

    protected void keyPressed(int keyCode) {
        Display.getInstance().keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        Display.getInstance().keyReleased(keyCode);
    }

    protected void pointerDragged(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerDragged(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerPressed(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.dragStarted = false;
        this.dragEventCounter = 0;
        this.pointerPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerReleased(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int[] x, int[] y) {
        Display.getInstance().pointerHover(x, y);
    }

    protected void pointerHoverReleased(int[] x, int[] y) {
        Display.getInstance().pointerHoverReleased(x, y);
    }

    protected void pointerHoverReleased(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHoverReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHoverPressed(int[] x, int[] y) {
        Display.getInstance().pointerHoverPressed(x, y);
    }

    protected void pointerHoverPressed(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHoverPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHover(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerDragged(int[] x, int[] y) {
        if (this.hasDragStarted(x, y)) {
            Display.getInstance().pointerDragged(x, y);
        }
    }

    protected boolean hasDragStarted(int[] x, int[] y) {
        return this.hasDragStarted(x[0], y[0]);
    }

    protected boolean hasDragStarted(int x, int y) {
        ++this.dragEventCounter;
        if (!this.dragStarted && Math.sqrt(Math.abs(x - this.pointerPressedX) * Math.abs(x - this.pointerPressedX) + Math.abs(y - this.pointerPressedY) * Math.abs(y - this.pointerPressedY)) > (double)this.dragStartPixels) {
            this.dragStarted = true;
        }
        return this.dragStarted && this.dragEventCounter > this.getDragAutoActivationThreshold();
    }

    public int getDragStartPercentage() {
        return this.dragStartPercentage;
    }

    public void setDragStartPercentage(int dragStartPercentage) {
        this.dragStartPercentage = dragStartPercentage;
        int displayW = Display.getInstance().getDisplayWidth();
        int displayH = Display.getInstance().getDisplayHeight();
        this.dragStartPixels = (int)Math.sqrt(displayW * displayW + displayH * displayH) * dragStartPercentage;
    }

    protected int getDragAutoActivationThreshold() {
        return 2;
    }

    protected void pointerPressed(int[] x, int[] y) {
        this.pointerPressedX = x[0];
        this.pointerPressedY = y[0];
        this.dragStarted = false;
        this.dragEventCounter = 0;
        Display.getInstance().pointerPressed(x, y);
    }

    protected void pointerReleased(int[] x, int[] y) {
        Display.getInstance().pointerReleased(x, y);
    }

    protected void sizeChanged(int w, int h) {
        Display.getInstance().sizeChanged(w, h);
    }

    protected void hideNotify() {
        Display.getInstance().hideNotify();
    }

    protected void showNotify() {
        Display.getInstance().showNotify();
    }

    private Object findCachedGradient(Hashtable cache, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal, int centerX, int centerY, int size) {
        if (cache != null) {
            Enumeration e = cache.keys();
            while (e.hasMoreElements()) {
                int[] current = (int[])e.nextElement();
                Object currentRef = cache.get(current);
                if (currentRef == null) {
                    cache.remove(current);
                    e = cache.keys();
                    continue;
                }
                Object currentImage = this.extractHardRef(currentRef);
                if (currentImage == null) {
                    cache.remove(current);
                    e = cache.keys();
                    continue;
                }
                if (current[0] != startColor || current[1] != endColor || current[2] != x || current[3] != y || current[5] != centerX || current[6] != centerY || current[7] != size || this.getImageWidth(currentImage) != width || this.getImageHeight(currentImage) != height || (!horizontal || current[4] != 1) && (horizontal || current[4] != 0)) continue;
                return currentImage;
            }
        }
        return null;
    }

    private void storeCachedGradient(Object img, Hashtable cache, int startColor, int endColor, int x, int y, boolean horizontal, int centerX, int centerY, int size) {
        int[] key = horizontal ? new int[]{startColor, endColor, x, y, 1, centerX, centerY, size} : new int[]{startColor, endColor, x, y, 0, centerX, centerY, size};
        cache.put(key, this.createSoftWeakRef(img));
    }

    public void fillRectRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, float relativeX, float relativeY, float relativeSize) {
        int centerX = (int)((float)width * (1.0f - relativeX));
        int centerY = (int)((float)height * (1.0f - relativeY));
        int size = (int)((float)Math.min(width, height) * relativeSize);
        int x2 = (int)((float)(width / 2) - (float)size * relativeX);
        int y2 = (int)((float)(height / 2) - (float)size * relativeY);
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        if (this.cacheRadialGradients()) {
            Object r = this.findCachedGradient(this.radialGradientCache, startColor, endColor, x, y, width, height, true, centerX, centerY, size);
            if (r != null) {
                this.drawImage(graphics, r, x, y);
            } else {
                r = this.createMutableImage(width, height, -1);
                Object imageGraphics = this.getNativeGraphics(r);
                this.setColor(imageGraphics, endColor);
                this.fillRect(imageGraphics, 0, 0, width, height);
                this.fillRadialGradientImpl(imageGraphics, startColor, endColor, x2, y2, size, size);
                this.drawImage(graphics, r, x, y);
                if (this.radialGradientCache == null) {
                    this.radialGradientCache = new Hashtable();
                }
                this.storeCachedGradient(r, this.radialGradientCache, startColor, endColor, x, y, true, centerX, centerY, size);
            }
        } else {
            this.setColor(graphics, endColor);
            this.fillRect(graphics, x, y, width, height);
            this.fillRadialGradientImpl(graphics, startColor, endColor, x + x2, y + y2, size, size);
        }
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    public void fillRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height) {
        this.fillRadialGradientImpl(graphics, startColor, endColor, x, y, width, height);
    }

    private void fillRadialGradientImpl(Object graphics, int startColor, int endColor, int x, int y, int width, int height) {
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        int originalHeight = height;
        while (width > 0 && height > 0) {
            this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, originalHeight, height);
            this.fillArc(graphics, x, y, width, height, 0, 360);
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        this.setColor(graphics, oldColor);
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    private void updateGradientColor(Object nativeGraphics, int sourceR, int sourceG, int sourceB, int destR, int destG, int destB, int distance, int offset) {
        int r = this.calculateGraidentChannel(sourceR, destR, distance, offset);
        int g = this.calculateGraidentChannel(sourceG, destG, distance, offset);
        int b = this.calculateGraidentChannel(sourceB, destB, distance, offset);
        int color = r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
        this.setColor(nativeGraphics, color);
    }

    private int calculateGraidentChannel(int sourceChannel, int destChannel, int distance, int offset) {
        if (sourceChannel == destChannel) {
            return sourceChannel;
        }
        float ratio = (float)offset / (float)distance;
        int pos = (int)((float)Math.abs(sourceChannel - destChannel) * ratio);
        if (sourceChannel > destChannel) {
            return sourceChannel - pos;
        }
        return sourceChannel + pos;
    }

    public void fillLinearGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        if (this.cacheLinearGradients()) {
            Object r = this.findCachedGradient(this.linearGradientCache, startColor, endColor, x, y, width, height, horizontal, 0, 0, 0);
            if (r != null) {
                this.drawImage(graphics, r, x, y);
            } else {
                r = this.createMutableImage(width, height, -1);
                this.fillLinearGradientImpl(this.getNativeGraphics(r), startColor, endColor, 0, 0, width, height, horizontal);
                this.drawImage(graphics, r, x, y);
                if (this.linearGradientCache == null) {
                    this.linearGradientCache = new Hashtable();
                }
                this.storeCachedGradient(r, this.linearGradientCache, startColor, endColor, x, y, horizontal, 0, 0, 0);
            }
        } else {
            this.fillLinearGradientImpl(graphics, startColor, endColor, x, y, width, height, horizontal);
        }
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    private void fillLinearGradientImpl(Object graphics, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        if (horizontal) {
            for (int iter = 0; iter < width; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, width, iter);
                this.drawLine(graphics, x + iter, y, x + iter, y + height);
            }
        } else {
            for (int iter = 0; iter < height; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, height, iter);
                this.drawLine(graphics, x, y + iter, x + width, y + iter);
            }
        }
        this.setColor(graphics, oldColor);
    }

    private boolean checkIntersection(Object g, int y0, int x1, int x2, int y1, int y2, int[] intersections, int intersectionsCount) {
        if (y0 > y1 && y0 < y2 || y0 > y2 && y0 < y1) {
            if (y1 == y2) {
                this.drawLine(g, x1, y0, x2, y0);
                return false;
            }
            intersections[intersectionsCount] = x1 + (y0 - y1) * (x2 - x1) / (y2 - y1);
            return true;
        }
        return false;
    }

    private int markIntersectionEdge(Object g, int idx, int[] yPoints, int[] xPoints, int nPoints, int[] intersections, int intersectionsCount) {
        intersections[intersectionsCount] = xPoints[idx];
        if ((yPoints[idx] - yPoints[(idx + 1) % nPoints]) * (yPoints[idx] - yPoints[(idx + nPoints - 1) % nPoints]) > 0) {
            intersections[intersectionsCount + 1] = xPoints[idx];
            return 2;
        }
        if (yPoints[idx] == yPoints[(idx + 1) % nPoints]) {
            this.drawLine(g, xPoints[idx], yPoints[idx], xPoints[(idx + 1) % nPoints], yPoints[(idx + 1) % nPoints]);
            if ((yPoints[(idx + 1) % nPoints] - yPoints[(idx + 2) % nPoints]) * (yPoints[idx] - yPoints[(idx + nPoints - 1) % nPoints]) > 0) {
                return 1;
            }
            intersections[intersectionsCount + 1] = xPoints[idx];
            return 2;
        }
        return 1;
    }

    public void fillPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        int[] intersections = new int[nPoints];
        int intersectionsCount = 0;
        int yMax = yPoints[0];
        int yMin = yPoints[0];
        for (int i = 0; i < nPoints; ++i) {
            yMax = Math.max(yMax, yPoints[i]);
            yMin = Math.min(yMin, yPoints[i]);
        }
        for (int row = yMin; row <= yMax; ++row) {
            int i;
            intersectionsCount = 0;
            for (int i2 = 1; i2 < nPoints; ++i2) {
                if (!this.checkIntersection(graphics, row, xPoints[i2 - 1], xPoints[i2], yPoints[i2 - 1], yPoints[i2], intersections, intersectionsCount)) continue;
                ++intersectionsCount;
            }
            if (this.checkIntersection(graphics, row, xPoints[nPoints - 1], xPoints[0], yPoints[nPoints - 1], yPoints[0], intersections, intersectionsCount)) {
                ++intersectionsCount;
            }
            for (int j = 0; j < nPoints; ++j) {
                if (row != yPoints[j]) continue;
                intersectionsCount += this.markIntersectionEdge(graphics, j, yPoints, xPoints, nPoints, intersections, intersectionsCount);
            }
            int swap = 0;
            for (i = 0; i < intersectionsCount; ++i) {
                for (int j = i; j < intersectionsCount; ++j) {
                    if (intersections[j] >= intersections[i]) continue;
                    swap = intersections[i];
                    intersections[i] = intersections[j];
                    intersections[j] = swap;
                }
            }
            for (i = 1; i < intersectionsCount; i += 2) {
                this.drawLine(graphics, intersections[i - 1], row, intersections[i], row);
            }
        }
    }

    public void drawPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 1; i < nPoints; ++i) {
            this.drawLine(graphics, xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]);
        }
        this.drawLine(graphics, xPoints[nPoints - 1], yPoints[nPoints - 1], xPoints[0], yPoints[0]);
    }

    public int getKeyboardType() {
        return 0;
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isMultiTouch() {
        return false;
    }

    public boolean isClickTouchScreen() {
        return false;
    }

    public boolean isNativeIndexed() {
        return false;
    }

    public Object createNativeIndexed(IndexedImage image) {
        return null;
    }

    public Object createVideoComponent(Object player) {
        return null;
    }

    public int getVideoWidth(Object videoControl) {
        return 0;
    }

    public int getVideoHeight(Object videoControl) {
        return 0;
    }

    public void setVideoVisible(Object vc, boolean visible) {
    }

    public void startVideo(Object player, Object videoControl) {
    }

    public void stopVideo(Object player, Object videoControl) {
    }

    public void setVideoLoopCount(Object player, int count) {
    }

    public long getMediaTime(Object player) {
        return 0L;
    }

    public long setMediaTime(Object player, long now) {
        return 0L;
    }

    public void setVideoFullScreen(Object player, boolean fullscreen) {
    }

    public void paintVideo(Component cmp, boolean fullScreen, Object nativeGraphics, Object video, Object player) {
    }

    public boolean isOpaque(Image lwuitImage, Object nativeImage) {
        int[] rgb = lwuitImage.getRGBCached();
        for (int iter = 0; iter < rgb.length; ++iter) {
            if ((rgb[iter] & 0xFF000000) == -16777216) continue;
            return false;
        }
        return true;
    }

    public boolean isAffineSupported() {
        return false;
    }

    public void resetAffine(Object nativeGraphics) {
        System.out.println("Affine unsupported");
    }

    public void scale(Object nativeGraphics, float x, float y) {
        System.out.println("Affine unsupported");
    }

    public void rotate(Object nativeGraphics, float angle) {
        System.out.println("Affine unsupported");
    }

    public void shear(Object nativeGraphics, float x, float y) {
        System.out.println("Affine unsupported");
    }

    public boolean isSVGSupported() {
        return false;
    }

    public Object createSVGImage(String baseURL, byte[] data) throws IOException {
        throw new IOException("SVG is not supported by this implementation");
    }

    public Object getSVGDocument(Object svgImage) {
        throw new RuntimeException("SVG is not supported by this implementation");
    }

    public boolean animateImage(Object nativeImage, long lastFrame) {
        return false;
    }

    public String[] getFontPlatformNames() {
        return new String[]{"MIDP", "MIDP2"};
    }

    public Object loadTrueTypeFont(InputStream stream) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public boolean isTrueTypeSupported() {
        return false;
    }

    public Object loadNativeFont(String lookup) {
        return null;
    }

    public boolean isLookupFontSupported() {
        return false;
    }

    public boolean minimizeApplication() {
        return false;
    }

    public void restoreMinimizedApplication() {
    }

    public boolean isMinimized() {
        return false;
    }

    protected boolean cacheRadialGradients() {
        return true;
    }

    protected boolean cacheLinearGradients() {
        return true;
    }

    public boolean isThirdSoftButton() {
        return false;
    }

    public int getDragPathLength() {
        return 10;
    }

    public int getDragPathTime() {
        return 200;
    }

    public float getDragSpeed(float[] points, long[] dragPathTime, int dragPathOffset, int dragPathLength) {
        long now = System.currentTimeMillis();
        long tooold = now - (long)this.getDragPathTime();
        int offset = dragPathOffset - dragPathLength;
        if (offset < 0) {
            offset = this.getDragPathLength() + offset;
        }
        long old = 0L;
        float oldPoint = 0.0f;
        float speed = 0.0f;
        float f = dragPathLength;
        while (dragPathLength > 0) {
            if (dragPathTime[offset] > tooold) {
                if (old == 0L) {
                    old = dragPathTime[offset];
                    oldPoint = points[offset];
                }
                long timediff = now - old;
                float diff = points[offset] - oldPoint;
                if (timediff > 0L) {
                    float velocity = diff / (float)timediff * 1.5f;
                    speed += velocity;
                }
            }
            --dragPathLength;
            if (++offset < this.getDragPathLength()) continue;
            offset = 0;
        }
        f = Math.max(1.0f, f);
        return -speed / f;
    }

    public boolean isBidiAlgorithm() {
        return bidi;
    }

    public void setBidiAlgorithm(boolean activate) {
        bidi = activate;
    }

    public String convertBidiLogicalToVisual(String s) {
        if (bidi && s.length() >= 2) {
            char[] c = s.toCharArray();
            this.swapBidiChars(c, 0, s.length(), -1);
            return new String(c);
        }
        return s;
    }

    public int getCharLocation(String source, int index) {
        if (bidi) {
            return this.swapBidiChars(source.toCharArray(), 0, source.length(), index);
        }
        return index;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean isRTLOrWhitespace(char c) {
        if (bidi) {
            return this.isRTL(c) || this.isWhitespace(c);
        }
        return false;
    }

    public boolean isRTL(char c) {
        return c >= '\u0590' && c <= '\u07bf';
    }

    private final int swapBidiChars(char[] chars, int ixStart, int len, int index) {
        int ix1;
        int destIndex = -1;
        int ixEnd = ixStart + len;
        int ix0 = ix1 = ixStart;
        boolean doSwap = false;
        for (int i1 = ixStart; i1 < ixEnd; ++i1) {
            if (!this.isRTL(chars[i1])) continue;
            doSwap = true;
            break;
        }
        if (doSwap) {
            while (ix0 < ixEnd && (ix1 = this.scanSecond(chars, ix0, ixEnd)) >= 0) {
                ix0 = ix1;
                ix1 = this.scanBackFirst(chars, ix0, ixEnd);
                int iy0 = ix0;
                for (int iy1 = ix1 - 1; iy0 < iy1; ++iy0, --iy1) {
                    char tmp = chars[iy0];
                    chars[iy0] = chars[iy1];
                    chars[iy1] = tmp;
                    if (index != iy1) continue;
                    destIndex = iy0;
                    index = iy0;
                }
                ix0 = ix1;
            }
        }
        if (doSwap) {
            ix0 = ixStart;
            for (ix1 = ixEnd - 1; ix0 <= ix1; ++ix0, --ix1) {
                char ch1;
                char ch0 = chars[ix0];
                chars[ix0] = ch1 = chars[ix1];
                chars[ix1] = ch0;
                if (index == ix0) {
                    destIndex = ix1;
                    continue;
                }
                if (index != ix1) continue;
                destIndex = ix0;
            }
        }
        return destIndex;
    }

    private boolean isRTLBreak(char ch1) {
        return ch1 == ')' || ch1 == ']' || ch1 == '}' || ch1 == '(' || ch1 == '[' || ch1 == '{';
    }

    private boolean isLTR(char c) {
        return !this.isRTL(c) && !this.isRTLBreak(c);
    }

    private final int scanSecond(char[] chars, int ixStart, int ixEnd) {
        int ixFound = -1;
        for (int ix = ixStart; ixFound < 0 && ix < ixEnd; ++ix) {
            if (this.isRTLOrWhitespace(chars[ix])) continue;
            ixFound = ix;
        }
        return ixFound;
    }

    private final int scanBackFirst(char[] chars, int ixStart, int ixEnd) {
        int ix;
        int ixFound = ixEnd;
        for (ix = ixStart + 1; ix < ixEnd; ++ix) {
            if (!this.isRTL(chars[ix]) && !this.isRTLBreak(chars[ix])) continue;
            ixFound = ix;
            break;
        }
        for (ix = ixFound - 1; ix >= ixStart; --ix) {
            if (!this.isLTR(chars[ix]) || this.isWhitespace(chars[ix])) continue;
            ixFound = ix + 1;
            break;
        }
        return ixFound;
    }

    public InputStream getResourceAsStream(Class cls, String resource) {
        return cls.getResourceAsStream(resource);
    }

    public boolean isAnimation(Object nativeImage) {
        return false;
    }

    public PeerComponent createNativePeer(Object nativeComponent) {
        throw new IllegalArgumentException(nativeComponent.getClass().getName());
    }

    public VideoComponent createVideoPeer(String url) throws IOException {
        throw new IllegalArgumentException("not supported");
    }

    public VideoComponent createVideoPeer(InputStream stream, String type) throws IOException {
        throw new IllegalArgumentException("not supported");
    }

    public void setVideoFullScreen(VideoComponent v, boolean fullscreen) {
    }

    public void showNativeScreen(Object nativeFullScreenPeer) {
    }

    public void setNativeCommands(Vector commands) {
    }

    public void exitApplication() {
    }

    public String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    public void execute(String url) {
    }

    public int getDeviceDensity() {
        int d = this.getDisplayHeight() * this.getDisplayWidth();
        if (this.isTablet()) {
            if (d >= 1036800) {
                return 40;
            }
            return 30;
        }
        if (d <= 38720) {
            return 10;
        }
        if (d <= 76800) {
            return 20;
        }
        if (d <= 172800) {
            return 30;
        }
        if (d <= 409920) {
            return 40;
        }
        if (d <= 1036800) {
            return 50;
        }
        return 60;
    }

    public void playBuiltinSound(String soundIdentifier) {
        this.playUserSound(soundIdentifier);
    }

    protected boolean playUserSound(String soundIdentifier) {
        Object sound = this.builtinSounds.get(soundIdentifier);
        if (sound == null) {
            return false;
        }
        this.playAudio(sound);
        return true;
    }

    protected void playNativeBuiltinSound(Object data) {
    }

    protected Object convertBuiltinSound(InputStream i) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int size = i.read(buffer);
        while (size > -1) {
            b.write(buffer, 0, size);
            size = i.read(buffer);
        }
        b.close();
        i.close();
        return b.toByteArray();
    }

    public void installBuiltinSound(String soundIdentifier, InputStream data) throws IOException {
        this.builtinSounds.put(soundIdentifier, this.convertBuiltinSound(data));
    }

    public boolean isBuiltinSoundAvailable(String soundIdentifier) {
        return this.builtinSounds.containsKey(soundIdentifier);
    }

    public void setBuiltinSoundsEnabled(boolean enabled) {
        this.builtinSoundEnabled = enabled;
    }

    public boolean isBuiltinSoundsEnabled() {
        return this.builtinSoundEnabled;
    }

    public Object createAudio(String uri, Runnable onCompletion) throws IOException {
        return null;
    }

    public Object createAudio(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return null;
    }

    public void playAudio(Object handle) {
    }

    public void pauseAudio(Object handle) {
    }

    public int getAudioTime(Object handle) {
        return -1;
    }

    public void setAudioTime(Object handle, int time) {
    }

    public int getAudioDuration(Object handle) {
        return -1;
    }

    public void cleanupAudio(Object handle) {
    }

    public void setVolume(int vol) {
    }

    public int getVolume() {
        return -1;
    }

    public Object createSoftWeakRef(Object o) {
        return new WeakReference<Object>(o);
    }

    public Object extractHardRef(Object o) {
        WeakReference w = (WeakReference)o;
        if (w != null) {
            return w.get();
        }
        return null;
    }

    public void notifyCommandBehavior(int commandBehavior) {
    }

    public boolean hasNativeTheme() {
        return false;
    }

    public void installNativeTheme() {
        throw new RuntimeException();
    }

    public void copyToClipboard(Object obj) {
        this.lightweightClipboard = obj;
    }

    public Object getPasteDataFromClipboard() {
        return this.lightweightClipboard;
    }

    public boolean isPortrait() {
        return this.getDisplayWidth() < this.getDisplayHeight();
    }

    public boolean canForceOrientation() {
        return false;
    }

    public void lockOrientation(boolean portrait) {
    }

    public boolean isNativeBrowserComponentSupported() {
        return false;
    }

    public PeerComponent createBrowserComponent(Object browserComponent) {
        return null;
    }

    public void setBrowserProperty(PeerComponent browserPeer, String key, Object value) {
    }

    public String getBrowserTitle(PeerComponent browserPeer) {
        return null;
    }

    public String getBrowserURL(PeerComponent browserPeer) {
        return null;
    }

    public void setBrowserURL(PeerComponent browserPeer, String url) {
        try {
            InputStream i = Display.getInstance().getResourceAsStream(this.getClass(), url.substring(6));
            if (i == null) {
                System.out.println("Local resource not found: " + url);
                return;
            }
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            int size = i.read(buffer);
            while (size > -1) {
                bo.write(buffer, 0, size);
                size = i.read(buffer);
            }
            i.close();
            bo.close();
            String htmlText = new String(bo.toByteArray(), "UTF-8");
            String baseUrl = url.substring(0, url.lastIndexOf(47));
            this.setBrowserPage(browserPeer, htmlText, baseUrl);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void browserReload(PeerComponent browserPeer) {
    }

    public boolean browserHasBack(PeerComponent browserPeer) {
        return false;
    }

    public boolean browserHasForward(PeerComponent browserPeer) {
        return false;
    }

    public void browserBack(PeerComponent browserPeer) {
    }

    public void browserForward(PeerComponent browserPeer) {
    }

    public void browserClearHistory(PeerComponent browserPeer) {
    }

    public void setBrowserPage(PeerComponent browserPeer, String html, String baseUrl) {
    }

    public void browserExecute(PeerComponent browserPeer, String javaScript) {
        this.setBrowserURL(browserPeer, "javascript:(" + javaScript + ")()");
    }

    public void browserExposeInJavaScript(PeerComponent browserPeer, Object o, String name) {
    }

    public int convertToPixels(int dipCount, boolean horizontal) {
        switch (this.getDeviceDensity()) {
            case 10: {
                return dipCount;
            }
            case 20: {
                return dipCount * 2;
            }
            case 30: {
                return dipCount * 5;
            }
            case 40: {
                return dipCount * 10;
            }
            case 50: {
                return dipCount * 14;
            }
            case 60: {
                return dipCount * 20;
            }
        }
        return dipCount;
    }

    public boolean isTablet() {
        return false;
    }
}

