/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.io;

import org.kxml2.io.Logger;

public final class Log {
    public static boolean showDebug = false;
    private static Logger[] out;

    static {
        Logger l = new Logger(){

            public void println(String txt) {
                System.out.println(txt);
            }
        };
        out = new Logger[]{l};
    }

    private Log() {
    }

    public static void setLogDestination(Logger l) {
        out = new Logger[]{l};
    }

    public static void addLogDestination(Logger o) {
        if (o == null) {
            return;
        }
        if (out == null) {
            out = new Logger[]{o};
            return;
        }
        Logger[] old = out;
        out = new Logger[old.length + 1];
        int i = 0;
        while (i < old.length) {
            Log.out[i] = old[i];
            ++i;
        }
        Log.out[old.length] = o;
    }

    public static boolean removeLogDestination(Logger o) {
        if (o == null || out == null) {
            return false;
        }
        boolean removed = false;
        Logger[] old = out;
        int i = 0;
        while (i < old.length) {
            if (old[i] == o) {
                old[i] = null;
                removed = true;
                break;
            }
            ++i;
        }
        if (removed) {
            Logger[] n = new Logger[old.length - 1];
            int p = 0;
            int i2 = 0;
            while (i2 < n.length) {
                if (old[p] == null) {
                    ++p;
                }
                n[i2] = old[p];
                ++p;
                ++i2;
            }
            out = n;
        }
        return removed;
    }

    public static void logInfo(String str) {
        if (out != null) {
            int i = 0;
            while (i < out.length) {
                out[i].println("INFO: " + str);
                ++i;
            }
        }
    }

    public static void logError(String str, Throwable e) {
        if (out != null) {
            int i = 0;
            while (i < out.length) {
                Logger o = out[i];
                o.println("ERROR: " + str);
                if (e != null) {
                    o.println("ERROR: " + e.getClass().getName());
                    o.println("ERROR: " + e.getMessage());
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static void logWarn(String str, Throwable e) {
        if (out != null) {
            int i = 0;
            while (i < out.length) {
                Logger o = out[i];
                o.println("WARN: " + str);
                if (e != null) {
                    o.println("WARN: " + e.getClass().getName());
                    o.println("WARN: " + e.getMessage());
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static void logWarn(String str) {
        if (out != null) {
            int i = 0;
            while (i < out.length) {
                out[i].println("WARN: " + str);
                ++i;
            }
        }
    }

    public static void logDebug(String str) {
        if (showDebug && out != null) {
            int i = 0;
            while (i < out.length) {
                out[i].println("DEBUG: " + str);
                ++i;
            }
        }
    }
}

