/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.ActionButton;
import com.nokia.lwuit.components.DatePicker;
import com.nokia.lwuit.components.DatePickerListener;
import com.nokia.lwuit.components.FormItemListener;
import com.nokia.lwuit.components.TimePicker;
import com.nokia.lwuit.components.TimePickerListener;
import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;

public class FormItem
extends Container
implements ActionListener,
DatePickerListener,
TimePickerListener {
    public static final int HIGHLIGHT_COLOR_NORMAL = 1;
    public static final int HIGHLIGHT_COLOR_BLUE = 2;
    public static final int HIGHLIGHT_COLOR_RED = 3;
    private int implType;
    private boolean isChildItemPressed;
    private boolean dragActivated;
    private boolean isTwoLine;
    private FormItem _formItem;
    private FormItemListener formItemListener;
    private InnerLabel itemName;
    private InnerLabel itemValue;
    private InnerLabel iconLabel;
    private InnerLabel datePickerLabel;
    private InnerLabel timePickerLabel;
    private InnerLabel leftComponentLabel;
    private InnerLabel rightComponentLabel;
    private InnerButton actionButton;
    private ActionButton button;
    private DatePicker datePicker;
    private TimePicker timePicker;
    private Component pressedComponent;
    private Component leftComponent;
    private Component rightComponent;
    private static final int FORMITEM_ONE_LINE_ITEM = 1;
    private static final int FORMITEM_ONE_LINE_ITEM_WITH_ICON = 2;
    private static final int FORMITEM_TWO_LINE_ITEM = 3;
    private static final int FORMITEM_READ_ONLY_ITEM = 4;
    private static final int FORMITEM_DATE_TIME_ITEM = 5;
    private static final int FORMITEM_TWO_LINE_ITEM_WITH_ICON = 6;
    private static final int FORMITEM_TWO_LINE_ITEM_WITH_ICON_ACTION = 7;
    private static final int FORMITEM_TWO_LINE_ITEM_WITH_ACTION = 8;
    private static final int FORMITEM_MULTIPLE_COMPONENT_ITEM = 9;

    private FormItem() {
        this("", false);
    }

    public FormItem(String text, boolean isDateTime) {
        if (this.isNull_Empty(text)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        if (isDateTime) {
            this.isTwoLine = true;
            this.setImplementationType(5);
            this.datePicker = new DatePicker(null, 1);
            this.datePicker.setDatePickerListener(this);
            this.timePicker = new TimePicker();
            this.timePicker.setTimePickerListener(this);
            this.setLayout(new GridLayout(2, 1));
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            Container cont = new Container(new GridLayout(1, 2));
            cont.setUIID("FormItemName");
            this.datePickerLabel = new InnerLabel(this._formItem);
            this.datePickerLabel.setText(this.datePicker.getValue());
            this.datePickerLabel.setUIID("FormItemValueLeft");
            this.datePickerLabel.setEndsWith3Points(false);
            this.datePickerLabel.setFocusable(false);
            this.timePickerLabel = new InnerLabel(this._formItem);
            this.timePickerLabel.setText(this.timePicker.getTimeString());
            this.timePickerLabel.setUIID("FormItemValueRight");
            this.timePickerLabel.setEndsWith3Points(false);
            this.timePickerLabel.setFocusable(false);
            cont.addComponent(this.datePickerLabel);
            cont.addComponent(this.timePickerLabel);
            this.addComponent(this.itemName);
            this.addComponent(cont);
        } else {
            this.isTwoLine = false;
            this.setImplementationType(1);
            this.setLayout(new GridLayout(1, 1));
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.addComponent(this.itemName);
        }
        this.setScrollable(false);
    }

    public FormItem(String text, Image icon) {
        if (this.isNull_Empty(text)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Null image is not allowed");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        this.isTwoLine = false;
        this.setImplementationType(2);
        this.setLayout(new GridLayout(1, 1));
        Container cont = new Container(new BoxLayout(1));
        cont.setUIID("FormItemName");
        this.itemName = new InnerLabel(this._formItem);
        this.itemName.setText(text);
        this.itemName.setUIID("FormItemName");
        this.itemName.setEndsWith3Points(false);
        this.itemName.setFocusable(false);
        this.iconLabel = new InnerLabel(this._formItem);
        this.iconLabel.setIcon(icon);
        this.iconLabel.setUIID("FormItemIcon");
        this.iconLabel.setFocusable(false);
        cont.addComponent(this.iconLabel);
        cont.addComponent(this.itemName);
        this.addComponent(cont);
        this.setScrollable(false);
    }

    public FormItem(String text, String value, boolean readOnly) {
        if (this.isNull_Empty(text) || this.isNull_Empty(value)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        this.isTwoLine = true;
        if (readOnly) {
            this.setImplementationType(4);
            this.setLayout(new GridLayout(2, 1));
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemNameReadOnly");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.itemName.setEnabled(false);
            this.itemValue = new InnerLabel(this._formItem);
            this.itemValue.setText(value);
            this.itemValue.setUIID("FormItemValueReadOnly");
            this.itemValue.setEndsWith3Points(false);
            this.itemValue.setFocusable(false);
            this.itemValue.setEnabled(false);
        } else {
            this.setImplementationType(3);
            this.setLayout(new GridLayout(2, 1));
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.itemValue = new InnerLabel(this._formItem);
            this.itemValue.setText(value);
            this.itemValue.setUIID("FormItemValueB");
            this.itemValue.setEndsWith3Points(false);
            this.itemValue.setFocusable(false);
        }
        this.addComponent(this.itemName);
        this.addComponent(this.itemValue);
        this.setScrollable(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormItem(String text, String value, Image image, boolean isActionable, int itemValue_HighlightColor) {
        if (this.isNull_Empty(text)) {
            throw new IllegalArgumentException("Text cannot be null or empty string");
        }
        if (this.isNull_Empty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty string");
        }
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        this.isTwoLine = true;
        if (!isActionable) {
            if (itemValue_HighlightColor != 1 && itemValue_HighlightColor != 3 && itemValue_HighlightColor != 2) throw new IllegalArgumentException("Invalid constraint value for item value highlight color");
            this.setImplementationType(6);
            this.setLayout(new BorderLayout());
            this.iconLabel = new InnerLabel(this._formItem);
            this.iconLabel.setIcon(image);
            this.iconLabel.setUIID("FormItemIcon");
            this.iconLabel.setFocusable(false);
            this.addComponent("West", (Component)this.iconLabel);
            Container cont = new Container(new GridLayout(2, 1));
            cont.setUIID("FormItemName");
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.itemValue = new InnerLabel(this._formItem);
            this.itemValue.setText(value);
            if (itemValue_HighlightColor == 1) {
                this.itemValue.setUIID("FormItemValue");
            } else if (itemValue_HighlightColor == 2) {
                this.itemValue.setUIID("FormItemValueB");
            } else {
                this.itemValue.setUIID("FormItemValueR");
            }
            this.itemValue.setEndsWith3Points(false);
            this.itemValue.setFocusable(false);
            cont.addComponent(this.itemName);
            cont.addComponent(this.itemValue);
            this.addComponent("Center", (Component)cont);
        } else {
            this.setImplementationType(8);
            this.setLayout(new BorderLayout());
            Container cont = new Container(new GridLayout(2, 1));
            cont.setUIID("FormItemName");
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.itemValue = new InnerLabel(this._formItem);
            this.itemValue.setText(value);
            this.itemValue.setUIID("FormItemValueB");
            this.itemValue.setEndsWith3Points(false);
            this.itemValue.setFocusable(false);
            cont.addComponent(this.itemName);
            cont.addComponent(this.itemValue);
            this.addComponent("Center", (Component)cont);
            this.actionButton = new InnerButton(this._formItem, image);
            this.actionButton.setIcon(image);
            this.actionButton.setUIID("FormItemAction");
            this.actionButton.setFocusable(false);
            this.addComponent("East", (Component)this.actionButton);
        }
        this.setScrollable(false);
    }

    public FormItem(String text, String value, Image icon, Image actionImage, Image actionPressedImage, int itemValue_HighlightColor) {
        if (this.isNull_Empty(text) || this.isNull_Empty(value)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        if (icon == null || actionImage == null) {
            throw new IllegalArgumentException("Null image is not allowed");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        this.isTwoLine = true;
        if (itemValue_HighlightColor == 1 || itemValue_HighlightColor == 3 || itemValue_HighlightColor == 2) {
            this.setImplementationType(7);
            this.setLayout(new BorderLayout());
            this.iconLabel = new InnerLabel(this._formItem);
            this.iconLabel.setIcon(icon);
            this.iconLabel.setUIID("FormItemIcon");
            this.iconLabel.setFocusable(false);
            this.addComponent("West", (Component)this.iconLabel);
            Container cont = new Container(new GridLayout(2, 1));
            cont.setUIID("FormItemName");
            this.itemName = new InnerLabel(this._formItem);
            this.itemName.setText(text);
            this.itemName.setUIID("FormItemName");
            this.itemName.setEndsWith3Points(false);
            this.itemName.setFocusable(false);
            this.itemValue = new InnerLabel(this._formItem);
            this.itemValue.setText(value);
            if (itemValue_HighlightColor == 1) {
                this.itemValue.setUIID("FormItemValue");
            } else if (itemValue_HighlightColor == 2) {
                this.itemValue.setUIID("FormItemValueB");
            } else {
                this.itemValue.setUIID("FormItemValueR");
            }
            this.itemValue.setEndsWith3Points(false);
            this.itemValue.setFocusable(false);
            cont.addComponent(this.itemName);
            cont.addComponent(this.itemValue);
            this.addComponent("Center", (Component)cont);
            this.button = new ActionButton(actionImage);
            this.button.setUIID("FormItemActionBG");
            if (actionPressedImage != null) {
                this.button.setPressedIcon(actionPressedImage);
            }
        } else {
            throw new IllegalArgumentException("Invalid constraint value for item value highlight color");
        }
        this.button.setFocusable(false);
        this.button.addActionListener(this);
        this.addComponent("East", (Component)this.button);
        this.setScrollable(false);
    }

    public FormItem(String item, String valueLeft, String valueRight, Component valueCmpLeft, Component valueCmpRight) {
        if (this.isNull_Empty(item) || this.isNull_Empty(valueLeft) || this.isNull_Empty(valueRight)) {
            throw new IllegalArgumentException("Null or empty string is not allowed");
        }
        if (valueCmpLeft == null || valueCmpRight == null) {
            throw new IllegalArgumentException("Null objectsare not allowed");
        }
        this._formItem = this;
        this.setUIID("FormItem");
        this.leftComponent = valueCmpLeft;
        this.rightComponent = valueCmpRight;
        this.isTwoLine = true;
        this.setImplementationType(9);
        this.setLayout(new GridLayout(2, 1));
        this.itemName = new InnerLabel(this._formItem);
        this.itemName.setText(item);
        this.itemName.setUIID("FormItemName");
        this.itemName.setEndsWith3Points(false);
        this.itemName.setFocusable(false);
        Container cont = new Container(new GridLayout(1, 2));
        cont.setUIID("FormItemName");
        this.leftComponentLabel = new InnerLabel(this._formItem);
        this.leftComponentLabel.setText(valueLeft);
        this.leftComponentLabel.setUIID("FormItemValueLeft");
        this.leftComponentLabel.setEndsWith3Points(false);
        this.leftComponentLabel.setFocusable(false);
        this.rightComponentLabel = new InnerLabel(this._formItem);
        this.rightComponentLabel.setText(valueRight);
        this.rightComponentLabel.setUIID("FormItemValueRight");
        this.rightComponentLabel.setEndsWith3Points(false);
        this.rightComponentLabel.setFocusable(false);
        cont.addComponent(this.leftComponentLabel);
        cont.addComponent(this.rightComponentLabel);
        this.addComponent(this.itemName);
        this.addComponent(cont);
        this.setScrollable(false);
    }

    public void setItemText(String text) {
        if (!this.isNull_Empty(text) && this.itemName != null) {
            this.itemName.setText(text);
        }
    }

    public String getItemText() {
        if (this.itemName != null) {
            return this.itemName.getText();
        }
        return null;
    }

    public void setItemValueText(String text) {
        if (!this.isNull_Empty(text) && this.itemValue != null) {
            this.itemValue.setText(text);
        }
    }

    public String getItemValueText() {
        if (this.itemValue != null) {
            return this.itemValue.getText();
        }
        return null;
    }

    public void setItemValueText(Component cmp, String text) {
        if (cmp != null && !this.isNull_Empty(text) && cmp instanceof Component) {
            if (cmp.equals(this.leftComponent)) {
                if (this.leftComponentLabel != null) {
                    this.leftComponentLabel.setText(text);
                }
            } else if (cmp.equals(this.rightComponent) && this.rightComponentLabel != null) {
                this.rightComponentLabel.setText(text);
            }
        }
    }

    public String getItemValueText(Component cmp) {
        if (cmp != null && cmp instanceof Component) {
            if (cmp.equals(this.leftComponent)) {
                if (this.leftComponentLabel != null) {
                    return this.leftComponentLabel.getText();
                }
            } else if (cmp.equals(this.rightComponent) && this.rightComponentLabel != null) {
                return this.rightComponentLabel.getText();
            }
        }
        return null;
    }

    public void setItemImage(Image image) {
        if (image != null && this.iconLabel != null) {
            this.iconLabel.setIcon(image);
        }
    }

    public Image getItemImage() {
        if (this.iconLabel != null) {
            return this.iconLabel.getIcon();
        }
        return null;
    }

    public void setActionImage(Image image) {
        if (image != null) {
            if (this.getImplementationType() == 8) {
                if (this.actionButton != null) {
                    this.actionButton.setIcon(image);
                }
            } else if (this.getImplementationType() == 7 && this.button != null) {
                this.button.setIcon(image);
            }
        }
    }

    public Image getActionImage() {
        if (this.iconLabel != null) {
            return this.iconLabel.getIcon();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component cmp = this.getComponentAt(i);
            if (cmp == null) continue;
            cmp.setEnabled(enabled);
        }
    }

    private void setImplementationType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.implType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid implementation type for FormItem");
            }
        }
    }

    private int getImplementationType() {
        return this.implType;
    }

    protected Dimension calcPreferredSize() {
        int height;
        int width;
        if (!this.isTwoLine) {
            width = Display.getInstance().getDisplayWidth();
            height = 50;
        } else {
            width = Display.getInstance().getDisplayWidth();
            height = 60;
        }
        return new Dimension(width, height);
    }

    public void pointerPressed(int x, int y) {
        this.dragActivated = false;
        this.isChildItemPressed = true;
        Form f = this.getComponentForm();
        f.setFocused(this);
    }

    public void pointerReleased(int x, int y) {
        if (!this.dragActivated) {
            this.isChildItemPressed = false;
            Form f = this.getComponentForm();
            f.setFocused(null);
            if (this.getImplementationType() == 5 || this.getImplementationType() == 9 || this.getImplementationType() == 8) {
                Component cmp = f.getComponentAt(x, y);
                if (cmp != null) {
                    if (cmp instanceof InnerLabel) {
                        if (cmp.equals(this.datePickerLabel)) {
                            this.datePicker.show();
                        } else if (cmp.equals(this.timePickerLabel)) {
                            this.timePicker.show();
                        } else if (cmp.equals(this.leftComponentLabel)) {
                            this.pressedComponent = this.leftComponent;
                            this.notifyListener(this.pressedComponent, false);
                        } else if (cmp.equals(this.rightComponentLabel)) {
                            this.pressedComponent = this.rightComponent;
                            this.notifyListener(this.pressedComponent, false);
                        } else {
                            this.pressedComponent = null;
                            this.notifyListener(this.pressedComponent, false);
                        }
                    } else if (cmp instanceof InnerButton) {
                        this.pressedComponent = null;
                        this.notifyListener(this.pressedComponent, true);
                    } else {
                        this.pressedComponent = null;
                        this.notifyListener(this.pressedComponent, false);
                    }
                }
            } else {
                this.pressedComponent = null;
                this.notifyListener(this.pressedComponent, false);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.dragActivated = true;
        this.isChildItemPressed = false;
        Form f = this.getComponentForm();
        f.setFocused(null);
    }

    private void notifyListener(Component component, boolean isActionButtonPressed) {
        if (this.formItemListener != null) {
            this.formItemListener.notifyFormItemListener(this, component, isActionButtonPressed);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.button) {
            this.pressedComponent = null;
            this.notifyListener(this.pressedComponent, true);
        }
    }

    public String getUIID() {
        return "FormItem";
    }

    public void setUIID(String id) {
        super.setUIID(id);
    }

    public Style getStyle() {
        if (this.hasFocus()) {
            return super.getPressedStyle();
        }
        return super.getUnselectedStyle();
    }

    public void setFormItemListener(FormItemListener listener) {
        this.formItemListener = listener;
    }

    public FormItemListener getFormItemListener() {
        return this.formItemListener;
    }

    public void notifyDatePickerListener(DatePicker dp) {
        if (dp.equals(this.datePicker)) {
            this.datePickerLabel.setText(this.datePicker.getValue());
        }
    }

    public void notifyTimePickerListener(TimePicker tp) {
        if (tp.equals(this.timePicker)) {
            this.timePickerLabel.setText(this.timePicker.getTimeString());
        }
    }

    private boolean isNull_Empty(String text) {
        if (text == null) {
            return true;
        }
        return text.equals("");
    }

    private class InnerButton
    extends Button {
        FormItem _item;
        Image icon;

        public InnerButton(FormItem item, Image icon) {
            this._item = item;
            Dimension d = new Dimension(icon.getWidth(), icon.getHeight());
            this.setPreferredSize(d);
        }

        public void setUIID(String id) {
            super.setUIID(id);
        }

        public Style getStyle() {
            if (!this.isEnabled()) {
                return super.getDisabledStyle();
            }
            if (this._item.isChildItemPressed) {
                return super.getPressedStyle();
            }
            return super.getUnselectedStyle();
        }

        public void pointerPressed(int x, int y) {
            this._item.pointerPressed(x, y);
        }

        public void pointerReleased(int x, int y) {
            this._item.pointerReleased(x, y);
        }

        public void pointerDragged(int x, int y) {
            this._item.isChildItemPressed = false;
            this._item.pointerDragged(x, y);
        }
    }

    private class InnerLabel
    extends Label {
        FormItem _item;

        public InnerLabel(FormItem item) {
            this._item = item;
        }

        public void pointerPressed(int x, int y) {
            this._item.pointerPressed(x, y);
        }

        public void pointerReleased(int x, int y) {
            this._item.pointerReleased(x, y);
        }

        public void pointerDragged(int x, int y) {
            this._item.isChildItemPressed = false;
            this._item.pointerDragged(x, y);
        }

        public void setUIID(String id) {
            super.setUIID(id);
        }

        public Style getStyle() {
            if (!this.isEnabled()) {
                return super.getDisabledStyle();
            }
            if (this._item.isChildItemPressed) {
                return super.getPressedStyle();
            }
            return super.getUnselectedStyle();
        }
    }
}

