/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.HeaderBarListener;
import com.nokia.lwuit.components.InfiniteProgressIndicator;
import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;

public class HeaderBar
extends Container {
    private Label mHeaderLabel;
    private Label mHeaderSubLabel;
    private Label mHeaderIcon;
    private Button mHeaderActionButton;
    private InfiniteProgressIndicator mHeaderSpinner;
    private HeaderBarListener internalListener = null;
    private int HEADER_TITLE_COLOR = 2729932;
    private int HEADER_SUBTITLE_COLOR = 0x808080;

    public HeaderBar(String title) {
        this.setUIID("HeaderBar");
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.addComponent(this.mHeaderLabel);
    }

    public HeaderBar(String title, boolean showSpinner) {
        this.setUIID("HeaderBar");
        this.setLayout(new BorderLayout());
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.addComponent("Center", (Component)this.mHeaderLabel);
        this.mHeaderSpinner = new InfiniteProgressIndicator(0);
        if (showSpinner) {
            this.addComponent("East", (Component)this.mHeaderSpinner);
        }
        this.setScrollable(false);
    }

    public HeaderBar(String title, String subText) {
        this.setUIID("HeaderBar");
        this.setLayout(new BoxLayout(2));
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.mHeaderLabel.getStyle().setPadding(2, 0);
        this.addComponent(this.mHeaderLabel);
        this.mHeaderSubLabel = this.initHeaderSubLabel(subText);
        this.mHeaderSubLabel.getStyle().setPadding(0, 0);
        this.mHeaderSubLabel.getStyle().setMargin(0, 0);
        this.addComponent(this.mHeaderSubLabel);
        this.setScrollable(false);
    }

    public HeaderBar(String title, Image icon, boolean showSpinner) {
        this.setUIID("HeaderBar");
        this.setLayout(new BorderLayout());
        this.mHeaderIcon = this.initHeaderIcon(icon);
        this.addComponent("West", (Component)this.mHeaderIcon);
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.addComponent("Center", (Component)this.mHeaderLabel);
        this.mHeaderSpinner = new InfiniteProgressIndicator(0);
        if (showSpinner) {
            this.addComponent("East", (Component)this.mHeaderSpinner);
        }
        this.setScrollable(false);
    }

    public HeaderBar(String title, String subText, Image icon) {
        this.setUIID("HeaderBar");
        this.setLayout(new BorderLayout());
        this.mHeaderIcon = this.initHeaderIcon(icon);
        this.addComponent("West", (Component)this.mHeaderIcon);
        Container cont = new Container(new GridLayout(2, 1));
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.mHeaderLabel.getStyle().setPadding(2, 0);
        cont.addComponent(this.mHeaderLabel);
        this.mHeaderSubLabel = this.initHeaderSubLabel(subText);
        this.mHeaderSubLabel.getStyle().setPadding(0, 0);
        this.mHeaderSubLabel.getStyle().setMargin(0, 0);
        cont.addComponent(this.mHeaderSubLabel);
        this.addComponent("Center", (Component)cont);
    }

    public HeaderBar(String title, Image unselectedIcon, Image selectedIcon) {
        this.setUIID("HeaderBar");
        this.setLayout(new BoxLayout(2));
        this.mHeaderLabel = this.initHeaderLabel(title);
        this.mHeaderActionButton = this.initHeaderActionButton(title, unselectedIcon, selectedIcon);
        this.addComponent(this.mHeaderActionButton);
    }

    private Label initHeaderLabel(String title) {
        Label l = new Label(title);
        l.getStyle().setBgTransparency(0);
        l.getStyle().setFont(Font.createSystemFont(0, 1, 0));
        l.getStyle().setFgColor(this.HEADER_TITLE_COLOR);
        l.setEndsWith3Points(false);
        l.setFocusable(false);
        return l;
    }

    private Label initHeaderSubLabel(String text) {
        Label l = new Label(text);
        l.getStyle().setBgTransparency(0);
        l.getStyle().setFont(Font.createSystemFont(0, 0, 8));
        l.getStyle().setFgColor(this.HEADER_SUBTITLE_COLOR);
        l.setEndsWith3Points(true);
        l.setFocusable(false);
        return l;
    }

    private Label initHeaderIcon(Image image) {
        Label l = new Label();
        l.setIcon(image);
        l.getStyle().setBgTransparency(0);
        l.setFocusable(false);
        return l;
    }

    private Button initHeaderActionButton(String title, final Image unselectedIcon, final Image selectedIcon) {
        Button b = new Button(title){
            private Image mCurrentIcon;
            {
                this.mCurrentIcon = unselectedIcon;
            }

            public void paint(Graphics g) {
                if (this.getState() == 1) {
                    this.mCurrentIcon = selectedIcon;
                    HeaderBar.this.repaint();
                } else {
                    this.mCurrentIcon = unselectedIcon;
                }
                super.paint(g);
                int x = this.getX();
                int y = this.getY();
                int rightpadding = this.getStyle().getPadding(3);
                if (this.mCurrentIcon != null) {
                    x = x + this.getWidth() - rightpadding - this.mCurrentIcon.getWidth();
                    g.drawImage(this.mCurrentIcon, x, y += this.getHeight() / 2 - this.mCurrentIcon.getHeight() / 2);
                }
            }

            public void pressed() {
                super.pressed();
                HeaderBar.this.repaint();
            }
        };
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (HeaderBar.this.internalListener != null) {
                    HeaderBar.this.internalListener.notifyHeaderBarListener(HeaderBar.this);
                }
            }
        });
        b.setUIID("Label");
        b.getStyle().merge(this.mHeaderLabel.getStyle());
        b.getPressedStyle().merge(this.mHeaderLabel.getStyle());
        b.getSelectedStyle().merge(this.mHeaderLabel.getStyle());
        return b;
    }

    public void setHeaderBarListener(HeaderBarListener listener) {
        this.internalListener = listener;
    }

    public void showSpinner() {
        if (this.mHeaderSpinner != null) {
            this.removeComponent(this.mHeaderSpinner);
            this.addComponent("East", (Component)this.mHeaderSpinner);
            this.revalidate();
        }
    }

    public void removeSpinner() {
        if (this.mHeaderSpinner != null) {
            this.removeComponent(this.mHeaderSpinner);
            this.revalidate();
        }
    }

    public Style getStyle() {
        if (this.mHeaderActionButton != null && this.mHeaderActionButton.getState() == 1) {
            return this.getPressedStyle();
        }
        return super.getStyle();
    }

    public void setUIID(String id) {
        super.setUIID(id);
    }

    public String getHeaderTitle() {
        if (this.mHeaderLabel != null) {
            return this.mHeaderLabel.getText();
        }
        return null;
    }

    public void setHeaderTitle(String text) {
        if (this.mHeaderLabel != null) {
            this.mHeaderLabel.setText(text);
        }
    }

    public String getHeaderSubTitle() {
        if (this.mHeaderSubLabel != null) {
            return this.mHeaderSubLabel.getText();
        }
        return null;
    }

    public void setHeaderSubTitle(String text) {
        if (this.mHeaderSubLabel != null) {
            this.mHeaderSubLabel.setText(text);
        }
    }

    public Image getHeaderIcon() {
        if (this.mHeaderIcon != null) {
            return this.mHeaderIcon.getIcon();
        }
        return null;
    }

    public void setHeaderIcon(Image image) {
        if (image != null && this.mHeaderIcon != null) {
            this.mHeaderIcon.setIcon(image);
        }
    }

    public int getHeaderTitleColor() {
        if (this.mHeaderLabel != null) {
            return this.mHeaderLabel.getStyle().getFgColor();
        }
        return this.HEADER_TITLE_COLOR;
    }

    public void setHeaderTitleColor(int color) {
        if (this.mHeaderLabel != null) {
            this.mHeaderLabel.getStyle().setFgColor(color);
            if (this.mHeaderActionButton != null) {
                this.mHeaderActionButton.getStyle().merge(this.mHeaderLabel.getStyle());
                this.mHeaderActionButton.getPressedStyle().merge(this.mHeaderLabel.getStyle());
                this.mHeaderActionButton.getSelectedStyle().merge(this.mHeaderLabel.getStyle());
            }
        }
    }

    public int getHeaderSubTitleColor() {
        if (this.mHeaderSubLabel != null) {
            return this.mHeaderSubLabel.getStyle().getFgColor();
        }
        return this.HEADER_SUBTITLE_COLOR;
    }

    public void setHeaderSubTitleColor(int color) {
        if (this.mHeaderSubLabel != null) {
            this.mHeaderSubLabel.getStyle().setFgColor(color);
        }
    }
}

