/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.PickerItemContainerListener;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class PickerItemContainer
extends Container {
    private static int PICKER_SIDE_NONE = -1;
    private static int PICKER_SIDE_LEFT = 1;
    private static int PICKER_SIDE_MIDDLE = 2;
    private static int PICKER_SIDE_RIGHT = 3;
    private static int PICKER_SIDE_FULL = 4;
    private int selectedIndex;
    private int pressedY;
    private boolean isCyclic;
    private Label pickerValueLabel;
    private PickerItemContainerListener pickerItemContainerListener;
    private InnerLabel previous;
    private InnerLabel current;
    private InnerLabel next;
    private Vector itemValue;
    private PointerDragListener dragListener;
    private Style labelSelected;
    private Style labelUnselected;
    private Style left;
    private Style middle;
    private Style right;
    private Style full;
    private Style pickerListItemNormal;
    private Style pickerListItemHalfSelected;
    private Style pickerListItemSelected;
    private int currentPickerSide;

    public PickerItemContainer(Vector values, Label label) {
        this.pickerValueLabel = label;
        this.setLayout(new GridLayout(3, 1));
        this.setUIID("PickerList");
        this.itemValue = values;
        this.currentPickerSide = PICKER_SIDE_NONE;
        Font font = Font.createDirectUtilsSystemFont(0, 1, 30);
        this.previous = new InnerLabel(this);
        this.previous.setFocusable(false);
        this.current = new InnerLabel(this);
        this.current.setFocusable(false);
        this.next = new InnerLabel(this);
        this.next.setFocusable(false);
        this.setFont(this.previous, font);
        this.setFont(this.current, font);
        this.setFont(this.next, font);
        this.previous.setVisible(false);
        this.next.setVisible(false);
        this.addComponent(this.previous);
        this.addComponent(this.current);
        this.addComponent(this.next);
        this.setSelectedIndex(0);
        this.setCyclic(true);
        this.initLabels();
        this.dragListener = new PointerDragListener(this);
    }

    private void setFont(Label label, Font font) {
        Style style = label.getStyle();
        style.setFont(font, true);
        label.setSelectedStyle(style);
        label.setUnselectedStyle(style);
        label.setPressedStyle(style);
        label.setDisabledStyle(style);
    }

    protected void initComponent() {
        super.initComponent();
        this.labelUnselected = UIManager.getInstance().getComponentStyle(this.pickerValueLabel.getUIID());
        this.labelSelected = UIManager.getInstance().getComponentSelectedStyle(this.pickerValueLabel.getUIID());
        this.left = UIManager.getInstance().getComponentStyle("PickerListSelectedLeft");
        this.middle = UIManager.getInstance().getComponentStyle("PickerListSelectedMiddle");
        this.right = UIManager.getInstance().getComponentStyle("PickerListSelectedRight");
        this.full = UIManager.getInstance().getComponentStyle("PickerListSelectedFull");
        this.pickerListItemNormal = UIManager.getInstance().getComponentStyle("PickerListItem");
        this.pickerListItemSelected = UIManager.getInstance().getComponentStyle("PickerListItemSelected");
        this.pickerListItemHalfSelected = UIManager.getInstance().getComponentStyle("PickerListItemHalfSelected");
        Form form = this.getComponentForm();
        if (form != null) {
            form.addPointerDraggedListener(this.dragListener);
        }
    }

    protected void deinitialize() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removePointerDraggedListener(this.dragListener);
        }
        super.deinitialize();
    }

    public void setDataChangeListener(PickerItemContainerListener listener) {
        this.pickerItemContainerListener = listener;
    }

    public PickerItemContainerListener getDataChangeListener() {
        return this.pickerItemContainerListener;
    }

    private void initLabels() {
        if (this.itemValue.size() < 2) {
            this.previous.setVisible(false);
            this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
            this.next.setVisible(false);
            this.updateLabelColorsOnDrag(true);
        } else if (this.selectedIndex == 0) {
            if (this.isCyclic) {
                this.previous.setText(String.valueOf(this.itemValue.elementAt(this.itemValue.size() - 1)));
                this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
                this.next.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex + 1)));
            } else {
                this.previous.setVisible(false);
                this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
                this.next.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex + 1)));
            }
        } else if (this.selectedIndex == this.itemValue.size() - 1) {
            if (this.isCyclic) {
                this.previous.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex - 1)));
                this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
                this.next.setText(String.valueOf(this.itemValue.elementAt(0)));
            } else {
                this.previous.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex - 1)));
                this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
                this.next.setVisible(false);
            }
        } else {
            this.previous.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex - 1)));
            this.current.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
            this.next.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex + 1)));
        }
    }

    private void updateLabelColorsOnDrag(boolean isDragging) {
        if (isDragging) {
            this.previous.getStyle().setFgColor(this.pickerListItemHalfSelected.getFgColor());
            this.current.getStyle().setFgColor(this.pickerListItemSelected.getFgColor());
            this.next.getStyle().setFgColor(this.pickerListItemHalfSelected.getFgColor());
        } else {
            this.previous.getStyle().setFgColor(this.pickerListItemNormal.getFgColor());
            this.current.getStyle().setFgColor(this.pickerListItemNormal.getFgColor());
            this.next.getStyle().setFgColor(this.pickerListItemNormal.getFgColor());
        }
    }

    private void changeLabelColor(Label label, int color) {
        label.getStyle().setFgColor(color);
    }

    public void updatePicker() {
        this.initLabels();
    }

    public void setSelectedIndex(int index) {
        if (index > this.itemValue.size() - 1 || index < 0) {
            throw new IllegalArgumentException("Invalid index value");
        }
        this.selectedIndex = index;
        this.initLabels();
        if (this.pickerValueLabel != null) {
            this.pickerValueLabel.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int setSelectedValue(String value) {
        int found = -1;
        if (value != null && this.itemValue != null) {
            for (int i = 0; i < this.itemValue.size(); ++i) {
                if (!String.valueOf(this.itemValue.elementAt(i)).equals(value)) continue;
                this.selectedIndex = i;
                found = i;
                this.initLabels();
                if (this.pickerValueLabel == null) break;
                this.pickerValueLabel.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
                break;
            }
        }
        return found;
    }

    public Object getSelectedValue() {
        return this.itemValue.elementAt(this.selectedIndex);
    }

    public void setCyclic(boolean value) {
        this.isCyclic = value ? (this.itemValue.size() > 2 ? value : false) : value;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public String getUIID() {
        return super.getUIID();
    }

    public void setUIID(String id) {
        super.setUIID(id);
    }

    public Style getStyle() {
        if (this.currentPickerSide == PICKER_SIDE_LEFT) {
            return this.left;
        }
        if (this.currentPickerSide == PICKER_SIDE_MIDDLE) {
            return this.middle;
        }
        if (this.currentPickerSide == PICKER_SIDE_RIGHT) {
            return this.right;
        }
        if (this.currentPickerSide == PICKER_SIDE_FULL) {
            return this.full;
        }
        return super.getUnselectedStyle();
    }

    public void pointerPressed(int x, int y) {
        this.pressedY = y;
    }

    public void pointerReleased(int x, int y) {
        this.resetPicker();
    }

    public void pointerDragged(int x, int y) {
        if (this.itemValue.size() < 2) {
            return;
        }
        int diff = Math.abs(y - this.pressedY);
        if (diff < 10) {
            return;
        }
        if (!this.previous.isVisible()) {
            this.previous.setVisible(true);
        }
        if (!this.next.isVisible()) {
            this.next.setVisible(true);
        }
        if (y > this.pressedY) {
            this.pressedY = y;
            if (this.selectedIndex == 0) {
                if (this.isCyclic) {
                    this.selectedIndex = this.itemValue.size() - 1;
                }
            } else {
                --this.selectedIndex;
            }
        } else if (y < this.pressedY) {
            this.pressedY = y;
            if (this.selectedIndex == this.itemValue.size() - 1) {
                if (this.isCyclic) {
                    this.selectedIndex = 0;
                }
            } else {
                ++this.selectedIndex;
            }
        }
        this.updateLabelColorsOnDrag(true);
        this.initLabels();
        if (this.pickerValueLabel != null) {
            this.pickerValueLabel.setText(String.valueOf(this.itemValue.elementAt(this.selectedIndex)));
            this.changeLabelColor(this.pickerValueLabel, this.labelSelected.getFgColor());
        }
        if (this.pickerItemContainerListener != null) {
            this.pickerItemContainerListener.notifyPickerItemContainerListener(this);
        }
        this.revalidate();
    }

    public void resetPicker() {
        this.updateLabelColorsOnDrag(false);
        if (this.pickerValueLabel != null) {
            this.changeLabelColor(this.pickerValueLabel, this.labelUnselected.getFgColor());
        }
        this.pressedY = -1;
        this.previous.setVisible(false);
        this.next.setVisible(false);
        this.currentPickerSide = PICKER_SIDE_NONE;
        this.revalidate();
    }

    public void setValues(Vector values) {
        this.itemValue = values;
    }

    class InnerLabel
    extends Label {
        PickerItemContainer _item;

        public InnerLabel(PickerItemContainer item) {
            this.setUIID("PickerListItem");
            this._item = item;
        }

        protected Dimension calcPreferredSize() {
            int width = this.getWidth() - this.getStyle().getMargin(1) - this.getStyle().getMargin(3);
            int height = 52;
            return new Dimension(width, height);
        }

        public void pointerPressed(int x, int y) {
            this._item.pointerPressed(x, y);
        }

        public void pointerReleased(int x, int y) {
            this._item.pointerReleased(x, y);
        }

        public void pointerDragged(int x, int y) {
            this._item.pointerDragged(x, y);
        }

        public void setUIID(String id) {
            super.setUIID(id);
        }

        public Style getStyle() {
            return super.getUnselectedStyle();
        }
    }

    private class PointerDragListener
    implements ActionListener {
        PickerItemContainer container;

        public PointerDragListener(PickerItemContainer container) {
            this.container = container;
        }

        public void actionPerformed(ActionEvent evt) {
            int y;
            int x = evt.getX();
            if (!this.container.contains(x, y = evt.getY())) {
                this.container.resetPicker();
            } else {
                int count = PickerItemContainer.this.getParent().getComponentCount();
                if (count == 1) {
                    PickerItemContainer.this.currentPickerSide = PICKER_SIDE_FULL;
                } else {
                    for (int i = 0; i < count; ++i) {
                        if (!this.container.equals(PickerItemContainer.this.getParent().getComponentAt(i))) continue;
                        if (i == 0) {
                            PickerItemContainer.this.currentPickerSide = PICKER_SIDE_LEFT;
                            continue;
                        }
                        if (i == count - 1) {
                            PickerItemContainer.this.currentPickerSide = PICKER_SIDE_RIGHT;
                            continue;
                        }
                        PickerItemContainer.this.currentPickerSide = PICKER_SIDE_MIDDLE;
                    }
                }
            }
        }
    }
}

