/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class Label
extends Component {
    private String text = "";
    private Image icon;
    private int valign = 2;
    private int textPosition = 3;
    private int gap = 2;
    private int shiftText = 0;
    private boolean tickerRunning = false;
    private static boolean defaultTickerEnabled = true;
    private boolean tickerEnabled = defaultTickerEnabled;
    private long tickerStartTime;
    private long tickerDelay;
    private boolean rightToLeft;
    private boolean endsWith3Points = true;

    public Label(String text) {
        this.setUIID("Label");
        this.text = text;
        this.localize();
        this.setFocusable(false);
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    Label(String text, String uiid) {
        this.text = text;
        this.localize();
        this.setFocusable(false);
        this.setUIID(uiid);
    }

    public Label() {
        this("");
    }

    public Label(Image icon) {
        this("");
        this.icon = icon;
    }

    public int getBaselineResizeBehavior() {
        switch (this.valign) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    public void setText(String text) {
        this.text = text;
        this.localize();
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    private void localize() {
        this.text = UIManager.getInstance().localize(this.text, this.text);
    }

    void initComponentImpl() {
        LookAndFeel lf;
        super.initComponentImpl();
        if (this.hasFocus() && (lf = UIManager.getInstance().getLookAndFeel()) instanceof DefaultLookAndFeel) {
            ((DefaultLookAndFeel)lf).focusGained(this);
        }
        if (this.isTickerEnabled() && this.isTickerRunning() && !this.isCellRenderer()) {
            this.getComponentForm().registerAnimatedInternal(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Image icon) {
        if (this.icon == icon) {
            return;
        }
        this.icon = icon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if (this.icon != null && this.icon.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setAlignment(int align) {
        this.getSelectedStyle().setAlignment(align);
        this.getUnselectedStyle().setAlignment(align);
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 4 && valign != 0 && valign != 2) {
            throw new IllegalArgumentException("Alignment can't be set to " + valign);
        }
        this.valign = valign;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public void setTextPosition(int textPosition) {
        if (textPosition != 1 && textPosition != 3 && textPosition != 2 && textPosition != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + textPosition);
        }
        this.textPosition = textPosition;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    protected String paramString() {
        return super.paramString() + ", text = " + this.getText() + ", gap = " + this.gap;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawLabel(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getLabelPreferredSize(this);
    }

    public int getShiftText() {
        return this.shiftText;
    }

    public void setShiftText(int shiftText) {
        this.shiftText = shiftText;
    }

    public boolean shouldTickerStart() {
        int textSpaceW;
        if (!this.tickerEnabled) {
            return false;
        }
        Style style = this.getStyle();
        int txtW = style.getFont().stringWidth(this.getText());
        return txtW > (textSpaceW = this.getAvaliableSpaceForText()) && textSpaceW > 0;
    }

    Image getIconFromState() {
        return this.getIcon();
    }

    int getAvaliableSpaceForText() {
        Style style = this.getStyle();
        int textSpaceW = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1);
        Image icon = this.getIconFromState();
        if (icon != null && (this.getTextPosition() == 3 || this.getTextPosition() == 1)) {
            textSpaceW -= icon.getWidth();
        }
        return textSpaceW;
    }

    public void startTicker() {
        this.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
    }

    public void startTicker(long delay, boolean rightToLeft) {
        Form parent;
        if (!this.tickerEnabled) {
            return;
        }
        if (!this.isCellRenderer() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimatedInternal(this);
        }
        this.tickerStartTime = System.currentTimeMillis();
        this.tickerDelay = delay;
        this.tickerRunning = true;
        this.rightToLeft = rightToLeft;
        if (this.isRTL()) {
            this.rightToLeft = !this.rightToLeft;
        }
    }

    public void stopTicker() {
        this.tickerRunning = false;
        this.setShiftText(0);
        this.deregisterAnimatedInternal();
    }

    void tryDeregisterAnimated() {
    }

    public boolean isTickerRunning() {
        return this.tickerRunning;
    }

    public void setTickerEnabled(boolean tickerEnabled) {
        this.tickerEnabled = tickerEnabled;
    }

    public boolean isTickerEnabled() {
        return this.tickerEnabled;
    }

    public void setEndsWith3Points(boolean endsWith3Points) {
        this.endsWith3Points = endsWith3Points;
    }

    public boolean isEndsWith3Points() {
        return this.endsWith3Points;
    }

    public boolean animate() {
        boolean animateTicker = false;
        if (this.tickerRunning && this.tickerStartTime + this.tickerDelay < System.currentTimeMillis()) {
            this.tickerStartTime = System.currentTimeMillis();
            this.shiftText = this.rightToLeft ? (this.shiftText -= 2) : (this.shiftText += 2);
            animateTicker = true;
        }
        boolean val = this.icon != null && this.icon.isAnimation() && this.icon.animate();
        boolean parent = super.animate();
        return val || parent || animateTicker;
    }

    public static boolean isDefaultTickerEnabled() {
        return defaultTickerEnabled;
    }

    public static void setDefaultTickerEnabled(boolean aDefaultTickerEnabled) {
        defaultTickerEnabled = aDefaultTickerEnabled;
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.checkIfTickerNeeded();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.checkIfTickerNeeded();
    }

    private void checkIfTickerNeeded() {
        if (!this.tickerEnabled) {
            return;
        }
        if (this.shouldTickerStart()) {
            if (!this.tickerRunning && this.hasFocus()) {
                this.startTicker();
            }
        } else {
            this.stopTicker();
        }
    }
}

