/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Slider
extends Label {
    private int value;
    private int maxValue = 100;
    private int minValue = 0;
    private boolean vertical;
    private boolean editable;
    private EventDispatcher listeners = new EventDispatcher();
    private int increments = 4;
    private int previousX = -1;
    private int previousY = -1;
    private Style sliderFull;
    private Style sliderFullSelected;
    private boolean paintingFull;
    private boolean renderPercentageOnTop;
    private boolean renderValueOnTop;
    private boolean infinite = false;
    private boolean sliderPressed = false;
    private float infiniteDirection = 0.03f;
    private Image thumbImage;
    private Image thumbImageNormal;
    private Image thumbImagePressed;
    private Label sliderBubble;
    private String text;
    PointerDragListener _pointerDragListener;
    private int sliderprefW = 0;
    private int sliderprefH = 0;

    public Slider() {
        this("Slider", "SliderFull");
    }

    private Slider(String uiid, String fullUIID) {
        this.setFocusable(false);
        this.setUIID(uiid);
        if (this.isASHADefaultThemeLoaded()) {
            this.thumbImageNormal = UIManager.getInstance().getThemeImageConstant("sliderThumbImage");
            this.thumbImagePressed = UIManager.getInstance().getThemeImageConstant("sliderPressedThumbImage");
            this.sliderBubble = new Label();
            this.sliderBubble.setUIID("SliderBubble");
            this.sliderBubble.setText("" + this.getSliderValue());
        }
        this.setAlignment(4);
    }

    public void setUIID(String id) {
        super.setUIID(id);
        this.sliderFull = UIManager.getInstance().getComponentStyle(id + "Full");
        this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle(id + "Full");
        this.initCustomStyle(this.sliderFull);
        this.initCustomStyle(this.sliderFullSelected);
    }

    public void initComponent() {
        this._pointerDragListener = new PointerDragListener(this);
        this.getComponentForm().addPointerDraggedListener(this._pointerDragListener);
        if (this.infinite) {
            this.getComponentForm().registerAnimatedInternal(this);
        }
    }

    public void deinitialize() {
        Form f;
        if (this.infinite && (f = this.getComponentForm()) != null) {
            f.deregisterAnimatedInternal(this);
        }
    }

    public boolean animate() {
        if (this.infinite) {
            super.animate();
            float f = this.infiniteDirection * (float)this.getRange();
            if ((int)f == 0) {
                f = f < 0.0f ? -1.0f : 1.0f;
            }
            this.value += (int)f;
            if (this.value >= this.maxValue) {
                this.value = this.maxValue;
                this.infiniteDirection *= -1.0f;
            }
            if (this.value <= 0) {
                this.value = 0;
                this.infiniteDirection *= -1.0f;
            }
            return true;
        }
        return super.animate();
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean i) {
        if (this.infinite != i) {
            this.infinite = i;
            if (this.isInitialized()) {
                if (i) {
                    this.getComponentForm().registerAnimated(this);
                } else {
                    this.getComponentForm().deregisterAnimated(this);
                }
            }
        }
        if (i) {
            this.minValue = 0;
            this.maxValue = 100;
            this.setRenderPercentageOnTop(false);
            this.setRenderValueOnTop(false);
            if (this.isASHADefaultThemeLoaded()) {
                this.setVertical(false);
            }
        }
    }

    public static Slider createInfinite() {
        Slider s = new Slider();
        s.infinite = true;
        return s;
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.deinitializeCustomStyle(this.sliderFull);
        this.deinitializeCustomStyle(this.sliderFullSelected);
        if (this.isASHADefaultThemeLoaded() && this.vertical && !this.infinite) {
            this.sliderFull = UIManager.getInstance().getComponentStyle("VerticalSliderFull");
            this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle("VerticalSliderFull");
        } else {
            this.sliderFull = UIManager.getInstance().getComponentStyle("SliderFull");
            this.sliderFullSelected = UIManager.getInstance().getComponentSelectedStyle("SliderFull");
        }
    }

    public int getSliderValue() {
        return this.value;
    }

    public void setSliderValue(int value) {
        if (value < this.minValue) {
            throw new IllegalArgumentException("Slider value must be greater or equal than the minimum value.");
        }
        if (value > this.maxValue) {
            throw new IllegalArgumentException("Slider value must be less or equal than the maximum value.");
        }
        this.value = value;
        this.refreshText();
    }

    private void refreshText() {
        if (this.isASHADefaultThemeLoaded()) {
            if (this.renderValueOnTop) {
                this.sliderBubble.setText("" + this.getSliderValue());
            } else if (this.renderPercentageOnTop) {
                this.sliderBubble.setText(this.getProgress() + "%");
            }
            this.repaint();
        } else if (this.renderValueOnTop) {
            super.setText("" + this.getSliderValue());
        } else if (this.renderPercentageOnTop) {
            super.setText(this.getProgress() + "%");
        } else {
            if (this.text != null) {
                super.setText(this.text);
            } else {
                super.setText("");
            }
            this.repaint();
        }
    }

    public int getProgress() {
        return (int)(this.getRelativeValue() * 100.0f);
    }

    private int getRange() {
        return this.maxValue - this.minValue;
    }

    private float getRelativeValue() {
        return (float)(this.value - this.minValue) / (float)this.getRange();
    }

    private void setRelativeValue(float relativeValue) {
        float rounder = relativeValue > 0.0f ? 0.5f : -0.5f;
        this.setSliderValue((int)((float)this.getRange() * relativeValue + (float)this.minValue + rounder));
        this.refreshText();
    }

    public void setProgress(int value) {
        this.setRelativeValue((float)value / 100.0f);
    }

    public Style getStyle() {
        if (this.paintingFull) {
            if (this.isASHADefaultThemeLoaded()) {
                if (this.hasFocus() && this.isSliderPressed() && !this.infinite) {
                    this.sliderBubble.setVisible(true);
                    return this.sliderFullSelected;
                }
                this.sliderBubble.setVisible(false);
            } else if (this.hasFocus()) {
                return this.sliderFullSelected;
            }
            return this.sliderFull;
        }
        return super.getStyle();
    }

    protected Dimension calcPreferredSize() {
        Style style = this.getStyle();
        int prefW = 0;
        int prefH = 0;
        if (style.getBorder() != null) {
            prefW = Math.max(style.getBorder().getMinimumWidth(), prefW);
            prefH = Math.max(style.getBorder().getMinimumHeight(), prefH);
        }
        if (this.isASHADefaultThemeLoaded()) {
            if (this.vertical) {
                return new Dimension(Math.max(prefW, Font.getDefaultFont().charWidth('X') * 2), Math.max(prefH, Display.getInstance().getDisplayHeight() / 2));
            }
            return new Dimension(Math.max(prefW, Display.getInstance().getDisplayWidth() / 2), Math.max(prefH, 80));
        }
        if (Display.getInstance().isTouchScreenDevice() && this.isEditable()) {
            if (this.vertical) {
                return new Dimension(Math.max(prefW, Font.getDefaultFont().charWidth('X') * 2), Math.max(prefH, Display.getInstance().getDisplayHeight() / 2));
            }
            return new Dimension(Math.max(prefW, Display.getInstance().getDisplayWidth() / 2), Math.max(prefH, Font.getDefaultFont().getHeight() * 2));
        }
        if (this.vertical) {
            return new Dimension(Math.max(prefW, Font.getDefaultFont().charWidth('X')), Math.max(prefH, Display.getInstance().getDisplayHeight() / 2));
        }
        return new Dimension(Math.max(prefW, Display.getInstance().getDisplayWidth() / 2), Math.max(prefH, Font.getDefaultFont().getHeight()));
    }

    public void paintBackground(Graphics g) {
        if (this.isASHADefaultThemeLoaded()) {
            int sliderX = this.getX();
            int sliderY = this.getY();
            this.sliderprefW = 0;
            this.sliderprefH = this.getPreferredH();
            if (this.getStyle().getBorder() != null) {
                this.sliderprefW = this.getStyle().getBorder().getMinimumWidth();
                this.sliderprefH += this.getStyle().getBorder().getMinimumHeight();
            }
            this.setSliderXY(sliderX + this.getWidth() / 2, sliderY + this.sliderprefH / 2);
            super.paintBackground(g);
            this.thumbImage = this.thumbImageNormal;
            if (this.hasFocus() && this.isSliderPressed() && !this.infinite) {
                this.thumbImage = this.thumbImagePressed;
                this.setSliderXY(sliderX + this.getWidth() / 2 - this.sliderFullSelected.getMargin(false, 1), sliderY + this.sliderprefH / 2 - this.sliderFullSelected.getMargin(false, 0));
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            int y = this.getY();
            if (this.infinite) {
                int blockSize = this.getWidth() / 5;
                int x = this.getX() + (int)(this.getRelativeValue() * (float)(this.getWidth() - blockSize));
                g.clipRect(x, y, blockSize, this.getHeight() - 1);
                this.paintingFull = true;
                super.paintBackground(g);
                this.paintingFull = false;
                this.setX(sliderX);
                this.setY(sliderY);
                g.setClip(clipX, clipY, clipW, clipH);
            } else if (this.vertical) {
                this.drawVerticalSlider(g, y, clipX, clipY, clipW, clipH, sliderX, sliderY);
            } else {
                this.drawHorizontalSlider(g, y, clipX, clipY, clipW, clipH, sliderX, sliderY);
            }
        } else {
            super.paintBackground(g);
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            int width = this.getWidth();
            int height = this.getHeight();
            int y = this.getY();
            if (this.infinite) {
                int blockSize = this.getWidth() / 5;
                int x = this.getX() + (int)(this.getRelativeValue() * (float)(this.getWidth() - blockSize));
                g.clipRect(x, y, blockSize, height - 1);
            } else {
                float pixelValue;
                if (this.vertical) {
                    pixelValue = this.getRelativeValue() * (float)this.getHeight();
                    y = pixelValue < 1.0f ? (y += height - (int)Math.floor(pixelValue)) : (y += height - (int)Math.ceil(pixelValue));
                } else {
                    pixelValue = this.getRelativeValue() * (float)this.getWidth();
                    width = pixelValue < 1.0f ? (int)Math.floor(pixelValue) : (int)Math.ceil(pixelValue);
                }
                g.clipRect(this.getX(), y, width, height);
            }
            this.paintingFull = true;
            super.paintBackground(g);
            this.paintingFull = false;
            g.setClip(clipX, clipY, clipW, clipH);
            if (this.thumbImage != null && !this.infinite && this.editable) {
                if (!this.vertical) {
                    int xPos = this.getX() + width - this.thumbImage.getWidth() / 2;
                    xPos = Math.max(this.getX(), xPos);
                    xPos = Math.min(this.getX() + this.getWidth() - this.thumbImage.getWidth(), xPos);
                    g.drawImage(this.thumbImage, xPos, y + height / 2 - this.thumbImage.getHeight() / 2);
                } else {
                    int yPos = y + height - this.thumbImage.getHeight() / 2;
                    yPos = Math.max(this.getY(), yPos);
                    yPos = Math.min(this.getY() + this.getHeight() - this.thumbImage.getHeight(), yPos);
                    g.drawImage(this.thumbImage, this.getX() + width / 2 - this.thumbImage.getWidth() / 2, yPos);
                }
            }
        }
    }

    private void drawHorizontalSlider(Graphics g, int y, int clipX, int clipY, int clipW, int clipH, int sliderX, int sliderY) {
        int width = this.getWidth();
        int height = this.getHeight();
        float pixelValue = this.getRelativeValue() * (float)this.getWidth();
        width = pixelValue < 1.0f ? (int)Math.floor(pixelValue) : (int)Math.ceil(pixelValue);
        g.clipRect(this.getX(), y, width, height);
        this.paintingFull = true;
        super.paintBackground(g);
        this.paintingFull = false;
        this.setX(sliderX);
        this.setY(sliderY);
        g.setClip(clipX, clipY, clipW, clipH);
        if (this.thumbImage != null && !this.infinite && this.editable) {
            y = sliderY + this.sliderprefH / 2;
            int xPos = this.getX() + width - this.thumbImage.getWidth() / 2;
            int yPos = y - this.thumbImage.getHeight() / 2;
            xPos = Math.max(this.getX(), xPos);
            xPos = Math.min(this.getX() + this.getWidth() - this.thumbImage.getWidth(), xPos);
            g.drawImage(this.thumbImage, xPos, yPos);
            if (this.renderValueOnTop || this.renderPercentageOnTop) {
                Dimension d = UIManager.getInstance().getLookAndFeel().getLabelPreferredSize(this.sliderBubble);
                this.sliderBubble.setWidth(d.getWidth());
                this.sliderBubble.setHeight(d.getHeight());
                xPos = Math.min(this.getX() + this.getWidth() - this.sliderBubble.getWidth(), xPos);
                this.sliderBubble.setX(xPos);
                this.sliderBubble.setY(sliderY);
                this.sliderBubble.paintComponent(g);
            }
        }
    }

    private void drawVerticalSlider(Graphics g, int y, int clipX, int clipY, int clipW, int clipH, int sliderX, int sliderY) {
        int width = this.getWidth();
        int height = this.getHeight();
        float pixelValue = this.getRelativeValue() * (float)this.getHeight();
        y = pixelValue < 1.0f ? (y += height - (int)Math.floor(pixelValue)) : (y += height - (int)Math.ceil(pixelValue));
        g.clipRect(this.getX(), y, width, height);
        this.paintingFull = true;
        super.paintBackground(g);
        this.paintingFull = false;
        this.setX(sliderX);
        this.setY(sliderY);
        g.setClip(clipX, clipY, clipW, clipH);
        if (this.thumbImage != null && !this.infinite && this.editable) {
            int x = sliderX + this.getWidth() / 2 + this.sliderprefW / 2;
            int yPos = y - this.thumbImage.getHeight() / 2;
            yPos = Math.max(this.getY() - 4, yPos);
            yPos = Math.min(this.getY() + this.getHeight() - this.thumbImage.getHeight() + 2, yPos);
            g.drawImage(this.thumbImage, x - this.thumbImage.getWidth() / 2, yPos);
            if (this.renderValueOnTop || this.renderPercentageOnTop) {
                Dimension d = UIManager.getInstance().getLookAndFeel().getLabelPreferredSize(this.sliderBubble);
                this.sliderBubble.setWidth(d.getWidth());
                this.sliderBubble.setHeight(d.getHeight());
                this.sliderBubble.setX(sliderX + this.thumbImage.getWidth() + clipW / 2);
                this.sliderBubble.setY(yPos + 4);
                this.sliderBubble.paintComponent(g);
            }
        }
    }

    private void setSliderXY(int x, int y) {
        if (this.vertical && !this.infinite) {
            this.setX(x);
        } else {
            this.setY(y);
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        if (this.isASHADefaultThemeLoaded()) {
            if (vertical && !this.infinite) {
                this.setUIID("VerticalSlider");
            } else {
                this.setUIID("Slider");
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.setFocusable(editable);
    }

    public void pointerPressed(int x, int y) {
        if (!this.editable) {
            return;
        }
        if (this.isASHADefaultThemeLoaded()) {
            this.setSliderPressed(true);
        }
        if (this.vertical) {
            this.setRelativeValue(1.0f - (float)(y -= this.getAbsoluteY()) / ((float)this.getHeight() - 1.0f));
        } else {
            x = Math.abs(x - this.getAbsoluteX());
            this.setRelativeValue((float)x / ((float)this.getWidth() - 1.0f));
        }
        if (this.vertical) {
            if (this.previousY < y) {
                this.fireDataChanged(1, this.value);
            } else {
                this.fireDataChanged(0, this.value);
            }
            this.previousY = y;
        } else {
            if (this.previousX < x) {
                this.fireDataChanged(1, this.value);
            } else {
                this.fireDataChanged(0, this.value);
            }
            this.previousX = x;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.editable) {
            return;
        }
        if (this.vertical && this.previousY == -1) {
            this.previousY = y;
            return;
        }
        if (!this.vertical && this.previousX == -1) {
            this.previousX = x;
            return;
        }
        if (this.isASHADefaultThemeLoaded()) {
            this.setSliderPressed(true);
        }
        int prevValue = this.getSliderValue();
        if (this.vertical) {
            this.setRelativeValue(1.0f - (float)(y -= this.getAbsoluteY()) / ((float)this.getHeight() - 1.0f));
        } else {
            this.setRelativeValue((float)(x -= this.getAbsoluteX()) / ((float)this.getWidth() - 1.0f));
        }
        if (prevValue != this.getSliderValue()) {
            if (this.vertical) {
                if (this.previousY < y) {
                    this.fireDataChanged(1, this.value);
                } else {
                    this.fireDataChanged(0, this.value);
                }
                this.previousY = y;
            } else {
                if (this.previousX < x) {
                    this.fireDataChanged(1, this.value);
                } else {
                    this.fireDataChanged(0, this.value);
                }
                this.previousX = x;
            }
        }
    }

    protected void fireClicked() {
        this.setHandlesInput(!this.handlesInput());
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void pointerReleased(int x, int y) {
        if (!this.editable) {
            return;
        }
        this.previousX = -1;
        this.previousY = -1;
        if (this.isASHADefaultThemeLoaded()) {
            this.setSliderPressed(false);
        }
    }

    public void keyPressed(int code) {
        if (this.editable && this.handlesInput()) {
            int game = Display.getInstance().getGameAction(code);
            switch (game) {
                case 1: {
                    if (this.vertical) {
                        this.setProgress((byte)Math.min(this.maxValue, this.value + this.increments));
                        this.fireDataChanged(1, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 6: {
                    if (this.vertical) {
                        this.setProgress((byte)Math.max(this.minValue, this.value - this.increments));
                        this.fireDataChanged(0, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 2: {
                    if (!this.vertical) {
                        this.setProgress((byte)Math.max(this.minValue, this.value - this.increments));
                        this.fireDataChanged(0, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 5: {
                    if (!this.vertical) {
                        this.setProgress((byte)Math.min(this.maxValue, this.value + this.increments));
                        this.fireDataChanged(1, this.value);
                        break;
                    }
                    this.setHandlesInput(false);
                    break;
                }
                case 8: {
                    if (Display.getInstance().isThirdSoftButton()) break;
                    this.fireClicked();
                }
            }
        } else if (!Display.getInstance().isThirdSoftButton() && Display.getInstance().getGameAction(code) == 8) {
            this.fireClicked();
        }
        super.keyPressed(code);
    }

    public int getIncrements() {
        return this.increments;
    }

    public void setIncrements(int increments) {
        this.increments = increments;
    }

    private void fireDataChanged(int event, int val) {
        this.listeners.fireDataChangeEvent(val, event);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.listeners.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.listeners.removeListener(l);
    }

    public boolean isRenderPercentageOnTop() {
        return this.renderPercentageOnTop;
    }

    public void setRenderPercentageOnTop(boolean renderPercentageOnTop) {
        this.renderPercentageOnTop = this.infinite ? false : renderPercentageOnTop;
        this.refreshText();
        this.repaint();
    }

    public void setText(String text) {
        if (this.isASHADefaultThemeLoaded()) {
            super.setText(null);
        } else {
            this.text = text;
            super.setText(text);
        }
    }

    public boolean isRenderValueOnTop() {
        return this.renderValueOnTop;
    }

    public void setRenderValueOnTop(boolean renderValueOnTop) {
        this.renderValueOnTop = this.infinite ? false : renderValueOnTop;
        this.refreshText();
        this.repaint();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        if (!this.infinite) {
            if (maxValue <= this.minValue) {
                throw new IllegalArgumentException("Slider maximum value must be greater than the minimum value.");
            }
            this.maxValue = maxValue;
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        if (!this.infinite) {
            if (minValue >= this.maxValue) {
                throw new IllegalArgumentException("Slider minimum value must be less than maximum value");
            }
            this.minValue = minValue;
        }
    }

    private boolean isSliderPressed() {
        return this.sliderPressed;
    }

    protected void setSliderPressed(boolean sliderPressed) {
        this.sliderPressed = sliderPressed;
    }

    public Image getThumbImage() {
        return this.thumbImage;
    }

    public void setThumbImage(Image thumbImage) {
        this.thumbImage = thumbImage;
        this.thumbImageNormal = thumbImage;
        this.thumbImagePressed = thumbImage;
    }

    boolean shouldBlockSideSwipe() {
        return !this.vertical;
    }

    private boolean isASHADefaultThemeLoaded() {
        return Display.getInstance().getDeviceType() == 3 && UIManager.getInstance().getThemeName() != null && UIManager.getInstance().getThemeName().equals("NokiaTheme");
    }

    private void resetSlider() {
        if (this.isASHADefaultThemeLoaded()) {
            this.setSliderPressed(false);
            this.repaint();
        }
    }

    private class PointerDragListener
    implements ActionListener {
        Slider _slider;

        public PointerDragListener(Slider slider2) {
            this._slider = slider2;
        }

        public void actionPerformed(ActionEvent evt) {
            int y;
            int x = evt.getX();
            if (!Slider.this.contains(x, y = evt.getY())) {
                this._slider.resetSlider();
            }
        }
    }
}

