/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.AnimationObject;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;

public final class Timeline
extends Image
implements Animation,
Painter {
    private int time;
    private int duration;
    AnimationObject[] animations;
    private Dimension size;
    private Dimension scaledTo;
    private long currentTime = -1L;
    private int animationDelay = 100;
    private boolean pause;
    private boolean loop = true;

    private Timeline() {
        super(null);
    }

    public void lock() {
        if (this.animations != null) {
            for (int iter = 0; iter < this.animations.length; ++iter) {
                this.animations[iter].lock();
            }
        }
    }

    public void unlock() {
        if (this.animations != null) {
            for (int iter = 0; iter < this.animations.length; ++iter) {
                this.animations[iter].unlock();
            }
        }
    }

    public int[] getRGB() {
        Image i = Image.createImage(this.getWidth(), this.getHeight());
        this.paint(i.getGraphics(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        return i.getRGB();
    }

    public int[] getRGBCached() {
        return this.getRGB();
    }

    public static Timeline createTimeline(int duration, AnimationObject[] animations, Dimension size) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Illegal duration " + duration);
        }
        Timeline t = new Timeline();
        t.duration = duration;
        t.animations = animations;
        t.size = size;
        return t;
    }

    public void addAnimation(AnimationObject o) {
        AnimationObject[] n = new AnimationObject[this.animations.length + 1];
        System.arraycopy(this.animations, 0, n, 0, this.animations.length);
        n[this.animations.length] = o;
        this.animations = n;
    }

    public void setTime(int time) {
        if (!this.pause && time >= 0 && time <= this.duration) {
            this.time = time;
            this.currentTime = System.currentTimeMillis();
        }
    }

    public int getTime() {
        return this.time;
    }

    public boolean isAnimation() {
        return true;
    }

    public boolean animate() {
        if (!this.pause) {
            if (this.currentTime < 0L) {
                this.currentTime = System.currentTimeMillis();
                this.setTime(0);
                return true;
            }
            long newCurrentTime = System.currentTimeMillis();
            if (newCurrentTime - this.currentTime >= (long)this.animationDelay) {
                int newTime = (int)((long)this.time + (newCurrentTime - this.currentTime));
                this.currentTime = newCurrentTime;
                if (newTime > this.duration) {
                    if (!this.loop) {
                        return false;
                    }
                    newTime = 0;
                }
                this.setTime(newTime);
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g) {
        this.paint(g, null);
    }

    public void paint(Graphics g, Rectangle rect) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (rect != null) {
            scaleX = (float)rect.getSize().getWidth() / (float)this.size.getWidth();
            scaleY = (float)rect.getSize().getHeight() / (float)this.size.getHeight();
        }
        this.paintScaled(g, scaleX, scaleY);
    }

    private void paintScaled(Graphics g, float scaleX, float scaleY) {
        for (int iter = 0; iter < this.animations.length; ++iter) {
            int e;
            int s = this.animations[iter].getStartTime();
            if (s > -1 && s > this.time || (e = this.animations[iter].getEndTime()) > -1 && e < this.time) continue;
            this.animations[iter].setTime(this.time);
            this.animations[iter].draw(g, scaleX, scaleY);
        }
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        g.translate(x, y);
        if (this.scaledTo != null) {
            float scaleX = (float)this.scaledTo.getWidth() / (float)this.size.getWidth();
            float scaleY = (float)this.scaledTo.getHeight() / (float)this.size.getHeight();
            this.paintScaled(g, scaleX, scaleY);
        } else {
            this.paint(g);
        }
        g.translate(-x, -y);
    }

    public int getWidth() {
        if (this.scaledTo != null) {
            return this.scaledTo.getWidth();
        }
        return this.size.getWidth();
    }

    public int getHeight() {
        if (this.scaledTo != null) {
            return this.scaledTo.getHeight();
        }
        return this.size.getHeight();
    }

    public Image scaled(int width, int height) {
        Timeline t = new Timeline();
        t.animationDelay = this.animationDelay;
        t.animations = this.animations;
        t.currentTime = this.currentTime;
        t.duration = this.duration;
        t.size = this.size;
        t.time = this.time;
        t.scaledTo = new Dimension(width, height);
        return t;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public int getDuration() {
        return this.duration;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getAnimationCount() {
        return this.animations.length;
    }

    public AnimationObject getAnimation(int i) {
        return this.animations[i];
    }

    public AnimationObject getAnimationAt(int x, int y) {
        for (int iter = 0; iter < this.animations.length; ++iter) {
            int ay;
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            if (this.scaledTo != null) {
                scaleX = (float)this.scaledTo.getWidth() / (float)this.size.getWidth();
                scaleY = (float)this.scaledTo.getHeight() / (float)this.size.getHeight();
            }
            int w = (int)((float)this.animations[iter].getWidth() * scaleX);
            int h = (int)((float)this.animations[iter].getHeight() * scaleY);
            int ax = (int)((float)this.animations[iter].getX() * scaleX);
            if (!Rectangle.intersects(ax, ay = (int)((float)this.animations[iter].getY() * scaleY), w, h, x, y, 1, 1)) continue;
            int[] rgb = this.animations[iter].getImage().scaled(w, h).getRGB();
            int relativeX = x - ax;
            int relativeY = y - ay;
            int offset = relativeX + relativeY * h;
            if (offset < 0 || offset >= rgb.length || (rgb[offset] & 0xFF000000) == 0) continue;
            return this.animations[iter];
        }
        return null;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }
}

