/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class DefaultListCellRenderer
extends Label
implements ListCellRenderer,
CellRenderer {
    private boolean showNumbers;
    private static boolean showNumbersDefault = true;
    private Label focusComponent = new Label();

    public DefaultListCellRenderer() {
        super("");
        this.setCellRenderer(true);
        this.setEndsWith3Points(false);
        this.showNumbers = UIManager.getInstance().isThemeConstant("rendererShowsNumbersBool", showNumbersDefault);
        this.focusComponent.setUIID("ListRendererFocus");
        this.focusComponent.setFocus(true);
        this.setUIID("ListRenderer");
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.focusComponent.refreshTheme();
    }

    public DefaultListCellRenderer(boolean showNumbers) {
        this();
        this.showNumbers = showNumbers;
    }

    public Component getCellRendererComponent(Component list, Object model, Object value, int index, boolean isSelected) {
        if (!Display.getInstance().shouldRenderSelection(list)) {
            isSelected = false;
        }
        this.setFocus(isSelected);
        if (this.showNumbers) {
            Object o;
            String text = "" + value;
            Hashtable t = UIManager.getInstance().getResourceBundle();
            if (t != null && value != null && (o = t.get(value.toString())) != null) {
                text = (String)o;
            }
            if (this.isRTL()) {
                this.setText(text + " ." + (index + 1));
            } else {
                this.setText("" + (index + 1) + ". " + text);
            }
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("null");
        }
        if (value instanceof Command) {
            this.setIcon(((Command)value).getIcon());
            this.setEnabled(((Command)value).isEnabled());
        }
        return this;
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        return this.getCellRendererComponent(list, list.getModel(), value, index, isSelected);
    }

    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    public void repaint() {
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public int getSelectionTransparency() {
        return this.focusComponent.getUnselectedStyle().getBgTransparency() & 0xFF;
    }

    public void setSelectionTransparency(int selectionTransparency) {
        this.focusComponent.getUnselectedStyle().setBgTransparency(selectionTransparency);
    }

    public static void setShowNumbersDefault(boolean def) {
        showNumbersDefault = def;
    }

    public static boolean isShowNumbersDefault() {
        return showNumbersDefault;
    }

    public Component getFocusComponent(Component list) {
        return this.focusComponent;
    }
}

