/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BorderLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Log {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private int level = 1;
    private static Log instance = new Log();
    private long zeroTime = System.currentTimeMillis();
    private Writer output;
    private boolean fileWriteEnabled = false;
    private String fileURL = null;

    public static void install(Log newInstance) {
        instance = newInstance;
    }

    public static void p(String text) {
        Log.p(text, 1);
    }

    public static void p(String text, int level) {
        instance.print(text, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(String text, int level) {
        if (this.level > level) {
            return;
        }
        text = this.getThreadAndTimeStamp() + " - " + text;
        System.out.println(text);
        if (this.isFileWriteEnabled()) {
            try {
                Log log = this;
                synchronized (log) {
                    Writer w = this.getWriter();
                    w.write(text + "\n");
                    w.close();
                    this.output = null;
                }
            }
            catch (Throwable err) {
                err.printStackTrace();
                this.setFileWriteEnabled(false);
            }
        } else {
            try {
                Log err = this;
                synchronized (err) {
                    RecordStore outputStore = RecordStore.openRecordStore((String)"log", (boolean)true);
                    byte[] bytes = text.getBytes();
                    outputStore.addRecord(bytes, 0, bytes.length);
                    outputStore.closeRecordStore();
                }
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected Writer createWriter() throws IOException {
        try {
            FileConnection con;
            if (instance.getFileURL() == null) {
                instance.setFileURL("file:///" + FileSystemRegistry.listRoots().nextElement() + "/lwuit.log");
            }
            if ((con = (FileConnection)Connector.open((String)instance.getFileURL(), (int)3)).exists()) {
                return new OutputStreamWriter(con.openOutputStream(con.fileSize()));
            }
            con.create();
            return new OutputStreamWriter(con.openOutputStream());
        }
        catch (Exception err) {
            this.setFileWriteEnabled(false);
            return new OutputStreamWriter(new ByteArrayOutputStream());
        }
    }

    private Writer getWriter() throws IOException {
        if (this.output == null) {
            this.output = this.createWriter();
        }
        return this.output;
    }

    protected String getThreadAndTimeStamp() {
        long time = System.currentTimeMillis() - this.zeroTime;
        long milli = time % 1000L;
        long sec = (time /= 1000L) % 60L;
        long min = (time /= 60L) % 60L;
        long hour = (time /= 60L) % 60L;
        return "[" + Thread.currentThread().getName() + "] " + hour + ":" + min + ":" + sec + "," + milli;
    }

    public static void setLevel(int level) {
        Log.instance.level = level;
    }

    public static int getLevel() {
        return Log.instance.level;
    }

    public static String getLogContent() {
        try {
            String text = "";
            if (instance.isFileWriteEnabled()) {
                if (instance.getFileURL() == null) {
                    instance.setFileURL("file:///" + FileSystemRegistry.listRoots().nextElement() + "/lwuit.log");
                }
                FileConnection con = (FileConnection)Connector.open((String)instance.getFileURL(), (int)1);
                InputStreamReader r = new InputStreamReader(con.openInputStream());
                char[] buffer = new char[1024];
                int size = r.read(buffer);
                while (size > -1) {
                    text = text + new String(buffer, 0, size);
                    size = r.read(buffer);
                }
                ((Reader)r).close();
            } else {
                RecordStore store = RecordStore.openRecordStore((String)"log", (boolean)true);
                int size = store.getNumRecords();
                for (int iter = 1; iter <= size; ++iter) {
                    text = text + new String(store.getRecord(iter));
                }
                store.closeRecordStore();
            }
            return text;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static void showLog() {
        try {
            String text = Log.getLogContent();
            TextArea area = new TextArea(text, 5, 20);
            Form f = new Form("Log");
            f.setScrollable(false);
            final Form current = Display.getInstance().getCurrent();
            Command back = new Command("Back"){

                public void actionPerformed(ActionEvent ev) {
                    current.show();
                }
            };
            f.addCommand(back);
            f.setBackCommand(back);
            f.setLayout(new BorderLayout());
            f.addComponent("Center", (Component)area);
            f.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Log getInstance() {
        return instance;
    }

    public boolean isFileWriteEnabled() {
        return this.fileWriteEnabled;
    }

    public void setFileWriteEnabled(boolean fileWriteEnabled) {
        this.fileWriteEnabled = fileWriteEnabled;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }
}

