/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class ContextMenu
extends Dialog
implements ActionListener {
    private List mList;
    private Component mParent;
    private final Image mArrow = UIManager.getInstance().getThemeImageConstant("ContextMenuArrowLeftImage");
    private Command backCommand;
    private boolean skipRelease = false;
    private int defaultTintColor;
    private int contextMenuTintColor = this.defaultTintColor = UIManager.getInstance().getLookAndFeel().getDefaultFormTintColor();

    public ContextMenu(Component parent) {
        super("", "");
        this.getContentPane().setUIID("ContextMenu");
        this.getContentPane().getParent().getStyle().setBgTransparency(0);
        this.mParent = parent;
        this.setDisposeWhenPointerOutOfBounds(true);
        this.setTransitionInAnimator(CommonTransitions.createEmpty());
        this.setTransitionOutAnimator(CommonTransitions.createEmpty());
        this.mList = new List();
        this.mList.addActionListener(this);
        this.mList.getStyle().setPadding(0, 0, 0, 0);
        this.setLayout(new BoxLayout(2));
        this.getTitleArea().setVisible(false);
        this.setScrollable(false);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        renderer.setShowNumbers(false);
        renderer.setUIID("TouchCommand");
        this.mList.setListCellRenderer(renderer);
        this.getContentPane().getStyle().setMargin(0, 0, 0, 0);
        if (this.mArrow != null) {
            this.getContentPane().getStyle().setMargin(1, this.mArrow.getWidth());
        }
        this.addComponent(this.mList);
        this.skipRelease = true;
        this.setDisposeOnRotation(true);
        if (this.getBackCommand() == null) {
            this.backCommand = new Command("Back");
            this.setBackCommand(this.backCommand);
            this.addCommandListener(this);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (Display.getInstance().getDeviceType() == 2) {
            this.paintArrow(g);
        }
    }

    private void paintArrow(Graphics g) {
        Rectangle rect = this.mParent.getSelectedRect();
        int y = rect.getY();
        if (y < this.mList.getAbsoluteY()) {
            y = this.mList.getAbsoluteY();
        } else if (y > this.mList.getAbsoluteY() + this.mList.getHeight() - this.mArrow.getHeight()) {
            y = this.mList.getAbsoluteY() + this.mList.getHeight() - this.mArrow.getHeight();
        }
        int x = this.mList.getAbsoluteX() - this.mArrow.getWidth() - 1;
        g.drawImage(this.mArrow, x, y);
    }

    public void setMenuItems(ListModel model) {
        this.mList.setModel(model);
    }

    public void actionPerformed(ActionEvent ae) {
        ae.consume();
        if (ae.getSource() == this.mList) {
            this.lastCommandPressed = (Command)this.mList.getSelectedItem();
        }
        this.dispose();
    }

    public static Command show(Command[] cmds, Component parent) {
        ContextMenu ctx = new ContextMenu(parent);
        ctx.setMenuItems(new DefaultListModel(cmds));
        return ctx.showImpl();
    }

    private Command showImpl() {
        int bottom;
        double MaxAmountOfListItems;
        this.contextMenuTintColor = Integer.parseInt(UIManager.getInstance().getThemeConstant("choiceTintColor", Integer.toHexString(this.contextMenuTintColor)), 16);
        Display.getInstance().getCurrent().setTintColor(this.contextMenuTintColor);
        double t_and_tLimit = 4.0;
        double d = MaxAmountOfListItems = Display.getInstance().isPortrait() ? 6.0 : 3.5;
        if (Display.getInstance().getDeviceType() == 1 || Display.getInstance().getDeviceType() == 3) {
            MaxAmountOfListItems = 4.0;
        }
        this.skipRelease = true;
        this.getStyle().setPadding(0, 0, 0, 0);
        Container contentPane = this.getContentPane();
        int listsize = this.mList.getModel().getSize();
        double itemsToShow = (double)listsize < MaxAmountOfListItems ? (double)listsize : MaxAmountOfListItems;
        int menuHeight = (int)(itemsToShow * (double)((Component)((Object)this.mList.getRenderer())).getPreferredH());
        if ((double)listsize < MaxAmountOfListItems && menuHeight < this.mList.getScrollDimension().getHeight()) {
            menuHeight = this.mList.getScrollDimension().getHeight();
        }
        menuHeight += this.getStyle().getPadding(0) + this.getStyle().getPadding(2);
        menuHeight += this.getContentPane().getStyle().getPadding(0) + this.getContentPane().getStyle().getPadding(2);
        Border bp = this.getContentPane().getStyle().getBorder();
        if (bp != null) {
            menuHeight += bp.getMinimumHeight();
        }
        menuHeight += contentPane.getStyle().getPadding(0);
        menuHeight += contentPane.getStyle().getPadding(2);
        menuHeight += this.mList.getStyle().getPadding(0);
        menuHeight += this.mList.getStyle().getPadding(2);
        menuHeight += this.mList.getStyle().getMargin(0);
        menuHeight += this.mList.getStyle().getMargin(2);
        this.revalidate();
        Style contentPaneStyle = this.getContentPane().getStyle();
        int prefHeight = contentPane.getPreferredH();
        int prefWidth = contentPane.getPreferredW();
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        Rectangle componentPos = this.mParent.getSelectedRect();
        int displayHeight = Display.getInstance().getDisplayHeight();
        int availableWidth = Display.getInstance().getDisplayWidth();
        int x = 0;
        int y = 0;
        x = componentPos.getX() < 0 ? 0 : x;
        int n = y = componentPos.getY() < 0 ? 0 : y;
        if (y + menuHeight > displayHeight) {
            y -= y + menuHeight - displayHeight;
        }
        bottom = (bottom = displayHeight - (y + menuHeight)) < 0 ? 0 : bottom;
        int right = 0;
        if (availableWidth > displayHeight) {
            right = displayHeight;
        }
        if (Display.getInstance().getDeviceType() == 3) {
            y = displayHeight - menuHeight;
            bottom = 0;
        }
        return this.show(y, bottom, x, right, true, true);
    }

    public void pointerReleased(int x, int y) {
        if (!this.skipRelease) {
            super.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.skipRelease = false;
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.skipRelease = false;
    }

    public void dispose() {
        super.dispose();
        Display.getInstance().getCurrent().setTintColor(this.defaultTintColor);
    }
}

