/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.DatePickerListener;
import com.nokia.lwuit.components.PickerContainer;
import com.nokia.lwuit.components.PickerItemContainer;
import com.nokia.lwuit.components.PickerItemContainerListener;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class DatePicker
extends Form
implements ActionListener,
PickerItemContainerListener {
    public static final int TYPE_PICKER_MM_DD_YYYY = 1;
    public static final int TYPE_PICKER_MM_YYYY = 2;
    public static final int TYPE_PICKER_DAY = 3;
    private static final int SUBTRACT_YEARS = 13;
    private int cachedDD;
    private int cachedMM;
    private int cachedYYYY;
    private int maxYears;
    private int startingYear;
    private int datePickerType;
    private String[] daysofWeek;
    private static String DAY_SYMBOL_TEXT;
    private static String MONTH_SYMBOL_TEXT;
    private static String YEAR_SYMBOL_TEXT;
    private static final String OK_TEXT;
    private static final int DEFAULT_STARTING_YEAR = 2005;
    private static final int DEFAULT_MAXIMUM_YEAR = 200;
    private Label ddLabel;
    private Label mmLabel;
    private Label yyyyLabel;
    private Label ddSymbol;
    private Label mmSymbol;
    private Label yySymbol;
    private Label dayLabel;
    private PickerContainer pickerDDMMYYY;
    private PickerItemContainer ddList;
    private PickerItemContainer mmList;
    private PickerItemContainer yyyyList;
    private Container contentPane;
    private Container dateContainer;
    private Vector noOfDates;
    private Vector noOfMonth;
    private Vector noOfYears;
    private Command okCommand;
    private Command backCommand;
    private Form previousForm;
    private TextArea titleText;
    private DayView dayView;
    private DatePickerListener datePickerListener;

    public DatePicker(int pickerType, int startingYear, int maxYears) {
        this(null, pickerType, startingYear, maxYears, true);
    }

    public DatePicker(String text, int pickerType) {
        this(text, pickerType, 2005, 200, false);
    }

    private DatePicker(String text, int pickerType, int startingYear, int maxYears, boolean customRange) {
        if (customRange) {
            if (pickerType == 3) {
                throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_DD_YYYY or TYPE_PICKER_MM_YYYY");
            }
            if (maxYears <= 0) {
                throw new IllegalArgumentException("Maximum number of years must be greater than 0");
            }
        }
        this.setUIID("Form");
        DAY_SYMBOL_TEXT = UIManager.getInstance().localize("DD", "D");
        MONTH_SYMBOL_TEXT = UIManager.getInstance().localize("MM", "M");
        YEAR_SYMBOL_TEXT = UIManager.getInstance().localize("YY", "Y");
        this.daysofWeek = new String[]{UIManager.getInstance().localize("Sunday", "Sunday"), UIManager.getInstance().localize("Monday", "Monday"), UIManager.getInstance().localize("Tuesday", "Tuesday"), UIManager.getInstance().localize("Wednesday", "Wednesday"), UIManager.getInstance().localize("Thursday", "Thursday"), UIManager.getInstance().localize("Friday", "Friday"), UIManager.getInstance().localize("Saturday", "Saturday")};
        this.okCommand = new Command(OK_TEXT);
        this.backCommand = new Command("Back");
        this.addCommandListener(this);
        this.setDatePickerType(pickerType);
        this.maxYears = maxYears;
        this.startingYear = startingYear;
        if (pickerType == 3) {
            this.initDayDatePicker(text);
        } else if (pickerType == 1) {
            this.initDatePickerThreeColumn();
        } else if (pickerType == 2) {
            this.initDatePickerTwoColumn();
        }
        this.setBackCommand(this.backCommand);
    }

    private void initDayDatePicker(String text) {
        this.setLayout(new BorderLayout());
        if (text == null) {
            text = "";
        }
        Calendar todayDate = Calendar.getInstance();
        this.titleText = new TextArea(3, 4);
        this.titleText.setUIID("DatePickerTitle");
        this.titleText.setText(text);
        this.titleText.setGrowByContent(false);
        this.titleText.setEditable(false);
        this.titleText.setFocusable(false);
        this.addComponent("North", (Component)this.titleText);
        this.dayView = new DayView();
        this.setDate(todayDate.get(5));
        this.addComponent("Center", (Component)this.dayView);
        this.addCommand(this.okCommand);
        this.setScrollable(false);
    }

    private void setFont(Label label, Font font) {
        Style style = label.getStyle();
        style.setFont(font, true);
        label.setSelectedStyle(style);
        label.setUnselectedStyle(style);
        label.setPressedStyle(style);
        label.setDisabledStyle(style);
    }

    private void initDatePickerThreeColumn() {
        int i;
        this.setLayout(new BorderLayout());
        this.contentPane = new Container(new BoxLayout(2));
        Calendar todayDate = Calendar.getInstance();
        this.ddLabel = new Label("");
        this.ddLabel.setUIID("DatePickerValue");
        this.mmLabel = new Label("");
        this.mmLabel.setUIID("DatePickerValue");
        this.yyyyLabel = new Label("");
        this.yyyyLabel.setUIID("DatePickerValue");
        Font font = Font.createDirectUtilsSystemFont(0, 1, 26);
        this.setFont(this.ddLabel, font);
        this.setFont(this.mmLabel, font);
        this.setFont(this.yyyyLabel, font);
        this.ddSymbol = new Label(DAY_SYMBOL_TEXT);
        this.ddSymbol.setUIID("DatePickerLabel");
        this.mmSymbol = new Label(MONTH_SYMBOL_TEXT);
        this.mmSymbol.setUIID("DatePickerLabel");
        this.yySymbol = new Label(YEAR_SYMBOL_TEXT);
        this.yySymbol.setUIID("DatePickerLabel");
        this.dayLabel = new Label("" + this.daysofWeek[todayDate.get(7) - 1]);
        this.dayLabel.getStyle().setAlignment(4);
        Container dateContainerParent = new Container(new FlowLayout(4));
        this.dateContainer = new Container(new BoxLayout(1));
        this.dateContainer.addComponent(this.mmLabel);
        this.dateContainer.addComponent(this.mmSymbol);
        this.dateContainer.addComponent(this.ddLabel);
        this.dateContainer.addComponent(this.ddSymbol);
        this.dateContainer.addComponent(this.yyyyLabel);
        this.dateContainer.addComponent(this.yySymbol);
        dateContainerParent.addComponent(this.dateContainer);
        this.noOfDates = new Vector();
        this.noOfMonth = new Vector();
        this.noOfYears = new Vector();
        int days = this.getDaysInMonth(todayDate.get(2), todayDate.get(1));
        for (i = 1; i <= days; ++i) {
            this.noOfDates.addElement(this.twoDigitValue(i));
        }
        for (i = 1; i <= 12; ++i) {
            this.noOfMonth.addElement(this.twoDigitValue(i));
        }
        for (i = 0; i <= this.maxYears; ++i) {
            this.noOfYears.addElement(String.valueOf(this.startingYear + i));
        }
        this.pickerDDMMYYY = new PickerContainer();
        this.pickerDDMMYYY.setLayout(new GridLayout(1, 3));
        this.ddList = new PickerItemContainer(this.noOfDates, this.ddLabel);
        this.mmList = new PickerItemContainer(this.noOfMonth, this.mmLabel);
        this.yyyyList = new PickerItemContainer(this.noOfYears, this.yyyyLabel);
        this.ddList.setDataChangeListener(this);
        this.mmList.setDataChangeListener(this);
        this.yyyyList.setDataChangeListener(this);
        this.pickerDDMMYYY.addComponent(this.mmList);
        this.pickerDDMMYYY.addComponent(this.ddList);
        this.pickerDDMMYYY.addComponent(this.yyyyList);
        this.ddList.setSelectedValue(this.twoDigitValue(todayDate.get(5)));
        this.mmList.setSelectedValue(this.twoDigitValue(todayDate.get(2) + 1));
        this.yyyyList.setSelectedValue(String.valueOf(todayDate.get(1)));
        this.contentPane.addComponent(dateContainerParent);
        this.contentPane.addComponent(this.dayLabel);
        this.contentPane.addComponent(this.pickerDDMMYYY);
        this.addComponent("North", (Component)new Label(" "));
        this.addComponent("Center", (Component)this.contentPane);
        this.addCommand(this.okCommand);
        this.setScrollable(false);
    }

    private void initDatePickerTwoColumn() {
        int i;
        this.setLayout(new BorderLayout());
        this.contentPane = new Container(new BoxLayout(2));
        Calendar todayDate = Calendar.getInstance();
        this.mmLabel = new Label("");
        this.mmLabel.setUIID("DatePickerValue");
        this.yyyyLabel = new Label("");
        this.yyyyLabel.setUIID("DatePickerValue");
        Font font = Font.createDirectUtilsSystemFont(0, 1, 26);
        this.setFont(this.mmLabel, font);
        this.setFont(this.yyyyLabel, font);
        this.mmSymbol = new Label(MONTH_SYMBOL_TEXT);
        this.mmSymbol.setUIID("DatePickerLabel");
        this.yySymbol = new Label(YEAR_SYMBOL_TEXT);
        this.yySymbol.setUIID("DatePickerLabel");
        Container dateContainerParent = new Container(new FlowLayout(4));
        this.dateContainer = new Container(new BoxLayout(1));
        this.dateContainer.addComponent(this.mmLabel);
        this.dateContainer.addComponent(this.mmSymbol);
        this.dateContainer.addComponent(this.yyyyLabel);
        this.dateContainer.addComponent(this.yySymbol);
        dateContainerParent.addComponent(this.dateContainer);
        this.noOfMonth = new Vector();
        this.noOfYears = new Vector();
        for (i = 1; i <= 12; ++i) {
            this.noOfMonth.addElement(this.twoDigitValue(i));
        }
        for (i = 0; i <= this.maxYears; ++i) {
            this.noOfYears.addElement(String.valueOf(this.startingYear + i));
        }
        this.pickerDDMMYYY = new PickerContainer();
        this.pickerDDMMYYY.setLayout(new GridLayout(1, 2));
        this.mmList = new PickerItemContainer(this.noOfMonth, this.mmLabel);
        this.yyyyList = new PickerItemContainer(this.noOfYears, this.yyyyLabel);
        this.mmList.setDataChangeListener(this);
        this.yyyyList.setDataChangeListener(this);
        this.mmList.setSelectedValue(this.twoDigitValue(todayDate.get(2) + 1));
        this.yyyyList.setSelectedValue(String.valueOf(todayDate.get(1)));
        this.pickerDDMMYYY.addComponent(this.mmList);
        this.pickerDDMMYYY.addComponent(this.yyyyList);
        this.contentPane.addComponent(dateContainerParent);
        this.contentPane.addComponent(this.pickerDDMMYYY);
        this.addComponent("North", (Component)new Label(" "));
        this.addComponent("Center", (Component)this.contentPane);
        this.addCommand(this.okCommand);
        this.setScrollable(false);
    }

    private String twoDigitValue(int input) {
        if (input < 10) {
            return "0" + input;
        }
        return String.valueOf(input);
    }

    public String getValue() {
        if (this.getDatePickerType() == 3) {
            return String.valueOf(this.dayView.getSelectedDay());
        }
        if (this.getDatePickerType() == 1) {
            return this.mmLabel.getText() + "-" + this.ddLabel.getText() + "-" + this.yyyyLabel.getText();
        }
        if (this.getDatePickerType() == 2) {
            return this.mmLabel.getText() + "-" + this.yyyyLabel.getText();
        }
        return null;
    }

    public void setDate(int ddValue, int mmValue, int yyValue) {
        if (this.getDatePickerType() != 1) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_DD_YYYY");
        }
        if (ddValue <= 0 || mmValue <= 0 || yyValue <= 0) {
            throw new IllegalArgumentException("Invalid values for date");
        }
        if (this.mmList.setSelectedValue(this.twoDigitValue(mmValue)) == -1) {
            throw new IllegalArgumentException("Invalid values for month");
        }
        if (this.yyyyList.setSelectedValue(String.valueOf(yyValue)) == -1) {
            throw new IllegalArgumentException("Invalid values for year");
        }
        int days = this.getDaysInMonth(mmValue - 1, yyValue);
        if (ddValue > days) {
            throw new IllegalArgumentException("Invalid values for date");
        }
        if (this.ddList != null) {
            this.noOfDates.removeAllElements();
            for (int i = 1; i <= days; ++i) {
                this.noOfDates.addElement(this.twoDigitValue(i));
            }
            this.ddList.setValues(this.noOfDates);
            this.ddList.setSelectedValue(this.twoDigitValue(ddValue));
        }
        this.ddLabel.setText(String.valueOf(this.ddList.getSelectedValue()));
        this.mmLabel.setText(String.valueOf(this.mmList.getSelectedValue()));
        this.yyyyLabel.setText(String.valueOf(this.yyyyList.getSelectedValue()));
        this.updateDayLabel();
    }

    public void setDate(int mmValue, int yyValue) {
        if (this.getDatePickerType() != 2) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_YYYY");
        }
        if (mmValue <= 0 || yyValue <= 0) {
            throw new IllegalArgumentException("Invalid values for date");
        }
        if (this.mmList.setSelectedValue(this.twoDigitValue(mmValue)) == -1) {
            throw new IllegalArgumentException("Invalid values for month");
        }
        if (this.yyyyList.setSelectedValue(String.valueOf(yyValue)) == -1) {
            throw new IllegalArgumentException("Invalid values for year");
        }
        this.mmLabel.setText(String.valueOf(this.mmList.getSelectedValue()));
        this.yyyyLabel.setText(String.valueOf(this.yyyyList.getSelectedValue()));
    }

    public void setDate(int ddValue) {
        if (ddValue < 1 || ddValue > 31) {
            throw new IllegalArgumentException("Selected day value must be in the range 1 to 31");
        }
        if (this.getDatePickerType() != 3) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_DAY");
        }
        this.dayView.setSelectedDay(ddValue);
    }

    private void cacheValues() {
        if (this.getDatePickerType() == 3) {
            this.cachedDD = this.dayView.getSelectedDay();
        }
        if (this.getDatePickerType() == 1) {
            this.cachedDD = Integer.parseInt(String.valueOf(this.ddList.getSelectedValue()));
            this.cachedMM = Integer.parseInt(String.valueOf(this.mmList.getSelectedValue()));
            this.cachedYYYY = Integer.parseInt(String.valueOf(this.yyyyList.getSelectedValue()));
        }
        if (this.getDatePickerType() == 2) {
            this.cachedMM = Integer.parseInt(String.valueOf(this.mmList.getSelectedValue()));
            this.cachedYYYY = Integer.parseInt(String.valueOf(this.yyyyList.getSelectedValue()));
        }
    }

    private void setCachedValue() {
        if (this.getDatePickerType() == 3) {
            this.dayView.setSelectedDay(this.cachedDD);
        }
        if (this.getDatePickerType() == 1) {
            this.setDate(this.cachedDD, this.cachedMM, this.cachedYYYY);
        }
        if (this.getDatePickerType() == 2) {
            this.setDate(this.cachedMM, this.cachedYYYY);
        }
    }

    public int getDay() {
        int val = -1;
        if (this.getDatePickerType() != 1 && this.getDatePickerType() != 3) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_DD_YYYY or TYPE_PICKER_DAY");
        }
        if (this.getDatePickerType() == 1) {
            val = Integer.parseInt(String.valueOf(this.ddList.getSelectedValue()));
        }
        if (this.getDatePickerType() == 3) {
            val = this.dayView.getSelectedDay();
        }
        return val;
    }

    public int getMonth() {
        if (this.getDatePickerType() == 3) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_DD_YYYY or TYPE_PICKER_MM_YYYY");
        }
        return Integer.parseInt(String.valueOf(this.mmList.getSelectedValue()));
    }

    public int getYear() {
        if (this.getDatePickerType() == 3) {
            throw new IllegalArgumentException("DatePicker must be of type TYPE_PICKER_MM_DD_YYYY or TYPE_PICKER_MM_YYYY");
        }
        return Integer.parseInt(String.valueOf(this.yyyyList.getSelectedValue()));
    }

    public void show() {
        this.previousForm = Display.getInstance().getCurrent();
        this.cacheValues();
        super.show();
    }

    private void setDatePickerType(int type) {
        this.datePickerType = type;
    }

    public int getDatePickerType() {
        return this.datePickerType;
    }

    public void setHeaderText(String text) {
        if (this.titleText != null) {
            if (text == null) {
                text = "";
            }
            this.titleText.setText(text);
        }
    }

    public String getHeaderText() {
        if (this.titleText != null) {
            return this.titleText.getText();
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.backCommand) {
            this.setCachedValue();
        }
        if (this.datePickerListener != null) {
            if (this.previousForm != null) {
                this.previousForm.show();
            }
            this.datePickerListener.notifyDatePickerListener(this);
        }
    }

    protected Button createDay() {
        Button day = new Button();
        day.setUIID("DayPicker");
        day.setEndsWith3Points(false);
        day.setTickerEnabled(false);
        day.setPreferredSize(new Dimension(32, 32));
        return day;
    }

    public void setDatePickerListener(DatePickerListener listener) {
        this.datePickerListener = listener;
    }

    public DatePickerListener getDatePickerListener() {
        return this.datePickerListener;
    }

    public synchronized void notifyPickerItemContainerListener(PickerItemContainer container) {
        if (container != null) {
            if (container.equals(this.mmList) && this.mmList != null) {
                this.updateDateList();
            }
            if (container.equals(this.yyyyList) && this.yyyyList != null) {
                this.updateDateList();
            }
            this.updateDayLabel();
        }
    }

    private void updateDayLabel() {
        if (this.getDatePickerType() == 1 && this.dayLabel != null) {
            Calendar newDate = Calendar.getInstance();
            newDate.set(5, Integer.parseInt(String.valueOf(this.noOfDates.elementAt(this.ddList.getSelectedIndex()))));
            newDate.set(2, Integer.parseInt(String.valueOf(this.noOfMonth.elementAt(this.mmList.getSelectedIndex()))) - 1);
            newDate.set(1, Integer.parseInt(String.valueOf(this.noOfYears.elementAt(this.yyyyList.getSelectedIndex()))));
            this.dayLabel.setText("" + this.daysofWeek[newDate.get(7) - 1]);
        }
    }

    private void updateDateList() {
        int month = Integer.parseInt(String.valueOf(this.noOfMonth.elementAt(this.mmList.getSelectedIndex()))) - 1;
        int year = Integer.parseInt(String.valueOf(this.noOfYears.elementAt(this.yyyyList.getSelectedIndex())));
        int days = this.getDaysInMonth(month, year);
        if (this.ddList != null) {
            this.noOfDates.removeAllElements();
            for (int i = 1; i <= days; ++i) {
                this.noOfDates.addElement(this.twoDigitValue(i));
            }
            this.ddList.setValues(this.noOfDates);
            if (this.ddList.getSelectedIndex() > days - 1) {
                this.ddList.setSelectedIndex(days - 1);
                this.ddList.updatePicker();
            }
            this.ddLabel.setText(String.valueOf(this.noOfDates.elementAt(this.ddList.getSelectedIndex())));
        }
    }

    private int getDaysInMonth(int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month);
        cal.set(5, 1);
        cal.set(1, year);
        cal.set(10, 0);
        cal.set(12, 0);
        Date startDate = cal.getTime();
        int nextMonth = month == 11 ? 0 : month + 1;
        cal.set(2, nextMonth);
        if (month == 11) {
            cal.set(1, year + 1);
        }
        Date endDate = cal.getTime();
        return (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
    }

    static {
        OK_TEXT = UIManager.getInstance().localize("ok", "OK");
    }

    private class DayView
    extends Container
    implements ActionListener {
        private Button[] dateButton = new Button[35];
        private Button selectedDayButton;
        private int selectedDay = 1;

        public DayView() {
            super(new GridLayout(5, 7));
            this.setUIID("DayPickerPane");
            for (int i = 0; i < this.dateButton.length; ++i) {
                this.dateButton[i] = DatePicker.this.createDay();
                if (i > 3) {
                    this.dateButton[i].setText("" + (i - 3));
                    if (this.dateButton[i].getText().equals(String.valueOf(this.selectedDay))) {
                        this.dateButton[i].setUIID("DayPickerSelected");
                        this.selectedDayButton = this.dateButton[i];
                    }
                    this.dateButton[i].addActionListener(this);
                }
                this.addComponent(this.dateButton[i]);
            }
            this.setScrollable(false);
        }

        public void setSelectedDay(int value) {
            this.selectedDay = value;
            if (this.selectedDayButton != null) {
                this.selectedDayButton.setUIID("DayPicker");
                this.selectedDayButton = this.dateButton[value + 3];
                this.selectedDayButton.setUIID("DayPickerSelected");
            }
        }

        public int getSelectedDay() {
            return this.selectedDay;
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src instanceof Button) {
                this.setSelectedDay(Integer.parseInt(((Button)src).getText()));
                this.repaint();
            }
        }

        public Style getStyle() {
            return super.getUnselectedStyle();
        }
    }
}

