/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class PopupChoiceGroup
extends Container {
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    private ButtonGroup mGroup;
    private RadioButton[] mButtons;
    private GroupContainer mGroupContainer;
    private ChoicePicker mChoicePicker;
    private Button mOpenButton;
    private Label mSelection;
    private final int OPEN;
    private final int CLOSED;
    private int mCurrentState = 1;
    private Border mClosedBorder;
    private Border mPressedBorder;
    private Border mOpenBorder;
    private Image mArrowOpenImage = UIManager.getInstance().getThemeImageConstant("PopupChoiceGroupOpenArrowImage");
    private Image mArrowClosedImage = UIManager.getInstance().getThemeImageConstant("PopupChoiceGroupClosedArrowImage");
    private Image mArrowClosedPressedImage = UIManager.getInstance().getThemeImageConstant("PopupChoiceGroupPressedArrowImage");
    private boolean isAshaDevice = false;
    private int mChoiceType;
    private String[] listItems;

    private static String[] convertToStringArray(RadioButton[] choices) {
        String[] items = null;
        if (choices != null && choices.length != 0) {
            items = new String[choices.length];
            for (int i = 0; i < choices.length; ++i) {
                items[i] = choices[i].getText();
            }
        }
        return items;
    }

    public PopupChoiceGroup(String title, RadioButton[] choices) {
        this(title, null, PopupChoiceGroup.convertToStringArray(choices), 1);
    }

    public PopupChoiceGroup(String title, String helpText, String[] choices, int choiceType) {
        this.OPEN = 0;
        this.CLOSED = 1;
        if (choices == null || choices.length == 0) {
            throw new IllegalArgumentException("choices can't be null or empty");
        }
        this.setUIID("PopupChoiceGroup");
        this.isAshaDevice = Display.getInstance().getDeviceType() == 3;
        if (!this.isAshaDevice) {
            this.mButtons = new RadioButton[choices.length];
            for (int i = 0; i < choices.length; ++i) {
                this.mButtons[i] = new RadioButton(choices[i]);
            }
            this.mGroup = new ButtonGroup();
            this.mGroupContainer = new GroupContainer(this.mButtons);
            this.mGroupContainer.getStyle().setBgColor(0);
            this.mGroupContainer.getStyle().setBgTransparency(255);
            this.mGroupContainer.getStyle().setMargin(1, 0);
            this.mGroupContainer.getStyle().setMargin(3, 0);
            this.mSelection = new Label();
            this.mSelection.getStyle().setFont(Font.createSystemFont(0, 0, 8));
            ActionListener choicelistener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RadioButton rb = (RadioButton)evt.getComponent();
                    PopupChoiceGroup.this.mSelection.setText(rb.getText());
                    if (PopupChoiceGroup.this.mCurrentState == 0) {
                        PopupChoiceGroup.this.removeChoices();
                    }
                }
            };
            int l = this.mButtons.length;
            for (int i = 0; i < l; ++i) {
                this.mButtons[i].addActionListener(choicelistener);
                this.mGroup.add(this.mButtons[i]);
            }
            this.mGroup.getRadioButton(0).setSelected(true);
            this.mSelection.setText(this.mGroup.getRadioButton(0).getText());
            this.mOpenButton = new Button(title){
                private Image mCurrentArrow;
                {
                    this.mCurrentArrow = PopupChoiceGroup.this.mArrowClosedImage;
                }

                public void paint(Graphics g) {
                    if (this.getState() == 1) {
                        this.mCurrentArrow = PopupChoiceGroup.this.mArrowClosedPressedImage;
                        PopupChoiceGroup.this.repaint();
                    } else {
                        this.mCurrentArrow = PopupChoiceGroup.this.mArrowClosedImage;
                    }
                    if (PopupChoiceGroup.this.mCurrentState == 0) {
                        this.mCurrentArrow = PopupChoiceGroup.this.mArrowOpenImage;
                    }
                    super.paint(g);
                    int x = this.getX();
                    int y = this.getY();
                    int rightpadding = this.getStyle().getPadding(3);
                    if (this.mCurrentArrow != null) {
                        x = x + this.getWidth() - rightpadding - this.mCurrentArrow.getWidth();
                        g.drawImage(this.mCurrentArrow, x, y += this.getHeight() / 2 - this.mCurrentArrow.getHeight() / 2);
                    }
                }

                public void pressed() {
                    super.pressed();
                    PopupChoiceGroup.this.repaint();
                }
            };
            this.mOpenButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (PopupChoiceGroup.this.mCurrentState == 1) {
                        PopupChoiceGroup.this.addChoices();
                    } else {
                        PopupChoiceGroup.this.removeChoices();
                    }
                }
            });
            Style openStyle = UIManager.getInstance().getComponentStyle("PopupChoiceGroupOpen");
            this.mOpenBorder = openStyle.getBorder();
            this.mClosedBorder = this.getUnselectedStyle().getBorder();
            this.mPressedBorder = this.getPressedStyle().getBorder();
        } else {
            this.mSelection = new Label();
            this.mSelection.setUIID("ChoicePickerLabel");
            this.mSelection.setText(choices[0]);
            this.mSelection.getStyle().setFont(Font.createSystemFont(0, 0, 8));
            this.mChoicePicker = new ChoicePicker(title, helpText, choices, choiceType, this.mSelection);
            this.mChoiceType = choiceType;
            this.listItems = choices;
            this.setSelected(0);
            this.mOpenButton = new Button(title);
            this.mOpenButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PopupChoiceGroup.this.mChoicePicker.show();
                }
            });
        }
        this.mOpenButton.setUIID("Label");
        this.mOpenButton.getStyle().setBgTransparency(0);
        this.mOpenButton.getPressedStyle().setBgTransparency(0);
        this.mOpenButton.getSelectedStyle().setBgTransparency(0);
        this.setScrollable(false);
        this.setLayout(new BoxLayout(2));
        this.addComponent(this.mOpenButton);
        this.addComponent(this.mSelection);
    }

    private void removeChoices() {
        this.getStyle().setPadding(2, 2);
        int l = this.mButtons.length;
        for (int i = 0; i < l; ++i) {
            this.removeComponent(this.mGroupContainer);
        }
        this.mCurrentState = 1;
        this.getStyle().setBorder(this.mClosedBorder);
        this.revalidate();
    }

    private void addChoices() {
        this.getStyle().setPadding(2, 5);
        this.getStyle().setBorder(this.mOpenBorder);
        int l = this.mButtons.length;
        this.addComponent(this.mGroupContainer);
        this.mCurrentState = 0;
        this.revalidate();
    }

    public String getText() {
        return this.mSelection.getText();
    }

    public Style getStyle() {
        if (!this.isAshaDevice && this.mOpenButton.getState() == 1) {
            return this.getPressedStyle();
        }
        return super.getStyle();
    }

    public int getSelectedIndex() {
        if (this.isAshaDevice) {
            return this.mChoicePicker.getSelectedIndex();
        }
        return this.mGroup.getSelectedIndex();
    }

    public RadioButton getSelected() {
        if (this.isAshaDevice) {
            return null;
        }
        return this.mGroup.getRadioButton(this.mGroup.getSelectedIndex());
    }

    public void setSelected(int index) {
        if (this.isAshaDevice) {
            if (index >= this.listItems.length) {
                throw new IllegalArgumentException("index must be less than length of choices");
            }
            this.mChoicePicker.setSelectedIndex(index);
            this.mChoicePicker.setSelectedItem(this.listItems[index]);
            if (this.mChoiceType == 2) {
                this.mChoicePicker.unSelectAllItems();
                this.mChoicePicker.setMultiSelectedIndexes(index);
                this.mChoicePicker.setMultiSelectedItems(this.listItems[index]);
            }
            this.mSelection.setText(this.listItems[index]);
        } else {
            if (index >= this.mGroup.getButtonCount()) {
                throw new IllegalArgumentException("index must be less than length of radiobuttons");
            }
            this.mGroup.getRadioButton(index).setSelected(true);
            this.mSelection.setText(this.mGroup.getRadioButton(index).getText());
        }
    }

    public String getSelectedItem() {
        if (this.isAshaDevice) {
            return this.mChoicePicker.getSelectedItem();
        }
        return this.mGroup.getRadioButton(this.mGroup.getSelectedIndex()).getText();
    }

    public Vector getMultiSelectedIndexes() {
        if (this.isAshaDevice) {
            return this.mChoicePicker.getMultiSelectedIndexes();
        }
        return null;
    }

    public Vector getMultiSelectedItems() {
        if (this.isAshaDevice) {
            return this.mChoicePicker.getMultiSelectedItems();
        }
        return null;
    }

    private static class ChoicePicker
    extends Dialog
    implements ActionListener {
        private List mList;
        private Label mSelection;
        private int selectedIndex;
        private String selectedItem;
        private boolean multiple;
        private Label choicePickerTitle;
        private Command defaultCommand;
        private Command backCommand;
        private ListCellRenderer choiceListRenderer;
        private TextArea choicePickerInfo;
        private Vector selectedIndexes = new Vector();
        private Vector selectedItems = new Vector();
        private String mSelectionText;
        private int currentSelectedIndex;
        private String currentSelectedItem;
        private Vector currentselectedIndexes;
        private Vector currentSelectedItems;
        private boolean skipRelease = false;
        private boolean isPressed = false;
        private String selectedText = UIManager.getInstance().localize("items selected", "items selected");
        private int defaultTintColor;
        private int choicePickerTintColor = this.defaultTintColor = UIManager.getInstance().getLookAndFeel().getDefaultFormTintColor();

        public ChoicePicker(String title, String textInfo, Object[] items, int type, Label mSelection) {
            this();
            this.mSelection = mSelection;
            this.initializePopup(title, textInfo, new DefaultListModel(items), type);
        }

        private ChoicePicker() {
            super("", "");
            this.initializeChoicePicker();
        }

        private void initializeChoicePicker() {
            this.getContentPane().setUIID("ChoicePicker");
            this.getContentPane().getParent().getStyle().setBgTransparency(0);
            this.setTransitionInAnimator(CommonTransitions.createEmpty());
            this.setTransitionOutAnimator(CommonTransitions.createEmpty());
            this.setLayout(new BoxLayout(2));
            this.getTitleArea().setVisible(false);
            this.setScrollable(false);
            this.getContentPane().getStyle().setMargin(0, 0, 0, 0);
            this.skipRelease = true;
            this.isPressed = false;
            if (this.getBackCommand() == null) {
                this.backCommand = new Command("Back");
                this.setBackCommand(this.backCommand);
            }
        }

        private void initializePopup(String title, String textInfo, ListModel model, int type) {
            this.multiple = false;
            if (type == 2) {
                this.multiple = true;
            }
            if (!this.multiple) {
                this.setDisposeWhenPointerOutOfBounds(true);
            }
            this.removeAllCommands();
            if (this.multiple) {
                this.defaultCommand = new Command(UIManager.getInstance().localize("ok", "OK"));
                this.addCommandListener(this);
                this.addCommand(this.defaultCommand);
                this.setDefaultCommand(this.defaultCommand);
            }
            if (this.selectedIndexes != null) {
                this.selectedIndexes.removeAllElements();
            }
            if (title != null) {
                this.choicePickerTitle = new Label(title);
                this.choicePickerTitle.setUIID("ChoicePickerTitle");
                Font titleFont = Font.createDirectUtilsSystemFont(0, 1, 18);
                this.setFont(this.choicePickerTitle, titleFont);
                this.choicePickerTitle.setFocusable(false);
                this.addComponent(this.choicePickerTitle);
            }
            if (textInfo != null) {
                this.choicePickerInfo = new TextArea(textInfo, 3, 30);
                this.choicePickerInfo.setUIID("ChoicePickerInfo");
                Font textInfoFont = Font.createDirectUtilsSystemFont(0, 0, 14);
                this.setFont(this.choicePickerInfo, textInfoFont);
                this.choicePickerInfo.setEditable(false);
                this.choicePickerInfo.setFocusable(false);
                this.addComponent(this.choicePickerInfo);
            }
            if (model != null) {
                this.mList = new List();
                this.mList.setModel(model);
                this.mList.addActionListener(this);
                this.mList.setScrollVisible(false);
                this.mList.setScrollToSelected(false);
                this.mList.getStyle().setPadding(0, 0, 0, 0);
                this.choiceListRenderer = new ChoicePickerRenderer(this.multiple);
                this.mList.setRenderer(this.choiceListRenderer);
                this.mList.setPreferredW(Display.getInstance().getDisplayWidth());
                this.addComponent(this.mList);
            }
        }

        private void setFont(Component comp, Font font) {
            Style style = comp.getStyle();
            style.setFont(font, true);
            comp.setSelectedStyle(style);
            comp.setUnselectedStyle(style);
            comp.setPressedStyle(style);
            comp.setDisabledStyle(style);
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        protected void setSelectedIndex(int index) {
            this.selectedIndex = index;
            this.mList.setSelectedIndex(index);
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        protected void setSelectedItem(Object item) {
            this.selectedItem = (String)item;
        }

        public String getSelectedItem() {
            return this.selectedItem;
        }

        private void setMultiSelectedIndexes(int selectedIndex) {
            if (this.selectedIndexes.contains("" + selectedIndex)) {
                this.selectedIndexes.removeElement("" + selectedIndex);
            } else {
                this.selectedIndexes.addElement("" + selectedIndex);
            }
        }

        public Vector getMultiSelectedIndexes() {
            return this.selectedIndexes;
        }

        private void setMultiSelectedItems(Object selectedItem) {
            if (this.selectedItems.contains(selectedItem)) {
                this.selectedItems.removeElement(selectedItem);
            } else {
                this.selectedItems.addElement(selectedItem);
            }
        }

        public Vector getMultiSelectedItems() {
            return this.selectedItems;
        }

        private void unSelectAllItems() {
            this.selectedIndexes.removeAllElements();
            this.selectedItems.removeAllElements();
        }

        private void storeSelectedValues() {
            if (this.multiple) {
                int i;
                this.mSelectionText = this.mSelection.getText();
                this.currentSelectedIndex = this.getSelectedIndex();
                this.currentSelectedItem = this.getSelectedItem();
                this.currentselectedIndexes = null;
                this.currentselectedIndexes = new Vector();
                for (i = 0; i < this.selectedIndexes.size(); ++i) {
                    this.currentselectedIndexes.addElement(this.selectedIndexes.elementAt(i));
                }
                this.currentSelectedItems = null;
                this.currentSelectedItems = new Vector();
                for (i = 0; i < this.selectedItems.size(); ++i) {
                    this.currentSelectedItems.addElement(this.selectedItems.elementAt(i));
                }
            }
        }

        private void resetSelectedValues() {
            if (this.multiple) {
                this.mSelection.setText(this.mSelectionText);
                this.setSelectedIndex(this.currentSelectedIndex);
                this.setSelectedItem(this.currentSelectedItem);
                this.selectedIndexes = this.currentselectedIndexes;
                this.selectedItems = this.currentSelectedItems;
            }
        }

        public void actionPerformed(ActionEvent ae) {
            ae.consume();
            if (ae.getSource() == this.mList) {
                this.setSelectedIndex(((List)ae.getSource()).getSelectedIndex());
                this.setSelectedItem(((List)ae.getSource()).getSelectedItem());
                this.mSelection.setText(this.selectedItem);
                if (this.multiple) {
                    this.setMultiSelectedIndexes(this.selectedIndex);
                    this.setMultiSelectedItems(this.selectedItem);
                    if (this.selectedIndexes.size() == 1) {
                        this.mSelection.setText("" + this.selectedItems.elementAt(0));
                    } else {
                        this.mSelection.setText(this.selectedIndexes.size() + " " + this.selectedText);
                    }
                    return;
                }
            }
            if (ae.getSource() == this.backCommand) {
                this.resetSelectedValues();
            }
            this.dispose();
        }

        public void show() {
            this.showImpl();
        }

        protected void autoAdjust(int w, int h) {
        }

        public void dispose() {
            super.dispose();
            Display.getInstance().getCurrent().setTintColor(this.defaultTintColor);
        }

        private Command showImpl() {
            this.initializeChoicePicker();
            this.storeSelectedValues();
            if (!this.multiple) {
                this.mList.setSelectedIndex(this.getSelectedIndex());
            }
            this.choicePickerTintColor = Integer.parseInt(UIManager.getInstance().getThemeConstant("choiceTintColor", Integer.toHexString(this.choicePickerTintColor)), 16);
            Display.getInstance().getCurrent().setTintColor(this.choicePickerTintColor);
            this.skipRelease = true;
            this.getStyle().setPadding(0, 0, 0, 0);
            Container contentPane = this.getContentPane();
            int listsize = this.mList.getModel().getSize();
            int menuHeight = listsize * ((Component)((Object)this.mList.getRenderer())).getPreferredH();
            if (menuHeight < this.mList.getScrollDimension().getHeight()) {
                menuHeight = this.mList.getScrollDimension().getHeight();
            }
            menuHeight += this.getStyle().getPadding(0) + this.getStyle().getPadding(2);
            menuHeight += this.getContentPane().getStyle().getPadding(0) + this.getContentPane().getStyle().getPadding(2);
            Border bp = this.getContentPane().getStyle().getBorder();
            if (bp != null) {
                menuHeight += bp.getMinimumHeight();
            }
            menuHeight += contentPane.getStyle().getPadding(0);
            menuHeight += contentPane.getStyle().getPadding(2);
            menuHeight += this.mList.getStyle().getPadding(0);
            menuHeight += this.mList.getStyle().getPadding(2);
            menuHeight += this.mList.getStyle().getMargin(0);
            menuHeight += this.mList.getStyle().getMargin(2);
            if (this.choicePickerTitle != null) {
                menuHeight += this.choicePickerTitle.getPreferredH() + this.choicePickerTitle.getStyle().getMargin(false, 0) + this.choicePickerTitle.getStyle().getMargin(false, 2);
            }
            if (this.choicePickerInfo != null) {
                menuHeight += this.choicePickerInfo.getPreferredH() + this.choicePickerInfo.getStyle().getMargin(false, 0) + this.choicePickerInfo.getStyle().getMargin(false, 2);
            }
            this.revalidate();
            Style contentPaneStyle = this.getContentPane().getStyle();
            int prefHeight = contentPane.getPreferredH();
            int prefWidth = contentPane.getPreferredW();
            if (contentPaneStyle.getBorder() != null) {
                prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
                prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
            }
            int displayHeight = Display.getInstance().getDisplayHeight();
            if (!Display.getInstance().isForceFullScreen()) {
                boolean showPortrait = Display.getInstance().isPortrait();
                displayHeight = showPortrait ? 302 : 222;
            }
            int availableWidth = Display.getInstance().getDisplayWidth();
            int left = 0;
            int right = 0;
            int top = 0;
            int bottom = 0;
            if (top + menuHeight > displayHeight) {
                top = 0;
                bottom = 0;
            } else {
                top = (displayHeight - menuHeight) / 2;
                bottom = displayHeight - (top + menuHeight);
            }
            return this.show(top, bottom, left, right, true, true);
        }

        public void pointerReleased(int x, int y) {
            if (!this.skipRelease) {
                super.pointerReleased(x, y);
            }
            this.isPressed = false;
        }

        public void pointerDragged(int x, int y) {
            super.pointerDragged(x, y);
            this.skipRelease = false;
            this.isPressed = false;
        }

        public void pointerPressed(int x, int y) {
            super.pointerPressed(x, y);
            this.skipRelease = false;
            this.isPressed = true;
        }

        protected void longPointerPress(int x, int y) {
            super.longPointerPress(x, y);
            this.skipRelease = true;
            this.isPressed = false;
        }

        private class ChoicePickerRenderer
        extends DefaultListCellRenderer {
            private boolean isSelected = false;
            private boolean multiple;

            public ChoicePickerRenderer(boolean multiple) {
                super(false);
                this.multiple = multiple;
            }

            public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                if (this.multiple && ChoicePicker.this.selectedIndexes.contains("" + index) || !this.multiple && index == ChoicePicker.this.getSelectedIndex()) {
                    this.setUIID("ChoicePickerItemSelected");
                    this.setFocus(false);
                    this.isSelected = true;
                } else {
                    if (ChoicePicker.this.isPressed && isSelected) {
                        this.setUIID("ChoicePickerItemPressed");
                    } else {
                        this.setUIID("ChoicePickerItem");
                    }
                    this.setFocus(isSelected);
                    this.isSelected = false;
                }
                this.setText(value.toString());
                return this;
            }

            public void paint(Graphics g) {
                if (this.isSelected) {
                    g.setColor(this.getSelectedStyle().getBgColor());
                    g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                } else {
                    g.setColor(this.getUnselectedStyle().getBgColor());
                    g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                }
                super.paint(g);
            }
        }
    }

    private static class GroupContainer
    extends Container {
        private RadioButton[] mButtons;
        private int height = 0;

        public GroupContainer(RadioButton[] buttons) {
            this.mButtons = buttons;
            this.height = 0;
            if (this.mButtons != null) {
                this.height = this.mButtons.length >= 3 ? this.mButtons[0].getPreferredH() * 3 : this.mButtons[0].getPreferredH() * this.mButtons.length;
            }
            this.setPreferredH(this.height);
            this.setLayout(new SimpleLayout());
            for (int i = 0; i < buttons.length; ++i) {
                this.addComponent(buttons[i]);
            }
            this.setScrollableY(true);
        }

        private static class SimpleLayout
        extends Layout {
            private SimpleLayout() {
            }

            public void layoutContainer(Container parent) {
                int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(false, 3) - parent.getStyle().getPadding(false, 1);
                int height = parent.getLayoutHeight() - parent.getBottomGap() - parent.getStyle().getPadding(false, 2) - parent.getStyle().getPadding(false, 0);
                int x = parent.getStyle().getPadding(parent.isRTL(), 1);
                int y = parent.getStyle().getPadding(false, 0);
                int numOfcomponents = parent.getComponentCount();
                boolean rtl = parent.isRTL();
                if (rtl) {
                    x += parent.getSideGap();
                }
                for (int i = 0; i < numOfcomponents; ++i) {
                    Component cmp = parent.getComponentAt(i);
                    Style stl = cmp.getStyle();
                    int cmpBottom = height;
                    int cmpH = cmp.getPreferredH();
                    cmp.setWidth(width - stl.getMargin(parent.isRTL(), 1) - stl.getMargin(parent.isRTL(), 3));
                    cmp.setHeight(cmpH);
                    cmp.setX(x + stl.getMargin(parent.isRTL(), 1));
                    cmp.setY(y += stl.getMargin(false, 0));
                    y += cmp.getHeight() + stl.getMargin(false, 2);
                }
            }

            public Dimension getPreferredSize(Container parent) {
                int height = 0;
                int width = 0;
                int numOfcomponents = parent.getComponentCount();
                for (int i = 0; i < numOfcomponents; ++i) {
                    Component cmp = parent.getComponentAt(i);
                    Style stl = cmp.getStyle();
                    int cmpH = cmp.getPreferredH() + stl.getMargin(false, 0) + stl.getMargin(false, 2);
                    height += cmpH;
                    width = Math.max(width, cmp.getPreferredW() + stl.getMargin(false, 1) + stl.getMargin(false, 3));
                }
                Dimension d = new Dimension(width + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3), height + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
                return d;
            }
        }
    }
}

