/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.ActionButton;
import com.nokia.lwuit.components.SearchBarListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class SearchBar
extends Container {
    private SearchBarListener listener = null;
    private ActionButton actionButton = null;
    private TextField textField = new TextField();

    public SearchBar(String text, Image image) {
        this.textField.setHint(text);
        this.textField.setUIID("SearchBarBox");
        if (image != null) {
            this.actionButton = new ActionButton(image);
        } else {
            Image defaultImage = UIManager.getInstance().getThemeImageConstant("searchBarDefaultImage");
            this.actionButton = new ActionButton(defaultImage);
        }
        this.initializeComponent();
    }

    private void initializeComponent() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SearchBar.this.listener != null) {
                    SearchBar.this.listener.notifySearchBarListener(SearchBar.this, SearchBar.this.getText());
                }
            }
        };
        this.actionButton.addActionListener(al);
        this.actionButton.setUIID("SearchBarImage");
        this.setScrollableY(false);
        this.setLayout(new BorderLayout());
        this.addComponent("East", (Component)this.actionButton);
        this.addComponent("Center", (Component)this.textField);
    }

    public void setActionListener(SearchBarListener listener) {
        this.listener = listener;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.notifySearchBarListener(this, this.getText());
        }
    }

    public String getTextFieldUiid() {
        return this.textField.getUIID();
    }

    public void setTextFieldUiid(String uiid) {
        this.textField.setUIID(uiid);
    }

    public String getActionButtonUiid() {
        return this.actionButton.getUIID();
    }

    public void setActionButtonUiid(String uiid) {
        this.actionButton.setUIID(uiid);
    }

    public Style getTextFieldStyle() {
        return this.textField.getStyle();
    }

    public Style getActionButtonStyle() {
        return this.actionButton.getStyle();
    }

    public String getText() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return null;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void clearText() {
        this.textField.clear();
    }

    public void setHint(String hint) {
        this.textField.setHint(hint);
    }
}

