/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.TimePickerListener;
import com.nokia.lwuit.components.Utility;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Calendar;

public class TimePicker
extends Form
implements ActionListener {
    public static final int HOUR = 1;
    public static final int MINUTE = 2;
    public static final int AM = 3;
    public static final int PM = 4;
    public static final int AM_PM = 5;
    private static final int NONE_PRESSED = 1;
    private static final int HOUR_PRESSED = 2;
    private static final int MINUTE_PRESSED = 3;
    private int minute_radius = 0;
    private int hour_radius = 0;
    private int minuteDialCenter_X;
    private int minuteDialCenter_Y;
    private int hourDialCenter_X;
    private int hourDialCenter_Y;
    private int minuteDial_XPos;
    private int minuteDial_YPos;
    private int hourDial_XPos;
    private int hourDial_YPos;
    private int minuteDialWidth;
    private int minuteDialHeight;
    private int hourDialWidth;
    private int hourDialHeight;
    private int minuteButton_XPos;
    private int minuteButton_YPos;
    private int hourButton_XPos;
    private int hourButton_YPos;
    private int minuteValue;
    private int hourValue;
    private int currentPressed;
    private int newHourValue;
    private int newMinuteValue;
    private int am_pm_value;
    private boolean isFirstTime;
    private static final String AM_STRING = UIManager.getInstance().localize("am", "AM");
    private static final String PM_STRING = UIManager.getInstance().localize("pm", "PM");
    private static final String OK_TEXT = UIManager.getInstance().localize("ok", "OK");
    private Utility utility;
    private TimeShowContainer timeContainer;
    private Container hh_mm_dialContainer;
    private TestButton minutesDial;
    private TestButton hoursDial;
    private TestButton hourPickerButton;
    private TestButton minutePickerButton;
    private Command okCommand;
    private Command backCommand;
    private Label hourLabel;
    private Label minutLabel;
    private Label timeFormatLabel;
    private Style labelSelected;
    private Style labelUnselected;
    private Form previousForm;
    private TimePickerListener timePickerListener;

    public TimePicker() {
        this.setUIID("Form");
        this.currentPressed = 1;
        this.utility = new Utility();
        this.setTimePicker();
    }

    public int get(int field) {
        int value = -1;
        switch (field) {
            case 1: {
                value = this.getHour();
                break;
            }
            case 2: {
                value = this.getMinute();
                break;
            }
            case 5: {
                value = this.getAM_PM();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid field");
            }
        }
        return value;
    }

    public void set(int field, int value) {
        switch (field) {
            case 1: {
                this.setHour(value);
                break;
            }
            case 2: {
                this.setMinute(value);
                break;
            }
            case 5: {
                this.setAM_PM(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid field");
            }
        }
    }

    protected void initComponent() {
        super.initComponent();
        this.labelUnselected = UIManager.getInstance().getComponentStyle("TimePickerLabel");
        this.labelSelected = UIManager.getInstance().getComponentSelectedStyle("TimePickerLabel");
    }

    private void initailizeTimePickerValues() {
        Calendar currentDate = Calendar.getInstance();
        if (currentDate.get(10) == 0) {
            this.set(1, 12);
        } else {
            this.set(1, currentDate.get(10));
        }
        this.set(2, currentDate.get(12));
        if (currentDate.get(9) == 0) {
            this.set(5, 3);
        } else {
            this.set(5, 4);
        }
        this.setLabelText();
    }

    private void setLabelText() {
        if (this.get(5) == 3) {
            this.timeFormatLabel.setText(AM_STRING);
        } else {
            this.timeFormatLabel.setText(PM_STRING);
        }
        this.hourPickerButton.setText("" + this.twoDigitValue(this.hourValue));
        this.hourLabel.setText("" + this.twoDigitValue(this.hourValue));
        this.minutePickerButton.setText("" + this.twoDigitValue(this.minuteValue));
        this.minutLabel.setText("" + this.twoDigitValue(this.minuteValue));
    }

    public void show() {
        this.previousForm = Display.getInstance().getCurrent();
        this.setLabelText();
        super.show();
    }

    public void setTimePickerListener(TimePickerListener listener) {
        this.timePickerListener = listener;
    }

    public TimePickerListener getTimePickerListener() {
        return this.timePickerListener;
    }

    private void setTimePicker() {
        this.setLayout(new BoxLayout(2));
        this.okCommand = new Command(OK_TEXT);
        this.backCommand = new Command("Back");
        this.addCommandListener(this);
        this.isFirstTime = true;
        this.timeContainer = new TimeShowContainer();
        this.hh_mm_dialContainer = new Container(new CoordinateLayout(Display.getInstance().getDisplayWidth(), 190));
        this.minutePickerButton = new TestButton("TimePickerMinuteButton");
        this.hourPickerButton = new TestButton("TimePickerHourButton");
        this.initailizeTimePickerValues();
        this.minutesDial = new TestButton("TimePickerMinute");
        this.minuteDial_XPos = this.minutesDial.getStyle().getMargin(1);
        this.minuteDial_YPos = this.minutesDial.getStyle().getMargin(0);
        this.minutesDial.setX(this.minuteDial_XPos);
        this.minutesDial.setY(this.minuteDial_YPos);
        this.minuteDialWidth = this.minutesDial.getPreferredW();
        this.minuteDialHeight = this.minutesDial.getPreferredH();
        this.hh_mm_dialContainer.addComponent(this.minutesDial);
        this.hoursDial = new TestButton("TimePickerHour");
        this.hourDialWidth = this.hoursDial.getPreferredW();
        this.hourDialHeight = this.hoursDial.getPreferredH();
        this.hourDial_XPos = this.minuteDial_XPos + (this.minuteDialWidth - this.hourDialWidth) / 2;
        this.hourDial_YPos = this.minuteDial_YPos + (this.minuteDialHeight - this.hourDialHeight) / 2;
        this.hoursDial.setX(this.hourDial_XPos);
        this.hoursDial.setY(this.hourDial_YPos);
        this.hh_mm_dialContainer.addComponent(this.hoursDial);
        this.minuteDialCenter_X = this.minuteDial_XPos + this.minuteDialWidth / 2;
        this.minuteDialCenter_Y = this.minuteDial_YPos + this.minuteDialHeight / 2;
        this.hourDialCenter_X = this.hourDial_XPos + this.hourDialWidth / 2;
        this.hourDialCenter_Y = this.hourDial_YPos + this.hourDialHeight / 2;
        this.minute_radius = this.minuteDialWidth / 2 - this.minutePickerButton.getPreferredW() / 2;
        this.minuteButton_XPos = this.minuteHandPointX(this.minuteValue);
        this.minuteButton_YPos = this.minuteHandPointY(this.minuteValue);
        this.minutePickerButton.setX(this.minuteButton_XPos);
        this.minutePickerButton.setY(this.minuteButton_YPos);
        this.hh_mm_dialContainer.addComponent(this.minutePickerButton);
        this.hour_radius = this.hourDialWidth / 2 - this.hourPickerButton.getPreferredW() / 2 - 9;
        this.hourButton_XPos = this.hourHandPointX(this.hourValue);
        this.hourButton_YPos = this.hourHandPointY(this.hourValue);
        this.hourPickerButton.setX(this.hourButton_XPos);
        this.hourPickerButton.setY(this.hourButton_YPos);
        this.hh_mm_dialContainer.addComponent(this.hourPickerButton);
        this.addComponent(this.timeContainer);
        this.addComponent(this.hh_mm_dialContainer);
        this.addCommand(this.okCommand);
        this.setBackCommand(this.backCommand);
        this.setScrollable(false);
    }

    private int minuteHandPointX(int minute) {
        int xPos = (int)((double)this.minuteDialCenter_X + (double)this.minute_radius * Math.sin((float)(minute * 2) * 3.14159f / 60.0f));
        return xPos -= this.minutePickerButton.getPreferredW() / 2;
    }

    private int minuteHandPointY(int minute) {
        int yPos = (int)((double)this.minuteDialCenter_Y - (double)this.minute_radius * Math.cos((float)(minute * 2) * 3.14159f / 60.0f));
        return yPos -= this.minutePickerButton.getPreferredH() / 2;
    }

    private int hourHandPointX(int hour) {
        int xPos = (int)((double)this.hourDialCenter_X + (double)this.hour_radius * Math.sin((float)(hour * 2) * 3.14159f / 12.0f));
        return xPos -= this.hourPickerButton.getPreferredW() / 2;
    }

    private int hourHandPointY(int hour) {
        int yPos = (int)((double)this.hourDialCenter_Y - (double)this.hour_radius * Math.cos((float)(hour * 2) * 3.14159f / 12.0f));
        return yPos -= this.hourPickerButton.getPreferredH() / 2;
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        if (this.minutePickerButton.contains(x, y)) {
            this.currentPressed = 3;
            this.changeLabelColor(this.minutLabel, this.labelSelected.getFgColor());
        } else if (this.hourPickerButton.contains(x, y)) {
            this.currentPressed = 2;
            this.changeLabelColor(this.hourLabel, this.labelSelected.getFgColor());
        } else {
            this.currentPressed = 1;
        }
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        y -= this.timeContainer.getPreferredH();
        if (this.currentPressed == 3) {
            this.newMinuteValue = this.getMinuteFromCordiantes(x, y);
            this.minuteButton_XPos = this.minuteHandPointX(this.newMinuteValue);
            this.minuteButton_YPos = this.minuteHandPointY(this.newMinuteValue);
            this.minutePickerButton.setX(this.minuteButton_XPos);
            this.minutePickerButton.setY(this.minuteButton_YPos);
            this.minutePickerButton.setText("" + this.twoDigitValue(this.newMinuteValue));
            this.minutLabel.setText("" + this.twoDigitValue(this.newMinuteValue));
        }
        if (this.currentPressed == 2) {
            int hh = this.getHourFromCordinates(x, y);
            this.hourButton_XPos = this.hourHandPointX(hh);
            this.hourButton_YPos = this.hourHandPointY(hh);
            this.hourPickerButton.setX(this.hourButton_XPos);
            this.hourPickerButton.setY(this.hourButton_YPos);
            if ((hh == 0 || hh == 12) && this.isFirstTime) {
                this.newHourValue = 12;
                if (this.timeFormatLabel.getText().equals(AM_STRING)) {
                    this.timeFormatLabel.setText(PM_STRING);
                } else {
                    this.timeFormatLabel.setText(AM_STRING);
                }
                this.isFirstTime = false;
            } else if (hh > 0 && hh < 12) {
                this.isFirstTime = true;
                this.newHourValue = hh;
            }
            this.hourPickerButton.setText("" + this.twoDigitValue(this.newHourValue));
            this.hourLabel.setText("" + this.twoDigitValue(this.newHourValue));
        }
        this.repaint();
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.currentPressed = 1;
        this.newMinuteValue = 0;
        this.newHourValue = 0;
        this.changeLabelColor(this.minutLabel, this.labelUnselected.getFgColor());
        this.changeLabelColor(this.hourLabel, this.labelUnselected.getFgColor());
        this.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.okCommand) {
            this.set(1, Integer.parseInt(this.hourLabel.getText()));
            this.set(2, Integer.parseInt(this.minutLabel.getText()));
            if (this.timeFormatLabel.getText().equals(AM_STRING)) {
                this.set(5, 3);
            } else {
                this.set(5, 4);
            }
        }
        if (evt.getSource() == this.backCommand) {
            this.hourPickerButton.setText("" + this.twoDigitValue(this.hourValue));
            this.hourLabel.setText("" + this.twoDigitValue(this.hourValue));
            this.minutePickerButton.setText("" + this.twoDigitValue(this.minuteValue));
            this.minutLabel.setText("" + this.twoDigitValue(this.minuteValue));
            if (this.get(5) == 3) {
                this.timeFormatLabel.setText(AM_STRING);
            } else {
                this.timeFormatLabel.setText(PM_STRING);
            }
            this.minuteButton_XPos = this.minuteHandPointX(this.minuteValue);
            this.minuteButton_YPos = this.minuteHandPointY(this.minuteValue);
            this.minutePickerButton.setX(this.minuteButton_XPos);
            this.minutePickerButton.setY(this.minuteButton_YPos);
            this.hourButton_XPos = this.hourHandPointX(this.hourValue);
            this.hourButton_YPos = this.hourHandPointY(this.hourValue);
            this.hourPickerButton.setX(this.hourButton_XPos);
            this.hourPickerButton.setY(this.hourButton_YPos);
        }
        if (this.timePickerListener != null) {
            if (this.previousForm != null) {
                this.previousForm.show();
            }
            this.timePickerListener.notifyTimePickerListener(this);
        }
    }

    private void setHour(int hours) {
        if (hours < 1 || hours > 12) {
            throw new IllegalArgumentException("Invalid hour value.  Value must be in range 1 to 12");
        }
        this.hourValue = hours;
    }

    private void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute value. Value must be in range 0 to 59");
        }
        this.minuteValue = minute;
    }

    private void setAM_PM(int value) {
        if (value != 3 && value != 4) {
            throw new IllegalArgumentException("Invalid value for field");
        }
        this.am_pm_value = value;
    }

    private int getAM_PM() {
        return this.am_pm_value;
    }

    private int getHour() {
        return this.hourValue;
    }

    private int getMinute() {
        return this.minuteValue;
    }

    public String getTimeString() {
        String str = this.twoDigitValue(this.hourValue) + ":" + this.twoDigitValue(this.minuteValue);
        str = this.get(5) == 3 ? str + " AM" : str + " PM";
        return str;
    }

    private void setFont(Label label, Font font) {
        Style style = label.getStyle();
        style.setFont(font, true);
        label.setSelectedStyle(style);
        label.setUnselectedStyle(style);
        label.setPressedStyle(style);
        label.setDisabledStyle(style);
    }

    public int getMinuteFromCordiantes(int x, int y) {
        double dx = x - this.minuteDialCenter_X;
        double dy = -(y - this.minuteDialCenter_Y);
        double inRads = this.utility.atan2(dy, dx);
        inRads = (inRads -= 1.5707963267948966) < 0.0 ? Math.abs(inRads) : Math.PI * 2 - inRads;
        int minute = (int)(Math.toDegrees(inRads) / 6.0);
        return minute;
    }

    public int getHourFromCordinates(int x, int y) {
        double dx = x - this.hourDialCenter_X;
        double dy = -(y - this.hourDialCenter_Y);
        double inRads = this.utility.atan2(dy, dx);
        inRads = (inRads -= 1.5707963267948966) < 0.0 ? Math.abs(inRads) : Math.PI * 2 - inRads;
        int hour = (int)(Math.toDegrees(inRads) / 30.0);
        return hour;
    }

    private String twoDigitValue(int input) {
        if (input < 10) {
            return "0" + input;
        }
        return String.valueOf(input);
    }

    private void changeLabelColor(Label label, int color) {
        label.getStyle().setFgColor(color);
    }

    class TimeShowContainer
    extends Container {
        private Container container;

        public TimeShowContainer() {
            FlowLayout fl = new FlowLayout(4);
            fl.setValign(4);
            this.setLayout(fl);
            this.container = new Container(new BoxLayout(1));
            Font fontLarge = Font.createDirectUtilsSystemFont(0, 1, 30);
            Font fontSmall = Font.createDirectUtilsSystemFont(0, 0, 20);
            TimePicker.this.hourLabel = new Label();
            TimePicker.this.hourLabel.setUIID("TimePickerLabel");
            TimePicker.this.setFont(TimePicker.this.hourLabel, fontLarge);
            TimePicker.this.hourLabel.setFocusable(false);
            Label colonLabel = new Label(":");
            colonLabel.setUIID("TimePickerLabel");
            TimePicker.this.setFont(colonLabel, fontLarge);
            colonLabel.setFocusable(false);
            TimePicker.this.minutLabel = new Label();
            TimePicker.this.minutLabel.setUIID("TimePickerLabel");
            TimePicker.this.setFont(TimePicker.this.minutLabel, fontLarge);
            TimePicker.this.minutLabel.setFocusable(false);
            TimePicker.this.timeFormatLabel = new Label("");
            TimePicker.this.timeFormatLabel.setUIID("TimePickerLabel");
            TimePicker.this.timeFormatLabel.getStyle().setMargin(1, 10);
            TimePicker.this.setFont(TimePicker.this.timeFormatLabel, fontSmall);
            TimePicker.this.timeFormatLabel.setFocusable(false);
            this.container.addComponent(TimePicker.this.hourLabel);
            this.container.addComponent(colonLabel);
            this.container.addComponent(TimePicker.this.minutLabel);
            this.container.addComponent(TimePicker.this.timeFormatLabel);
            this.addComponent(this.container);
        }

        protected Dimension calcPreferredSize() {
            return new Dimension(Display.getInstance().getDisplayWidth() - (this.getStyle().getMargin(1) + this.getStyle().getMargin(3)), 60);
        }
    }

    class TestButton
    extends Button {
        public TestButton(String uiid) {
            this.setUIID(uiid);
        }

        protected Dimension calcPreferredSize() {
            Style style = this.getUnselectedStyle();
            return new Dimension(style.getBgImage().getWidth(), style.getBgImage().getWidth());
        }
    }
}

