/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

class Utility {
    Utility() {
    }

    public double square(double operand) {
        return operand * operand;
    }

    public double asin(double operand) throws ArithmeticException {
        if (operand < -1.0 || operand > 1.0) {
            throw new ArithmeticException("Error");
        }
        return this.atan(operand / Math.sqrt(1.0 - this.square(operand)));
    }

    public double acos(double operand) throws ArithmeticException {
        if (operand < -1.0 || operand > 1.0) {
            throw new ArithmeticException("Error");
        }
        return 1.5707963267948966 - this.asin(operand);
    }

    public double atan(double operand) {
        double result = 0.0;
        double modulus = this.modulus(operand);
        if (modulus < 1.0) {
            for (int i = 0; i < 100; ++i) {
                result += this.pow(-1.0 * this.square(operand), i) / (double)(2 * i + 1);
            }
            result *= operand;
        } else if (modulus == 1.0) {
            double result1 = 0.0;
            for (int i = 0; i < 100; ++i) {
                result1 += this.pow(-1.0 * this.square(operand), i) / (double)(2 * i + 1);
            }
            result1 *= operand;
            double sum = 0.0;
            for (int i = 0; i < 100; ++i) {
                sum += this.pow(-1.0 * this.square(operand), -i) / (double)(2 * i + 1);
            }
            double result2 = Math.PI * (double)this.signum(operand) / 2.0 - 1.0 / operand * sum;
            result = (result1 + result2) / 2.0;
        } else {
            double sum = 0.0;
            for (int i = 0; i < 100; ++i) {
                sum += this.pow(-1.0 * this.square(operand), -i) / (double)(2 * i + 1);
            }
            result = Math.PI * (double)this.signum(operand) / 2.0 - 1.0 / operand * sum;
        }
        return result;
    }

    private double modulus(double operand) {
        if (operand < 0.0) {
            return -operand;
        }
        return operand;
    }

    public double pow(double basis, int exponent) throws ArithmeticException {
        if (exponent == 0) {
            return 1.0;
        }
        if (exponent == 1) {
            return basis;
        }
        if (basis == 0.0) {
            return 0.0;
        }
        if (basis == 1.0) {
            return 1.0;
        }
        if (exponent > 999999) {
            throw new ArithmeticException("Out of range");
        }
        int iterations = exponent < 0 ? -exponent : exponent;
        --iterations;
        double result = basis;
        for (int i = 0; i < iterations; ++i) {
            result *= basis;
        }
        if (exponent < 0) {
            result = 1.0 / result;
        }
        return result;
    }

    private int signum(double operand) {
        if (operand > 0.0) {
            return 1;
        }
        if (operand == 0.0) {
            return 0;
        }
        return -1;
    }

    public double atan2(double y, double x) {
        if (y == 0.0 && x == 0.0) {
            return 0.0;
        }
        if (x > 0.0) {
            return this.atan(y / x);
        }
        if (x < 0.0) {
            if (y < 0.0) {
                return -(Math.PI - this.atan(y / x));
            }
            return Math.PI - this.atan(-y / x);
        }
        if (y < 0.0) {
            return -1.5707963267948966;
        }
        return 1.5707963267948966;
    }
}

